/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.Gesture;
import android.gesture.GesturePoint;
import android.gesture.GestureStroke;
import android.gesture.OrientedBoundingBox;
import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public final class GestureUtils {
    private static final float NONUNIFORM_SCALE = 0.0f;
    private static final float SCALING_THRESHOLD = 0.26f;

    static {
        NONUNIFORM_SCALE = (float)Math.sqrt(2.0);
    }

    private GestureUtils() {
    }

    static void closeStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            int n = Log.e("Gestures", "Could not close stream", iOException);
            return;
        }
    }

    static float[] computeCentroid(float[] fArray) {
        float f;
        float f2;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float f5 = fArray[n2];
            f3 += f5;
            int n3 = n2 + 1;
            float f6 = fArray[n3];
            f4 += f6;
            n2 = n3 + 1;
        }
        float[] fArray2 = new float[2];
        float f7 = 2.0f * f3;
        float f8 = n;
        fArray2[0] = f2 = f7 / f8;
        float f9 = 2.0f * f4;
        float f10 = n;
        fArray2[1] = f = f9 / f10;
        return fArray2;
    }

    private static float[][] computeCoVariance(float[] fArray) {
        float f;
        float f2;
        float f3;
        float f4;
        int[] nArray = new int[]{2, 2};
        float[][] fArray2 = (float[][])Array.newInstance(Float.TYPE, nArray);
        fArray2[0][0] = 0.0f;
        fArray2[0][1] = 0.0f;
        fArray2[1][0] = 0.0f;
        fArray2[1][1] = 0.0f;
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float f5;
            float f6;
            float f7;
            float f8;
            float f9 = fArray[n2];
            int n3 = n2 + 1;
            float f10 = fArray[n3];
            float[] fArray3 = fArray2[0];
            float f11 = fArray3[0];
            float f12 = f9 * f9;
            fArray3[0] = f8 = f11 + f12;
            float[] fArray4 = fArray2[0];
            float f13 = fArray4[1];
            float f14 = f9 * f10;
            fArray4[1] = f7 = f13 + f14;
            float[] fArray5 = fArray2[1];
            fArray5[0] = f6 = fArray2[0][1];
            float[] fArray6 = fArray2[1];
            float f15 = fArray6[1];
            float f16 = f10 * f10;
            fArray6[1] = f5 = f15 + f16;
            n2 = n3 + 1;
        }
        float[] fArray7 = fArray2[0];
        float f17 = fArray7[0];
        float f18 = n / 2;
        fArray7[0] = f4 = f17 / f18;
        float[] fArray8 = fArray2[0];
        float f19 = fArray8[1];
        float f20 = n / 2;
        fArray8[1] = f3 = f19 / f20;
        float[] fArray9 = fArray2[1];
        float f21 = fArray9[0];
        float f22 = n / 2;
        fArray9[0] = f2 = f21 / f22;
        float[] fArray10 = fArray2[1];
        float f23 = fArray10[1];
        float f24 = n / 2;
        fArray10[1] = f = f23 / f24;
        return fArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static float[] computeOrientation(float[][] fArray) {
        float f;
        float f2;
        double d;
        float[] fArray2 = new float[2];
        if (fArray[0][1] == 0.0f || fArray[1][0] == 0.0f) {
            fArray2[0] = 1065353216;
            fArray2[1] = 0.0f;
        }
        float f3 = -fArray[0][0];
        float f4 = fArray[1][1];
        float f5 = f3 - f4;
        float f6 = fArray[0][0];
        float f7 = fArray[1][1];
        float f8 = f6 * f7;
        float f9 = fArray[0][1];
        float f10 = fArray[1][0];
        float f11 = f9 * f10;
        float f12 = f8 - f11;
        float f13 = f5 / 2.0f;
        double d2 = Math.pow(f13, 2.0);
        float f14 = (float)Math.sqrt(d2 - (d = (double)f12));
        float f15 = -f13 + f14;
        if (f15 == (f2 = -f13 - f14)) {
            fArray2[0] = 0.0f;
            fArray2[1] = 0.0f;
            return fArray2;
        }
        if (!(f15 > f2)) {
            f15 = f2;
        }
        fArray2[0] = 1065353216;
        float f16 = fArray[0][0];
        float f17 = f15 - f16;
        float f18 = fArray[0][1];
        fArray2[1] = f = f17 / f18;
        return fArray2;
    }

    public static OrientedBoundingBox computeOrientedBoundingBox(ArrayList<GesturePoint> arrayList) {
        int n = arrayList.size();
        float[] fArray = new float[n * 2];
        for (int i = 0; i < n; ++i) {
            float f;
            float f2;
            GesturePoint gesturePoint = arrayList.get(i);
            int n2 = i * 2;
            fArray[n2] = f2 = gesturePoint.x;
            int n3 = n2 + 1;
            fArray[n3] = f = gesturePoint.y;
        }
        float[] fArray2 = GestureUtils.computeCentroid(fArray);
        return GestureUtils.computeOrientedBoundingBox(fArray, fArray2);
    }

    public static OrientedBoundingBox computeOrientedBoundingBox(float[] fArray) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            float f;
            fArray2[i] = f = fArray[i];
        }
        float[] fArray3 = GestureUtils.computeCentroid(fArray2);
        return GestureUtils.computeOrientedBoundingBox(fArray2, fArray3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static OrientedBoundingBox computeOrientedBoundingBox(float[] fArray, float[] fArray2) {
        float f;
        float f2 = -fArray2[0];
        float f3 = -fArray2[1];
        float[] fArray3 = GestureUtils.translate(fArray, f2, f3);
        float[] fArray4 = GestureUtils.computeOrientation(GestureUtils.computeCoVariance(fArray));
        if (fArray4[0] == 0.0f && fArray4[1] == 0.0f) {
            f = -1.5707964f;
        } else {
            double d = fArray4[1];
            double d2 = fArray4[0];
            float f4 = (float)Math.atan2(d, d2);
            float f5 = -f4;
            float[] fArray5 = GestureUtils.rotate(fArray, f5);
            f = f4;
        }
        int n = fArray.length;
        int n2 = 0;
        int n3 = 0x7F7FFFFF;
        int n4 = 0x7F7FFFFF;
        int n5 = 1;
        int n6 = 1;
        while (true) {
            if (n2 >= n) {
                float f6 = (float)((double)(180.0f * f) / Math.PI);
                float f7 = fArray2[0];
                float f8 = fArray2[1];
                int n7 = n6 - n4;
                int n8 = n5 - n3;
                return new OrientedBoundingBox(f6, f7, f8, n7, n8);
            }
            if (fArray[n2] < n4) {
                n4 = (int)fArray[n2];
            }
            int n9 = (int)(fArray[n2] > n6 ? fArray[n2] : n6);
            int n10 = n2 + 1;
            if (fArray[n10] < n3) {
                n3 = (int)fArray[n10];
            }
            int n11 = fArray[n10] > n5 ? (int)fArray[n10] : n5;
            n2 = n10 + 1;
            n5 = n11;
            n6 = n9;
        }
    }

    static float computeStraightness(float[] fArray) {
        float f = GestureUtils.computeTotalLength(fArray);
        float f2 = fArray[2];
        float f3 = fArray[0];
        float f4 = f2 - f3;
        float f5 = fArray[3];
        float f6 = fArray[1];
        float f7 = f5 - f6;
        float f8 = f4 * f4;
        float f9 = f7 * f7;
        return (float)Math.sqrt(f8 + f9) / f;
    }

    static float computeStraightness(float[] fArray, float f) {
        float f2 = fArray[2];
        float f3 = fArray[0];
        float f4 = f2 - f3;
        float f5 = fArray[3];
        float f6 = fArray[1];
        float f7 = f5 - f6;
        float f8 = f4 * f4;
        float f9 = f7 * f7;
        return (float)Math.sqrt(f8 + f9) / f;
    }

    static float computeTotalLength(float[] fArray) {
        float f = 0.0f;
        int n = fArray.length - 4;
        for (int i = 0; i < n; i += 2) {
            int n2 = i + 2;
            float f2 = fArray[n2];
            float f3 = fArray[i];
            float f4 = f2 - f3;
            int n3 = i + 3;
            float f5 = fArray[n3];
            int n4 = i + 1;
            float f6 = fArray[n4];
            float f7 = f5 - f6;
            double d = f;
            float f8 = f4 * f4;
            float f9 = f7 * f7;
            double d2 = Math.sqrt(f8 + f9);
            f = (float)(d + d2);
        }
        return f;
    }

    static float cosineDistance(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float f2 = fArray[i];
            float f3 = fArray2[i];
            float f4 = f2 * f3;
            f += f4;
        }
        return (float)Math.acos(f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static float minimumCosineDistance(float[] fArray, float[] fArray2, int n) {
        double d;
        double d2;
        double d3;
        int n2 = fArray.length;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        while (0 < n2) {
            float f4 = fArray[0];
            float f5 = fArray2[0];
            float f6 = f4 * f5;
            int n3 = 0 + 1;
            float f7 = fArray[n3];
            int n4 = 0 + 1;
            float f8 = fArray2[n4];
            float f9 = f7 * f8;
            float f10 = f6 + f9;
            f += f10;
            float f11 = fArray[0];
            int n5 = 0 + 1;
            float f12 = fArray2[n5];
            float f13 = f11 * f12;
            int n6 = 0 + 1;
            float f14 = fArray[n6];
            float f15 = fArray2[0];
            float f16 = f14 * f15;
            float f17 = f13 - f16;
            f2 += f17;
            int n7 = 0 + 2;
        }
        if (f == 0.0f) return 1.5707964f;
        f3 = f2 / f;
        double d4 = Math.atan(f3);
        if (n > 2 && (d3 = Math.abs(d4)) >= (d2 = Math.PI / (d = (double)n))) {
            return (float)Math.acos(f);
        }
        double d5 = Math.cos(d4);
        double d6 = (double)f3 * d5;
        double d7 = f;
        double d8 = d5 * d7;
        double d9 = (double)f2 * d6;
        return (float)Math.acos(d8 + d9);
    }

    private static void plot(float f, float f2, float[] fArray, int n) {
        int n2;
        float f3;
        float f4;
        int n3;
        float f5;
        float f6;
        int n4;
        float f7;
        float f8;
        int n5;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        int n6 = (int)Math.floor(f);
        int n7 = (int)Math.ceil(f);
        int n8 = (int)Math.floor(f2);
        int n9 = (int)Math.ceil(f2);
        float f15 = n6;
        if (f == f15 && f2 == (f14 = (float)n8)) {
            int n10 = n9 * n + n7;
            if (!(fArray[n10] < 1.0f)) {
                return;
            }
            fArray[n10] = 1065353216;
            return;
        }
        double d = Math.pow((float)n6 - f, 2.0);
        double d2 = Math.pow((float)n8 - f2, 2.0);
        double d3 = Math.pow((float)n7 - f, 2.0);
        double d4 = Math.pow((float)n9 - f2, 2.0);
        float f16 = (float)Math.sqrt(d + d2);
        float f17 = f16 / (f13 = f16 + (f12 = (float)Math.sqrt(d3 + d2)) + (f11 = (float)Math.sqrt(d + d4)) + (f10 = (float)Math.sqrt(d3 + d4)));
        if (f17 > (f9 = fArray[n5 = n8 * n + n6])) {
            fArray[n5] = f17;
        }
        if ((f8 = f12 / f13) > (f7 = fArray[n4 = n8 * n + n7])) {
            fArray[n4] = f8;
        }
        if ((f6 = f11 / f13) > (f5 = fArray[n3 = n9 * n + n6])) {
            fArray[n3] = f6;
        }
        if (!((f4 = f10 / f13) > (f3 = fArray[n2 = n9 * n + n7]))) {
            return;
        }
        fArray[n2] = f4;
    }

    static float[] rotate(float[] fArray, float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        int n = fArray.length;
        for (int i = 0; i < n; i += 2) {
            float f4 = fArray[i] * f2;
            int n2 = i + 1;
            float f5 = fArray[n2] * f3;
            float f6 = f4 - f5;
            float f7 = fArray[i] * f3;
            int n3 = i + 1;
            float f8 = fArray[n3] * f2;
            float f9 = f7 + f8;
            fArray[i] = f6;
            int n4 = i + 1;
            fArray[n4] = f9;
        }
        return fArray;
    }

    static float[] scale(float[] fArray, float f, float f2) {
        int n = fArray.length;
        for (int i = 0; i < n; i += 2) {
            float f3;
            float f4;
            fArray[i] = f4 = fArray[i] * f;
            int n2 = i + 1;
            fArray[n2] = f3 = fArray[n2] * f2;
        }
        return fArray;
    }

    public static float[] spatialSampling(Gesture gesture, int n) {
        return GestureUtils.spatialSampling(gesture, n, false);
    }

    /*
     * Unable to fully structure code
     */
    public static float[] spatialSampling(Gesture var0, int var1_1, boolean var2_2) {
        block30: {
            block31: {
                block23: {
                    block22: {
                        block29: {
                            block27: {
                                block28: {
                                    var3_3 = var1_1 - 1;
                                    var4_4 = new float[var1_1 * var1_1];
                                    Arrays.fill(var4_4, 0.0f);
                                    var5_5 = var0.getBoundingBox();
                                    var6_6 = var5_5.width();
                                    var7_7 = var5_5.height();
                                    var8_8 = var3_3 / var6_6;
                                    var9_9 = var3_3 / var7_7;
                                    if (var2_2) {
                                        if (var8_8 < var9_9) {
                                            var10_10 = var8_8;
lbl12:
                                            // 2 sources

                                            while (true) {
                                                var11_11 = var10_10;
                                                var12_12 = var10_10;
                                                var13_13 = var11_11;
lbl16:
                                                // 5 sources

                                                while (true) {
                                                    var14_19 = -var5_5.centerX();
                                                    var15_20 = -var5_5.centerY();
                                                    var16_21 = var3_3 / 2.0f;
                                                    var17_22 = var3_3 / 2.0f;
                                                    var18_23 = var0.getStrokes();
                                                    var19_24 = var18_23.size();
                                                    var20_25 = 0;
lbl24:
                                                    // 2 sources

                                                    while ((var21_26 = ++var20_25) < (var22_27 = var19_24)) {
                                                        var23_28 = var18_23;
                                                        var24_29 = var20_25;
                                                        var25_30 = var23_28.get((int)var24_29).points;
                                                        var26_31 = var25_30.length;
                                                        var27_32 = new float[var26_31];
                                                        var28_33 = 0;
                                                        while ((var29_34 = var28_33) < (var30_35 = var26_31)) {
                                                            var27_32[var28_33] = var31_36 = (var25_30[var28_33] + var14_19) * var13_13 + var16_21;
                                                            var32_37 = var28_33 + 1;
                                                            var33_38 = var28_33 + 1;
                                                            var27_32[var32_37] = var34_39 = (var25_30[var33_38] + var15_20) * var12_12 + var17_22;
                                                            var28_33 += 2;
                                                        }
                                                        break block22;
                                                    }
                                                    break block23;
                                                    break;
                                                }
                                                break;
                                            }
                                        }
                                        var10_10 = var9_9;
                                        ** continue;
                                    }
                                    var35_14 = var6_6 / var7_7;
                                    if (var35_14 > 1.0f) {
                                        var35_14 = 1.0f / var35_14;
                                    }
                                    if (!(var35_14 < 0.26f)) break block27;
                                    if (!(var8_8 < var9_9)) break block28;
                                    var36_15 = var8_8;
lbl48:
                                    // 2 sources

                                    while (true) {
                                        var37_16 = var36_15;
                                        var12_12 = var36_15;
                                        var13_13 = var37_16;
                                        ** GOTO lbl16
                                        break;
                                    }
                                }
                                var36_15 = var9_9;
                                ** while (true)
                            }
                            if (!(var8_8 > var9_9)) break block29;
                            var38_17 = GestureUtils.NONUNIFORM_SCALE * var9_9;
                            if (!(var38_17 < var8_8)) break block30;
                            var39_18 = var38_17;
lbl61:
                            // 2 sources

                            while (true) {
                                var12_12 = var9_9;
                                var13_13 = var39_18;
                                ** GOTO lbl16
                                break;
                            }
                        }
                        var39_18 = GestureUtils.NONUNIFORM_SCALE * var8_8;
                        if (!(var39_18 < var9_9)) break block31;
                        var12_12 = var39_18;
                        var13_13 = var8_8;
                        ** GOTO lbl16
                    }
                    var6_6 = -1.0f;
                    var40_40 = -1.0f;
                    var41_42 = 0;
                    while ((var42_43 = var41_42) < (var43_44 = var26_31)) {
                        block24: {
                            block26: {
                                block25: {
                                    block33: {
                                        block32: {
                                            if (!(var27_32[var41_42] < 0.0f)) break block32;
                                            var44_45 = 0;
lbl78:
                                            // 2 sources

                                            while (var27_32[var45_47 = var41_42 + 1] < 0.0f) {
                                                var46_48 = 0;
lbl80:
                                                // 2 sources

                                                while (true) {
                                                    if (var44_45 > var3_3) {
                                                        var44_46 = var3_3;
                                                    }
                                                    if (var46_48 > var3_3) {
                                                        var46_49 = var3_3;
                                                    }
                                                    var47_50 = var44_45;
                                                    var48_51 = var46_48;
                                                    var49_52 = var4_4;
                                                    var50_53 = var1_1;
                                                    GestureUtils.plot(var47_50, var48_51, var49_52, var50_53);
                                                    if (var6_6 == -1.0f) break block24;
                                                    if (!(var6_6 > var44_45)) break block25;
                                                    var51_54 = (float)Math.ceil(var44_45);
                                                    var52_55 = var40_40 - var46_48;
                                                    var53_56 = var6_6 - var44_45;
                                                    var54_57 = var52_55 / var53_56;
                                                    while (var51_54 < var6_6) {
                                                        var55_58 = (var51_54 - var44_45) * var54_57 + var46_48;
                                                        var56_59 = var51_54;
                                                        var57_60 = var55_58;
                                                        var58_61 = var4_4;
                                                        var59_62 = var1_1;
                                                        GestureUtils.plot(var56_59, var57_60, var58_61, var59_62);
                                                        var60_63 = var51_54 + 1.0f;
                                                    }
                                                    break block26;
                                                    break;
                                                }
                                            }
                                            break block33;
                                        }
                                        var44_45 = var27_32[var41_42];
                                        ** GOTO lbl78
                                    }
                                    var61_64 = var41_42 + 1;
                                    var46_48 = var27_32[var61_64];
                                    ** continue;
                                }
                                if (var6_6 < var44_45) {
                                    var62_65 = var40_40 - var46_48;
                                    var63_66 = var6_6 - var44_45;
                                    var54_57 = var62_65 / var63_66;
                                    for (var51_54 = (float)Math.ceil(var6_6); var51_54 < var44_45; var51_54 += 1.0f) {
                                        var64_67 = (var51_54 - var44_45) * var54_57 + var46_48;
                                        var65_68 = var51_54;
                                        var66_69 = var64_67;
                                        var67_70 = var4_4;
                                        var68_71 = var1_1;
                                        GestureUtils.plot(var65_68, var66_69, var67_70, var68_71);
                                    }
                                }
                            }
                            if (var40_40 > var46_48) {
                                var69_72 = (float)Math.ceil(var46_48);
                                var70_73 = var6_6 - var44_45;
                                var71_74 = var40_40 - var46_48;
                                var72_75 = var70_73 / var71_74;
                                for (var51_54 = var69_72; var51_54 < var40_40; var51_54 = 1.0f + var51_54) {
                                    var73_76 = (var51_54 - var46_48) * var72_75 + var44_45;
                                    var74_77 = var51_54;
                                    var75_78 = var4_4;
                                    var76_79 = var1_1;
                                    GestureUtils.plot(var73_76, var74_77, var75_78, var76_79);
                                }
                            } else if (var40_40 < var46_48) {
                                var78_81 = var6_6 - var44_45;
                                var79_82 = var40_40 - var46_48;
                                var72_75 = var78_81 / var79_82;
                                for (var77_80 = (float)Math.ceil(var40_40); var77_80 < var46_48; var77_80 = 1.0f + var77_80) {
                                    var80_83 = (var77_80 - var46_48) * var72_75 + var44_45;
                                    var81_84 = var77_80;
                                    var82_85 = var4_4;
                                    var83_86 = var1_1;
                                    GestureUtils.plot(var80_83, var81_84, var82_85, var83_86);
                                }
                            }
                        }
                        var84_87 = var44_45;
                        var40_41 = var46_48;
                        var41_42 += 2;
                    }
                    ** GOTO lbl24
                }
                return var4_4;
            }
            var12_12 = var9_9;
            var13_13 = var8_8;
            ** while (true)
        }
        var39_18 = var8_8;
        ** while (true)
    }

    static float squaredEuclideanDistance(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float f2 = fArray[i];
            float f3 = fArray2[i];
            float f4 = f2 - f3;
            float f5 = f4 * f4;
            f += f5;
        }
        float f6 = n;
        return f / f6;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float[] temporalSampling(GestureStroke gestureStroke, int n) {
        float f;
        float f2;
        int n2;
        float[] fArray;
        int n3;
        block8: {
            float f3 = gestureStroke.length;
            float f4 = n - 1;
            float f5 = f3 / f4;
            n3 = n * 2;
            fArray = new float[n3];
            float[] fArray2 = gestureStroke.points;
            float f6 = fArray2[0];
            float f7 = fArray2[1];
            int n4 = 1;
            int n5 = 1;
            fArray[0] = f6;
            int n6 = 0 + 1;
            fArray[n6] = f7;
            int n7 = n6 + 1;
            int n8 = fArray2.length / 2;
            n2 = n7;
            f2 = f7;
            f = f6;
            float f8 = 0.0f;
            int n9 = 0;
            while (n9 < n8) {
                float f9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                float f10;
                int n17;
                if (n4 == Float.MIN_VALUE) {
                    if (++n9 >= n8) {
                        int n18 = n9;
                        break block8;
                    }
                    int n19 = n9 * 2;
                    n4 = fArray2[n19];
                    int n20 = n9 * 2 + 1;
                    n5 = fArray2[n20];
                    n17 = n9;
                } else {
                    n17 = n9;
                }
                if (f8 + (f10 = (float)Math.sqrt((n16 = (n15 = n4 - f) * n15) + (n14 = (n13 = n5 - f2) * n13))) >= f5) {
                    float f11 = (f5 - f8) / f10;
                    int n21 = n15 * f11;
                    float f12 = f + n21;
                    float f13 = f11 * n13;
                    float f14 = f2 + f13;
                    fArray[n2] = f12;
                    int n22 = n2 + 1;
                    fArray[n22] = f14;
                    n12 = n22 + 1;
                    n11 = f12;
                    n10 = f14;
                    f9 = 0.0f;
                } else {
                    int n23 = n4;
                    int n24 = n5;
                    n4 = 1;
                    n5 = 1;
                    f9 = f8 + f10;
                    n10 = n24;
                    n11 = n23;
                    n12 = n2;
                }
                n2 = n12;
                int n25 = n10;
                int n26 = n11;
                f8 = f9;
                int n27 = n17;
            }
            int n28 = n9;
        }
        int n29 = n2;
        while (n29 < n3) {
            fArray[n29] = f;
            int n30 = n29 + 1;
            fArray[n30] = f2;
            n29 += 2;
        }
        return fArray;
    }

    static float[] translate(float[] fArray, float f, float f2) {
        int n = fArray.length;
        for (int i = 0; i < n; i += 2) {
            float f3;
            float f4;
            fArray[i] = f4 = fArray[i] + f;
            int n2 = i + 1;
            fArray[n2] = f3 = fArray[n2] + f2;
        }
        return fArray;
    }
}

