/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.Gesture;
import android.gesture.GestureUtils;

class Instance {
    private static final float[] ORIENTATIONS = new float[]{0.0f, 1061752795, 1070141403, 1075235812, 1078530011, 0.0f, -1085730853, -1077342245, -1072247836, -1068953637};
    private static final int PATCH_SAMPLE_SIZE = 16;
    private static final int SEQUENCE_SAMPLE_SIZE = 16;
    final long id;
    final String label;
    final float[] vector;

    private Instance(long l, float[] fArray, String string2) {
        this.id = l;
        this.vector = fArray;
        this.label = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Instance createInstance(int n, int n2, Gesture gesture, String string2) {
        if (n == 2) {
            float[] fArray = Instance.temporalSampler(n2, gesture);
            long l = gesture.getID();
            Instance instance = new Instance(l, fArray, string2);
            instance.normalize();
            return instance;
        }
        float[] fArray = Instance.spatialSampler(gesture);
        long l = gesture.getID();
        return new Instance(l, fArray, string2);
    }

    private void normalize() {
        float[] fArray = this.vector;
        float f = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float f2 = fArray[i];
            float f3 = fArray[i];
            float f4 = f2 * f3;
            f += f4;
        }
        float f5 = (float)Math.sqrt(f);
        int n2 = 0;
        while (n2 < n) {
            float f6;
            fArray[n2] = f6 = fArray[n2] / f5;
            ++n2;
        }
        return;
    }

    private static float[] spatialSampler(Gesture gesture) {
        return GestureUtils.spatialSampling(gesture, 16, false);
    }

    private static float[] temporalSampler(int n, Gesture gesture) {
        float[] fArray = GestureUtils.temporalSampling(gesture.getStrokes().get(0), 16);
        float[] fArray2 = GestureUtils.computeCentroid(fArray);
        float f = fArray[1];
        float f2 = fArray2[1];
        double d = f - f2;
        float f3 = fArray[0];
        float f4 = fArray2[0];
        double d2 = f3 - f4;
        float f5 = (float)Math.atan2(d, d2);
        float f6 = -f5;
        if (n != 1) {
            int n2 = ORIENTATIONS.length;
            for (int i = 0; i < n2; ++i) {
                float f7;
                float f8 = ORIENTATIONS[i] - f5;
                float f9 = Math.abs(f8);
                if (!(f9 < (f7 = Math.abs(f6)))) continue;
                f6 = f8;
            }
        }
        float f10 = -fArray2[0];
        float f11 = -fArray2[1];
        float[] fArray3 = GestureUtils.translate(fArray, f10, f11);
        float[] fArray4 = GestureUtils.rotate(fArray, f6);
        return fArray;
    }
}

