/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public final class Bitmap
implements Parcelable {
    public static final Parcelable.Creator<Bitmap> CREATOR;
    public static final int DENSITY_NONE = 0;
    private static final int WORKING_COMPRESS_STORAGE = 4096;
    private static volatile int sDefaultDensity;
    private static volatile Matrix sScaleMatrix;
    int mDensity;
    private int mHeight = -1;
    private final boolean mIsMutable;
    private final int mNativeBitmap;
    private byte[] mNinePatchChunk;
    private boolean mRecycled;
    private int mWidth = -1;

    static {
        sDefaultDensity = -1;
        CREATOR = new Parcelable.Creator<Bitmap>(){

            @Override
            public Bitmap createFromParcel(Parcel parcel) {
                Bitmap bitmap = Bitmap.nativeCreateFromParcel(parcel);
                if (bitmap == null) {
                    throw new RuntimeException("Failed to unparcel Bitmap");
                }
                return bitmap;
            }

            public Bitmap[] newArray(int n) {
                return new Bitmap[n];
            }
        };
    }

    private Bitmap(int n, boolean bl, byte[] byArray, int n2) {
        int n3;
        sDefaultDensity = n3 = Bitmap.getDefaultDensity();
        this.mDensity = n3;
        if (n == 0) {
            throw new RuntimeException("internal error: native bitmap is 0");
        }
        this.mNativeBitmap = n;
        this.mIsMutable = bl;
        this.mNinePatchChunk = byArray;
        if (n2 < 0) {
            return;
        }
        this.mDensity = n2;
    }

    private void checkPixelAccess(int n, int n2) {
        Bitmap.checkXYSign(n, n2);
        int n3 = this.getWidth();
        if (n >= n3) {
            throw new IllegalArgumentException("x must be < bitmap.width()");
        }
        int n4 = this.getHeight();
        if (n2 < n4) {
            return;
        }
        throw new IllegalArgumentException("y must be < bitmap.height()");
    }

    private void checkPixelsAccess(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        Bitmap.checkXYSign(n, n2);
        if (n3 < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        int n7 = n + n3;
        int n8 = this.getWidth();
        if (n7 > n8) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        int n9 = n2 + n4;
        int n10 = this.getHeight();
        if (n9 > n10) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (Math.abs(n6) < n3) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int n11 = (n4 - 1) * n6;
        int n12 = n5 + n11;
        int n13 = nArray.length;
        if (n5 >= 0 && n5 + n3 <= n13 && n12 >= 0 && n12 + n3 <= n13) {
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private void checkRecycled(String string2) {
        if (!this.mRecycled) {
            return;
        }
        throw new IllegalStateException(string2);
    }

    private static void checkWidthHeight(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (n2 > 0) {
            return;
        }
        throw new IllegalArgumentException("height must be > 0");
    }

    private static void checkXYSign(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("x must be >= 0");
        }
        if (n2 >= 0) {
            return;
        }
        throw new IllegalArgumentException("y must be >= 0");
    }

    public static Bitmap createBitmap(int n, int n2, Config config) {
        int n3 = config.nativeInt;
        int n4 = n;
        int n5 = n;
        int n6 = n2;
        Bitmap bitmap = Bitmap.nativeCreate(null, 0, n4, n5, n6, n3, true);
        bitmap.eraseColor(0);
        return bitmap;
    }

    public static Bitmap createBitmap(Bitmap bitmap) {
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        return Bitmap.createBitmap(bitmap, 0, 0, n, n2);
    }

    public static Bitmap createBitmap(Bitmap bitmap, int n, int n2, int n3, int n4) {
        Bitmap bitmap2 = bitmap;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        return Bitmap.createBitmap(bitmap2, n5, n6, n7, n8, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap createBitmap(Bitmap bitmap, int n, int n2, int n3, int n4, Matrix matrix, boolean bl) {
        int n5;
        Paint paint;
        Bitmap bitmap2;
        int n6;
        int n7;
        Bitmap.checkXYSign(n, n2);
        Bitmap.checkWidthHeight(n3, n4);
        int n8 = n + n3;
        int n9 = bitmap.getWidth();
        if (n8 > n9) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        int n10 = n2 + n4;
        int n11 = bitmap.getHeight();
        if (n10 > n11) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (!bitmap.isMutable() && n == null && n2 == 0 && n3 != (n7 = bitmap.getWidth()) && n4 != (n6 = bitmap.getHeight())) {
            if (matrix == null) return bitmap;
            if (matrix.isIdentity()) {
                return bitmap;
            }
        }
        int n12 = n3;
        int n13 = n4;
        Canvas canvas = new Canvas();
        int n14 = n + n3;
        int n15 = n2 + n4;
        Rect rect = new Rect(n, n2, n14, n15);
        float f = n3;
        float f2 = n4;
        RectF rectF = new RectF(0.0f, 0.0f, f, f2);
        if (matrix == null || matrix.isIdentity()) {
            Config config = bitmap.hasAlpha() ? Config.ARGB_8888 : Config.RGB_565;
            bitmap2 = Bitmap.createBitmap(n12, n13, config);
            paint = null;
            int n16 = n12;
            int n17 = n13;
        } else {
            boolean bl2 = bitmap.hasAlpha() || !matrix.rectStaysRect();
            RectF rectF2 = new RectF();
            boolean bl3 = matrix.mapRect(rectF2, rectF);
            n13 = Math.round(rectF2.width());
            int n18 = Math.round(rectF2.height());
            Config config = bl2 ? Config.ARGB_8888 : Config.RGB_565;
            bitmap2 = Bitmap.createBitmap(n13, n18, config);
            if (bl2) {
                bitmap2.eraseColor(0);
            }
            float f3 = -rectF2.left;
            float f4 = -rectF2.top;
            canvas.translate(f3, f4);
            canvas.concat(matrix);
            Paint paint2 = new Paint();
            paint2.setFilterBitmap(bl);
            if (!matrix.rectStaysRect()) {
                paint2.setAntiAlias(true);
            }
            int n19 = n13;
            int n20 = n18;
            paint = paint2;
            int n21 = n20;
        }
        bitmap2.mDensity = n5 = bitmap.mDensity;
        canvas.setBitmap(bitmap2);
        canvas.drawBitmap(bitmap, rect, rectF, paint);
        return bitmap2;
    }

    public static Bitmap createBitmap(int[] nArray, int n, int n2, int n3, int n4, Config config) {
        Bitmap.checkWidthHeight(n3, n4);
        if (Math.abs(n2) < n3) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int n5 = (n4 - 1) * n2;
        int n6 = n + n5;
        int n7 = nArray.length;
        if (n < 0 || n + n3 > n7 || n6 < 0 || n6 + n3 > n7) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n8 = config.nativeInt;
        int[] nArray2 = nArray;
        int n9 = n;
        int n10 = n2;
        int n11 = n3;
        int n12 = n4;
        return Bitmap.nativeCreate(nArray2, n9, n10, n11, n12, n8, false);
    }

    public static Bitmap createBitmap(int[] nArray, int n, int n2, Config config) {
        int[] nArray2 = nArray;
        int n3 = n;
        int n4 = n;
        int n5 = n2;
        Config config2 = config;
        return Bitmap.createBitmap(nArray2, 0, n3, n4, n5, config2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Bitmap createScaledBitmap(Bitmap bitmap, int n, int n2, boolean bl) {
        Object var4_4 = null;
        // MONITORENTER : android.graphics.Bitmap.class
        Matrix matrix = sScaleMatrix;
        sScaleMatrix = null;
        // MONITOREXIT : android.graphics.Bitmap.class
        if (matrix == null) {
            matrix = new Matrix();
        }
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        float f = n;
        float f2 = n3;
        float f3 = f / f2;
        float f4 = n2;
        float f5 = n4;
        float f6 = f4 / f5;
        matrix.setScale(f3, f6);
        Bitmap bitmap2 = bitmap;
        int n5 = 0;
        boolean bl2 = bl;
        Bitmap bitmap3 = Bitmap.createBitmap(bitmap2, 0, n5, n3, n4, matrix, bl2);
        Class<Bitmap> clazz = Bitmap.class;
        // MONITORENTER : android.graphics.Bitmap.class
        if (sScaleMatrix == null) {
            sScaleMatrix = matrix;
        }
        // MONITOREXIT : clazz
        return bitmap3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int getDefaultDensity() {
        if (sDefaultDensity < 0) return sDefaultDensity = DisplayMetrics.DENSITY_DEVICE;
        return sDefaultDensity;
    }

    private static native boolean nativeCompress(int var0, int var1, int var2, OutputStream var3, byte[] var4);

    private static native int nativeConfig(int var0);

    private static native Bitmap nativeCopy(int var0, int var1, boolean var2);

    private static native void nativeCopyPixelsFromBuffer(int var0, Buffer var1);

    private static native void nativeCopyPixelsToBuffer(int var0, Buffer var1);

    private static native Bitmap nativeCreate(int[] var0, int var1, int var2, int var3, int var4, int var5, boolean var6);

    private static native Bitmap nativeCreateFromParcel(Parcel var0);

    private static native void nativeDestructor(int var0);

    private static native void nativeErase(int var0, int var1);

    private static native Bitmap nativeExtractAlpha(int var0, int var1, int[] var2);

    private static native int nativeGetPixel(int var0, int var1, int var2);

    private static native void nativeGetPixels(int var0, int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native boolean nativeHasAlpha(int var0);

    private static native int nativeHeight(int var0);

    private static native void nativePrepareToDraw(int var0);

    private static native void nativeRecycle(int var0);

    private static native int nativeRowBytes(int var0);

    private static native boolean nativeSameAs(int var0, int var1);

    private static native void nativeSetHasAlpha(int var0, boolean var1);

    private static native void nativeSetPixel(int var0, int var1, int var2, int var3);

    private static native void nativeSetPixels(int var0, int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native int nativeWidth(int var0);

    private static native boolean nativeWriteToParcel(int var0, boolean var1, int var2, Parcel var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int scaleFromDensity(int n, int n2, int n3) {
        if (n2 == 0) return n;
        if (n2 != n3) {
            return n;
        }
        int n4 = n * n3;
        int n5 = n2 >> 1;
        return (n4 + n5) / n2;
    }

    public static void setDefaultDensity(int n) {
        sDefaultDensity = n;
    }

    public boolean compress(CompressFormat compressFormat, int n, OutputStream outputStream) {
        this.checkRecycled("Can't compress a recycled bitmap");
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        int n2 = this.mNativeBitmap;
        int n3 = compressFormat.nativeInt;
        byte[] byArray = new byte[4096];
        return Bitmap.nativeCompress(n2, n3, n, outputStream, byArray);
    }

    public Bitmap copy(Config config, boolean bl) {
        this.checkRecycled("Can't copy a recycled bitmap");
        int n = this.mNativeBitmap;
        int n2 = config.nativeInt;
        Bitmap bitmap = Bitmap.nativeCopy(n, n2, bl);
        if (bitmap != null) {
            int n3;
            bitmap.mDensity = n3 = this.mDensity;
        }
        return bitmap;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void copyPixelsFromBuffer(Buffer buffer) {
        long l;
        long l2;
        long l3;
        long l4;
        int n;
        this.checkRecycled("copyPixelsFromBuffer called on recycled bitmap");
        int n2 = buffer.remaining();
        if (buffer instanceof ByteBuffer) {
            n = 0;
        } else if (buffer instanceof ShortBuffer) {
            n = 1;
        } else {
            if (!(buffer instanceof IntBuffer)) {
                throw new RuntimeException("unsupported Buffer subclass");
            }
            n = 2;
        }
        if ((l4 = (long)n2 << n) < (l3 = (l2 = (long)this.getRowBytes()) * (l = (long)this.getHeight()))) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsFromBuffer(this.mNativeBitmap, buffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void copyPixelsToBuffer(Buffer buffer) {
        long l;
        long l2;
        long l3;
        long l4;
        int n;
        int n2 = buffer.remaining();
        if (buffer instanceof ByteBuffer) {
            n = 0;
        } else if (buffer instanceof ShortBuffer) {
            n = 1;
        } else {
            if (!(buffer instanceof IntBuffer)) {
                throw new RuntimeException("unsupported Buffer subclass");
            }
            n = 2;
        }
        if ((l4 = (long)n2 << n) < (l3 = (l2 = (long)this.getRowBytes()) * (l = (long)this.getHeight()))) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsToBuffer(this.mNativeBitmap, buffer);
        long l5 = buffer.position();
        long l6 = l3 >> n;
        int n3 = (int)(l5 + l6);
        Buffer buffer2 = buffer.position(n3);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void eraseColor(int n) {
        this.checkRecycled("Can't erase a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException("cannot erase immutable bitmaps");
        }
        Bitmap.nativeErase(this.mNativeBitmap, n);
    }

    public Bitmap extractAlpha() {
        return this.extractAlpha(null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Bitmap extractAlpha(Paint paint, int[] nArray) {
        int n;
        this.checkRecycled("Can't extractAlpha on a recycled bitmap");
        int n2 = paint != null ? paint.mNativePaint : 0;
        Bitmap bitmap = Bitmap.nativeExtractAlpha(this.mNativeBitmap, n2, nArray);
        if (bitmap == null) {
            throw new RuntimeException("Failed to extractAlpha on Bitmap");
        }
        bitmap.mDensity = n = this.mDensity;
        return bitmap;
    }

    protected void finalize() throws Throwable {
        try {
            Bitmap.nativeDestructor(this.mNativeBitmap);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public final Config getConfig() {
        return Config.nativeToConfig(Bitmap.nativeConfig(this.mNativeBitmap));
    }

    public int getDensity() {
        return this.mDensity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getHeight() {
        int n;
        if (this.mHeight != -1) return this.mHeight;
        this.mHeight = n = Bitmap.nativeHeight(this.mNativeBitmap);
        return n;
    }

    public byte[] getNinePatchChunk() {
        return this.mNinePatchChunk;
    }

    public int getPixel(int n, int n2) {
        this.checkRecycled("Can't call getPixel() on a recycled bitmap");
        this.checkPixelAccess(n, n2);
        return Bitmap.nativeGetPixel(this.mNativeBitmap, n, n2);
    }

    public void getPixels(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkRecycled("Can't call getPixels() on a recycled bitmap");
        if (n5 == 0) {
            return;
        }
        if (n6 == 0) {
            return;
        }
        Bitmap bitmap = this;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        int n10 = n6;
        int n11 = n;
        int n12 = n2;
        int[] nArray2 = nArray;
        bitmap.checkPixelsAccess(n7, n8, n9, n10, n11, n12, nArray2);
        int n13 = this.mNativeBitmap;
        int[] nArray3 = nArray;
        int n14 = n;
        int n15 = n2;
        int n16 = n3;
        int n17 = n4;
        int n18 = n5;
        int n19 = n6;
        Bitmap.nativeGetPixels(n13, nArray3, n14, n15, n16, n17, n18, n19);
    }

    public final int getRowBytes() {
        return Bitmap.nativeRowBytes(this.mNativeBitmap);
    }

    public int getScaledHeight(int n) {
        int n2 = this.getHeight();
        int n3 = this.mDensity;
        return Bitmap.scaleFromDensity(n2, n3, n);
    }

    public int getScaledHeight(Canvas canvas) {
        int n = this.getHeight();
        int n2 = this.mDensity;
        int n3 = canvas.mDensity;
        return Bitmap.scaleFromDensity(n, n2, n3);
    }

    public int getScaledHeight(DisplayMetrics displayMetrics) {
        int n = this.getHeight();
        int n2 = this.mDensity;
        int n3 = displayMetrics.densityDpi;
        return Bitmap.scaleFromDensity(n, n2, n3);
    }

    public int getScaledWidth(int n) {
        int n2 = this.getWidth();
        int n3 = this.mDensity;
        return Bitmap.scaleFromDensity(n2, n3, n);
    }

    public int getScaledWidth(Canvas canvas) {
        int n = this.getWidth();
        int n2 = this.mDensity;
        int n3 = canvas.mDensity;
        return Bitmap.scaleFromDensity(n, n2, n3);
    }

    public int getScaledWidth(DisplayMetrics displayMetrics) {
        int n = this.getWidth();
        int n2 = this.mDensity;
        int n3 = displayMetrics.densityDpi;
        return Bitmap.scaleFromDensity(n, n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getWidth() {
        int n;
        if (this.mWidth != -1) return this.mWidth;
        this.mWidth = n = Bitmap.nativeWidth(this.mNativeBitmap);
        return n;
    }

    public final boolean hasAlpha() {
        return Bitmap.nativeHasAlpha(this.mNativeBitmap);
    }

    public final boolean isMutable() {
        return this.mIsMutable;
    }

    public final boolean isRecycled() {
        return this.mRecycled;
    }

    final int ni() {
        return this.mNativeBitmap;
    }

    public void prepareToDraw() {
        Bitmap.nativePrepareToDraw(this.mNativeBitmap);
    }

    public void recycle() {
        if (this.mRecycled) {
            return;
        }
        Bitmap.nativeRecycle(this.mNativeBitmap);
        this.mNinePatchChunk = null;
        this.mRecycled = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sameAs(Bitmap bitmap) {
        if (this == bitmap) return true;
        if (bitmap == null) return false;
        int n = this.mNativeBitmap;
        int n2 = bitmap.mNativeBitmap;
        if (!Bitmap.nativeSameAs(n, n2)) return false;
        return true;
    }

    public void setDensity(int n) {
        this.mDensity = n;
    }

    public void setHasAlpha(boolean bl) {
        Bitmap.nativeSetHasAlpha(this.mNativeBitmap, bl);
    }

    public void setNinePatchChunk(byte[] byArray) {
        this.mNinePatchChunk = byArray;
    }

    public void setPixel(int n, int n2, int n3) {
        this.checkRecycled("Can't call setPixel() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        this.checkPixelAccess(n, n2);
        Bitmap.nativeSetPixel(this.mNativeBitmap, n, n2, n3);
    }

    public void setPixels(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkRecycled("Can't call setPixels() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        if (n5 == 0) {
            return;
        }
        if (n6 == 0) {
            return;
        }
        Bitmap bitmap = this;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        int n10 = n6;
        int n11 = n;
        int n12 = n2;
        int[] nArray2 = nArray;
        bitmap.checkPixelsAccess(n7, n8, n9, n10, n11, n12, nArray2);
        int n13 = this.mNativeBitmap;
        int[] nArray3 = nArray;
        int n14 = n;
        int n15 = n2;
        int n16 = n3;
        int n17 = n4;
        int n18 = n5;
        int n19 = n6;
        Bitmap.nativeSetPixels(n13, nArray3, n14, n15, n16, n17, n18, n19);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.checkRecycled("Can't parcel a recycled bitmap");
        int n2 = this.mNativeBitmap;
        boolean bl = this.mIsMutable;
        int n3 = this.mDensity;
        if (Bitmap.nativeWriteToParcel(n2, bl, n3, parcel)) {
            return;
        }
        throw new RuntimeException("native writeToParcel failed");
    }

    public static final class CompressFormat
    extends Enum<CompressFormat> {
        private static final /* synthetic */ CompressFormat[] $VALUES;
        public static final /* enum */ CompressFormat JPEG = new CompressFormat(0);
        public static final /* enum */ CompressFormat PNG = new CompressFormat(1);
        final int nativeInt;

        static {
            CompressFormat compressFormat = JPEG;
            CompressFormat compressFormat2 = PNG;
            CompressFormat[] compressFormatArray = new CompressFormat[]{compressFormat, compressFormat2};
            $VALUES = compressFormatArray;
        }

        private CompressFormat(int n2) {
            this.nativeInt = n2;
        }

        public static CompressFormat valueOf(String string2) {
            return Enum.valueOf(CompressFormat.class, string2);
        }

        public static CompressFormat[] values() {
            return (CompressFormat[])$VALUES.clone();
        }
    }

    public static final class Config
    extends Enum<Config> {
        private static final /* synthetic */ Config[] $VALUES;
        public static final /* enum */ Config ALPHA_8 = new Config(2);
        public static final /* enum */ Config ARGB_4444;
        public static final /* enum */ Config ARGB_8888;
        public static final /* enum */ Config RGB_565;
        private static Config[] sConfigs;
        final int nativeInt;

        static {
            RGB_565 = new Config(4);
            ARGB_4444 = new Config(5);
            ARGB_8888 = new Config(6);
            Config config = ALPHA_8;
            Config config2 = RGB_565;
            Config config3 = ARGB_4444;
            Config config4 = ARGB_8888;
            Config[] configArray = new Config[]{config, config2, config3, config4};
            $VALUES = configArray;
            Config config5 = ALPHA_8;
            Config config6 = RGB_565;
            Config config7 = ARGB_4444;
            Config config8 = ARGB_8888;
            Config[] configArray2 = new Config[]{null, null, config5, null, config6, config7, config8};
            sConfigs = configArray2;
        }

        private Config(int n2) {
            this.nativeInt = n2;
        }

        static Config nativeToConfig(int n) {
            return sConfigs[n];
        }

        public static Config valueOf(String string2) {
            return Enum.valueOf(Config.class, string2);
        }

        public static Config[] values() {
            return (Config[])$VALUES.clone();
        }
    }
}

