/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.os.MemoryFile;
import android.util.TypedValue;
import java.io.BufferedInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapFactory {
    public static Bitmap decodeByteArray(byte[] byArray, int n, int n2) {
        return BitmapFactory.decodeByteArray(byArray, n, n2, null);
    }

    public static Bitmap decodeByteArray(byte[] byArray, int n, int n2, Options options) {
        int n3;
        int n4;
        if ((n | n2) < 0 || (n4 = byArray.length) < (n3 = n + n2)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return BitmapFactory.nativeDecodeByteArray(byArray, n, n2, options);
    }

    public static Bitmap decodeFile(String string2) {
        return BitmapFactory.decodeFile(string2, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Bitmap decodeFile(String var0, Options var1_1) {
        block17: {
            var2_2 = null;
            var3_3 = null;
            var4_4 = new FileInputStream(var0);
            var5_5 = null;
            var2_2 = var6_6 = BitmapFactory.decodeStream(var4_4, var5_5, var1_1);
            if (var4_4 == null) break block17;
            try {
                var4_4.close();
                var7_7 = var4_4;
            }
            catch (IOException var8_8) {
                var9_9 = var4_4;
            }
lbl12:
            // 5 sources

            return var2_2;
            ** GOTO lbl12
            catch (Exception var10_10) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var3_3 == null) ** GOTO lbl12
                    try {
                        var3_3.close();
                    }
                    catch (IOException var11_11) {}
                    break;
                }
            }
            catch (Throwable var12_12) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var13_15 != null) {
                        var13_15.close();
                    }
lbl30:
                    // 4 sources

                    throw var12_13;
                    catch (IOException var14_16) {
                        ** continue;
                    }
                    break;
                }
            }
            catch (Throwable var12_14) {
                var13_15 = var4_4;
                ** continue;
            }
            catch (Exception var15_17) {
                var3_3 = var4_4;
                ** continue;
            }
        }
        var16_18 = var4_4;
        ** while (true)
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fileDescriptor) {
        return BitmapFactory.decodeFileDescriptor(fileDescriptor, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap decodeFileDescriptor(FileDescriptor fileDescriptor, Rect rect, Options options) {
        try {
            if (!MemoryFile.isMemoryFile(fileDescriptor)) return BitmapFactory.finishDecode(BitmapFactory.nativeDecodeFileDescriptor(fileDescriptor, rect, options), rect, options);
            int n = MemoryFile.getSize(fileDescriptor);
            Bitmap bitmap = BitmapFactory.finishDecode(BitmapFactory.decodeStream(new MemoryFile(fileDescriptor, n, "r").getInputStream(), rect, options), rect, options);
            return bitmap;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Bitmap decodeResource(Resources resources, int n) {
        return BitmapFactory.decodeResource(resources, n, null);
    }

    /*
     * Exception decompiling
     */
    public static Bitmap decodeResource(Resources var0, int var1, Options var2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap decodeResourceStream(Resources resources, TypedValue typedValue, InputStream inputStream, Rect rect, Options options) {
        if (options == null) {
            options = new Options();
        }
        if (options.inDensity == 0 && typedValue != null) {
            int n = typedValue.density;
            if (n == 0) {
                options.inDensity = 160;
            } else if (n != 65535) {
                options.inDensity = n;
            }
        }
        if (options.inTargetDensity == 0 && resources != null) {
            int n;
            options.inTargetDensity = n = resources.getDisplayMetrics().densityDpi;
        }
        return BitmapFactory.decodeStream(inputStream, rect, options);
    }

    public static Bitmap decodeStream(InputStream inputStream) {
        return BitmapFactory.decodeStream(inputStream, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap decodeStream(InputStream inputStream, Rect rect, Options options) {
        Bitmap bitmap;
        if (inputStream == null) {
            return null;
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 16384);
        }
        inputStream.mark(1024);
        if (inputStream instanceof AssetManager.AssetInputStream) {
            bitmap = BitmapFactory.nativeDecodeAsset(((AssetManager.AssetInputStream)inputStream).getAssetInt(), rect, options);
            return BitmapFactory.finishDecode(bitmap, rect, options);
        }
        byte[] byArray = null;
        if (options != null) {
            byArray = options.inTempStorage;
        }
        if (byArray == null) {
            byArray = new byte[16384];
        }
        bitmap = BitmapFactory.nativeDecodeStream(inputStream, byArray, rect, options);
        return BitmapFactory.finishDecode(bitmap, rect, options);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Bitmap finishDecode(Bitmap bitmap, Rect rect, Options options) {
        if (bitmap == null) return bitmap;
        if (options == null) {
            return bitmap;
        }
        int n = options.inDensity;
        if (n == 0) return bitmap;
        bitmap.setDensity(n);
        int n2 = options.inTargetDensity;
        if (n2 == 0) return bitmap;
        if (n == n2) return bitmap;
        int n3 = options.inScreenDensity;
        if (n == n3) return bitmap;
        byte[] byArray = bitmap.getNinePatchChunk();
        boolean bl = byArray != null && NinePatch.isNinePatchChunk(byArray);
        if (!options.inScaled) {
            if (!bl) return bitmap;
        }
        float f = n2;
        float f2 = n;
        float f3 = f / f2;
        Bitmap bitmap2 = bitmap;
        int n4 = (int)((float)bitmap.getWidth() * f3 + 0.5f);
        int n5 = (int)((float)bitmap.getHeight() * f3 + 0.5f);
        bitmap = Bitmap.createScaledBitmap(bitmap2, n4, n5, true);
        bitmap2.recycle();
        if (bl) {
            byte[] byArray2 = BitmapFactory.nativeScaleNinePatch(byArray, f3, rect);
            bitmap.setNinePatchChunk(byArray2);
        }
        bitmap.setDensity(n2);
        return bitmap;
    }

    private static native Bitmap nativeDecodeAsset(int var0, Rect var1, Options var2);

    private static native Bitmap nativeDecodeByteArray(byte[] var0, int var1, int var2, Options var3);

    private static native Bitmap nativeDecodeFileDescriptor(FileDescriptor var0, Rect var1, Options var2);

    private static native Bitmap nativeDecodeStream(InputStream var0, byte[] var1, Rect var2, Options var3);

    private static native byte[] nativeScaleNinePatch(byte[] var0, float var1, Rect var2);

    private static native void nativeSetDefaultConfig(int var0);

    public static void setDefaultConfig(Bitmap.Config config) {
        if (config == null) {
            config = Bitmap.Config.RGB_565;
        }
        BitmapFactory.nativeSetDefaultConfig(config.nativeInt);
    }

    public static class Options {
        public int inDensity;
        public boolean inDither;
        public boolean inInputShareable;
        public boolean inJustDecodeBounds;
        public boolean inNativeAlloc;
        public boolean inPreferQualityOverSpeed;
        public Bitmap.Config inPreferredConfig;
        public boolean inPurgeable;
        public int inSampleSize;
        public boolean inScaled;
        public int inScreenDensity;
        public int inTargetDensity;
        public byte[] inTempStorage;
        public boolean mCancel;
        public int outHeight;
        public String outMimeType;
        public int outWidth;

        public Options() {
            Bitmap.Config config;
            this.inPreferredConfig = config = Bitmap.Config.ARGB_8888;
            this.inDither = false;
            this.inScaled = true;
        }

        private native void requestCancel();

        public void requestCancelDecode() {
            this.mCancel = true;
            this.requestCancel();
        }
    }
}

