/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import java.io.BufferedInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BitmapRegionDecoder {
    private int mNativeBitmapRegionDecoder;
    private boolean mRecycled;

    private BitmapRegionDecoder(int n) {
        this.mNativeBitmapRegionDecoder = n;
        this.mRecycled = false;
    }

    private void checkRecycled(String string2) {
        if (!this.mRecycled) {
            return;
        }
        throw new IllegalStateException(string2);
    }

    private static native void nativeClean(int var0);

    private static native Bitmap nativeDecodeRegion(int var0, int var1, int var2, int var3, int var4, BitmapFactory.Options var5);

    private static native int nativeGetHeight(int var0);

    private static native int nativeGetWidth(int var0);

    private static native BitmapRegionDecoder nativeNewInstance(int var0, boolean var1);

    private static native BitmapRegionDecoder nativeNewInstance(FileDescriptor var0, boolean var1);

    private static native BitmapRegionDecoder nativeNewInstance(InputStream var0, byte[] var1, boolean var2);

    private static native BitmapRegionDecoder nativeNewInstance(byte[] var0, int var1, int var2, boolean var3);

    public static BitmapRegionDecoder newInstance(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        return BitmapRegionDecoder.nativeNewInstance(fileDescriptor, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BitmapRegionDecoder newInstance(InputStream inputStream, boolean bl) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 16384);
        }
        if (inputStream instanceof AssetManager.AssetInputStream) {
            return BitmapRegionDecoder.nativeNewInstance(((AssetManager.AssetInputStream)inputStream).getAssetInt(), bl);
        }
        byte[] byArray = new byte[16384];
        return BitmapRegionDecoder.nativeNewInstance(inputStream, byArray, bl);
    }

    /*
     * Unable to fully structure code
     */
    public static BitmapRegionDecoder newInstance(String var0, boolean var1_1) throws IOException {
        block12: {
            var2_2 = null;
            var3_3 = new FileInputStream(var0);
            var5_5 = var4_4 = BitmapRegionDecoder.newInstance(var3_3, var1_1);
            if (var3_3 == null) break block12;
            try {
                var3_3.close();
            }
            catch (IOException var7_9) {
                ** continue;
            }
        }
lbl10:
        // 2 sources

        return var5_5;
        catch (Throwable var6_6) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var2_2 != null) {
                    var2_2.close();
                }
lbl17:
                // 4 sources

                throw var6_7;
            }
        }
        {
            catch (IOException var8_10) {
                ** continue;
            }
        }
        catch (Throwable var6_8) {
            var2_2 = var3_3;
            ** continue;
        }
    }

    public static BitmapRegionDecoder newInstance(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        int n3;
        int n4;
        if ((n | n2) < 0 || (n4 = byArray.length) < (n3 = n + n2)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return BitmapRegionDecoder.nativeNewInstance(byArray, n, n2, bl);
    }

    public Bitmap decodeRegion(Rect rect, BitmapFactory.Options options) {
        int n;
        int n2;
        int n3;
        int n4;
        this.checkRecycled("decodeRegion called on recycled region decoder");
        if (rect.left < 0 || rect.top < 0 || (n4 = rect.right) > (n3 = this.getWidth()) || (n2 = rect.bottom) > (n = this.getHeight())) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        int n5 = this.mNativeBitmapRegionDecoder;
        int n6 = rect.left;
        int n7 = rect.top;
        int n8 = rect.right;
        int n9 = rect.left;
        int n10 = n8 - n9;
        int n11 = rect.bottom;
        int n12 = rect.top;
        int n13 = n11 - n12;
        BitmapFactory.Options options2 = options;
        return BitmapRegionDecoder.nativeDecodeRegion(n5, n6, n7, n10, n13, options2);
    }

    protected void finalize() throws Throwable {
        try {
            this.recycle();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getHeight() {
        this.checkRecycled("getHeight called on recycled region decoder");
        return BitmapRegionDecoder.nativeGetHeight(this.mNativeBitmapRegionDecoder);
    }

    public int getWidth() {
        this.checkRecycled("getWidth called on recycled region decoder");
        return BitmapRegionDecoder.nativeGetWidth(this.mNativeBitmapRegionDecoder);
    }

    public final boolean isRecycled() {
        return this.mRecycled;
    }

    public void recycle() {
        if (this.mRecycled) {
            return;
        }
        BitmapRegionDecoder.nativeClean(this.mNativeBitmapRegionDecoder);
        this.mRecycled = true;
    }
}

