/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import javax.microedition.khronos.opengles.GL;

public class Canvas {
    public static final int ALL_SAVE_FLAG = 31;
    public static final int CLIP_SAVE_FLAG = 2;
    public static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static final int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static final int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static final int MATRIX_SAVE_FLAG = 1;
    private Bitmap mBitmap;
    int mDensity = 0;
    private DrawFilter mDrawFilter;
    private GL mGL;
    final int mNativeCanvas;
    private int mScreenDensity = 0;
    private int mSurfaceFormat;

    public Canvas() {
        int n;
        this.mNativeCanvas = n = Canvas.initRaster(0);
    }

    Canvas(int n) {
        int n2;
        if (n == 0) {
            throw new IllegalStateException();
        }
        this.mNativeCanvas = n;
        this.mDensity = n2 = Bitmap.getDefaultDensity();
    }

    public Canvas(Bitmap bitmap) {
        int n;
        int n2;
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        Canvas.throwIfRecycled(bitmap);
        this.mNativeCanvas = n2 = Canvas.initRaster(bitmap.ni());
        this.mBitmap = bitmap;
        this.mDensity = n = bitmap.mDensity;
    }

    public Canvas(GL gL) {
        int n;
        int n2;
        this.mNativeCanvas = n2 = Canvas.initGL();
        this.mGL = gL;
        this.mDensity = n = Bitmap.getDefaultDensity();
    }

    private static void checkRange(int n, int n2, int n3) {
        if ((n2 | n3) >= 0 && n2 + n3 <= n) {
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private static native void finalizer(int var0);

    public static native void freeCaches();

    public static void freeGlCaches() {
        Canvas.freeCaches();
    }

    private static native int initGL();

    private static native int initRaster(int var0);

    private static native void nativeDrawBitmapMatrix(int var0, int var1, int var2, int var3);

    private static native void nativeDrawBitmapMesh(int var0, int var1, int var2, int var3, float[] var4, int var5, int[] var6, int var7, int var8);

    private static native void nativeDrawVertices(int var0, int var1, int var2, float[] var3, int var4, float[] var5, int var6, int[] var7, int var8, short[] var9, int var10, int var11, int var12);

    private static native void nativeSetDrawFilter(int var0, int var1);

    private static native void nativeSetViewport(int var0, int var1, int var2);

    private static native boolean native_clipPath(int var0, int var1, int var2);

    private static native boolean native_clipRect(int var0, float var1, float var2, float var3, float var4, int var5);

    private static native boolean native_clipRegion(int var0, int var1, int var2);

    private static native void native_concat(int var0, int var1);

    private static native void native_drawARGB(int var0, int var1, int var2, int var3, int var4);

    private static native void native_drawArc(int var0, RectF var1, float var2, float var3, boolean var4, int var5);

    private native void native_drawBitmap(int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8);

    private static native void native_drawBitmap(int var0, int var1, Rect var2, Rect var3, int var4, int var5, int var6);

    private native void native_drawBitmap(int var1, int var2, Rect var3, RectF var4, int var5, int var6, int var7);

    private static native void native_drawBitmap(int var0, int[] var1, int var2, int var3, float var4, float var5, int var6, int var7, boolean var8, int var9);

    private static native void native_drawCircle(int var0, float var1, float var2, float var3, int var4);

    private static native void native_drawColor(int var0, int var1);

    private static native void native_drawColor(int var0, int var1, int var2);

    private static native void native_drawLine(int var0, float var1, float var2, float var3, float var4, int var5);

    private static native void native_drawOval(int var0, RectF var1, int var2);

    private static native void native_drawPaint(int var0, int var1);

    private static native void native_drawPath(int var0, int var1, int var2);

    private static native void native_drawPicture(int var0, int var1);

    private static native void native_drawPosText(int var0, String var1, float[] var2, int var3);

    private static native void native_drawPosText(int var0, char[] var1, int var2, int var3, float[] var4, int var5);

    private static native void native_drawRGB(int var0, int var1, int var2, int var3);

    private static native void native_drawRect(int var0, float var1, float var2, float var3, float var4, int var5);

    private static native void native_drawRect(int var0, RectF var1, int var2);

    private static native void native_drawRoundRect(int var0, RectF var1, float var2, float var3, int var4);

    private static native void native_drawText(int var0, String var1, int var2, int var3, float var4, float var5, int var6);

    private static native void native_drawText(int var0, char[] var1, int var2, int var3, float var4, float var5, int var6);

    private static native void native_drawTextOnPath(int var0, String var1, int var2, float var3, float var4, int var5);

    private static native void native_drawTextOnPath(int var0, char[] var1, int var2, int var3, int var4, float var5, float var6, int var7);

    private static native void native_getCTM(int var0, int var1);

    private static native boolean native_getClipBounds(int var0, Rect var1);

    private static native boolean native_quickReject(int var0, float var1, float var2, float var3, float var4, int var5);

    private static native boolean native_quickReject(int var0, int var1, int var2);

    private static native boolean native_quickReject(int var0, RectF var1, int var2);

    private static native int native_saveLayer(int var0, float var1, float var2, float var3, float var4, int var5, int var6);

    private static native int native_saveLayer(int var0, RectF var1, int var2, int var3);

    private static native int native_saveLayerAlpha(int var0, float var1, float var2, float var3, float var4, int var5, int var6);

    private static native int native_saveLayerAlpha(int var0, RectF var1, int var2, int var3);

    private static native void native_setBitmap(int var0, int var1);

    private static native void native_setMatrix(int var0, int var1);

    private static void throwIfRecycled(Bitmap bitmap) {
        if (!bitmap.isRecycled()) {
            return;
        }
        String string2 = "Canvas: trying to use a recycled bitmap " + bitmap;
        throw new RuntimeException(string2);
    }

    public boolean clipPath(Path path) {
        Region.Op op = Region.Op.INTERSECT;
        return this.clipPath(path, op);
    }

    public boolean clipPath(Path path, Region.Op op) {
        int n = this.mNativeCanvas;
        int n2 = path.ni();
        int n3 = op.nativeInt;
        return Canvas.native_clipPath(n, n2, n3);
    }

    public native boolean clipRect(float var1, float var2, float var3, float var4);

    public boolean clipRect(float f, float f2, float f3, float f4, Region.Op op) {
        int n = this.mNativeCanvas;
        int n2 = op.nativeInt;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        return Canvas.native_clipRect(n, f5, f6, f7, f8, n2);
    }

    public native boolean clipRect(int var1, int var2, int var3, int var4);

    public native boolean clipRect(Rect var1);

    public boolean clipRect(Rect rect, Region.Op op) {
        int n = this.mNativeCanvas;
        float f = rect.left;
        float f2 = rect.top;
        float f3 = rect.right;
        float f4 = rect.bottom;
        int n2 = op.nativeInt;
        return Canvas.native_clipRect(n, f, f2, f3, f4, n2);
    }

    public native boolean clipRect(RectF var1);

    public boolean clipRect(RectF rectF, Region.Op op) {
        int n = this.mNativeCanvas;
        float f = rectF.left;
        float f2 = rectF.top;
        float f3 = rectF.right;
        float f4 = rectF.bottom;
        int n2 = op.nativeInt;
        return Canvas.native_clipRect(n, f, f2, f3, f4, n2);
    }

    public boolean clipRegion(Region region) {
        Region.Op op = Region.Op.INTERSECT;
        return this.clipRegion(region, op);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        int n = this.mNativeCanvas;
        int n2 = region.ni();
        int n3 = op.nativeInt;
        return Canvas.native_clipRegion(n, n2, n3);
    }

    public void concat(Matrix matrix) {
        int n = this.mNativeCanvas;
        int n2 = matrix.native_instance;
        Canvas.native_concat(n, n2);
    }

    public void drawARGB(int n, int n2, int n3, int n4) {
        Canvas.native_drawARGB(this.mNativeCanvas, n, n2, n3, n4);
    }

    public void drawArc(RectF rectF, float f, float f2, boolean bl, Paint paint) {
        if (rectF == null) {
            throw new NullPointerException();
        }
        int n = this.mNativeCanvas;
        int n2 = paint.mNativePaint;
        RectF rectF2 = rectF;
        float f3 = f;
        float f4 = f2;
        boolean bl2 = bl;
        Canvas.native_drawArc(n, rectF2, f3, f4, bl2, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmap(Bitmap bitmap, float f, float f2, Paint paint) {
        Canvas.throwIfRecycled(bitmap);
        int n = this.mNativeCanvas;
        int n2 = bitmap.ni();
        int n3 = paint != null ? paint.mNativePaint : 0;
        int n4 = this.mDensity;
        int n5 = this.mScreenDensity;
        int n6 = bitmap.mDensity;
        Canvas canvas = this;
        float f3 = f;
        float f4 = f2;
        canvas.native_drawBitmap(n, n2, f3, f4, n3, n4, n5, n6);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        int n = this.mNativeCanvas;
        int n2 = bitmap.ni();
        int n3 = matrix.ni();
        int n4 = paint != null ? paint.mNativePaint : 0;
        Canvas.nativeDrawBitmapMatrix(n, n2, n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmap(Bitmap bitmap, Rect rect, Rect rect2, Paint paint) {
        if (rect2 == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfRecycled(bitmap);
        int n = this.mNativeCanvas;
        int n2 = bitmap.ni();
        int n3 = paint != null ? paint.mNativePaint : 0;
        int n4 = this.mScreenDensity;
        int n5 = bitmap.mDensity;
        Rect rect3 = rect;
        Rect rect4 = rect2;
        Canvas.native_drawBitmap(n, n2, rect3, rect4, n3, n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmap(Bitmap bitmap, Rect rect, RectF rectF, Paint paint) {
        if (rectF == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfRecycled(bitmap);
        int n = this.mNativeCanvas;
        int n2 = bitmap.ni();
        int n3 = paint != null ? paint.mNativePaint : 0;
        int n4 = this.mScreenDensity;
        int n5 = bitmap.mDensity;
        Canvas canvas = this;
        Rect rect2 = rect;
        RectF rectF2 = rectF;
        canvas.native_drawBitmap(n, n2, rect2, rectF2, n3, n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmap(int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, Paint paint) {
        int n5;
        if (n3 < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        int n6 = Math.abs(n2);
        if (n6 < (n5 = n3)) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int n7 = (n4 - 1) * n2;
        int n8 = n + n7;
        int n9 = nArray.length;
        if (n < 0 || n + n3 > n9 || n8 < 0 || n8 + n3 > n9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        if (n4 == 0) {
            return;
        }
        int n10 = this.mNativeCanvas;
        int n11 = paint != null ? paint.mNativePaint : 0;
        int[] nArray2 = nArray;
        int n12 = n;
        int n13 = n2;
        float f3 = f;
        float f4 = f2;
        int n14 = n3;
        int n15 = n4;
        boolean bl2 = bl;
        Canvas.native_drawBitmap(n10, nArray2, n12, n13, f3, f4, n14, n15, bl2, n11);
    }

    public void drawBitmap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Paint paint) {
        float f = n3;
        float f2 = n4;
        Canvas canvas = this;
        int[] nArray2 = nArray;
        int n7 = n;
        int n8 = n2;
        int n9 = n5;
        int n10 = n6;
        boolean bl2 = bl;
        Paint paint2 = paint;
        canvas.drawBitmap(nArray2, n7, n8, f, f2, n9, n10, bl2, paint2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmapMesh(Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, Paint paint) {
        if ((n | n2 | n3 | n4) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n == 0) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        int n5 = n + 1;
        int n6 = n2 + 1;
        int n7 = n5 * n6;
        int n8 = fArray.length;
        int n9 = n7 * 2;
        int n10 = n8;
        int n11 = n3;
        int n12 = n9;
        Canvas.checkRange(n10, n11, n12);
        if (nArray != null) {
            int n13 = nArray.length;
            int n14 = n4;
            int n15 = n7;
            Canvas.checkRange(n13, n14, n15);
        }
        int n16 = this.mNativeCanvas;
        int n17 = bitmap.ni();
        int n18 = paint != null ? paint.mNativePaint : 0;
        int n19 = n;
        int n20 = n2;
        float[] fArray2 = fArray;
        int n21 = n3;
        int[] nArray2 = nArray;
        int n22 = n4;
        Canvas.nativeDrawBitmapMesh(n16, n17, n19, n20, fArray2, n21, nArray2, n22, n18);
    }

    public void drawCircle(float f, float f2, float f3, Paint paint) {
        int n = this.mNativeCanvas;
        int n2 = paint.mNativePaint;
        Canvas.native_drawCircle(n, f, f2, f3, n2);
    }

    public void drawColor(int n) {
        Canvas.native_drawColor(this.mNativeCanvas, n);
    }

    public void drawColor(int n, PorterDuff.Mode mode) {
        int n2 = this.mNativeCanvas;
        int n3 = mode.nativeInt;
        Canvas.native_drawColor(n2, n, n3);
    }

    public void drawLine(float f, float f2, float f3, float f4, Paint paint) {
        int n = this.mNativeCanvas;
        int n2 = paint.mNativePaint;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        Canvas.native_drawLine(n, f5, f6, f7, f8, n2);
    }

    public native void drawLines(float[] var1, int var2, int var3, Paint var4);

    public void drawLines(float[] fArray, Paint paint) {
        int n = fArray.length;
        this.drawLines(fArray, 0, n, paint);
    }

    public void drawOval(RectF rectF, Paint paint) {
        if (rectF == null) {
            throw new NullPointerException();
        }
        int n = this.mNativeCanvas;
        int n2 = paint.mNativePaint;
        Canvas.native_drawOval(n, rectF, n2);
    }

    public void drawPaint(Paint paint) {
        int n = this.mNativeCanvas;
        int n2 = paint.mNativePaint;
        Canvas.native_drawPaint(n, n2);
    }

    public void drawPath(Path path, Paint paint) {
        int n = this.mNativeCanvas;
        int n2 = path.ni();
        int n3 = paint.mNativePaint;
        Canvas.native_drawPath(n, n2, n3);
    }

    public void drawPicture(Picture picture) {
        picture.endRecording();
        int n = this.mNativeCanvas;
        int n2 = picture.ni();
        Canvas.native_drawPicture(n, n2);
    }

    public void drawPicture(Picture picture, Rect rect) {
        int n = this.save();
        float f = rect.left;
        float f2 = rect.top;
        this.translate(f, f2);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            float f3 = rect.width();
            float f4 = picture.getWidth();
            float f5 = f3 / f4;
            float f6 = rect.height();
            float f7 = picture.getHeight();
            float f8 = f6 / f7;
            this.scale(f5, f8);
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, RectF rectF) {
        int n = this.save();
        float f = rectF.left;
        float f2 = rectF.top;
        this.translate(f, f2);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            float f3 = rectF.width();
            float f4 = picture.getWidth();
            float f5 = f3 / f4;
            float f6 = rectF.height();
            float f7 = picture.getHeight();
            float f8 = f6 / f7;
            this.scale(f5, f8);
        }
        this.drawPicture(picture);
        this.restore();
    }

    public native void drawPoint(float var1, float var2, Paint var3);

    public native void drawPoints(float[] var1, int var2, int var3, Paint var4);

    public void drawPoints(float[] fArray, Paint paint) {
        int n = fArray.length;
        this.drawPoints(fArray, 0, n, paint);
    }

    public void drawPosText(String string2, float[] fArray, Paint paint) {
        int n;
        int n2 = string2.length() * 2;
        if (n2 > (n = fArray.length)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = this.mNativeCanvas;
        int n4 = paint.mNativePaint;
        Canvas.native_drawPosText(n3, string2, fArray, n4);
    }

    public void drawPosText(char[] cArray, int n, int n2, float[] fArray, Paint paint) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n < 0 || (n6 = n + n2) > (n5 = cArray.length) || (n4 = n2 * 2) > (n3 = fArray.length)) {
            throw new IndexOutOfBoundsException();
        }
        int n7 = this.mNativeCanvas;
        int n8 = paint.mNativePaint;
        char[] cArray2 = cArray;
        int n9 = n;
        int n10 = n2;
        float[] fArray2 = fArray;
        Canvas.native_drawPosText(n7, cArray2, n9, n10, fArray2, n8);
    }

    public void drawRGB(int n, int n2, int n3) {
        Canvas.native_drawRGB(this.mNativeCanvas, n, n2, n3);
    }

    public void drawRect(float f, float f2, float f3, float f4, Paint paint) {
        int n = this.mNativeCanvas;
        int n2 = paint.mNativePaint;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        Canvas.native_drawRect(n, f5, f6, f7, f8, n2);
    }

    public void drawRect(Rect rect, Paint paint) {
        float f = rect.left;
        float f2 = rect.top;
        float f3 = rect.right;
        float f4 = rect.bottom;
        Canvas canvas = this;
        Paint paint2 = paint;
        canvas.drawRect(f, f2, f3, f4, paint2);
    }

    public void drawRect(RectF rectF, Paint paint) {
        int n = this.mNativeCanvas;
        int n2 = paint.mNativePaint;
        Canvas.native_drawRect(n, rectF, n2);
    }

    public void drawRoundRect(RectF rectF, float f, float f2, Paint paint) {
        if (rectF == null) {
            throw new NullPointerException();
        }
        int n = this.mNativeCanvas;
        int n2 = paint.mNativePaint;
        Canvas.native_drawRoundRect(n, rectF, f, f2, n2);
    }

    public void drawText(CharSequence charSequence, int n, int n2, float f, float f2, Paint paint) {
        if (charSequence instanceof String || charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            int n3 = this.mNativeCanvas;
            String string2 = ((Object)charSequence).toString();
            int n4 = paint.mNativePaint;
            int n5 = n;
            int n6 = n2;
            float f3 = f;
            float f4 = f2;
            Canvas.native_drawText(n3, string2, n5, n6, f3, f4, n4);
            return;
        }
        if (charSequence instanceof GraphicsOperations) {
            GraphicsOperations graphicsOperations = (GraphicsOperations)charSequence;
            Canvas canvas = this;
            int n7 = n;
            int n8 = n2;
            float f5 = f;
            float f6 = f2;
            Paint paint2 = paint;
            graphicsOperations.drawText(canvas, n7, n8, f5, f6, paint2);
            return;
        }
        char[] cArray = TemporaryBuffer.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        int n9 = n2 - n;
        Canvas canvas = this;
        float f7 = f;
        float f8 = f2;
        Paint paint3 = paint;
        canvas.drawText(cArray, 0, n9, f7, f8, paint3);
        TemporaryBuffer.recycle(cArray);
    }

    public native void drawText(String var1, float var2, float var3, Paint var4);

    public void drawText(String string2, int n, int n2, float f, float f2, Paint paint) {
        int n3 = n | n2;
        int n4 = n2 - n;
        int n5 = n3 | n4;
        int n6 = string2.length() - n2;
        if ((n5 | n6) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n7 = this.mNativeCanvas;
        int n8 = paint.mNativePaint;
        String string3 = string2;
        int n9 = n;
        int n10 = n2;
        float f3 = f;
        float f4 = f2;
        Canvas.native_drawText(n7, string3, n9, n10, f3, f4, n8);
    }

    public void drawText(char[] cArray, int n, int n2, float f, float f2, Paint paint) {
        int n3 = n | n2;
        int n4 = n + n2;
        int n5 = n3 | n4;
        int n6 = cArray.length - n - n2;
        if ((n5 | n6) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n7 = this.mNativeCanvas;
        int n8 = paint.mNativePaint;
        char[] cArray2 = cArray;
        int n9 = n;
        int n10 = n2;
        float f3 = f;
        float f4 = f2;
        Canvas.native_drawText(n7, cArray2, n9, n10, f3, f4, n8);
    }

    public void drawTextOnPath(String string2, Path path, float f, float f2, Paint paint) {
        if (string2.length() <= 0) {
            return;
        }
        int n = this.mNativeCanvas;
        int n2 = path.ni();
        int n3 = paint.mNativePaint;
        String string3 = string2;
        float f3 = f;
        float f4 = f2;
        Canvas.native_drawTextOnPath(n, string3, n2, f3, f4, n3);
    }

    public void drawTextOnPath(char[] cArray, int n, int n2, Path path, float f, float f2, Paint paint) {
        int n3;
        int n4;
        if (n < 0 || (n4 = n + n2) > (n3 = cArray.length)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n5 = this.mNativeCanvas;
        int n6 = path.ni();
        int n7 = paint.mNativePaint;
        char[] cArray2 = cArray;
        int n8 = n;
        int n9 = n2;
        float f3 = f;
        float f4 = f2;
        Canvas.native_drawTextOnPath(n5, cArray2, n8, n9, n6, f3, f4, n7);
    }

    public void drawVertices(VertexMode vertexMode, int n, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, short[] sArray, int n5, int n6, Paint paint) {
        int n7 = fArray.length;
        int n8 = n2;
        int n9 = n;
        Canvas.checkRange(n7, n8, n9);
        if (fArray2 != null) {
            int n10 = fArray2.length;
            int n11 = n3;
            int n12 = n;
            Canvas.checkRange(n10, n11, n12);
        }
        if (nArray != null) {
            int n13 = nArray.length;
            int n14 = n4;
            int n15 = n;
            Canvas.checkRange(n13, n14, n15);
        }
        if (sArray != null) {
            int n16 = sArray.length;
            int n17 = n5;
            int n18 = n6;
            Canvas.checkRange(n16, n17, n18);
        }
        int n19 = this.mNativeCanvas;
        int n20 = vertexMode.nativeInt;
        int n21 = paint.mNativePaint;
        int n22 = n;
        float[] fArray3 = fArray;
        int n23 = n2;
        float[] fArray4 = fArray2;
        int n24 = n3;
        int[] nArray2 = nArray;
        int n25 = n4;
        short[] sArray2 = sArray;
        int n26 = n5;
        int n27 = n6;
        Canvas.nativeDrawVertices(n19, n20, n22, fArray3, n23, fArray4, n24, nArray2, n25, sArray2, n26, n27, n21);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mNativeCanvas == 0) {
            return;
        }
        Canvas.finalizer(this.mNativeCanvas);
    }

    public final Rect getClipBounds() {
        Rect rect = new Rect();
        boolean bl = this.getClipBounds(rect);
        return rect;
    }

    public boolean getClipBounds(Rect rect) {
        return Canvas.native_getClipBounds(this.mNativeCanvas, rect);
    }

    public int getDensity() {
        return this.mDensity;
    }

    public DrawFilter getDrawFilter() {
        return this.mDrawFilter;
    }

    public GL getGL() {
        return this.mGL;
    }

    public native int getHeight();

    public final Matrix getMatrix() {
        Matrix matrix = new Matrix();
        this.getMatrix(matrix);
        return matrix;
    }

    public void getMatrix(Matrix matrix) {
        int n = this.mNativeCanvas;
        int n2 = matrix.native_instance;
        Canvas.native_getCTM(n, n2);
    }

    public native int getSaveCount();

    public native int getWidth();

    public native boolean isOpaque();

    public boolean quickReject(float f, float f2, float f3, float f4, EdgeType edgeType) {
        int n = this.mNativeCanvas;
        int n2 = edgeType.nativeInt;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        return Canvas.native_quickReject(n, f5, f6, f7, f8, n2);
    }

    public boolean quickReject(Path path, EdgeType edgeType) {
        int n = this.mNativeCanvas;
        int n2 = path.ni();
        int n3 = edgeType.nativeInt;
        return Canvas.native_quickReject(n, n2, n3);
    }

    public boolean quickReject(RectF rectF, EdgeType edgeType) {
        int n = this.mNativeCanvas;
        int n2 = edgeType.nativeInt;
        return Canvas.native_quickReject(n, rectF, n2);
    }

    public native void restore();

    public native void restoreToCount(int var1);

    public native void rotate(float var1);

    public final void rotate(float f, float f2, float f3) {
        this.translate(f2, f3);
        this.rotate(f);
        float f4 = -f2;
        float f5 = -f3;
        this.translate(f4, f5);
    }

    public native int save();

    public native int save(int var1);

    /*
     * Enabled aggressive block sorting
     */
    public int saveLayer(float f, float f2, float f3, float f4, Paint paint, int n) {
        int n2 = this.mNativeCanvas;
        int n3 = paint != null ? paint.mNativePaint : 0;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        int n4 = n;
        return Canvas.native_saveLayer(n2, f5, f6, f7, f8, n3, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int saveLayer(RectF rectF, Paint paint, int n) {
        int n2;
        int n3 = this.mNativeCanvas;
        if (paint != null) {
            n2 = paint.mNativePaint;
            return Canvas.native_saveLayer(n3, rectF, n2, n);
        }
        n2 = 0;
        return Canvas.native_saveLayer(n3, rectF, n2, n);
    }

    public int saveLayerAlpha(float f, float f2, float f3, float f4, int n, int n2) {
        int n3 = this.mNativeCanvas;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        int n4 = n;
        int n5 = n2;
        return Canvas.native_saveLayerAlpha(n3, f5, f6, f7, f8, n4, n5);
    }

    public int saveLayerAlpha(RectF rectF, int n, int n2) {
        int n3 = Math.max(0, n);
        int n4 = Math.min(255, n3);
        return Canvas.native_saveLayerAlpha(this.mNativeCanvas, rectF, n4, n2);
    }

    public native void scale(float var1, float var2);

    public final void scale(float f, float f2, float f3, float f4) {
        this.translate(f3, f4);
        this.scale(f, f2);
        float f5 = -f3;
        float f6 = -f4;
        this.translate(f5, f6);
    }

    public void setBitmap(Bitmap bitmap) {
        int n;
        if (!bitmap.isMutable()) {
            throw new IllegalStateException();
        }
        if (this.mGL != null) {
            throw new RuntimeException("Can't set a bitmap device on a GL canvas");
        }
        Canvas.throwIfRecycled(bitmap);
        int n2 = this.mNativeCanvas;
        int n3 = bitmap.ni();
        Canvas.native_setBitmap(n2, n3);
        this.mBitmap = bitmap;
        this.mDensity = n = bitmap.mDensity;
    }

    public void setDensity(int n) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(n);
        }
        this.mDensity = n;
    }

    public void setDrawFilter(DrawFilter drawFilter) {
        int n = 0;
        if (drawFilter != null) {
            n = drawFilter.mNativeInt;
        }
        this.mDrawFilter = drawFilter;
        Canvas.nativeSetDrawFilter(this.mNativeCanvas, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMatrix(Matrix matrix) {
        int n = this.mNativeCanvas;
        int n2 = matrix == null ? 0 : matrix.native_instance;
        Canvas.native_setMatrix(n, n2);
    }

    public void setScreenDensity(int n) {
        this.mScreenDensity = n;
    }

    public void setViewport(int n, int n2) {
        if (this.mGL == null) {
            return;
        }
        Canvas.nativeSetViewport(this.mNativeCanvas, n, n2);
    }

    public native void skew(float var1, float var2);

    public native void translate(float var1, float var2);

    public static final class VertexMode
    extends Enum<VertexMode> {
        private static final /* synthetic */ VertexMode[] $VALUES;
        public static final /* enum */ VertexMode TRIANGLES = new VertexMode(0);
        public static final /* enum */ VertexMode TRIANGLE_FAN;
        public static final /* enum */ VertexMode TRIANGLE_STRIP;
        final int nativeInt;

        static {
            TRIANGLE_STRIP = new VertexMode(1);
            TRIANGLE_FAN = new VertexMode(2);
            VertexMode vertexMode = TRIANGLES;
            VertexMode vertexMode2 = TRIANGLE_STRIP;
            VertexMode vertexMode3 = TRIANGLE_FAN;
            VertexMode[] vertexModeArray = new VertexMode[]{vertexMode, vertexMode2, vertexMode3};
            $VALUES = vertexModeArray;
        }

        private VertexMode(int n2) {
            this.nativeInt = n2;
        }

        public static VertexMode valueOf(String string2) {
            return Enum.valueOf(VertexMode.class, string2);
        }

        public static VertexMode[] values() {
            return (VertexMode[])$VALUES.clone();
        }
    }

    public static final class EdgeType
    extends Enum<EdgeType> {
        private static final /* synthetic */ EdgeType[] $VALUES;
        public static final /* enum */ EdgeType AA;
        public static final /* enum */ EdgeType BW;
        final int nativeInt;

        static {
            BW = new EdgeType(0);
            AA = new EdgeType(1);
            EdgeType edgeType = BW;
            EdgeType edgeType2 = AA;
            EdgeType[] edgeTypeArray = new EdgeType[]{edgeType, edgeType2};
            $VALUES = edgeTypeArray;
        }

        private EdgeType(int n2) {
            this.nativeInt = n2;
        }

        public static EdgeType valueOf(String string2) {
            return Enum.valueOf(EdgeType.class, string2);
        }

        public static EdgeType[] values() {
            return (EdgeType[])$VALUES.clone();
        }
    }
}

