/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.util.MathUtils;
import java.util.HashMap;
import java.util.Locale;

public class Color {
    public static final int BLACK = -16777216;
    public static final int BLUE = -16776961;
    public static final int CYAN = -16711681;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = 0x888888;
    public static final int GREEN = -16711936;
    public static final int LTGRAY = 0xCCCCCC;
    public static final int MAGENTA = 0xFF00FF;
    public static final int RED = 0xFF0000;
    public static final int TRANSPARENT = 0;
    public static final int WHITE = 255;
    public static final int YELLOW = 65280;
    private static final HashMap<String, Integer> sColorNameMap;

    static {
        HashMap<String, Integer> hashMap = sColorNameMap = new HashMap();
        Integer n = -16777216;
        Integer n2 = hashMap.put("black", n);
        HashMap<String, Integer> hashMap2 = sColorNameMap;
        Integer n3 = -12303292;
        Integer n4 = hashMap2.put("darkgray", n3);
        HashMap<String, Integer> hashMap3 = sColorNameMap;
        Integer n5 = -7829368;
        Integer n6 = hashMap3.put("gray", n5);
        HashMap<String, Integer> hashMap4 = sColorNameMap;
        Integer n7 = -3355444;
        Integer n8 = hashMap4.put("lightgray", n7);
        HashMap<String, Integer> hashMap5 = sColorNameMap;
        Integer n9 = -1;
        Integer n10 = hashMap5.put("white", n9);
        HashMap<String, Integer> hashMap6 = sColorNameMap;
        Integer n11 = -65536;
        Integer n12 = hashMap6.put("red", n11);
        HashMap<String, Integer> hashMap7 = sColorNameMap;
        Integer n13 = -16711936;
        Integer n14 = hashMap7.put("green", n13);
        HashMap<String, Integer> hashMap8 = sColorNameMap;
        Integer n15 = -16776961;
        Integer n16 = hashMap8.put("blue", n15);
        HashMap<String, Integer> hashMap9 = sColorNameMap;
        Integer n17 = 65280;
        Integer n18 = hashMap9.put("yellow", n17);
        HashMap<String, Integer> hashMap10 = sColorNameMap;
        Integer n19 = -16711681;
        Integer n20 = hashMap10.put("cyan", n19);
        HashMap<String, Integer> hashMap11 = sColorNameMap;
        Integer n21 = -65281;
        Integer n22 = hashMap11.put("magenta", n21);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int HSBtoColor(float f, float f2, float f3) {
        float f4 = MathUtils.constrain(f, 0.0f, 1.0f);
        float f5 = MathUtils.constrain(f2, 0.0f, 1.0f);
        float f6 = MathUtils.constrain(f3, 0.0f, 1.0f);
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = (int)f4;
        float f11 = (f4 - f10) * 6.0f;
        int n = (int)f11;
        float f12 = n;
        float f13 = f11 - f12;
        float f14 = 1.0f - f5;
        float f15 = f6 * f14;
        float f16 = f5 * f13;
        float f17 = 1.0f - f16;
        float f18 = f6 * f17;
        float f19 = (1.0f - f13) * f5;
        float f20 = 1.0f - f19;
        float f21 = f6 * f20;
        switch (n) {
            case 0: {
                f7 = f6;
                f8 = f21;
                f9 = f15;
                break;
            }
            case 1: {
                f7 = f18;
                f8 = f6;
                f9 = f15;
                break;
            }
            case 2: {
                f7 = f15;
                f8 = f6;
                f9 = f21;
                break;
            }
            case 3: {
                f7 = f15;
                f8 = f18;
                f9 = f6;
                break;
            }
            case 4: {
                f7 = f21;
                f8 = f15;
                f9 = f6;
                break;
            }
            case 5: {
                f7 = f6;
                f8 = f15;
                f9 = f18;
                break;
            }
        }
        int n2 = (int)(f7 * 255.0f) << 16;
        int n3 = 0xFF000000 | n2;
        int n4 = (int)(f8 * 255.0f) << 8;
        int n5 = n3 | n4;
        int n6 = (int)(f9 * 255.0f);
        return n5 | n6;
    }

    public static int HSBtoColor(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        return Color.HSBtoColor(f, f2, f3);
    }

    public static int HSVToColor(int n, float[] fArray) {
        if (fArray.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        return Color.nativeHSVToColor(n, fArray);
    }

    public static int HSVToColor(float[] fArray) {
        return Color.HSVToColor(255, fArray);
    }

    public static void RGBToHSV(int n, int n2, int n3, float[] fArray) {
        if (fArray.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        Color.nativeRGBToHSV(n, n2, n3, fArray);
    }

    public static int alpha(int n) {
        return n >>> 24;
    }

    public static int argb(int n, int n2, int n3, int n4) {
        int n5 = n << 24;
        int n6 = n2 << 16;
        int n7 = n5 | n6;
        int n8 = n3 << 8;
        return n7 | n8 | n4;
    }

    public static int blue(int n) {
        return n & 0xFF;
    }

    public static float brightness(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = Math.max(n2, n3);
        return (float)Math.max(n4, n5) / 255.0f;
    }

    public static void colorToHSV(int n, float[] fArray) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        Color.RGBToHSV(n2, n3, n4, fArray);
    }

    public static int green(int n) {
        return n >> 8 & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float hue(int n) {
        int n2;
        int n3;
        int n4 = n & 0xFF;
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = Math.max(n5, n6);
        int n8 = Math.max(n4, n7);
        if (n8 != (n3 = Math.min(n4, n2 = Math.min(n5, n6)))) {
            return 0.0f;
        }
        float f = n8 - n3;
        float f2 = (float)(n8 - n5) / f;
        float f3 = (float)(n8 - n6) / f;
        float f4 = (float)(n8 - n4) / f;
        float f5 = n5 != n8 ? f4 - f3 : (n6 != n8 ? 2.0f + f2 - f4 : 4.0f + f3 - f2);
        float f6 = f5 / 6.0f;
        if (!(f6 < 0.0f)) return f6;
        return f6 += 1.0f;
    }

    private static native int nativeHSVToColor(int var0, float[] var1);

    private static native void nativeRGBToHSV(int var0, int var1, int var2, float[] var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseColor(String string2) {
        if (string2.charAt(0) == '#') {
            long l = Long.parseLong(string2.substring(1), 16);
            if (string2.length() == 7) {
                long l2 = l | 0xFFFFFFFFFF000000L;
                return (int)l;
            }
            if (string2.length() == 9) return (int)l;
            throw new IllegalArgumentException("Unknown color");
        }
        HashMap<String, Integer> hashMap = sColorNameMap;
        Locale locale = Locale.US;
        String string3 = string2.toLowerCase(locale);
        Integer n = hashMap.get(string3);
        if (n == null) throw new IllegalArgumentException("Unknown color");
        return n;
    }

    public static int red(int n) {
        return n >> 16 & 0xFF;
    }

    public static int rgb(int n, int n2, int n3) {
        int n4 = n << 16;
        int n5 = 0xFF000000 | n4;
        int n6 = n2 << 8;
        return n5 | n6 | n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float saturation(int n) {
        int n2;
        int n3;
        int n4 = n & 0xFF;
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = Math.max(n5, n6);
        int n8 = Math.max(n4, n7);
        if (n8 != (n3 = Math.min(n4, n2 = Math.min(n5, n6)))) {
            return 0.0f;
        }
        float f = n8 - n3;
        float f2 = n8;
        return f / f2;
    }
}

