/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.util.FloatMath;

public class ColorMatrix {
    private final float[] mArray;

    public ColorMatrix() {
        float[] fArray = new float[20];
        this.mArray = fArray;
        this.reset();
    }

    public ColorMatrix(ColorMatrix colorMatrix) {
        float[] fArray = new float[20];
        this.mArray = fArray;
        float[] fArray2 = colorMatrix.mArray;
        float[] fArray3 = this.mArray;
        System.arraycopy(fArray2, 0, fArray3, 0, 20);
    }

    public ColorMatrix(float[] fArray) {
        float[] fArray2 = new float[20];
        float[] fArray3 = this.mArray = fArray2;
        System.arraycopy(fArray, 0, fArray3, 0, 20);
    }

    public final float[] getArray() {
        return this.mArray;
    }

    public void postConcat(ColorMatrix colorMatrix) {
        this.setConcat(colorMatrix, this);
    }

    public void preConcat(ColorMatrix colorMatrix) {
        this.setConcat(this, colorMatrix);
    }

    public void reset() {
        float[] fArray = this.mArray;
        for (int i = 19; i > 0; i += -1) {
            fArray[i] = 0.0f;
        }
        fArray[18] = 1065353216;
        fArray[12] = 1065353216;
        fArray[6] = 1065353216;
        fArray[0] = 1065353216;
    }

    public void set(ColorMatrix colorMatrix) {
        float[] fArray = colorMatrix.mArray;
        float[] fArray2 = this.mArray;
        System.arraycopy(fArray, 0, fArray2, 0, 20);
    }

    public void set(float[] fArray) {
        float[] fArray2 = this.mArray;
        System.arraycopy(fArray, 0, fArray2, 0, 20);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setConcat(ColorMatrix colorMatrix, ColorMatrix colorMatrix2) {
        float[] fArray = colorMatrix == this || colorMatrix2 == this ? new float[20] : this.mArray;
        float[] fArray2 = colorMatrix.mArray;
        float[] fArray3 = colorMatrix2.mArray;
        int n = 0;
        for (int i = 0; i < 20; i += 5) {
            float f;
            int n2 = n;
            for (int j = 0; j < 4; ++j) {
                float f2;
                int n3 = n2 + 1;
                int n4 = i + 0;
                float f3 = fArray2[n4];
                int n5 = j + 0;
                float f4 = fArray3[n5];
                float f5 = f3 * f4;
                int n6 = i + 1;
                float f6 = fArray2[n6];
                int n7 = j + 5;
                float f7 = fArray3[n7];
                float f8 = f6 * f7;
                float f9 = f5 + f8;
                int n8 = i + 2;
                float f10 = fArray2[n8];
                int n9 = j + 10;
                float f11 = fArray3[n9];
                float f12 = f10 * f11;
                float f13 = f9 + f12;
                int n10 = i + 3;
                float f14 = fArray2[n10];
                int n11 = j + 15;
                float f15 = fArray3[n11];
                float f16 = f14 * f15;
                fArray[n2] = f2 = f13 + f16;
                n2 = n3;
            }
            n = n2 + 1;
            int n12 = i + 0;
            float f17 = fArray2[n12];
            float f18 = fArray3[4];
            float f19 = f17 * f18;
            int n13 = i + 1;
            float f20 = fArray2[n13];
            float f21 = fArray3[9];
            float f22 = f20 * f21;
            float f23 = f19 + f22;
            int n14 = i + 2;
            float f24 = fArray2[n14];
            float f25 = fArray3[14];
            float f26 = f24 * f25;
            float f27 = f23 + f26;
            int n15 = i + 3;
            float f28 = fArray2[n15];
            float f29 = fArray3[19];
            float f30 = f28 * f29;
            float f31 = f27 + f30;
            int n16 = i + 4;
            float f32 = fArray2[n16];
            fArray[n2] = f = f31 + f32;
        }
        float[] fArray4 = this.mArray;
        if (fArray == fArray4) {
            return;
        }
        float[] fArray5 = this.mArray;
        System.arraycopy(fArray, 0, fArray5, 0, 20);
    }

    public void setRGB2YUV() {
        this.reset();
        float[] fArray = this.mArray;
        fArray[0] = 1050220167;
        fArray[1] = 1058424226;
        fArray[2] = 1038710997;
        fArray[5] = -1104360914;
        fArray[6] = -1096181015;
        fArray[7] = 0x3F000000;
        fArray[10] = 0x3F000000;
        fArray[11] = -1093247351;
        fArray[12] = -1113160229;
    }

    public void setRotate(int n, float f) {
        float f2;
        this.reset();
        float f3 = (float)Math.PI * f / 180.0f;
        float f4 = FloatMath.cos(f3);
        float f5 = FloatMath.sin(f3);
        switch (n) {
            default: {
                throw new RuntimeException();
            }
            case 0: {
                float f6;
                float[] fArray = this.mArray;
                this.mArray[12] = f4;
                fArray[6] = f4;
                this.mArray[7] = f5;
                float[] fArray2 = this.mArray;
                fArray2[11] = f6 = -f5;
                return;
            }
            case 1: {
                float f7;
                float[] fArray = this.mArray;
                this.mArray[12] = f4;
                fArray[0] = f4;
                float[] fArray3 = this.mArray;
                fArray3[2] = f7 = -f5;
                this.mArray[10] = f5;
                return;
            }
            case 2: 
        }
        float[] fArray = this.mArray;
        this.mArray[6] = f4;
        fArray[0] = f4;
        this.mArray[1] = f5;
        float[] fArray4 = this.mArray;
        fArray4[5] = f2 = -f5;
    }

    public void setSaturation(float f) {
        float f2;
        float f3;
        float f4;
        this.reset();
        float[] fArray = this.mArray;
        float f5 = 1.0f - f;
        float f6 = 0.213f * f5;
        float f7 = 0.715f * f5;
        float f8 = 0.072f * f5;
        fArray[0] = f4 = f6 + f;
        fArray[1] = f7;
        fArray[2] = f8;
        fArray[5] = f6;
        fArray[6] = f3 = f7 + f;
        fArray[7] = f8;
        fArray[10] = f6;
        fArray[11] = f7;
        fArray[12] = f2 = f8 + f;
    }

    public void setScale(float f, float f2, float f3, float f4) {
        float[] fArray = this.mArray;
        for (int i = 19; i > 0; i += -1) {
            fArray[i] = 0.0f;
        }
        fArray[0] = f;
        fArray[6] = f2;
        fArray[12] = f3;
        fArray[18] = f4;
    }

    public void setYUV2RGB() {
        this.reset();
        float[] fArray = this.mArray;
        fArray[2] = 1068725436;
        fArray[5] = 1065353216;
        fArray[6] = -1095748834;
        fArray[7] = -1086926367;
        fArray[10] = 1065353216;
        fArray[11] = 1071829221;
        fArray[12] = 0.0f;
    }
}

