/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.SystemClock;

public class Interpolator {
    private int mFrameCount;
    private int mValueCount;
    private final int native_instance;

    public Interpolator(int n) {
        int n2;
        this.mValueCount = n;
        this.mFrameCount = 2;
        this.native_instance = n2 = Interpolator.nativeConstructor(n, 2);
    }

    public Interpolator(int n, int n2) {
        int n3;
        this.mValueCount = n;
        this.mFrameCount = n2;
        this.native_instance = n3 = Interpolator.nativeConstructor(n, n2);
    }

    private static native int nativeConstructor(int var0, int var1);

    private static native void nativeDestructor(int var0);

    private static native void nativeReset(int var0, int var1, int var2);

    private static native void nativeSetKeyFrame(int var0, int var1, int var2, float[] var3, float[] var4);

    private static native void nativeSetRepeatMirror(int var0, float var1, boolean var2);

    private static native int nativeTimeToValues(int var0, int var1, float[] var2);

    protected void finalize() throws Throwable {
        Interpolator.nativeDestructor(this.native_instance);
    }

    public final int getKeyFrameCount() {
        return this.mFrameCount;
    }

    public final int getValueCount() {
        return this.mValueCount;
    }

    public void reset(int n) {
        this.reset(n, 2);
    }

    public void reset(int n, int n2) {
        this.mValueCount = n;
        this.mFrameCount = n2;
        Interpolator.nativeReset(this.native_instance, n, n2);
    }

    public void setKeyFrame(int n, int n2, float[] fArray) {
        this.setKeyFrame(n, n2, fArray, null);
    }

    public void setKeyFrame(int n, int n2, float[] fArray, float[] fArray2) {
        int n3;
        if (n < 0 || n >= (n3 = this.mFrameCount)) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = fArray.length;
        int n5 = this.mValueCount;
        if (n4 < n5) {
            throw new ArrayStoreException();
        }
        if (fArray2 != null && fArray2.length < 4) {
            throw new ArrayStoreException();
        }
        Interpolator.nativeSetKeyFrame(this.native_instance, n, n2, fArray, fArray2);
    }

    public void setRepeatMirror(float f, boolean bl) {
        if (!(f >= 0.0f)) {
            return;
        }
        Interpolator.nativeSetRepeatMirror(this.native_instance, f, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result timeToValues(int n, float[] fArray) {
        int n2;
        int n3;
        if (fArray != null && (n3 = fArray.length) < (n2 = this.mValueCount)) {
            throw new ArrayStoreException();
        }
        switch (Interpolator.nativeTimeToValues(this.native_instance, n, fArray)) {
            default: {
                return Result.FREEZE_END;
            }
            case 0: {
                return Result.NORMAL;
            }
            case 1: 
        }
        return Result.FREEZE_START;
    }

    public Result timeToValues(float[] fArray) {
        int n = (int)SystemClock.uptimeMillis();
        return this.timeToValues(n, fArray);
    }

    public static final class Result
    extends Enum<Result> {
        private static final /* synthetic */ Result[] $VALUES;
        public static final /* enum */ Result FREEZE_END;
        public static final /* enum */ Result FREEZE_START;
        public static final /* enum */ Result NORMAL;

        static {
            NORMAL = new Result();
            FREEZE_START = new Result();
            FREEZE_END = new Result();
            Result result = NORMAL;
            Result result2 = FREEZE_START;
            Result result3 = FREEZE_END;
            Result[] resultArray = new Result[]{result, result2, result3};
            $VALUES = resultArray;
        }

        public static Result valueOf(String string2) {
            return Enum.valueOf(Result.class, string2);
        }

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }
    }
}

