/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;

public final class LargeBitmap {
    private int mNativeLargeBitmap;
    private boolean mRecycled;

    private LargeBitmap(int n) {
        this.mNativeLargeBitmap = n;
        this.mRecycled = false;
    }

    private void checkRecycled(String string2) {
        if (!this.mRecycled) {
            return;
        }
        throw new IllegalStateException(string2);
    }

    private static native void nativeClean(int var0);

    private static native Bitmap nativeDecodeRegion(int var0, int var1, int var2, int var3, int var4, BitmapFactory.Options var5);

    private static native int nativeGetHeight(int var0);

    private static native int nativeGetWidth(int var0);

    public Bitmap decodeRegion(Rect rect, BitmapFactory.Options options) {
        int n;
        int n2;
        int n3;
        int n4;
        this.checkRecycled("decodeRegion called on recycled large bitmap");
        if (rect.left < 0 || rect.top < 0 || (n4 = rect.right) > (n3 = this.getWidth()) || (n2 = rect.bottom) > (n = this.getHeight())) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        int n5 = this.mNativeLargeBitmap;
        int n6 = rect.left;
        int n7 = rect.top;
        int n8 = rect.right;
        int n9 = rect.left;
        int n10 = n8 - n9;
        int n11 = rect.bottom;
        int n12 = rect.top;
        int n13 = n11 - n12;
        BitmapFactory.Options options2 = options;
        return LargeBitmap.nativeDecodeRegion(n5, n6, n7, n10, n13, options2);
    }

    protected void finalize() {
        this.recycle();
    }

    public int getHeight() {
        this.checkRecycled("getHeight called on recycled large bitmap");
        return LargeBitmap.nativeGetHeight(this.mNativeLargeBitmap);
    }

    public int getWidth() {
        this.checkRecycled("getWidth called on recycled large bitmap");
        return LargeBitmap.nativeGetWidth(this.mNativeLargeBitmap);
    }

    public final boolean isRecycled() {
        return this.mRecycled;
    }

    public void recycle() {
        if (this.mRecycled) {
            return;
        }
        LargeBitmap.nativeClean(this.mNativeLargeBitmap);
        this.mRecycled = true;
    }
}

