/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.RectF;
import java.io.PrintWriter;

public class Matrix {
    public static final int MPERSP_0 = 6;
    public static final int MPERSP_1 = 7;
    public static final int MPERSP_2 = 8;
    public static final int MSCALE_X = 0;
    public static final int MSCALE_Y = 4;
    public static final int MSKEW_X = 1;
    public static final int MSKEW_Y = 3;
    public static final int MTRANS_X = 2;
    public static final int MTRANS_Y = 5;
    int native_instance;

    public Matrix() {
        int n;
        this.native_instance = n = Matrix.native_create(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Matrix(Matrix matrix) {
        int n;
        int n2 = matrix != null ? matrix.native_instance : 0;
        this.native_instance = n = Matrix.native_create(n2);
    }

    private static void checkPointArrays(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n3 << 1;
        int n7 = n + n6;
        int n8 = n3 << 1;
        int n9 = n2 + n8;
        if ((n3 | n | n2 | n7 | n9) >= 0 && n7 <= (n5 = fArray.length) && n9 <= (n4 = fArray2.length)) {
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private static native void finalizer(int var0);

    private static native int native_create(int var0);

    private static native boolean native_equals(int var0, int var1);

    private static native void native_getValues(int var0, float[] var1);

    private static native boolean native_invert(int var0, int var1);

    private static native boolean native_isIdentity(int var0);

    private static native void native_mapPoints(int var0, float[] var1, int var2, float[] var3, int var4, int var5, boolean var6);

    private static native float native_mapRadius(int var0, float var1);

    private static native boolean native_mapRect(int var0, RectF var1, RectF var2);

    private static native boolean native_postConcat(int var0, int var1);

    private static native boolean native_postRotate(int var0, float var1);

    private static native boolean native_postRotate(int var0, float var1, float var2, float var3);

    private static native boolean native_postScale(int var0, float var1, float var2);

    private static native boolean native_postScale(int var0, float var1, float var2, float var3, float var4);

    private static native boolean native_postSkew(int var0, float var1, float var2);

    private static native boolean native_postSkew(int var0, float var1, float var2, float var3, float var4);

    private static native boolean native_postTranslate(int var0, float var1, float var2);

    private static native boolean native_preConcat(int var0, int var1);

    private static native boolean native_preRotate(int var0, float var1);

    private static native boolean native_preRotate(int var0, float var1, float var2, float var3);

    private static native boolean native_preScale(int var0, float var1, float var2);

    private static native boolean native_preScale(int var0, float var1, float var2, float var3, float var4);

    private static native boolean native_preSkew(int var0, float var1, float var2);

    private static native boolean native_preSkew(int var0, float var1, float var2, float var3, float var4);

    private static native boolean native_preTranslate(int var0, float var1, float var2);

    private static native boolean native_rectStaysRect(int var0);

    private static native void native_reset(int var0);

    private static native void native_set(int var0, int var1);

    private static native boolean native_setConcat(int var0, int var1, int var2);

    private static native boolean native_setPolyToPoly(int var0, float[] var1, int var2, float[] var3, int var4, int var5);

    private static native boolean native_setRectToRect(int var0, RectF var1, RectF var2, int var3);

    private static native void native_setRotate(int var0, float var1);

    private static native void native_setRotate(int var0, float var1, float var2, float var3);

    private static native void native_setScale(int var0, float var1, float var2);

    private static native void native_setScale(int var0, float var1, float var2, float var3, float var4);

    private static native void native_setSinCos(int var0, float var1, float var2);

    private static native void native_setSinCos(int var0, float var1, float var2, float var3, float var4);

    private static native void native_setSkew(int var0, float var1, float var2);

    private static native void native_setSkew(int var0, float var1, float var2, float var3, float var4);

    private static native void native_setTranslate(int var0, float var1, float var2);

    private static native void native_setValues(int var0, float[] var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null) return false;
        if (!(object instanceof Matrix)) return false;
        int n = this.native_instance;
        int n2 = ((Matrix)object).native_instance;
        if (!Matrix.native_equals(n, n2)) return false;
        return true;
    }

    protected void finalize() throws Throwable {
        Matrix.finalizer(this.native_instance);
    }

    public void getValues(float[] fArray) {
        if (fArray.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.native_getValues(this.native_instance, fArray);
    }

    public boolean invert(Matrix matrix) {
        int n = this.native_instance;
        int n2 = matrix.native_instance;
        return Matrix.native_invert(n, n2);
    }

    public boolean isIdentity() {
        return Matrix.native_isIdentity(this.native_instance);
    }

    public void mapPoints(float[] fArray) {
        int n = fArray.length >> 1;
        Matrix matrix = this;
        float[] fArray2 = fArray;
        float[] fArray3 = fArray;
        int n2 = 0;
        matrix.mapPoints(fArray2, 0, fArray3, n2, n);
    }

    public void mapPoints(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        Matrix.checkPointArrays(fArray2, n2, fArray, n, n3);
        int n4 = this.native_instance;
        float[] fArray3 = fArray;
        int n5 = n;
        float[] fArray4 = fArray2;
        int n6 = n2;
        int n7 = n3;
        Matrix.native_mapPoints(n4, fArray3, n5, fArray4, n6, n7, true);
    }

    public void mapPoints(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        int n2 = fArray2.length;
        if (n != n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = fArray.length >> 1;
        Matrix matrix = this;
        float[] fArray3 = fArray;
        float[] fArray4 = fArray2;
        int n4 = 0;
        matrix.mapPoints(fArray3, 0, fArray4, n4, n3);
    }

    public float mapRadius(float f) {
        return Matrix.native_mapRadius(this.native_instance, f);
    }

    public boolean mapRect(RectF rectF) {
        return this.mapRect(rectF, rectF);
    }

    public boolean mapRect(RectF rectF, RectF rectF2) {
        if (rectF == null || rectF2 == null) {
            throw new NullPointerException();
        }
        return Matrix.native_mapRect(this.native_instance, rectF, rectF2);
    }

    public void mapVectors(float[] fArray) {
        int n = fArray.length >> 1;
        Matrix matrix = this;
        float[] fArray2 = fArray;
        float[] fArray3 = fArray;
        int n2 = 0;
        matrix.mapVectors(fArray2, 0, fArray3, n2, n);
    }

    public void mapVectors(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        Matrix.checkPointArrays(fArray2, n2, fArray, n, n3);
        int n4 = this.native_instance;
        float[] fArray3 = fArray;
        int n5 = n;
        float[] fArray4 = fArray2;
        int n6 = n2;
        int n7 = n3;
        Matrix.native_mapPoints(n4, fArray3, n5, fArray4, n6, n7, false);
    }

    public void mapVectors(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        int n2 = fArray2.length;
        if (n != n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = fArray.length >> 1;
        Matrix matrix = this;
        float[] fArray3 = fArray;
        float[] fArray4 = fArray2;
        int n4 = 0;
        matrix.mapVectors(fArray3, 0, fArray4, n4, n3);
    }

    final int ni() {
        return this.native_instance;
    }

    public boolean postConcat(Matrix matrix) {
        int n = this.native_instance;
        int n2 = matrix.native_instance;
        return Matrix.native_postConcat(n, n2);
    }

    public boolean postRotate(float f) {
        return Matrix.native_postRotate(this.native_instance, f);
    }

    public boolean postRotate(float f, float f2, float f3) {
        return Matrix.native_postRotate(this.native_instance, f, f2, f3);
    }

    public boolean postScale(float f, float f2) {
        return Matrix.native_postScale(this.native_instance, f, f2);
    }

    public boolean postScale(float f, float f2, float f3, float f4) {
        return Matrix.native_postScale(this.native_instance, f, f2, f3, f4);
    }

    public boolean postSkew(float f, float f2) {
        return Matrix.native_postSkew(this.native_instance, f, f2);
    }

    public boolean postSkew(float f, float f2, float f3, float f4) {
        return Matrix.native_postSkew(this.native_instance, f, f2, f3, f4);
    }

    public boolean postTranslate(float f, float f2) {
        return Matrix.native_postTranslate(this.native_instance, f, f2);
    }

    public boolean preConcat(Matrix matrix) {
        int n = this.native_instance;
        int n2 = matrix.native_instance;
        return Matrix.native_preConcat(n, n2);
    }

    public boolean preRotate(float f) {
        return Matrix.native_preRotate(this.native_instance, f);
    }

    public boolean preRotate(float f, float f2, float f3) {
        return Matrix.native_preRotate(this.native_instance, f, f2, f3);
    }

    public boolean preScale(float f, float f2) {
        return Matrix.native_preScale(this.native_instance, f, f2);
    }

    public boolean preScale(float f, float f2, float f3, float f4) {
        return Matrix.native_preScale(this.native_instance, f, f2, f3, f4);
    }

    public boolean preSkew(float f, float f2) {
        return Matrix.native_preSkew(this.native_instance, f, f2);
    }

    public boolean preSkew(float f, float f2, float f3, float f4) {
        return Matrix.native_preSkew(this.native_instance, f, f2, f3, f4);
    }

    public boolean preTranslate(float f, float f2) {
        return Matrix.native_preTranslate(this.native_instance, f, f2);
    }

    public void printShortString(PrintWriter printWriter) {
        float[] fArray = new float[9];
        this.getValues(fArray);
        printWriter.print('[');
        float f = fArray[0];
        printWriter.print(f);
        printWriter.print(", ");
        float f2 = fArray[1];
        printWriter.print(f2);
        printWriter.print(", ");
        float f3 = fArray[2];
        printWriter.print(f3);
        printWriter.print("][");
        float f4 = fArray[3];
        printWriter.print(f4);
        printWriter.print(", ");
        float f5 = fArray[4];
        printWriter.print(f5);
        printWriter.print(", ");
        float f6 = fArray[5];
        printWriter.print(f6);
        printWriter.print("][");
        float f7 = fArray[6];
        printWriter.print(f7);
        printWriter.print(", ");
        float f8 = fArray[7];
        printWriter.print(f8);
        printWriter.print(", ");
        float f9 = fArray[8];
        printWriter.print(f9);
        printWriter.print(']');
    }

    public boolean rectStaysRect() {
        return Matrix.native_rectStaysRect(this.native_instance);
    }

    public void reset() {
        Matrix.native_reset(this.native_instance);
    }

    public void set(Matrix matrix) {
        if (matrix == null) {
            this.reset();
            return;
        }
        int n = this.native_instance;
        int n2 = matrix.native_instance;
        Matrix.native_set(n, n2);
    }

    public boolean setConcat(Matrix matrix, Matrix matrix2) {
        int n = this.native_instance;
        int n2 = matrix.native_instance;
        int n3 = matrix2.native_instance;
        return Matrix.native_setConcat(n, n2, n3);
    }

    public boolean setPolyToPoly(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException();
        }
        Matrix.checkPointArrays(fArray, n, fArray2, n2, n3);
        int n4 = this.native_instance;
        float[] fArray3 = fArray;
        int n5 = n;
        float[] fArray4 = fArray2;
        int n6 = n2;
        int n7 = n3;
        return Matrix.native_setPolyToPoly(n4, fArray3, n5, fArray4, n6, n7);
    }

    public boolean setRectToRect(RectF rectF, RectF rectF2, ScaleToFit scaleToFit) {
        if (rectF2 == null || rectF == null) {
            throw new NullPointerException();
        }
        int n = this.native_instance;
        int n2 = scaleToFit.nativeInt;
        return Matrix.native_setRectToRect(n, rectF, rectF2, n2);
    }

    public void setRotate(float f) {
        Matrix.native_setRotate(this.native_instance, f);
    }

    public void setRotate(float f, float f2, float f3) {
        Matrix.native_setRotate(this.native_instance, f, f2, f3);
    }

    public void setScale(float f, float f2) {
        Matrix.native_setScale(this.native_instance, f, f2);
    }

    public void setScale(float f, float f2, float f3, float f4) {
        Matrix.native_setScale(this.native_instance, f, f2, f3, f4);
    }

    public void setSinCos(float f, float f2) {
        Matrix.native_setSinCos(this.native_instance, f, f2);
    }

    public void setSinCos(float f, float f2, float f3, float f4) {
        Matrix.native_setSinCos(this.native_instance, f, f2, f3, f4);
    }

    public void setSkew(float f, float f2) {
        Matrix.native_setSkew(this.native_instance, f, f2);
    }

    public void setSkew(float f, float f2, float f3, float f4) {
        Matrix.native_setSkew(this.native_instance, f, f2, f3, f4);
    }

    public void setTranslate(float f, float f2) {
        Matrix.native_setTranslate(this.native_instance, f, f2);
    }

    public void setValues(float[] fArray) {
        if (fArray.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.native_setValues(this.native_instance, fArray);
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        this.toShortString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toShortString(StringBuilder stringBuilder) {
        float[] fArray = new float[9];
        this.getValues(fArray);
        StringBuilder stringBuilder2 = stringBuilder.append('[');
        float f = fArray[0];
        StringBuilder stringBuilder3 = stringBuilder.append(f);
        StringBuilder stringBuilder4 = stringBuilder.append(", ");
        float f2 = fArray[1];
        StringBuilder stringBuilder5 = stringBuilder.append(f2);
        StringBuilder stringBuilder6 = stringBuilder.append(", ");
        float f3 = fArray[2];
        StringBuilder stringBuilder7 = stringBuilder.append(f3);
        StringBuilder stringBuilder8 = stringBuilder.append("][");
        float f4 = fArray[3];
        StringBuilder stringBuilder9 = stringBuilder.append(f4);
        StringBuilder stringBuilder10 = stringBuilder.append(", ");
        float f5 = fArray[4];
        StringBuilder stringBuilder11 = stringBuilder.append(f5);
        StringBuilder stringBuilder12 = stringBuilder.append(", ");
        float f6 = fArray[5];
        StringBuilder stringBuilder13 = stringBuilder.append(f6);
        StringBuilder stringBuilder14 = stringBuilder.append("][");
        float f7 = fArray[6];
        StringBuilder stringBuilder15 = stringBuilder.append(f7);
        StringBuilder stringBuilder16 = stringBuilder.append(", ");
        float f8 = fArray[7];
        StringBuilder stringBuilder17 = stringBuilder.append(f8);
        StringBuilder stringBuilder18 = stringBuilder.append(", ");
        float f9 = fArray[8];
        StringBuilder stringBuilder19 = stringBuilder.append(f9);
        StringBuilder stringBuilder20 = stringBuilder.append(']');
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        StringBuilder stringBuilder2 = stringBuilder.append("Matrix{");
        this.toShortString(stringBuilder);
        StringBuilder stringBuilder3 = stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static final class ScaleToFit
    extends Enum<ScaleToFit> {
        private static final /* synthetic */ ScaleToFit[] $VALUES;
        public static final /* enum */ ScaleToFit CENTER;
        public static final /* enum */ ScaleToFit END;
        public static final /* enum */ ScaleToFit FILL;
        public static final /* enum */ ScaleToFit START;
        final int nativeInt;

        static {
            FILL = new ScaleToFit(0);
            START = new ScaleToFit(1);
            CENTER = new ScaleToFit(2);
            END = new ScaleToFit(3);
            ScaleToFit scaleToFit = FILL;
            ScaleToFit scaleToFit2 = START;
            ScaleToFit scaleToFit3 = CENTER;
            ScaleToFit scaleToFit4 = END;
            ScaleToFit[] scaleToFitArray = new ScaleToFit[]{scaleToFit, scaleToFit2, scaleToFit3, scaleToFit4};
            $VALUES = scaleToFitArray;
        }

        private ScaleToFit(int n2) {
            this.nativeInt = n2;
        }

        public static ScaleToFit valueOf(String string2) {
            return Enum.valueOf(ScaleToFit.class, string2);
        }

        public static ScaleToFit[] values() {
            return (ScaleToFit[])$VALUES.clone();
        }
    }
}

