/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Movie {
    private final int mNativeMovie;

    private Movie(int n) {
        if (n == 0) {
            throw new RuntimeException("native movie creation failed");
        }
        this.mNativeMovie = n;
    }

    public static native Movie decodeByteArray(byte[] var0, int var1, int var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Movie decodeFile(String string2) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return Movie.decodeTempStream(fileInputStream);
    }

    public static native Movie decodeStream(InputStream var0);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Movie decodeTempStream(InputStream inputStream) {
        Movie movie;
        try {
            movie = Movie.decodeStream(inputStream);
            inputStream.close();
            return movie;
        }
        catch (IOException iOException) {
            return movie;
        }
    }

    public void draw(Canvas canvas, float f, float f2) {
        this.draw(canvas, f, f2, null);
    }

    public native void draw(Canvas var1, float var2, float var3, Paint var4);

    public native int duration();

    public native int height();

    public native boolean isOpaque();

    public native boolean setTime(int var1);

    public native int width();
}

