/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;

public class NinePatch {
    private final Bitmap mBitmap;
    private final byte[] mChunk;
    private Paint mPaint;
    private String mSrcName;

    public NinePatch(Bitmap bitmap, byte[] byArray, String string2) {
        this.mBitmap = bitmap;
        this.mChunk = byArray;
        this.mSrcName = string2;
        NinePatch.validateNinePatchChunk(this.mBitmap.ni(), byArray);
    }

    public NinePatch(NinePatch ninePatch) {
        String string2;
        byte[] byArray;
        Bitmap bitmap;
        this.mBitmap = bitmap = ninePatch.mBitmap;
        this.mChunk = byArray = ninePatch.mChunk;
        this.mSrcName = string2 = ninePatch.mSrcName;
        if (ninePatch.mPaint != null) {
            Paint paint;
            Paint paint2 = ninePatch.mPaint;
            this.mPaint = paint = new Paint(paint2);
        }
        int n = this.mBitmap.ni();
        byte[] byArray2 = this.mChunk;
        NinePatch.validateNinePatchChunk(n, byArray2);
    }

    public static native boolean isNinePatchChunk(byte[] var0);

    private static native void nativeDraw(int var0, Rect var1, int var2, byte[] var3, int var4, int var5, int var6);

    private static native void nativeDraw(int var0, RectF var1, int var2, byte[] var3, int var4, int var5, int var6);

    private static native int nativeGetTransparentRegion(int var0, byte[] var1, Rect var2);

    private static native void validateNinePatchChunk(int var0, byte[] var1);

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas, Rect rect) {
        int n = canvas.mNativeCanvas;
        int n2 = this.mBitmap.ni();
        byte[] byArray = this.mChunk;
        int n3 = this.mPaint != null ? this.mPaint.mNativePaint : 0;
        int n4 = canvas.mDensity;
        int n5 = this.mBitmap.mDensity;
        Rect rect2 = rect;
        NinePatch.nativeDraw(n, rect2, n2, byArray, n3, n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas, Rect rect, Paint paint) {
        int n = canvas.mNativeCanvas;
        int n2 = this.mBitmap.ni();
        byte[] byArray = this.mChunk;
        int n3 = paint != null ? paint.mNativePaint : 0;
        int n4 = canvas.mDensity;
        int n5 = this.mBitmap.mDensity;
        Rect rect2 = rect;
        NinePatch.nativeDraw(n, rect2, n2, byArray, n3, n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas, RectF rectF) {
        int n = canvas.mNativeCanvas;
        int n2 = this.mBitmap.ni();
        byte[] byArray = this.mChunk;
        int n3 = this.mPaint != null ? this.mPaint.mNativePaint : 0;
        int n4 = canvas.mDensity;
        int n5 = this.mBitmap.mDensity;
        RectF rectF2 = rectF;
        NinePatch.nativeDraw(n, rectF2, n2, byArray, n3, n4, n5);
    }

    public int getDensity() {
        return this.mBitmap.mDensity;
    }

    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Region getTransparentRegion(Rect rect) {
        byte[] byArray;
        int n = this.mBitmap.ni();
        int n2 = NinePatch.nativeGetTransparentRegion(n, byArray = this.mChunk, rect);
        if (n2 == 0) return null;
        return new Region(n2);
    }

    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    public final boolean hasAlpha() {
        return this.mBitmap.hasAlpha();
    }

    public void setPaint(Paint paint) {
        this.mPaint = paint;
    }
}

