/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;

public class Paint {
    public static final int ANTI_ALIAS_FLAG = 1;
    private static final int DEFAULT_PAINT_FLAGS = 256;
    public static final int DEV_KERN_TEXT_FLAG = 256;
    public static final int DITHER_FLAG = 4;
    public static final int FAKE_BOLD_TEXT_FLAG = 32;
    public static final int FILTER_BITMAP_FLAG = 2;
    public static final int LINEAR_TEXT_FLAG = 64;
    public static final int STRIKE_THRU_TEXT_FLAG = 16;
    public static final int SUBPIXEL_TEXT_FLAG = 128;
    public static final int UNDERLINE_TEXT_FLAG = 8;
    private static final Align[] sAlignArray;
    private static final Cap[] sCapArray;
    private static final Join[] sJoinArray;
    private static final Style[] sStyleArray;
    private ColorFilter mColorFilter;
    private float mCompatScaling;
    private boolean mHasCompatScaling;
    private float mInvCompatScaling;
    private MaskFilter mMaskFilter;
    int mNativePaint;
    private PathEffect mPathEffect;
    private Rasterizer mRasterizer;
    private Shader mShader;
    private Typeface mTypeface;
    private Xfermode mXfermode;

    static {
        Style style2 = Style.FILL;
        Style style3 = Style.STROKE;
        Style style4 = Style.FILL_AND_STROKE;
        Style[] styleArray = new Style[]{style2, style3, style4};
        sStyleArray = styleArray;
        Cap cap = Cap.BUTT;
        Cap cap2 = Cap.ROUND;
        Cap cap3 = Cap.SQUARE;
        Cap[] capArray = new Cap[]{cap, cap2, cap3};
        sCapArray = capArray;
        Join join = Join.MITER;
        Join join2 = Join.ROUND;
        Join join3 = Join.BEVEL;
        Join[] joinArray = new Join[]{join, join2, join3};
        sJoinArray = joinArray;
        Align align = Align.LEFT;
        Align align2 = Align.CENTER;
        Align align3 = Align.RIGHT;
        Align[] alignArray = new Align[]{align, align2, align3};
        sAlignArray = alignArray;
    }

    public Paint() {
        this(0);
    }

    public Paint(int n) {
        int n2;
        this.mNativePaint = n2 = Paint.native_init();
        int n3 = n | 0x100;
        this.setFlags(n3);
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
    }

    public Paint(Paint paint) {
        float f;
        float f2;
        boolean bl;
        int n;
        this.mNativePaint = n = Paint.native_initWithPaint(paint.mNativePaint);
        this.mHasCompatScaling = bl = paint.mHasCompatScaling;
        this.mCompatScaling = f2 = paint.mCompatScaling;
        this.mInvCompatScaling = f = paint.mInvCompatScaling;
    }

    private static native void finalizer(int var0);

    private static native void nativeGetCharArrayBounds(int var0, char[] var1, int var2, int var3, Rect var4);

    private static native void nativeGetStringBounds(int var0, String var1, int var2, int var3, Rect var4);

    private native int native_breakText(String var1, boolean var2, float var3, float[] var4);

    private native int native_breakText(char[] var1, int var2, int var3, float var4, float[] var5);

    private static native boolean native_getFillPath(int var0, int var1, int var2);

    private static native float native_getFontMetrics(int var0, FontMetrics var1);

    private static native int native_getStrokeCap(int var0);

    private static native int native_getStrokeJoin(int var0);

    private static native int native_getStyle(int var0);

    private static native int native_getTextAlign(int var0);

    private static native void native_getTextPath(int var0, String var1, int var2, int var3, float var4, float var5, int var6);

    private static native void native_getTextPath(int var0, char[] var1, int var2, int var3, float var4, float var5, int var6);

    private static native int native_getTextWidths(int var0, String var1, int var2, int var3, float[] var4);

    private static native int native_getTextWidths(int var0, char[] var1, int var2, int var3, float[] var4);

    private static native int native_init();

    private static native int native_initWithPaint(int var0);

    private native float native_measureText(String var1);

    private native float native_measureText(String var1, int var2, int var3);

    private native float native_measureText(char[] var1, int var2, int var3);

    private static native void native_reset(int var0);

    private static native void native_set(int var0, int var1);

    private static native int native_setColorFilter(int var0, int var1);

    private static native int native_setMaskFilter(int var0, int var1);

    private static native int native_setPathEffect(int var0, int var1);

    private static native int native_setRasterizer(int var0, int var1);

    private static native int native_setShader(int var0, int var1);

    private static native void native_setStrokeCap(int var0, int var1);

    private static native void native_setStrokeJoin(int var0, int var1);

    private static native void native_setStyle(int var0, int var1);

    private static native void native_setTextAlign(int var0, int var1);

    private static native int native_setTypeface(int var0, int var1);

    private static native int native_setXfermode(int var0, int var1);

    public native float ascent();

    /*
     * Enabled aggressive block sorting
     */
    public int breakText(CharSequence charSequence, int n, int n2, boolean bl, float f, float[] fArray) {
        int n3;
        int n4;
        if (n == 0 && charSequence instanceof String && n2 != (n4 = charSequence.length())) {
            String string2 = (String)charSequence;
            return this.breakText(string2, bl, f, fArray);
        }
        char[] cArray = TemporaryBuffer.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        if (bl) {
            int n5 = n2 - n;
            Paint paint = this;
            float f2 = f;
            float[] fArray2 = fArray;
            n3 = paint.breakText(cArray, 0, n5, f2, fArray2);
        } else {
            int n6 = -(n2 - n);
            Paint paint = this;
            float f3 = f;
            float[] fArray3 = fArray;
            n3 = paint.breakText(cArray, 0, n6, f3, fArray3);
        }
        TemporaryBuffer.recycle(cArray);
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int breakText(String string2, boolean bl, float f, float[] fArray) {
        float f2;
        if (!this.mHasCompatScaling) {
            return this.native_breakText(string2, bl, f, fArray);
        }
        float f3 = this.getTextSize();
        float f4 = this.mCompatScaling * f3;
        this.setTextSize(f4);
        float f5 = this.mCompatScaling * f;
        int n = this.native_breakText(string2, bl, f5, fArray);
        this.setTextSize(f3);
        if (fArray == null) return n;
        float f6 = fArray[0];
        float f7 = this.mInvCompatScaling;
        fArray[0] = f2 = f6 * f7;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int breakText(char[] cArray, int n, int n2, float f, float[] fArray) {
        float f2;
        if (!this.mHasCompatScaling) {
            return this.native_breakText(cArray, n, n2, f, fArray);
        }
        float f3 = this.getTextSize();
        float f4 = this.mCompatScaling * f3;
        this.setTextSize(f4);
        float f5 = this.mCompatScaling;
        float f6 = f * f5;
        Paint paint = this;
        char[] cArray2 = cArray;
        int n3 = n;
        int n4 = n2;
        float[] fArray2 = fArray;
        int n5 = paint.native_breakText(cArray2, n3, n4, f6, fArray2);
        this.setTextSize(f3);
        if (fArray == null) return n5;
        float f7 = fArray[0];
        float f8 = this.mInvCompatScaling;
        fArray[0] = f2 = f7 * f8;
        return n5;
    }

    public void clearShadowLayer() {
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    public native float descent();

    protected void finalize() throws Throwable {
        Paint.finalizer(this.mNativePaint);
    }

    public native int getAlpha();

    public native int getColor();

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public boolean getFillPath(Path path, Path path2) {
        int n = this.mNativePaint;
        int n2 = path.ni();
        int n3 = path2.ni();
        return Paint.native_getFillPath(n, n2, n3);
    }

    public native int getFlags();

    public native float getFontMetrics(FontMetrics var1);

    public FontMetrics getFontMetrics() {
        FontMetrics fontMetrics = new FontMetrics();
        float f = this.getFontMetrics(fontMetrics);
        return fontMetrics;
    }

    public native int getFontMetricsInt(FontMetricsInt var1);

    public FontMetricsInt getFontMetricsInt() {
        FontMetricsInt fontMetricsInt = new FontMetricsInt();
        int n = this.getFontMetricsInt(fontMetricsInt);
        return fontMetricsInt;
    }

    public float getFontSpacing() {
        return this.getFontMetrics(null);
    }

    public MaskFilter getMaskFilter() {
        return this.mMaskFilter;
    }

    public PathEffect getPathEffect() {
        return this.mPathEffect;
    }

    public Rasterizer getRasterizer() {
        return this.mRasterizer;
    }

    public Shader getShader() {
        return this.mShader;
    }

    public Cap getStrokeCap() {
        Cap[] capArray = sCapArray;
        int n = Paint.native_getStrokeCap(this.mNativePaint);
        return capArray[n];
    }

    public Join getStrokeJoin() {
        Join[] joinArray = sJoinArray;
        int n = Paint.native_getStrokeJoin(this.mNativePaint);
        return joinArray[n];
    }

    public native float getStrokeMiter();

    public native float getStrokeWidth();

    public Style getStyle() {
        Style[] styleArray = sStyleArray;
        int n = Paint.native_getStyle(this.mNativePaint);
        return styleArray[n];
    }

    public Align getTextAlign() {
        Align[] alignArray = sAlignArray;
        int n = Paint.native_getTextAlign(this.mNativePaint);
        return alignArray[n];
    }

    public void getTextBounds(String string2, int n, int n2, Rect rect) {
        int n3 = n | n2;
        int n4 = n2 - n;
        int n5 = n3 | n4;
        int n6 = string2.length() - n2;
        if ((n5 | n6) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (rect == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nativeGetStringBounds(this.mNativePaint, string2, n, n2, rect);
    }

    public void getTextBounds(char[] cArray, int n, int n2, Rect rect) {
        int n3;
        int n4;
        if ((n | n2) < 0 || (n4 = n + n2) > (n3 = cArray.length)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (rect == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nativeGetCharArrayBounds(this.mNativePaint, cArray, n, n2, rect);
    }

    public void getTextPath(String string2, int n, int n2, float f, float f2, Path path) {
        int n3 = n | n2;
        int n4 = n2 - n;
        int n5 = n3 | n4;
        int n6 = string2.length() - n2;
        if ((n5 | n6) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n7 = this.mNativePaint;
        int n8 = path.ni();
        String string3 = string2;
        int n9 = n;
        int n10 = n2;
        float f3 = f;
        float f4 = f2;
        Paint.native_getTextPath(n7, string3, n9, n10, f3, f4, n8);
    }

    public void getTextPath(char[] cArray, int n, int n2, float f, float f2, Path path) {
        int n3;
        int n4;
        if ((n | n2) < 0 || (n4 = n + n2) > (n3 = cArray.length)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n5 = this.mNativePaint;
        int n6 = path.ni();
        char[] cArray2 = cArray;
        int n7 = n;
        int n8 = n2;
        float f3 = f;
        float f4 = f2;
        Paint.native_getTextPath(n5, cArray2, n7, n8, f3, f4, n6);
    }

    public native float getTextScaleX();

    public native float getTextSize();

    public native float getTextSkewX();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTextWidths(CharSequence charSequence, int n, int n2, float[] fArray) {
        if (charSequence instanceof String) {
            String string2 = (String)charSequence;
            return this.getTextWidths(string2, n, n2, fArray);
        }
        if (charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            String string3 = ((Object)charSequence).toString();
            return this.getTextWidths(string3, n, n2, fArray);
        }
        if (charSequence instanceof GraphicsOperations) {
            return ((GraphicsOperations)charSequence).getTextWidths(n, n2, fArray, this);
        }
        char[] cArray = TemporaryBuffer.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        int n3 = n2 - n;
        int n4 = this.getTextWidths(cArray, 0, n3, fArray);
        TemporaryBuffer.recycle(cArray);
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTextWidths(String string2, int n, int n2, float[] fArray) {
        int n3 = n | n2;
        int n4 = n2 - n;
        int n5 = n3 | n4;
        int n6 = string2.length() - n2;
        if ((n5 | n6) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n7 = n2 - n;
        int n8 = fArray.length;
        if (n7 > n8) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextWidths(this.mNativePaint, string2, n, n2, fArray);
        }
        float f = this.getTextSize();
        float f2 = this.mCompatScaling * f;
        this.setTextSize(f2);
        int n9 = Paint.native_getTextWidths(this.mNativePaint, string2, n, n2, fArray);
        this.setTextSize(f);
        int n10 = 0;
        while (n10 < n9) {
            float f3;
            float f4 = fArray[n10];
            float f5 = this.mInvCompatScaling;
            fArray[n10] = f3 = f4 * f5;
            ++n10;
        }
        return n9;
    }

    public int getTextWidths(String string2, float[] fArray) {
        int n = string2.length();
        return this.getTextWidths(string2, 0, n, fArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTextWidths(char[] cArray, int n, int n2, float[] fArray) {
        if ((n | n2) < 0) throw new ArrayIndexOutOfBoundsException();
        int n3 = n + n2;
        int n4 = cArray.length;
        if (n3 > n4) throw new ArrayIndexOutOfBoundsException();
        int n5 = fArray.length;
        if (n2 > n5) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextWidths(this.mNativePaint, cArray, n, n2, fArray);
        }
        float f = this.getTextSize();
        float f2 = this.mCompatScaling * f;
        this.setTextSize(f2);
        int n6 = Paint.native_getTextWidths(this.mNativePaint, cArray, n, n2, fArray);
        this.setTextSize(f);
        int n7 = 0;
        while (n7 < n6) {
            float f3;
            float f4 = fArray[n7];
            float f5 = this.mInvCompatScaling;
            fArray[n7] = f3 = f4 * f5;
            ++n7;
        }
        return n6;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public Xfermode getXfermode() {
        return this.mXfermode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAntiAlias() {
        if ((this.getFlags() & 1) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isDither() {
        if ((this.getFlags() & 4) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFakeBoldText() {
        if ((this.getFlags() & 0x20) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFilterBitmap() {
        if ((this.getFlags() & 2) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLinearText() {
        if ((this.getFlags() & 0x40) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isStrikeThruText() {
        if ((this.getFlags() & 0x10) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSubpixelText() {
        if ((this.getFlags() & 0x80) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnderlineText() {
        if ((this.getFlags() & 8) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float measureText(CharSequence charSequence, int n, int n2) {
        if (charSequence instanceof String) {
            String string2 = (String)charSequence;
            return this.measureText(string2, n, n2);
        }
        if (charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            String string3 = ((Object)charSequence).toString();
            return this.measureText(string3, n, n2);
        }
        if (charSequence instanceof GraphicsOperations) {
            return ((GraphicsOperations)charSequence).measureText(n, n2, this);
        }
        char[] cArray = TemporaryBuffer.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        int n3 = n2 - n;
        float f = this.measureText(cArray, 0, n3);
        TemporaryBuffer.recycle(cArray);
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float measureText(String string2) {
        if (!this.mHasCompatScaling) {
            return this.native_measureText(string2);
        }
        float f = this.getTextSize();
        float f2 = this.mCompatScaling * f;
        this.setTextSize(f2);
        float f3 = this.native_measureText(string2);
        this.setTextSize(f);
        return this.mInvCompatScaling * f3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float measureText(String string2, int n, int n2) {
        if (!this.mHasCompatScaling) {
            return this.native_measureText(string2, n, n2);
        }
        float f = this.getTextSize();
        float f2 = this.mCompatScaling * f;
        this.setTextSize(f2);
        float f3 = this.native_measureText(string2, n, n2);
        this.setTextSize(f);
        return this.mInvCompatScaling * f3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float measureText(char[] cArray, int n, int n2) {
        if (!this.mHasCompatScaling) {
            return this.native_measureText(cArray, n, n2);
        }
        float f = this.getTextSize();
        float f2 = this.mCompatScaling * f;
        this.setTextSize(f2);
        float f3 = this.native_measureText(cArray, n, n2);
        this.setTextSize(f);
        return this.mInvCompatScaling * f3;
    }

    public void reset() {
        Paint.native_reset(this.mNativePaint);
        this.setFlags(256);
        this.mHasCompatScaling = false;
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
    }

    public void set(Paint paint) {
        float f;
        float f2;
        boolean bl;
        Xfermode xfermode;
        Typeface typeface;
        Shader shader;
        Rasterizer rasterizer;
        PathEffect pathEffect;
        MaskFilter maskFilter;
        ColorFilter colorFilter;
        if (this == paint) {
            return;
        }
        int n = this.mNativePaint;
        int n2 = paint.mNativePaint;
        Paint.native_set(n, n2);
        this.mColorFilter = colorFilter = paint.mColorFilter;
        this.mMaskFilter = maskFilter = paint.mMaskFilter;
        this.mPathEffect = pathEffect = paint.mPathEffect;
        this.mRasterizer = rasterizer = paint.mRasterizer;
        this.mShader = shader = paint.mShader;
        this.mTypeface = typeface = paint.mTypeface;
        this.mXfermode = xfermode = paint.mXfermode;
        this.mHasCompatScaling = bl = paint.mHasCompatScaling;
        this.mCompatScaling = f2 = paint.mCompatScaling;
        this.mInvCompatScaling = f = paint.mInvCompatScaling;
    }

    public void setARGB(int n, int n2, int n3, int n4) {
        int n5 = n << 24;
        int n6 = n2 << 16;
        int n7 = n5 | n6;
        int n8 = n3 << 8;
        int n9 = n7 | n8 | n4;
        this.setColor(n9);
    }

    public native void setAlpha(int var1);

    public native void setAntiAlias(boolean var1);

    public native void setColor(int var1);

    public ColorFilter setColorFilter(ColorFilter colorFilter) {
        int n = 0;
        if (colorFilter != null) {
            n = colorFilter.native_instance;
        }
        int n2 = Paint.native_setColorFilter(this.mNativePaint, n);
        this.mColorFilter = colorFilter;
        return colorFilter;
    }

    public void setCompatibilityScaling(float f) {
        float f2;
        if ((double)f == 1.0) {
            this.mHasCompatScaling = false;
            this.mInvCompatScaling = 1.0f;
            this.mCompatScaling = 1.0f;
            return;
        }
        this.mHasCompatScaling = true;
        this.mCompatScaling = f;
        this.mInvCompatScaling = f2 = 1.0f / f;
    }

    public native void setDither(boolean var1);

    public native void setFakeBoldText(boolean var1);

    public native void setFilterBitmap(boolean var1);

    public native void setFlags(int var1);

    public native void setLinearText(boolean var1);

    public MaskFilter setMaskFilter(MaskFilter maskFilter) {
        int n = 0;
        if (maskFilter != null) {
            n = maskFilter.native_instance;
        }
        int n2 = Paint.native_setMaskFilter(this.mNativePaint, n);
        this.mMaskFilter = maskFilter;
        return maskFilter;
    }

    public PathEffect setPathEffect(PathEffect pathEffect) {
        int n = 0;
        if (pathEffect != null) {
            n = pathEffect.native_instance;
        }
        int n2 = Paint.native_setPathEffect(this.mNativePaint, n);
        this.mPathEffect = pathEffect;
        return pathEffect;
    }

    public Rasterizer setRasterizer(Rasterizer rasterizer) {
        int n = 0;
        if (rasterizer != null) {
            n = rasterizer.native_instance;
        }
        int n2 = Paint.native_setRasterizer(this.mNativePaint, n);
        this.mRasterizer = rasterizer;
        return rasterizer;
    }

    public Shader setShader(Shader shader) {
        int n = 0;
        if (shader != null) {
            n = shader.native_instance;
        }
        int n2 = Paint.native_setShader(this.mNativePaint, n);
        this.mShader = shader;
        return shader;
    }

    public native void setShadowLayer(float var1, float var2, float var3, int var4);

    public native void setStrikeThruText(boolean var1);

    public void setStrokeCap(Cap cap) {
        int n = this.mNativePaint;
        int n2 = cap.nativeInt;
        Paint.native_setStrokeCap(n, n2);
    }

    public void setStrokeJoin(Join join) {
        int n = this.mNativePaint;
        int n2 = join.nativeInt;
        Paint.native_setStrokeJoin(n, n2);
    }

    public native void setStrokeMiter(float var1);

    public native void setStrokeWidth(float var1);

    public void setStyle(Style style2) {
        int n = this.mNativePaint;
        int n2 = style2.nativeInt;
        Paint.native_setStyle(n, n2);
    }

    public native void setSubpixelText(boolean var1);

    public void setTextAlign(Align align) {
        int n = this.mNativePaint;
        int n2 = align.nativeInt;
        Paint.native_setTextAlign(n, n2);
    }

    public native void setTextScaleX(float var1);

    public native void setTextSize(float var1);

    public native void setTextSkewX(float var1);

    public Typeface setTypeface(Typeface typeface) {
        int n = 0;
        if (typeface != null) {
            n = typeface.native_instance;
        }
        int n2 = Paint.native_setTypeface(this.mNativePaint, n);
        this.mTypeface = typeface;
        return typeface;
    }

    public native void setUnderlineText(boolean var1);

    public Xfermode setXfermode(Xfermode xfermode) {
        int n = 0;
        if (xfermode != null) {
            n = xfermode.native_instance;
        }
        int n2 = Paint.native_setXfermode(this.mNativePaint, n);
        this.mXfermode = xfermode;
        return xfermode;
    }

    public static class FontMetricsInt {
        public int ascent;
        public int bottom;
        public int descent;
        public int leading;
        public int top;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("FontMetricsInt: top=");
            int n = this.top;
            StringBuilder stringBuilder2 = stringBuilder.append(n).append(" ascent=");
            int n2 = this.ascent;
            StringBuilder stringBuilder3 = stringBuilder2.append(n2).append(" descent=");
            int n3 = this.descent;
            StringBuilder stringBuilder4 = stringBuilder3.append(n3).append(" bottom=");
            int n4 = this.bottom;
            StringBuilder stringBuilder5 = stringBuilder4.append(n4).append(" leading=");
            int n5 = this.leading;
            return stringBuilder5.append(n5).toString();
        }
    }

    public static class FontMetrics {
        public float ascent;
        public float bottom;
        public float descent;
        public float leading;
        public float top;
    }

    public static final class Align
    extends Enum<Align> {
        private static final /* synthetic */ Align[] $VALUES;
        public static final /* enum */ Align CENTER;
        public static final /* enum */ Align LEFT;
        public static final /* enum */ Align RIGHT;
        final int nativeInt;

        static {
            LEFT = new Align(0);
            CENTER = new Align(1);
            RIGHT = new Align(2);
            Align align = LEFT;
            Align align2 = CENTER;
            Align align3 = RIGHT;
            Align[] alignArray = new Align[]{align, align2, align3};
            $VALUES = alignArray;
        }

        private Align(int n2) {
            this.nativeInt = n2;
        }

        public static Align valueOf(String string2) {
            return Enum.valueOf(Align.class, string2);
        }

        public static Align[] values() {
            return (Align[])$VALUES.clone();
        }
    }

    public static final class Join
    extends Enum<Join> {
        private static final /* synthetic */ Join[] $VALUES;
        public static final /* enum */ Join BEVEL;
        public static final /* enum */ Join MITER;
        public static final /* enum */ Join ROUND;
        final int nativeInt;

        static {
            MITER = new Join(0);
            ROUND = new Join(1);
            BEVEL = new Join(2);
            Join join = MITER;
            Join join2 = ROUND;
            Join join3 = BEVEL;
            Join[] joinArray = new Join[]{join, join2, join3};
            $VALUES = joinArray;
        }

        private Join(int n2) {
            this.nativeInt = n2;
        }

        public static Join valueOf(String string2) {
            return Enum.valueOf(Join.class, string2);
        }

        public static Join[] values() {
            return (Join[])$VALUES.clone();
        }
    }

    public static final class Cap
    extends Enum<Cap> {
        private static final /* synthetic */ Cap[] $VALUES;
        public static final /* enum */ Cap BUTT = new Cap(0);
        public static final /* enum */ Cap ROUND = new Cap(1);
        public static final /* enum */ Cap SQUARE = new Cap(2);
        final int nativeInt;

        static {
            Cap cap = BUTT;
            Cap cap2 = ROUND;
            Cap cap3 = SQUARE;
            Cap[] capArray = new Cap[]{cap, cap2, cap3};
            $VALUES = capArray;
        }

        private Cap(int n2) {
            this.nativeInt = n2;
        }

        public static Cap valueOf(String string2) {
            return Enum.valueOf(Cap.class, string2);
        }

        public static Cap[] values() {
            return (Cap[])$VALUES.clone();
        }
    }

    public static final class Style
    extends Enum<Style> {
        private static final /* synthetic */ Style[] $VALUES;
        public static final /* enum */ Style FILL = new Style(0);
        public static final /* enum */ Style FILL_AND_STROKE;
        public static final /* enum */ Style STROKE;
        final int nativeInt;

        static {
            STROKE = new Style(1);
            FILL_AND_STROKE = new Style(2);
            Style style2 = FILL;
            Style style3 = STROKE;
            Style style4 = FILL_AND_STROKE;
            Style[] styleArray = new Style[]{style2, style3, style4};
            $VALUES = styleArray;
        }

        private Style(int n2) {
            this.nativeInt = n2;
        }

        public static Style valueOf(String string2) {
            return Enum.valueOf(Style.class, string2);
        }

        public static Style[] values() {
            return (Style[])$VALUES.clone();
        }
    }
}

