/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.RectF;

public class Path {
    private static final FillType[] sFillTypeArray;
    private final int mNativePath;

    static {
        FillType fillType = FillType.WINDING;
        FillType fillType2 = FillType.EVEN_ODD;
        FillType fillType3 = FillType.INVERSE_WINDING;
        FillType fillType4 = FillType.INVERSE_EVEN_ODD;
        FillType[] fillTypeArray = new FillType[]{fillType, fillType2, fillType3, fillType4};
        sFillTypeArray = fillTypeArray;
    }

    public Path() {
        int n;
        this.mNativePath = n = Path.init1();
    }

    public Path(Path path) {
        int n;
        int n2 = 0;
        if (path != null) {
            n2 = path.mNativePath;
        }
        this.mNativePath = n = Path.init2(n2);
    }

    private static native void finalizer(int var0);

    private static native int init1();

    private static native int init2(int var0);

    private static native void native_addArc(int var0, RectF var1, float var2, float var3);

    private static native void native_addCircle(int var0, float var1, float var2, float var3, int var4);

    private static native void native_addOval(int var0, RectF var1, int var2);

    private static native void native_addPath(int var0, int var1);

    private static native void native_addPath(int var0, int var1, float var2, float var3);

    private static native void native_addPath(int var0, int var1, int var2);

    private static native void native_addRect(int var0, float var1, float var2, float var3, float var4, int var5);

    private static native void native_addRect(int var0, RectF var1, int var2);

    private static native void native_addRoundRect(int var0, RectF var1, float var2, float var3, int var4);

    private static native void native_addRoundRect(int var0, RectF var1, float[] var2, int var3);

    private static native void native_arcTo(int var0, RectF var1, float var2, float var3, boolean var4);

    private static native void native_close(int var0);

    private static native void native_computeBounds(int var0, RectF var1);

    private static native void native_cubicTo(int var0, float var1, float var2, float var3, float var4, float var5, float var6);

    private static native int native_getFillType(int var0);

    private static native void native_incReserve(int var0, int var1);

    private static native boolean native_isEmpty(int var0);

    private static native boolean native_isRect(int var0, RectF var1);

    private static native void native_lineTo(int var0, float var1, float var2);

    private static native void native_moveTo(int var0, float var1, float var2);

    private static native void native_offset(int var0, float var1, float var2);

    private static native void native_offset(int var0, float var1, float var2, int var3);

    private static native void native_quadTo(int var0, float var1, float var2, float var3, float var4);

    private static native void native_rCubicTo(int var0, float var1, float var2, float var3, float var4, float var5, float var6);

    private static native void native_rLineTo(int var0, float var1, float var2);

    private static native void native_rMoveTo(int var0, float var1, float var2);

    private static native void native_rQuadTo(int var0, float var1, float var2, float var3, float var4);

    private static native void native_reset(int var0);

    private static native void native_rewind(int var0);

    private static native void native_set(int var0, int var1);

    private static native void native_setFillType(int var0, int var1);

    private static native void native_setLastPoint(int var0, float var1, float var2);

    private static native void native_transform(int var0, int var1);

    private static native void native_transform(int var0, int var1, int var2);

    public void addArc(RectF rectF, float f, float f2) {
        if (rectF == null) {
            throw new NullPointerException("need oval parameter");
        }
        Path.native_addArc(this.mNativePath, rectF, f, f2);
    }

    public void addCircle(float f, float f2, float f3, Direction direction) {
        int n = this.mNativePath;
        int n2 = direction.nativeInt;
        Path.native_addCircle(n, f, f2, f3, n2);
    }

    public void addOval(RectF rectF, Direction direction) {
        if (rectF == null) {
            throw new NullPointerException("need oval parameter");
        }
        int n = this.mNativePath;
        int n2 = direction.nativeInt;
        Path.native_addOval(n, rectF, n2);
    }

    public void addPath(Path path) {
        int n = this.mNativePath;
        int n2 = path.mNativePath;
        Path.native_addPath(n, n2);
    }

    public void addPath(Path path, float f, float f2) {
        int n = this.mNativePath;
        int n2 = path.mNativePath;
        Path.native_addPath(n, n2, f, f2);
    }

    public void addPath(Path path, Matrix matrix) {
        int n = this.mNativePath;
        int n2 = path.mNativePath;
        int n3 = matrix.native_instance;
        Path.native_addPath(n, n2, n3);
    }

    public void addRect(float f, float f2, float f3, float f4, Direction direction) {
        int n = this.mNativePath;
        int n2 = direction.nativeInt;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        Path.native_addRect(n, f5, f6, f7, f8, n2);
    }

    public void addRect(RectF rectF, Direction direction) {
        if (rectF == null) {
            throw new NullPointerException("need rect parameter");
        }
        int n = this.mNativePath;
        int n2 = direction.nativeInt;
        Path.native_addRect(n, rectF, n2);
    }

    public void addRoundRect(RectF rectF, float f, float f2, Direction direction) {
        if (rectF == null) {
            throw new NullPointerException("need rect parameter");
        }
        int n = this.mNativePath;
        int n2 = direction.nativeInt;
        Path.native_addRoundRect(n, rectF, f, f2, n2);
    }

    public void addRoundRect(RectF rectF, float[] fArray, Direction direction) {
        if (rectF == null) {
            throw new NullPointerException("need rect parameter");
        }
        if (fArray.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        int n = this.mNativePath;
        int n2 = direction.nativeInt;
        Path.native_addRoundRect(n, rectF, fArray, n2);
    }

    public void arcTo(RectF rectF, float f, float f2) {
        Path.native_arcTo(this.mNativePath, rectF, f, f2, false);
    }

    public void arcTo(RectF rectF, float f, float f2, boolean bl) {
        Path.native_arcTo(this.mNativePath, rectF, f, f2, bl);
    }

    public void close() {
        Path.native_close(this.mNativePath);
    }

    public void computeBounds(RectF rectF, boolean bl) {
        Path.native_computeBounds(this.mNativePath, rectF);
    }

    public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        int n = this.mNativePath;
        float f7 = f;
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        float f11 = f5;
        float f12 = f6;
        Path.native_cubicTo(n, f7, f8, f9, f10, f11, f12);
    }

    protected void finalize() throws Throwable {
        try {
            Path.finalizer(this.mNativePath);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public FillType getFillType() {
        FillType[] fillTypeArray = sFillTypeArray;
        int n = Path.native_getFillType(this.mNativePath);
        return fillTypeArray[n];
    }

    public void incReserve(int n) {
        Path.native_incReserve(this.mNativePath, n);
    }

    public boolean isEmpty() {
        return Path.native_isEmpty(this.mNativePath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInverseFillType() {
        if ((Path.native_getFillType(this.mNativePath) & 2) == 0) return false;
        return true;
    }

    public boolean isRect(RectF rectF) {
        return Path.native_isRect(this.mNativePath, rectF);
    }

    public void lineTo(float f, float f2) {
        Path.native_lineTo(this.mNativePath, f, f2);
    }

    public void moveTo(float f, float f2) {
        Path.native_moveTo(this.mNativePath, f, f2);
    }

    final int ni() {
        return this.mNativePath;
    }

    public void offset(float f, float f2) {
        Path.native_offset(this.mNativePath, f, f2);
    }

    public void offset(float f, float f2, Path path) {
        int n = 0;
        if (path != null) {
            n = path.mNativePath;
        }
        Path.native_offset(this.mNativePath, f, f2, n);
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        Path.native_quadTo(this.mNativePath, f, f2, f3, f4);
    }

    public void rCubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        int n = this.mNativePath;
        float f7 = f;
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        float f11 = f5;
        float f12 = f6;
        Path.native_rCubicTo(n, f7, f8, f9, f10, f11, f12);
    }

    public void rLineTo(float f, float f2) {
        Path.native_rLineTo(this.mNativePath, f, f2);
    }

    public void rMoveTo(float f, float f2) {
        Path.native_rMoveTo(this.mNativePath, f, f2);
    }

    public void rQuadTo(float f, float f2, float f3, float f4) {
        Path.native_rQuadTo(this.mNativePath, f, f2, f3, f4);
    }

    public void reset() {
        Path.native_reset(this.mNativePath);
    }

    public void rewind() {
        Path.native_rewind(this.mNativePath);
    }

    public void set(Path path) {
        if (this == path) {
            return;
        }
        int n = this.mNativePath;
        int n2 = path.mNativePath;
        Path.native_set(n, n2);
    }

    public void setFillType(FillType fillType) {
        int n = this.mNativePath;
        int n2 = fillType.nativeInt;
        Path.native_setFillType(n, n2);
    }

    public void setLastPoint(float f, float f2) {
        Path.native_setLastPoint(this.mNativePath, f, f2);
    }

    public void toggleInverseFillType() {
        int n = Path.native_getFillType(this.mNativePath) ^ 2;
        Path.native_setFillType(this.mNativePath, n);
    }

    public void transform(Matrix matrix) {
        int n = this.mNativePath;
        int n2 = matrix.native_instance;
        Path.native_transform(n, n2);
    }

    public void transform(Matrix matrix, Path path) {
        int n = 0;
        if (path != null) {
            n = path.mNativePath;
        }
        int n2 = this.mNativePath;
        int n3 = matrix.native_instance;
        Path.native_transform(n2, n3, n);
    }

    public static final class Direction
    extends Enum<Direction> {
        private static final /* synthetic */ Direction[] $VALUES;
        public static final /* enum */ Direction CCW;
        public static final /* enum */ Direction CW;
        final int nativeInt;

        static {
            CW = new Direction(0);
            CCW = new Direction(1);
            Direction direction = CW;
            Direction direction2 = CCW;
            Direction[] directionArray = new Direction[]{direction, direction2};
            $VALUES = directionArray;
        }

        private Direction(int n2) {
            this.nativeInt = n2;
        }

        public static Direction valueOf(String string2) {
            return Enum.valueOf(Direction.class, string2);
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }
    }

    public static final class FillType
    extends Enum<FillType> {
        private static final /* synthetic */ FillType[] $VALUES;
        public static final /* enum */ FillType EVEN_ODD;
        public static final /* enum */ FillType INVERSE_EVEN_ODD;
        public static final /* enum */ FillType INVERSE_WINDING;
        public static final /* enum */ FillType WINDING;
        final int nativeInt;

        static {
            WINDING = new FillType(0);
            EVEN_ODD = new FillType(1);
            INVERSE_WINDING = new FillType(2);
            INVERSE_EVEN_ODD = new FillType(3);
            FillType fillType = WINDING;
            FillType fillType2 = EVEN_ODD;
            FillType fillType3 = INVERSE_WINDING;
            FillType fillType4 = INVERSE_EVEN_ODD;
            FillType[] fillTypeArray = new FillType[]{fillType, fillType2, fillType3, fillType4};
            $VALUES = fillTypeArray;
        }

        private FillType(int n2) {
            this.nativeInt = n2;
        }

        public static FillType valueOf(String string2) {
            return Enum.valueOf(FillType.class, string2);
        }

        public static FillType[] values() {
            return (FillType[])$VALUES.clone();
        }
    }
}

