/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Path;

public class PathMeasure {
    public static final int POSITION_MATRIX_FLAG = 1;
    public static final int TANGENT_MATRIX_FLAG = 2;
    private final int native_instance;

    public PathMeasure() {
        int n;
        this.native_instance = n = PathMeasure.native_create(0, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public PathMeasure(Path path, boolean bl) {
        int n;
        int n2 = path != null ? path.ni() : 0;
        this.native_instance = n = PathMeasure.native_create(n2, bl);
    }

    private static native int native_create(int var0, boolean var1);

    private static native void native_destroy(int var0);

    private static native float native_getLength(int var0);

    private static native boolean native_getMatrix(int var0, float var1, int var2, int var3);

    private static native boolean native_getPosTan(int var0, float var1, float[] var2, float[] var3);

    private static native boolean native_getSegment(int var0, float var1, float var2, int var3, boolean var4);

    private static native boolean native_isClosed(int var0);

    private static native boolean native_nextContour(int var0);

    private static native void native_setPath(int var0, int var1, boolean var2);

    protected void finalize() throws Throwable {
        PathMeasure.native_destroy(this.native_instance);
    }

    public float getLength() {
        return PathMeasure.native_getLength(this.native_instance);
    }

    public boolean getMatrix(float f, Matrix matrix, int n) {
        int n2 = this.native_instance;
        int n3 = matrix.native_instance;
        return PathMeasure.native_getMatrix(n2, f, n3, n);
    }

    public boolean getPosTan(float f, float[] fArray, float[] fArray2) {
        if (fArray != null && fArray.length < 2 || fArray2 != null && fArray2.length < 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return PathMeasure.native_getPosTan(this.native_instance, f, fArray, fArray2);
    }

    public boolean getSegment(float f, float f2, Path path, boolean bl) {
        int n = this.native_instance;
        int n2 = path.ni();
        return PathMeasure.native_getSegment(n, f, f2, n2, bl);
    }

    public boolean isClosed() {
        return PathMeasure.native_isClosed(this.native_instance);
    }

    public boolean nextContour() {
        return PathMeasure.native_nextContour(this.native_instance);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPath(Path path, boolean bl) {
        int n = this.native_instance;
        int n2 = path != null ? path.ni() : 0;
        PathMeasure.native_setPath(n, n2, bl);
    }
}

