/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import java.io.InputStream;
import java.io.OutputStream;

public class Picture {
    private static final int WORKING_STREAM_STORAGE = 16384;
    private final int mNativePicture;
    private Canvas mRecordingCanvas;

    public Picture() {
        int n = Picture.nativeConstructor(0);
        this(n);
    }

    private Picture(int n) {
        if (n == 0) {
            throw new RuntimeException();
        }
        this.mNativePicture = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Picture(Picture picture) {
        int n = picture != null ? picture.mNativePicture : 0;
        int n2 = Picture.nativeConstructor(n);
        this(n2);
    }

    public static Picture createFromStream(InputStream inputStream) {
        byte[] byArray = new byte[16384];
        int n = Picture.nativeCreateFromStream(inputStream, byArray);
        return new Picture(n);
    }

    private static native int nativeBeginRecording(int var0, int var1, int var2);

    private static native int nativeConstructor(int var0);

    private static native int nativeCreateFromStream(InputStream var0, byte[] var1);

    private static native void nativeDestructor(int var0);

    private static native void nativeDraw(int var0, int var1);

    private static native void nativeEndRecording(int var0);

    private static native boolean nativeWriteToStream(int var0, OutputStream var1, byte[] var2);

    public Canvas beginRecording(int n, int n2) {
        int n3 = Picture.nativeBeginRecording(this.mNativePicture, n, n2);
        RecordingCanvas recordingCanvas = new RecordingCanvas(this, n3);
        this.mRecordingCanvas = recordingCanvas;
        return this.mRecordingCanvas;
    }

    public void draw(Canvas canvas) {
        if (this.mRecordingCanvas != null) {
            this.endRecording();
        }
        int n = canvas.mNativeCanvas;
        int n2 = this.mNativePicture;
        Picture.nativeDraw(n, n2);
    }

    public void endRecording() {
        if (this.mRecordingCanvas == null) {
            return;
        }
        this.mRecordingCanvas = null;
        Picture.nativeEndRecording(this.mNativePicture);
    }

    protected void finalize() throws Throwable {
        Picture.nativeDestructor(this.mNativePicture);
    }

    public native int getHeight();

    public native int getWidth();

    final int ni() {
        return this.mNativePicture;
    }

    public void writeToStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        int n = this.mNativePicture;
        byte[] byArray = new byte[16384];
        if (Picture.nativeWriteToStream(n, outputStream, byArray)) {
            return;
        }
        throw new RuntimeException();
    }

    private static class RecordingCanvas
    extends Canvas {
        private final Picture mPicture;

        public RecordingCanvas(Picture picture, int n) {
            super(n);
            this.mPicture = picture;
        }

        @Override
        public void drawPicture(Picture picture) {
            if (this.mPicture == picture) {
                throw new RuntimeException("Cannot draw a picture into its recording canvas");
            }
            super.drawPicture(picture);
        }

        @Override
        public void setBitmap(Bitmap bitmap) {
            throw new RuntimeException("Cannot call setBitmap on a picture canvas");
        }
    }
}

