/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Rect
implements Parcelable {
    public static final Parcelable.Creator<Rect> CREATOR;
    private static final Pattern FLATTENED_PATTERN;
    public int bottom;
    public int left;
    public int right;
    public int top;

    static {
        FLATTENED_PATTERN = Pattern.compile("(-?\\d+) (-?\\d+) (-?\\d+) (-?\\d+)");
        CREATOR = new Parcelable.Creator<Rect>(){

            @Override
            public Rect createFromParcel(Parcel parcel) {
                Rect rect = new Rect();
                rect.readFromParcel(parcel);
                return rect;
            }

            public Rect[] newArray(int n) {
                return new Rect[n];
            }
        };
    }

    public Rect() {
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public Rect(Rect rect) {
        int n;
        int n2;
        int n3;
        int n4;
        this.left = n4 = rect.left;
        this.top = n3 = rect.top;
        this.right = n2 = rect.right;
        this.bottom = n = rect.bottom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean intersects(Rect rect, Rect rect2) {
        int n = rect.left;
        int n2 = rect2.right;
        if (n >= n2) return false;
        int n3 = rect2.left;
        int n4 = rect.right;
        if (n3 >= n4) return false;
        int n5 = rect.top;
        int n6 = rect2.bottom;
        if (n5 >= n6) return false;
        int n7 = rect2.top;
        int n8 = rect.bottom;
        if (n7 >= n8) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Rect unflattenFromString(String string2) {
        Matcher matcher = FLATTENED_PATTERN.matcher(string2);
        if (!matcher.matches()) {
            return null;
        }
        int n = Integer.parseInt(matcher.group(1));
        int n2 = Integer.parseInt(matcher.group(2));
        int n3 = Integer.parseInt(matcher.group(3));
        int n4 = Integer.parseInt(matcher.group(4));
        return new Rect(n, n2, n3, n4);
    }

    public final int centerX() {
        int n = this.left;
        int n2 = this.right;
        return n + n2 >> 1;
    }

    public final int centerY() {
        int n = this.top;
        int n2 = this.bottom;
        return n + n2 >> 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(int n, int n2) {
        int n3 = this.left;
        int n4 = this.right;
        if (n3 >= n4) return false;
        int n5 = this.top;
        int n6 = this.bottom;
        if (n5 >= n6) return false;
        int n7 = this.left;
        if (n < n7) return false;
        int n8 = this.right;
        if (n >= n8) return false;
        int n9 = this.top;
        if (n2 < n9) return false;
        int n10 = this.bottom;
        if (n2 >= n10) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(int n, int n2, int n3, int n4) {
        int n5 = this.left;
        int n6 = this.right;
        if (n5 >= n6) return false;
        int n7 = this.top;
        int n8 = this.bottom;
        if (n7 >= n8) return false;
        if (this.left > n) return false;
        if (this.top > n2) return false;
        if (this.right < n3) return false;
        if (this.bottom < n4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(Rect rect) {
        int n = this.left;
        int n2 = this.right;
        if (n >= n2) return false;
        int n3 = this.top;
        int n4 = this.bottom;
        if (n3 >= n4) return false;
        int n5 = this.left;
        int n6 = rect.left;
        if (n5 > n6) return false;
        int n7 = this.top;
        int n8 = rect.top;
        if (n7 > n8) return false;
        int n9 = this.right;
        int n10 = rect.right;
        if (n9 < n10) return false;
        int n11 = this.bottom;
        int n12 = rect.bottom;
        if (n11 < n12) return false;
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        Rect rect = (Rect)object;
        if (rect == null) return false;
        int n = this.left;
        int n2 = rect.left;
        if (n == n2) return false;
        int n3 = this.top;
        int n4 = rect.top;
        if (n3 == n4) return false;
        int n5 = this.right;
        int n6 = rect.right;
        if (n5 == n6) return false;
        int n7 = this.bottom;
        int n8 = rect.bottom;
        if (n7 == n8) return false;
        return true;
    }

    public final float exactCenterX() {
        int n = this.left;
        int n2 = this.right;
        return (float)(n + n2) * 0.5f;
    }

    public final float exactCenterY() {
        int n = this.top;
        int n2 = this.bottom;
        return (float)(n + n2) * 0.5f;
    }

    public String flattenToString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        int n = this.left;
        StringBuilder stringBuilder2 = stringBuilder.append(n);
        StringBuilder stringBuilder3 = stringBuilder.append(' ');
        int n2 = this.top;
        StringBuilder stringBuilder4 = stringBuilder.append(n2);
        StringBuilder stringBuilder5 = stringBuilder.append(' ');
        int n3 = this.right;
        StringBuilder stringBuilder6 = stringBuilder.append(n3);
        StringBuilder stringBuilder7 = stringBuilder.append(' ');
        int n4 = this.bottom;
        StringBuilder stringBuilder8 = stringBuilder.append(n4);
        return stringBuilder.toString();
    }

    public final int height() {
        int n = this.bottom;
        int n2 = this.top;
        return n - n2;
    }

    public void inset(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        this.left = n6 = this.left + n;
        this.top = n5 = this.top + n2;
        this.right = n4 = this.right - n;
        this.bottom = n3 = this.bottom - n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean intersect(int n, int n2, int n3, int n4) {
        if (this.left >= n3) return false;
        int n5 = this.right;
        if (n >= n5) return false;
        if (this.top >= n4) return false;
        int n6 = this.bottom;
        if (n2 >= n6) return false;
        if (this.left < n) {
            this.left = n;
        }
        if (this.top < n2) {
            this.top = n2;
        }
        if (this.right > n3) {
            this.right = n3;
        }
        if (this.bottom <= n4) return true;
        this.bottom = n4;
        return true;
    }

    public boolean intersect(Rect rect) {
        int n = rect.left;
        int n2 = rect.top;
        int n3 = rect.right;
        int n4 = rect.bottom;
        return this.intersect(n, n2, n3, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean intersects(int n, int n2, int n3, int n4) {
        if (this.left >= n3) return false;
        int n5 = this.right;
        if (n >= n5) return false;
        if (this.top >= n4) return false;
        int n6 = this.bottom;
        if (n2 >= n6) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmpty() {
        int n = this.left;
        int n2 = this.right;
        if (n >= n2) return true;
        int n3 = this.top;
        int n4 = this.bottom;
        if (n3 < n4) return false;
        return true;
    }

    public void offset(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        this.left = n6 = this.left + n;
        this.top = n5 = this.top + n2;
        this.right = n4 = this.right + n;
        this.bottom = n3 = this.bottom + n2;
    }

    public void offsetTo(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.right;
        int n6 = this.left;
        int n7 = n - n6;
        this.right = n4 = n5 + n7;
        int n8 = this.bottom;
        int n9 = this.top;
        int n10 = n2 - n9;
        this.bottom = n3 = n8 + n10;
        this.left = n;
        this.top = n2;
    }

    public void printShortString(PrintWriter printWriter) {
        printWriter.print('[');
        int n = this.left;
        printWriter.print(n);
        printWriter.print(',');
        int n2 = this.top;
        printWriter.print(n2);
        printWriter.print("][");
        int n3 = this.right;
        printWriter.print(n3);
        printWriter.print(',');
        int n4 = this.bottom;
        printWriter.print(n4);
        printWriter.print(']');
    }

    public void readFromParcel(Parcel parcel) {
        int n;
        int n2;
        int n3;
        int n4;
        this.left = n4 = parcel.readInt();
        this.top = n3 = parcel.readInt();
        this.right = n2 = parcel.readInt();
        this.bottom = n = parcel.readInt();
    }

    public void scale(float f) {
        int n;
        int n2;
        int n3;
        int n4;
        if (f == 1.0f) {
            return;
        }
        this.left = n4 = (int)((float)this.left * f + 0.5f);
        this.top = n3 = (int)((float)this.top * f + 0.5f);
        this.right = n2 = (int)((float)this.right * f + 0.5f);
        this.bottom = n = (int)((float)this.bottom * f + 0.5f);
    }

    public void set(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public void set(Rect rect) {
        int n;
        int n2;
        int n3;
        int n4;
        this.left = n4 = rect.left;
        this.top = n3 = rect.top;
        this.right = n2 = rect.right;
        this.bottom = n = rect.bottom;
    }

    public void setEmpty() {
        this.bottom = 0;
        this.top = 0;
        this.right = 0;
        this.left = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setIntersect(Rect rect, Rect rect2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = rect.left;
        int n6 = rect2.right;
        if (n5 >= n6) return false;
        int n7 = rect2.left;
        int n8 = rect.right;
        if (n7 >= n8) return false;
        int n9 = rect.top;
        int n10 = rect2.bottom;
        if (n9 >= n10) return false;
        int n11 = rect2.top;
        int n12 = rect.bottom;
        if (n11 >= n12) return false;
        int n13 = rect.left;
        int n14 = rect2.left;
        this.left = n4 = Math.max(n13, n14);
        int n15 = rect.top;
        int n16 = rect2.top;
        this.top = n3 = Math.max(n15, n16);
        int n17 = rect.right;
        int n18 = rect2.right;
        this.right = n2 = Math.min(n17, n18);
        int n19 = rect.bottom;
        int n20 = rect2.bottom;
        this.bottom = n = Math.min(n19, n20);
        return true;
    }

    public void sort() {
        int n;
        int n2;
        int n3;
        int n4 = this.left;
        int n5 = this.right;
        if (n4 > n5) {
            int n6;
            int n7 = this.left;
            this.left = n6 = this.right;
            this.right = n7;
        }
        if ((n3 = this.top) <= (n2 = this.bottom)) {
            return;
        }
        int n8 = this.top;
        this.top = n = this.bottom;
        this.bottom = n8;
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        return this.toShortString(stringBuilder);
    }

    public String toShortString(StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        StringBuilder stringBuilder2 = stringBuilder.append('[');
        int n = this.left;
        StringBuilder stringBuilder3 = stringBuilder.append(n);
        StringBuilder stringBuilder4 = stringBuilder.append(',');
        int n2 = this.top;
        StringBuilder stringBuilder5 = stringBuilder.append(n2);
        StringBuilder stringBuilder6 = stringBuilder.append("][");
        int n3 = this.right;
        StringBuilder stringBuilder7 = stringBuilder.append(n3);
        StringBuilder stringBuilder8 = stringBuilder.append(',');
        int n4 = this.bottom;
        StringBuilder stringBuilder9 = stringBuilder.append(n4);
        StringBuilder stringBuilder10 = stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        StringBuilder stringBuilder2 = stringBuilder.append("Rect(");
        int n = this.left;
        StringBuilder stringBuilder3 = stringBuilder.append(n);
        StringBuilder stringBuilder4 = stringBuilder.append(", ");
        int n2 = this.top;
        StringBuilder stringBuilder5 = stringBuilder.append(n2);
        StringBuilder stringBuilder6 = stringBuilder.append(" - ");
        int n3 = this.right;
        StringBuilder stringBuilder7 = stringBuilder.append(n3);
        StringBuilder stringBuilder8 = stringBuilder.append(", ");
        int n4 = this.bottom;
        StringBuilder stringBuilder9 = stringBuilder.append(n4);
        StringBuilder stringBuilder10 = stringBuilder.append(")");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void union(int n, int n2) {
        int n3;
        int n4 = this.left;
        if (n < n4) {
            this.left = n;
        } else {
            int n5 = this.right;
            if (n > n5) {
                this.right = n;
            }
        }
        if (n2 < (n3 = this.top)) {
            this.top = n2;
            return;
        }
        int n6 = this.bottom;
        if (n2 <= n6) {
            return;
        }
        this.bottom = n2;
    }

    public void union(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n >= n3) {
            return;
        }
        if (n2 >= n4) {
            return;
        }
        int n7 = this.left;
        int n8 = this.right;
        if (n7 < n8 && (n6 = this.top) < (n5 = this.bottom)) {
            if (this.left > n) {
                this.left = n;
            }
            if (this.top > n2) {
                this.top = n2;
            }
            if (this.right < n3) {
                this.right = n3;
            }
            if (this.bottom >= n4) {
                return;
            }
            this.bottom = n4;
            return;
        }
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public void union(Rect rect) {
        int n = rect.left;
        int n2 = rect.top;
        int n3 = rect.right;
        int n4 = rect.bottom;
        this.union(n, n2, n3, n4);
    }

    public final int width() {
        int n = this.right;
        int n2 = this.left;
        return n - n2;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.left;
        parcel.writeInt(n2);
        int n3 = this.top;
        parcel.writeInt(n3);
        int n4 = this.right;
        parcel.writeInt(n4);
        int n5 = this.bottom;
        parcel.writeInt(n5);
    }
}

