/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.FloatMath;
import com.android.internal.util.FastMath;

public class RectF
implements Parcelable {
    public static final Parcelable.Creator<RectF> CREATOR = new Parcelable.Creator<RectF>(){

        @Override
        public RectF createFromParcel(Parcel parcel) {
            RectF rectF = new RectF();
            rectF.readFromParcel(parcel);
            return rectF;
        }

        public RectF[] newArray(int n) {
            return new RectF[n];
        }
    };
    public float bottom;
    public float left;
    public float right;
    public float top;

    public RectF() {
    }

    public RectF(float f, float f2, float f3, float f4) {
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
    }

    public RectF(Rect rect) {
        float f;
        float f2;
        float f3;
        float f4;
        this.left = f4 = (float)rect.left;
        this.top = f3 = (float)rect.top;
        this.right = f2 = (float)rect.right;
        this.bottom = f = (float)rect.bottom;
    }

    public RectF(RectF rectF) {
        float f;
        float f2;
        float f3;
        float f4;
        this.left = f4 = rectF.left;
        this.top = f3 = rectF.top;
        this.right = f2 = rectF.right;
        this.bottom = f = rectF.bottom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean intersects(RectF rectF, RectF rectF2) {
        float f = rectF.left;
        float f2 = rectF2.right;
        if (!(f < f2)) return false;
        float f3 = rectF2.left;
        float f4 = rectF.right;
        if (!(f3 < f4)) return false;
        float f5 = rectF.top;
        float f6 = rectF2.bottom;
        if (!(f5 < f6)) return false;
        float f7 = rectF2.top;
        float f8 = rectF.bottom;
        if (!(f7 < f8)) return false;
        return true;
    }

    public final float centerX() {
        float f = this.left;
        float f2 = this.right;
        return (f + f2) * 0.5f;
    }

    public final float centerY() {
        float f = this.top;
        float f2 = this.bottom;
        return (f + f2) * 0.5f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(float f, float f2) {
        float f3 = this.left;
        float f4 = this.right;
        if (!(f3 < f4)) return false;
        float f5 = this.top;
        float f6 = this.bottom;
        if (!(f5 < f6)) return false;
        float f7 = this.left;
        if (!(f >= f7)) return false;
        float f8 = this.right;
        if (!(f < f8)) return false;
        float f9 = this.top;
        if (!(f2 >= f9)) return false;
        float f10 = this.bottom;
        if (!(f2 < f10)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(float f, float f2, float f3, float f4) {
        float f5 = this.left;
        float f6 = this.right;
        if (!(f5 < f6)) return false;
        float f7 = this.top;
        float f8 = this.bottom;
        if (!(f7 < f8)) return false;
        if (!(this.left <= f)) return false;
        if (!(this.top <= f2)) return false;
        if (!(this.right >= f3)) return false;
        if (!(this.bottom >= f4)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(RectF rectF) {
        float f = this.left;
        float f2 = this.right;
        if (!(f < f2)) return false;
        float f3 = this.top;
        float f4 = this.bottom;
        if (!(f3 < f4)) return false;
        float f5 = this.left;
        float f6 = rectF.left;
        if (!(f5 <= f6)) return false;
        float f7 = this.top;
        float f8 = rectF.top;
        if (!(f7 <= f8)) return false;
        float f9 = this.right;
        float f10 = rectF.right;
        if (!(f9 >= f10)) return false;
        float f11 = this.bottom;
        float f12 = rectF.bottom;
        if (!(f11 >= f12)) return false;
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public final float height() {
        float f = this.bottom;
        float f2 = this.top;
        return f - f2;
    }

    public void inset(float f, float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        this.left = f6 = this.left + f;
        this.top = f5 = this.top + f2;
        this.right = f4 = this.right - f;
        this.bottom = f3 = this.bottom - f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean intersect(float f, float f2, float f3, float f4) {
        if (!(this.left < f3)) return false;
        float f5 = this.right;
        if (!(f < f5)) return false;
        if (!(this.top < f4)) return false;
        float f6 = this.bottom;
        if (!(f2 < f6)) return false;
        if (this.left < f) {
            this.left = f;
        }
        if (this.top < f2) {
            this.top = f2;
        }
        if (this.right > f3) {
            this.right = f3;
        }
        if (!(this.bottom > f4)) return true;
        this.bottom = f4;
        return true;
    }

    public boolean intersect(RectF rectF) {
        float f = rectF.left;
        float f2 = rectF.top;
        float f3 = rectF.right;
        float f4 = rectF.bottom;
        return this.intersect(f, f2, f3, f4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean intersects(float f, float f2, float f3, float f4) {
        if (!(this.left < f3)) return false;
        float f5 = this.right;
        if (!(f < f5)) return false;
        if (!(this.top < f4)) return false;
        float f6 = this.bottom;
        if (!(f2 < f6)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmpty() {
        float f = this.left;
        float f2 = this.right;
        if (f >= f2) return true;
        float f3 = this.top;
        float f4 = this.bottom;
        if (!(f3 >= f4)) return false;
        return true;
    }

    public void offset(float f, float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        this.left = f6 = this.left + f;
        this.top = f5 = this.top + f2;
        this.right = f4 = this.right + f;
        this.bottom = f3 = this.bottom + f2;
    }

    public void offsetTo(float f, float f2) {
        float f3;
        float f4;
        float f5 = this.right;
        float f6 = this.left;
        float f7 = f - f6;
        this.right = f4 = f5 + f7;
        float f8 = this.bottom;
        float f9 = this.top;
        float f10 = f2 - f9;
        this.bottom = f3 = f8 + f10;
        this.left = f;
        this.top = f2;
    }

    public void readFromParcel(Parcel parcel) {
        float f;
        float f2;
        float f3;
        float f4;
        this.left = f4 = parcel.readFloat();
        this.top = f3 = parcel.readFloat();
        this.right = f2 = parcel.readFloat();
        this.bottom = f = parcel.readFloat();
    }

    public void round(Rect rect) {
        int n = FastMath.round(this.left);
        int n2 = FastMath.round(this.top);
        int n3 = FastMath.round(this.right);
        int n4 = FastMath.round(this.bottom);
        rect.set(n, n2, n3, n4);
    }

    public void roundOut(Rect rect) {
        int n = (int)FloatMath.floor(this.left);
        int n2 = (int)FloatMath.floor(this.top);
        int n3 = (int)FloatMath.ceil(this.right);
        int n4 = (int)FloatMath.ceil(this.bottom);
        rect.set(n, n2, n3, n4);
    }

    public void set(float f, float f2, float f3, float f4) {
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
    }

    public void set(Rect rect) {
        float f;
        float f2;
        float f3;
        float f4;
        this.left = f4 = (float)rect.left;
        this.top = f3 = (float)rect.top;
        this.right = f2 = (float)rect.right;
        this.bottom = f = (float)rect.bottom;
    }

    public void set(RectF rectF) {
        float f;
        float f2;
        float f3;
        float f4;
        this.left = f4 = rectF.left;
        this.top = f3 = rectF.top;
        this.right = f2 = rectF.right;
        this.bottom = f = rectF.bottom;
    }

    public void setEmpty() {
        this.bottom = 0.0f;
        this.top = 0.0f;
        this.right = 0.0f;
        this.left = 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setIntersect(RectF rectF, RectF rectF2) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5 = rectF.left;
        float f6 = rectF2.right;
        if (!(f5 < f6)) return false;
        float f7 = rectF2.left;
        float f8 = rectF.right;
        if (!(f7 < f8)) return false;
        float f9 = rectF.top;
        float f10 = rectF2.bottom;
        if (!(f9 < f10)) return false;
        float f11 = rectF2.top;
        float f12 = rectF.bottom;
        if (!(f11 < f12)) return false;
        float f13 = rectF.left;
        float f14 = rectF2.left;
        this.left = f4 = Math.max(f13, f14);
        float f15 = rectF.top;
        float f16 = rectF2.top;
        this.top = f3 = Math.max(f15, f16);
        float f17 = rectF.right;
        float f18 = rectF2.right;
        this.right = f2 = Math.min(f17, f18);
        float f19 = rectF.bottom;
        float f20 = rectF2.bottom;
        this.bottom = f = Math.min(f19, f20);
        return true;
    }

    public void sort() {
        float f;
        float f2;
        float f3;
        float f4 = this.left;
        float f5 = this.right;
        if (f4 > f5) {
            float f6;
            float f7 = this.left;
            this.left = f6 = this.right;
            this.right = f7;
        }
        if (!((f3 = this.top) > (f2 = this.bottom))) {
            return;
        }
        float f8 = this.top;
        this.top = f = this.bottom;
        this.bottom = f8;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("RectF(");
        float f = this.left;
        StringBuilder stringBuilder2 = stringBuilder.append(f).append(", ");
        float f2 = this.top;
        StringBuilder stringBuilder3 = stringBuilder2.append(f2).append(", ");
        float f3 = this.right;
        StringBuilder stringBuilder4 = stringBuilder3.append(f3).append(", ");
        float f4 = this.bottom;
        return stringBuilder4.append(f4).append(")").toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void union(float f, float f2) {
        float f3;
        float f4 = this.left;
        if (f < f4) {
            this.left = f;
        } else {
            float f5 = this.right;
            if (f > f5) {
                this.right = f;
            }
        }
        if (f2 < (f3 = this.top)) {
            this.top = f2;
            return;
        }
        float f6 = this.bottom;
        if (!(f2 > f6)) {
            return;
        }
        this.bottom = f2;
    }

    public void union(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        if (!(f < f3)) {
            return;
        }
        if (!(f2 < f4)) {
            return;
        }
        float f7 = this.left;
        float f8 = this.right;
        if (f7 < f8 && (f6 = this.top) < (f5 = this.bottom)) {
            if (this.left > f) {
                this.left = f;
            }
            if (this.top > f2) {
                this.top = f2;
            }
            if (this.right < f3) {
                this.right = f3;
            }
            if (!(this.bottom < f4)) {
                return;
            }
            this.bottom = f4;
            return;
        }
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
    }

    public void union(RectF rectF) {
        float f = rectF.left;
        float f2 = rectF.top;
        float f3 = rectF.right;
        float f4 = rectF.bottom;
        this.union(f, f2, f3, f4);
    }

    public final float width() {
        float f = this.right;
        float f2 = this.left;
        return f - f2;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        float f = this.left;
        parcel.writeFloat(f);
        float f2 = this.top;
        parcel.writeFloat(f2);
        float f3 = this.right;
        parcel.writeFloat(f3);
        float f4 = this.bottom;
        parcel.writeFloat(f4);
    }
}

