/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;

public class Region
implements Parcelable {
    public static final Parcelable.Creator<Region> CREATOR = new Parcelable.Creator<Region>(){

        @Override
        public Region createFromParcel(Parcel parcel) {
            int n = Region.nativeCreateFromParcel(parcel);
            if (n == 0) {
                throw new RuntimeException();
            }
            return new Region(n);
        }

        public Region[] newArray(int n) {
            return new Region[n];
        }
    };
    private final int mNativeRegion;

    public Region() {
        int n = Region.nativeConstructor();
        this(n);
    }

    Region(int n) {
        if (n == 0) {
            throw new RuntimeException();
        }
        this.mNativeRegion = n;
    }

    private Region(int n, int n2) {
        this(n);
    }

    public Region(int n, int n2, int n3, int n4) {
        int n5;
        this.mNativeRegion = n5 = Region.nativeConstructor();
        boolean bl = Region.nativeSetRect(this.mNativeRegion, n, n2, n3, n4);
    }

    public Region(Rect rect) {
        int n;
        int n2 = this.mNativeRegion = (n = Region.nativeConstructor());
        int n3 = rect.left;
        int n4 = rect.top;
        int n5 = rect.right;
        int n6 = rect.bottom;
        boolean bl = Region.nativeSetRect(n2, n3, n4, n5, n6);
    }

    public Region(Region region) {
        int n = Region.nativeConstructor();
        this(n);
        int n2 = this.mNativeRegion;
        int n3 = region.mNativeRegion;
        boolean bl = Region.nativeSetRegion(n2, n3);
    }

    private static native int nativeConstructor();

    private static native int nativeCreateFromParcel(Parcel var0);

    private static native void nativeDestructor(int var0);

    private static native boolean nativeEquals(int var0, int var1);

    private static native boolean nativeGetBoundaryPath(int var0, int var1);

    private static native boolean nativeGetBounds(int var0, Rect var1);

    private static native boolean nativeOp(int var0, int var1, int var2, int var3);

    private static native boolean nativeOp(int var0, int var1, int var2, int var3, int var4, int var5);

    private static native boolean nativeOp(int var0, Rect var1, int var2, int var3);

    private static native boolean nativeSetPath(int var0, int var1, int var2);

    private static native boolean nativeSetRect(int var0, int var1, int var2, int var3, int var4);

    private static native boolean nativeSetRegion(int var0, int var1);

    private static native boolean nativeWriteToParcel(int var0, Parcel var1);

    public native boolean contains(int var1, int var2);

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null) return false;
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        int n = this.mNativeRegion;
        int n2 = region.mNativeRegion;
        return Region.nativeEquals(n, n2);
    }

    protected void finalize() throws Throwable {
        Region.nativeDestructor(this.mNativeRegion);
    }

    public Path getBoundaryPath() {
        Path path = new Path();
        int n = this.mNativeRegion;
        int n2 = path.ni();
        boolean bl = Region.nativeGetBoundaryPath(n, n2);
        return path;
    }

    public boolean getBoundaryPath(Path path) {
        int n = this.mNativeRegion;
        int n2 = path.ni();
        return Region.nativeGetBoundaryPath(n, n2);
    }

    public Rect getBounds() {
        Rect rect = new Rect();
        boolean bl = Region.nativeGetBounds(this.mNativeRegion, rect);
        return rect;
    }

    public boolean getBounds(Rect rect) {
        if (rect == null) {
            throw new NullPointerException();
        }
        return Region.nativeGetBounds(this.mNativeRegion, rect);
    }

    public native boolean isComplex();

    public native boolean isEmpty();

    public native boolean isRect();

    final int ni() {
        return this.mNativeRegion;
    }

    public boolean op(int n, int n2, int n3, int n4, Op op) {
        int n5 = this.mNativeRegion;
        int n6 = op.nativeInt;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        return Region.nativeOp(n5, n7, n8, n9, n10, n6);
    }

    public boolean op(Rect rect, Op op) {
        int n = this.mNativeRegion;
        int n2 = rect.left;
        int n3 = rect.top;
        int n4 = rect.right;
        int n5 = rect.bottom;
        int n6 = op.nativeInt;
        return Region.nativeOp(n, n2, n3, n4, n5, n6);
    }

    public boolean op(Rect rect, Region region, Op op) {
        int n = this.mNativeRegion;
        int n2 = region.mNativeRegion;
        int n3 = op.nativeInt;
        return Region.nativeOp(n, rect, n2, n3);
    }

    public boolean op(Region region, Op op) {
        return this.op(this, region, op);
    }

    public boolean op(Region region, Region region2, Op op) {
        int n = this.mNativeRegion;
        int n2 = region.mNativeRegion;
        int n3 = region2.mNativeRegion;
        int n4 = op.nativeInt;
        return Region.nativeOp(n, n2, n3, n4);
    }

    public native boolean quickContains(int var1, int var2, int var3, int var4);

    public boolean quickContains(Rect rect) {
        int n = rect.left;
        int n2 = rect.top;
        int n3 = rect.right;
        int n4 = rect.bottom;
        return this.quickContains(n, n2, n3, n4);
    }

    public native boolean quickReject(int var1, int var2, int var3, int var4);

    public boolean quickReject(Rect rect) {
        int n = rect.left;
        int n2 = rect.top;
        int n3 = rect.right;
        int n4 = rect.bottom;
        return this.quickReject(n, n2, n3, n4);
    }

    public native boolean quickReject(Region var1);

    public void scale(float f) {
        this.scale(f, null);
    }

    public native void scale(float var1, Region var2);

    public boolean set(int n, int n2, int n3, int n4) {
        return Region.nativeSetRect(this.mNativeRegion, n, n2, n3, n4);
    }

    public boolean set(Rect rect) {
        int n = this.mNativeRegion;
        int n2 = rect.left;
        int n3 = rect.top;
        int n4 = rect.right;
        int n5 = rect.bottom;
        return Region.nativeSetRect(n, n2, n3, n4, n5);
    }

    public boolean set(Region region) {
        int n = this.mNativeRegion;
        int n2 = region.mNativeRegion;
        return Region.nativeSetRegion(n, n2);
    }

    public void setEmpty() {
        boolean bl = Region.nativeSetRect(this.mNativeRegion, 0, 0, 0, 0);
    }

    public boolean setPath(Path path, Region region) {
        int n = this.mNativeRegion;
        int n2 = path.ni();
        int n3 = region.mNativeRegion;
        return Region.nativeSetPath(n, n2, n3);
    }

    public void translate(int n, int n2) {
        this.translate(n, n2, null);
    }

    public native void translate(int var1, int var2, Region var3);

    public final boolean union(Rect rect) {
        Op op = Op.UNION;
        return this.op(rect, op);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (Region.nativeWriteToParcel(this.mNativeRegion, parcel)) {
            return;
        }
        throw new RuntimeException();
    }

    public static final class Op
    extends Enum<Op> {
        private static final /* synthetic */ Op[] $VALUES;
        public static final /* enum */ Op DIFFERENCE = new Op(0);
        public static final /* enum */ Op INTERSECT = new Op(1);
        public static final /* enum */ Op REPLACE;
        public static final /* enum */ Op REVERSE_DIFFERENCE;
        public static final /* enum */ Op UNION;
        public static final /* enum */ Op XOR;
        final int nativeInt;

        static {
            UNION = new Op(2);
            XOR = new Op(3);
            REVERSE_DIFFERENCE = new Op(4);
            REPLACE = new Op(5);
            Op op = DIFFERENCE;
            Op op2 = INTERSECT;
            Op op3 = UNION;
            Op op4 = XOR;
            Op op5 = REVERSE_DIFFERENCE;
            Op op6 = REPLACE;
            Op[] opArray = new Op[]{op, op2, op3, op4, op5, op6};
            $VALUES = opArray;
        }

        private Op(int n2) {
            this.nativeInt = n2;
        }

        public static Op valueOf(String string2) {
            return Enum.valueOf(Op.class, string2);
        }

        public static Op[] values() {
            return (Op[])$VALUES.clone();
        }
    }
}

