/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import java.io.File;

public class Typeface {
    public static final int BOLD = 1;
    public static final int BOLD_ITALIC = 3;
    public static final Typeface DEFAULT;
    public static final Typeface DEFAULT_BOLD;
    public static final int ITALIC = 2;
    public static final Typeface MONOSPACE;
    public static final int NORMAL;
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    private static Typeface[] sDefaults;
    int native_instance;

    static {
        Typeface typeface;
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        Typeface typeface2 = DEFAULT;
        Typeface typeface3 = DEFAULT_BOLD;
        Typeface typeface4 = Typeface.create((String)null, 2);
        Typeface[] typefaceArray = new Typeface[]{typeface2, typeface3, typeface4, typeface = Typeface.create((String)null, 3)};
        sDefaults = typefaceArray;
    }

    private Typeface(int n) {
        if (n == 0) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = n;
    }

    public static Typeface create(Typeface typeface, int n) {
        int n2 = 0;
        if (typeface != null) {
            n2 = typeface.native_instance;
        }
        int n3 = Typeface.nativeCreateFromTypeface(n2, n);
        return new Typeface(n3);
    }

    public static Typeface create(String string2, int n) {
        int n2 = Typeface.nativeCreate(string2, n);
        return new Typeface(n2);
    }

    public static Typeface createFromAsset(AssetManager assetManager, String string2) {
        int n = Typeface.nativeCreateFromAsset(assetManager, string2);
        return new Typeface(n);
    }

    public static Typeface createFromFile(File file) {
        int n = Typeface.nativeCreateFromFile(file.getAbsolutePath());
        return new Typeface(n);
    }

    public static Typeface createFromFile(String string2) {
        int n = Typeface.nativeCreateFromFile(string2);
        return new Typeface(n);
    }

    public static Typeface defaultFromStyle(int n) {
        return sDefaults[n];
    }

    private static native int nativeCreate(String var0, int var1);

    private static native int nativeCreateFromAsset(AssetManager var0, String var1);

    private static native int nativeCreateFromFile(String var0);

    private static native int nativeCreateFromTypeface(int var0, int var1);

    private static native int nativeGetStyle(int var0);

    private static native void nativeUnref(int var0);

    public static native void setGammaForText(float var0, float var1);

    protected void finalize() throws Throwable {
        super.finalize();
        Typeface.nativeUnref(this.native_instance);
    }

    public int getStyle() {
        return Typeface.nativeGetStyle(this.native_instance);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBold() {
        if ((this.getStyle() & 1) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isItalic() {
        if ((this.getStyle() & 2) == 0) return false;
        return true;
    }
}

