/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Rect;
import java.io.OutputStream;

public class YuvImage {
    private static final int WORKING_COMPRESS_STORAGE = 4096;
    private byte[] mData;
    private int mFormat;
    private int mHeight;
    private int[] mStrides;
    private int mWidth;

    /*
     * Enabled aggressive block sorting
     */
    public YuvImage(byte[] byArray, int n, int n2, int n3, int[] nArray) {
        if (n != 17 && n != 20) {
            throw new IllegalArgumentException("only support ImageFormat.NV21 and ImageFormat.YUY2 for now");
        }
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("width and height must large than 0");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("yuv cannot be null");
        }
        if (nArray == null) {
            int[] nArray2 = this.calculateStrides(n2, n);
            this.mStrides = nArray2;
        } else {
            this.mStrides = nArray;
        }
        this.mData = byArray;
        this.mFormat = n;
        this.mWidth = n2;
        this.mHeight = n3;
    }

    private void adjustRectangle(Rect rect) {
        int n;
        int n2;
        int n3 = rect.width();
        int n4 = rect.height();
        if (this.mFormat == 17) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = n4 & 0xFFFFFFFE;
            rect.left = n8 = rect.left & 0xFFFFFFFE;
            rect.top = n7 = rect.top & 0xFFFFFFFE;
            rect.right = n6 = rect.left + (n3 &= 0xFFFFFFFE);
            rect.bottom = n5 = rect.top + n9;
        }
        if (this.mFormat != 20) {
            return;
        }
        int n10 = n3 & 0xFFFFFFFE;
        rect.left = n2 = rect.left & 0xFFFFFFFE;
        rect.right = n = rect.left + n10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] calculateStrides(int n, int n2) {
        if (n2 == 17) {
            int[] nArray = new int[]{n, n};
            return nArray;
        }
        if (n2 != 20) return null;
        int n3 = n * 2;
        int[] nArray = new int[]{n3};
        return nArray;
    }

    private static native boolean nativeCompressToJpeg(byte[] var0, int var1, int var2, int var3, int[] var4, int[] var5, int var6, OutputStream var7, byte[] var8);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int[] calculateOffsets(int n, int n2) {
        int n3;
        if (this.mFormat == 17) {
            int n4;
            int n5;
            int[] nArray = new int[2];
            nArray[0] = n5 = this.mStrides[0] * n2 + n;
            int n6 = this.mHeight;
            int n7 = this.mStrides[0];
            int n8 = n6 * n7;
            int n9 = n2 / 2;
            int n10 = this.mStrides[1];
            int n11 = n9 * n10;
            int n12 = n8 + n11;
            int n13 = n / 2 * 2;
            nArray[1] = n4 = n12 + n13;
            return nArray;
        }
        if (this.mFormat != 20) return null;
        int[] nArray = new int[1];
        int n14 = this.mStrides[0] * n2;
        int n15 = n / 2 * 4;
        nArray[0] = n3 = n14 + n15;
        return nArray;
    }

    public boolean compressToJpeg(Rect rect, int n, OutputStream outputStream) {
        int n2 = this.mWidth;
        int n3 = this.mHeight;
        if (!new Rect(0, 0, n2, n3).contains(rect)) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this.adjustRectangle(rect);
        int n4 = rect.left;
        int n5 = rect.top;
        int[] nArray = this.calculateOffsets(n4, n5);
        byte[] byArray = this.mData;
        int n6 = this.mFormat;
        int n7 = rect.width();
        int n8 = rect.height();
        int[] nArray2 = this.mStrides;
        byte[] byArray2 = new byte[4096];
        int n9 = n;
        OutputStream outputStream2 = outputStream;
        return YuvImage.nativeCompressToJpeg(byArray, n6, n7, n8, nArray, nArray2, n9, outputStream2, byArray2);
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int[] getStrides() {
        return this.mStrides;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public byte[] getYuvData() {
        return this.mData;
    }

    public int getYuvFormat() {
        return this.mFormat;
    }
}

