/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedRotateDrawable
extends Drawable
implements Drawable.Callback,
Runnable,
Animatable {
    private float mCurrentDegrees;
    private float mIncrement;
    private boolean mMutated;
    private boolean mRunning;
    private AnimatedRotateState mState;

    public AnimatedRotateDrawable() {
        this(null, null);
    }

    private AnimatedRotateDrawable(AnimatedRotateState animatedRotateState, Resources resources) {
        AnimatedRotateState animatedRotateState2;
        this.mState = animatedRotateState2 = new AnimatedRotateState(animatedRotateState, this, resources);
        this.init();
    }

    private void init() {
        float f;
        AnimatedRotateState animatedRotateState = this.mState;
        float f2 = animatedRotateState.mFramesCount;
        this.mIncrement = f = 360.0f / f2;
        Drawable drawable2 = animatedRotateState.mDrawable;
        if (drawable2 == null) {
            return;
        }
        drawable2.setFilterBitmap(true);
        if (!(drawable2 instanceof BitmapDrawable)) {
            return;
        }
        ((BitmapDrawable)drawable2).setAntiAlias(true);
    }

    private void nextFrame() {
        this.unscheduleSelf(this);
        long l = SystemClock.uptimeMillis();
        long l2 = this.mState.mFrameDuration;
        long l3 = l + l2;
        this.scheduleSelf(this, l3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        float f;
        float f2;
        int n = canvas.save();
        AnimatedRotateState animatedRotateState = this.mState;
        Drawable drawable2 = animatedRotateState.mDrawable;
        Rect rect = drawable2.getBounds();
        int n2 = rect.right;
        int n3 = rect.left;
        int n4 = n2 - n3;
        int n5 = rect.bottom;
        int n6 = rect.top;
        int n7 = n5 - n6;
        if (animatedRotateState.mPivotXRel) {
            float f3 = n4;
            float f4 = animatedRotateState.mPivotX;
            f2 = f3 * f4;
        } else {
            f2 = animatedRotateState.mPivotX;
        }
        if (animatedRotateState.mPivotYRel) {
            float f5 = n7;
            float f6 = animatedRotateState.mPivotY;
            f = f5 * f6;
        } else {
            f = animatedRotateState.mPivotY;
        }
        float f7 = this.mCurrentDegrees;
        canvas.rotate(f7, f2, f);
        drawable2.draw(canvas);
        canvas.restoreToCount(n);
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mState.mChangingConfigurations;
        int n3 = n | n2;
        int n4 = this.mState.mDrawable.getChangingConfigurations();
        return n3 | n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        if (!this.mState.canConstantState()) return null;
        AnimatedRotateState animatedRotateState = this.mState;
        animatedRotateState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mState;
    }

    public Drawable getDrawable() {
        return this.mState.mDrawable;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mState.mDrawable.getOpacity();
    }

    @Override
    public boolean getPadding(Rect rect) {
        return this.mState.mDrawable.getPadding(rect);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        float f;
        float f2;
        int[] nArray = R.styleable.AnimatedRotateDrawable;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray = resources2.obtainAttributes(attributeSet2, nArray2);
        AnimatedRotateDrawable animatedRotateDrawable = this;
        Resources resources3 = resources;
        XmlPullParser xmlPullParser2 = xmlPullParser;
        TypedArray typedArray2 = typedArray;
        int n8 = 0;
        super.inflateWithAttributes(resources3, xmlPullParser2, typedArray2, n8);
        TypedArray typedArray3 = typedArray;
        int n9 = 2;
        TypedValue typedValue = typedArray3.peekValue(n9);
        int n10 = typedValue.type;
        int n11 = 6;
        boolean bl = n10 == n11;
        if (bl) {
            TypedValue typedValue2 = typedValue;
            float f3 = 1.0f;
            float f4 = 1.0f;
            f2 = typedValue2.getFraction(f3, f4);
        } else {
            f2 = typedValue.getFloat();
        }
        TypedArray typedArray4 = typedArray;
        int n12 = 3;
        TypedValue typedValue3 = typedArray4.peekValue(n12);
        int n13 = typedValue3.type;
        int n14 = 6;
        boolean bl2 = n13 == n14;
        if (bl2) {
            TypedValue typedValue4 = typedValue3;
            float f5 = 1.0f;
            float f6 = 1.0f;
            f = typedValue4.getFraction(f5, f6);
        } else {
            f = typedValue3.getFloat();
        }
        TypedArray typedArray5 = typedArray;
        int n15 = 5;
        int n16 = 12;
        int n17 = typedArray5.getInt(n15, n16);
        TypedArray typedArray6 = typedArray;
        int n18 = 4;
        int n19 = 150;
        int n20 = typedArray6.getInt(n18, n19);
        TypedArray typedArray7 = typedArray;
        int n21 = 1;
        int n22 = 0;
        int n23 = typedArray7.getResourceId(n21, n22);
        Drawable drawable2 = null;
        if (n23 > 0) {
            Resources resources4 = resources;
            int n24 = n23;
            drawable2 = resources4.getDrawable(n24);
        }
        typedArray.recycle();
        int n25 = xmlPullParser.getDepth();
        while ((n7 = (n6 = xmlPullParser.next())) != (n5 = 1) && ((n4 = n6) != (n3 = 3) || (n2 = xmlPullParser.getDepth()) > (n = n25))) {
            int n26 = n6;
            int n27 = 2;
            if (n26 != n27 || (drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet)) != null) continue;
            StringBuilder stringBuilder = new StringBuilder().append("Bad element under <animated-rotate>: ");
            String string2 = xmlPullParser.getName();
            String string3 = stringBuilder.append(string2).toString();
            int n28 = Log.w("drawable", string3);
        }
        if (drawable2 == null) {
            int n29 = Log.w("drawable", "No drawable specified for <animated-rotate>");
        }
        AnimatedRotateState animatedRotateState = this.mState;
        animatedRotateState.mDrawable = drawable2;
        animatedRotateState.mPivotXRel = bl;
        animatedRotateState.mPivotX = f2;
        animatedRotateState.mPivotYRel = bl2;
        animatedRotateState.mPivotY = f;
        animatedRotateState.mFramesCount = n17;
        animatedRotateState.mFrameDuration = n20;
        this.init();
        if (drawable2 == null) {
            return;
        }
        Drawable drawable3 = drawable2;
        AnimatedRotateDrawable animatedRotateDrawable2 = this;
        drawable3.setCallback(animatedRotateDrawable2);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.invalidateDrawable(this);
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public boolean isStateful() {
        return this.mState.mDrawable.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            Drawable drawable2 = this.mState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        Drawable drawable2 = this.mState.mDrawable;
        int n = rect.left;
        int n2 = rect.top;
        int n3 = rect.right;
        int n4 = rect.bottom;
        drawable2.setBounds(n, n2, n3, n4);
    }

    @Override
    public void run() {
        float f = this.mCurrentDegrees;
        float f2 = this.mIncrement;
        float f3 = f + f2;
        this.mCurrentDegrees = f3;
        float f4 = this.mCurrentDegrees;
        float f5 = this.mIncrement;
        float f6 = 360.0f - f5;
        if (f4 > f6) {
            this.mCurrentDegrees = 0.0f;
        }
        this.invalidateSelf();
        this.nextFrame();
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.scheduleDrawable(this, runnable, l);
    }

    @Override
    public void setAlpha(int n) {
        this.mState.mDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mState.mDrawable.setColorFilter(colorFilter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = this.mState.mDrawable.setVisible(bl, bl2);
        boolean bl4 = super.setVisible(bl, bl2);
        if (bl) {
            if (bl4 || bl2) {
                this.mCurrentDegrees = 0.0f;
                this.nextFrame();
            }
            return bl4;
        }
        this.unscheduleSelf(this);
        return bl4;
    }

    @Override
    public void start() {
        if (this.mRunning) {
            return;
        }
        this.mRunning = true;
        this.nextFrame();
    }

    @Override
    public void stop() {
        this.mRunning = false;
        this.unscheduleSelf(this);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.unscheduleDrawable(this, runnable);
    }

    static final class AnimatedRotateState
    extends Drawable.ConstantState {
        private boolean mCanConstantState;
        int mChangingConfigurations;
        private boolean mCheckedConstantState;
        Drawable mDrawable;
        int mFrameDuration;
        int mFramesCount;
        float mPivotX;
        boolean mPivotXRel;
        float mPivotY;
        boolean mPivotYRel;

        /*
         * Enabled aggressive block sorting
         */
        public AnimatedRotateState(AnimatedRotateState animatedRotateState, AnimatedRotateDrawable animatedRotateDrawable, Resources resources) {
            int n;
            int n2;
            float f;
            boolean bl;
            float f2;
            boolean bl2;
            Drawable drawable2;
            Drawable drawable3;
            if (animatedRotateState == null) {
                return;
            }
            this.mDrawable = resources != null ? (drawable3 = animatedRotateState.mDrawable.getConstantState().newDrawable(resources)) : (drawable2 = animatedRotateState.mDrawable.getConstantState().newDrawable());
            this.mDrawable.setCallback(animatedRotateDrawable);
            this.mPivotXRel = bl2 = animatedRotateState.mPivotXRel;
            this.mPivotX = f2 = animatedRotateState.mPivotX;
            this.mPivotYRel = bl = animatedRotateState.mPivotYRel;
            this.mPivotY = f = animatedRotateState.mPivotY;
            this.mFramesCount = n2 = animatedRotateState.mFramesCount;
            this.mFrameDuration = n = animatedRotateState.mFrameDuration;
            this.mCheckedConstantState = true;
            this.mCanConstantState = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                boolean bl = this.mDrawable.getConstantState() != null;
                this.mCanConstantState = bl;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new AnimatedRotateDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new AnimatedRotateDrawable(this, resources);
        }
    }
}

