/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.os.SystemClock;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationDrawable
extends DrawableContainer
implements Runnable,
Animatable {
    private final AnimationState mAnimationState;
    private int mCurFrame = -1;
    private boolean mMutated;

    public AnimationDrawable() {
        this(null, null);
    }

    private AnimationDrawable(AnimationState animationState, Resources resources) {
        AnimationState animationState2;
        this.mAnimationState = animationState2 = new AnimationState(animationState, this, resources);
        this.setConstantState(animationState2);
        if (animationState == null) {
            return;
        }
        this.setFrame(0, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void nextFrame(boolean bl) {
        int n;
        int n2 = this.mCurFrame + 1;
        int n3 = this.mAnimationState.getChildCount();
        if (n2 >= n3) {
            n2 = 0;
        }
        boolean bl2 = !this.mAnimationState.mOneShot || n2 < (n = n3 - 1);
        this.setFrame(n2, bl, bl2);
    }

    private void setFrame(int n, boolean bl, boolean bl2) {
        int n2 = this.mAnimationState.getChildCount();
        if (n >= n2) {
            return;
        }
        this.mCurFrame = n;
        boolean bl3 = this.selectDrawable(n);
        if (bl) {
            this.unscheduleSelf(this);
        }
        if (!bl2) {
            return;
        }
        long l = SystemClock.uptimeMillis();
        long l2 = this.mAnimationState.mDurations[n];
        long l3 = l + l2;
        this.scheduleSelf(this, l3);
    }

    public void addFrame(Drawable drawable2, int n) {
        this.mAnimationState.addFrame(drawable2, n);
    }

    public int getDuration(int n) {
        return this.mAnimationState.mDurations[n];
    }

    public Drawable getFrame(int n) {
        return this.mAnimationState.getChildren()[n];
    }

    public int getNumberOfFrames() {
        return this.mAnimationState.getChildCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        int n2;
        int[] nArray = R.styleable.AnimationDrawable;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        super.inflateWithAttributes(resources, xmlPullParser, typedArray, 0);
        AnimationState animationState = this.mAnimationState;
        boolean bl = typedArray.getBoolean(1, false);
        animationState.setVariablePadding(bl);
        AnimationState animationState2 = this.mAnimationState;
        boolean bl2 = typedArray.getBoolean(2, false);
        boolean bl3 = AnimationState.access$102(animationState2, bl2);
        typedArray.recycle();
        int n3 = xmlPullParser.getDepth() + 1;
        while ((n2 = xmlPullParser.next()) != 1 && ((n = xmlPullParser.getDepth()) >= n3 || n2 != 3)) {
            Drawable drawable2;
            if (n2 != 2 || n > n3 || !xmlPullParser.getName().equals("item")) continue;
            int[] nArray2 = R.styleable.AnimationDrawableItem;
            TypedArray typedArray2 = resources.obtainAttributes(attributeSet, nArray2);
            int n4 = typedArray2.getInt(0, -1);
            if (n4 < 0) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = xmlPullParser.getPositionDescription();
                String string3 = stringBuilder.append(string2).append(": <item> tag requires a 'duration' attribute").toString();
                throw new XmlPullParserException(string3);
            }
            int n5 = typedArray2.getResourceId(1, 0);
            typedArray2.recycle();
            if (n5 != 0) {
                drawable2 = resources.getDrawable(n5);
            } else {
                while ((n2 = xmlPullParser.next()) == 4) {
                }
                if (n2 != 2) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string4 = xmlPullParser.getPositionDescription();
                    String string5 = stringBuilder.append(string4).append(": <item> tag requires a 'drawable' attribute or child tag").append(" defining a drawable").toString();
                    throw new XmlPullParserException(string5);
                }
                drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet);
            }
            this.mAnimationState.addFrame(drawable2, n4);
            if (drawable2 == null) continue;
            drawable2.setCallback(this);
        }
        this.setFrame(0, true, false);
    }

    public boolean isOneShot() {
        return this.mAnimationState.mOneShot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isRunning() {
        if (this.mCurFrame <= -1) return false;
        return true;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            AnimationState animationState = this.mAnimationState;
            int[] nArray = (int[])this.mAnimationState.mDurations.clone();
            int[] nArray2 = AnimationState.access$002(animationState, nArray);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void run() {
        this.nextFrame(false);
    }

    public void setOneShot(boolean bl) {
        boolean bl2 = AnimationState.access$102(this.mAnimationState, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = super.setVisible(bl, bl2);
        if (bl) {
            if (bl3 || bl2) {
                this.setFrame(0, true, true);
            }
            return bl3;
        }
        this.unscheduleSelf(this);
        return bl3;
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.run();
    }

    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.unscheduleSelf(this);
    }

    @Override
    public void unscheduleSelf(Runnable runnable) {
        this.mCurFrame = -1;
        super.unscheduleSelf(runnable);
    }

    private static final class AnimationState
    extends DrawableContainer.DrawableContainerState {
        private int[] mDurations;
        private boolean mOneShot;

        AnimationState(AnimationState animationState, AnimationDrawable animationDrawable, Resources resources) {
            super(animationState, animationDrawable, resources);
            if (animationState != null) {
                boolean bl;
                int[] nArray;
                this.mDurations = nArray = animationState.mDurations;
                this.mOneShot = bl = animationState.mOneShot;
                return;
            }
            int[] nArray = new int[this.getChildren().length];
            this.mDurations = nArray;
            this.mOneShot = true;
        }

        static /* synthetic */ int[] access$002(AnimationState animationState, int[] nArray) {
            animationState.mDurations = nArray;
            return nArray;
        }

        static /* synthetic */ boolean access$102(AnimationState animationState, boolean bl) {
            animationState.mOneShot = bl;
            return bl;
        }

        public void addFrame(Drawable drawable2, int n) {
            int n2 = super.addChild(drawable2);
            this.mDurations[n2] = n;
        }

        @Override
        public void growArray(int n, int n2) {
            super.growArray(n, n2);
            int[] nArray = new int[n2];
            System.arraycopy(this.mDurations, 0, nArray, 0, n);
            this.mDurations = nArray;
        }

        @Override
        public Drawable newDrawable() {
            return new AnimationDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new AnimationDrawable(this, resources);
        }
    }
}

