/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BitmapDrawable
extends Drawable {
    private static final int DEFAULT_PAINT_FLAGS = 6;
    private boolean mApplyGravity;
    private Bitmap mBitmap;
    private int mBitmapHeight;
    private BitmapState mBitmapState;
    private int mBitmapWidth;
    private final Rect mDstRect;
    private boolean mMutated;
    private boolean mRebuildShader;
    private int mTargetDensity;

    @Deprecated
    public BitmapDrawable() {
        BitmapState bitmapState;
        Rect rect;
        this.mDstRect = rect = new Rect();
        Bitmap bitmap = null;
        this.mBitmapState = bitmapState = new BitmapState(bitmap);
    }

    public BitmapDrawable(Resources resources) {
        int n;
        BitmapState bitmapState;
        Rect rect;
        this.mDstRect = rect = new Rect();
        Bitmap bitmap = null;
        BitmapState bitmapState2 = this.mBitmapState = (bitmapState = new BitmapState(bitmap));
        bitmapState2.mTargetDensity = n = this.mTargetDensity;
    }

    public BitmapDrawable(Resources resources, Bitmap bitmap) {
        int n;
        BitmapState bitmapState = new BitmapState(bitmap);
        this(bitmapState, resources);
        BitmapState bitmapState2 = this.mBitmapState;
        bitmapState2.mTargetDensity = n = this.mTargetDensity;
    }

    public BitmapDrawable(Resources resources, InputStream inputStream) {
        int n;
        Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
        BitmapState bitmapState = new BitmapState(bitmap);
        this(bitmapState, null);
        BitmapState bitmapState2 = this.mBitmapState;
        bitmapState2.mTargetDensity = n = this.mTargetDensity;
        if (this.mBitmap != null) {
            return;
        }
        String string2 = "BitmapDrawable cannot decode " + inputStream;
        int n2 = Log.w("BitmapDrawable", string2);
    }

    public BitmapDrawable(Resources resources, String string2) {
        int n;
        Bitmap bitmap = BitmapFactory.decodeFile(string2);
        BitmapState bitmapState = new BitmapState(bitmap);
        this(bitmapState, null);
        BitmapState bitmapState2 = this.mBitmapState;
        bitmapState2.mTargetDensity = n = this.mTargetDensity;
        if (this.mBitmap != null) {
            return;
        }
        String string3 = "BitmapDrawable cannot decode " + string2;
        int n2 = Log.w("BitmapDrawable", string3);
    }

    @Deprecated
    public BitmapDrawable(Bitmap bitmap) {
        BitmapState bitmapState = new BitmapState(bitmap);
        this(bitmapState, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private BitmapDrawable(BitmapState bitmapState, Resources resources) {
        int n;
        int n2;
        Rect rect;
        this.mDstRect = rect = new Rect();
        this.mBitmapState = bitmapState;
        this.mTargetDensity = resources != null ? (n2 = resources.getDisplayMetrics().densityDpi) : (bitmapState != null ? (n = bitmapState.mTargetDensity) : 160);
        Bitmap bitmap = bitmapState.mBitmap;
        this.setBitmap(bitmap);
    }

    @Deprecated
    public BitmapDrawable(InputStream inputStream) {
        Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
        BitmapState bitmapState = new BitmapState(bitmap);
        this(bitmapState, null);
        if (this.mBitmap != null) {
            return;
        }
        String string2 = "BitmapDrawable cannot decode " + inputStream;
        int n = Log.w("BitmapDrawable", string2);
    }

    @Deprecated
    public BitmapDrawable(String string2) {
        Bitmap bitmap = BitmapFactory.decodeFile(string2);
        BitmapState bitmapState = new BitmapState(bitmap);
        this(bitmapState, null);
        if (this.mBitmap != null) {
            return;
        }
        String string3 = "BitmapDrawable cannot decode " + string2;
        int n = Log.w("BitmapDrawable", string3);
    }

    private void computeBitmapSize() {
        int n;
        int n2;
        Bitmap bitmap = this.mBitmap;
        int n3 = this.mTargetDensity;
        this.mBitmapWidth = n2 = bitmap.getScaledWidth(n3);
        Bitmap bitmap2 = this.mBitmap;
        int n4 = this.mTargetDensity;
        this.mBitmapHeight = n = bitmap2.getScaledHeight(n4);
    }

    private void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        if (bitmap != null) {
            this.computeBitmapSize();
            return;
        }
        this.mBitmapHeight = -1;
        this.mBitmapWidth = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            return;
        }
        BitmapState bitmapState = this.mBitmapState;
        if (this.mRebuildShader) {
            Shader.TileMode tileMode = bitmapState.mTileModeX;
            Shader.TileMode tileMode2 = bitmapState.mTileModeY;
            if (tileMode == null && tileMode2 == null) {
                Shader shader = bitmapState.mPaint.setShader(null);
            } else {
                Shader.TileMode tileMode3 = tileMode == null ? Shader.TileMode.CLAMP : tileMode;
                Shader.TileMode tileMode4 = tileMode2 == null ? Shader.TileMode.CLAMP : tileMode2;
                BitmapShader bitmapShader = new BitmapShader(bitmap, tileMode3, tileMode4);
                Shader shader = bitmapState.mPaint.setShader(bitmapShader);
            }
            this.mRebuildShader = false;
            Rect rect = this.mDstRect;
            this.copyBounds(rect);
        }
        if (bitmapState.mPaint.getShader() == null) {
            if (this.mApplyGravity) {
                int n = bitmapState.mGravity;
                int n2 = this.mBitmapWidth;
                int n3 = this.mBitmapHeight;
                Rect rect = this.getBounds();
                Rect rect2 = this.mDstRect;
                Gravity.apply(n, n2, n3, rect, rect2);
                this.mApplyGravity = false;
            }
            Rect rect = this.mDstRect;
            Paint paint = bitmapState.mPaint;
            canvas.drawBitmap(bitmap, null, rect, paint);
            return;
        }
        if (this.mApplyGravity) {
            Rect rect = this.mDstRect;
            Rect rect3 = this.getBounds();
            rect.set(rect3);
            this.mApplyGravity = false;
        }
        Rect rect = this.mDstRect;
        Paint paint = bitmapState.mPaint;
        canvas.drawRect(rect, paint);
    }

    public final Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mBitmapState.mChangingConfigurations;
        return n | n2;
    }

    @Override
    public final Drawable.ConstantState getConstantState() {
        int n;
        BitmapState bitmapState = this.mBitmapState;
        bitmapState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mBitmapState;
    }

    public int getGravity() {
        return this.mBitmapState.mGravity;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getOpacity() {
        if (this.mBitmapState.mGravity != 119) {
            return -1;
        }
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) return -1;
        if (bitmap.hasAlpha()) return -1;
        if (this.mBitmapState.mPaint.getAlpha() >= 255) return -1;
        return -1;
    }

    public final Paint getPaint() {
        return this.mBitmapState.mPaint;
    }

    public Shader.TileMode getTileModeX() {
        return this.mBitmapState.mTileModeX;
    }

    public Shader.TileMode getTileModeY() {
        return this.mBitmapState.mTileModeY;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        super.inflate(resources, xmlPullParser, attributeSet);
        int[] nArray = R.styleable.BitmapDrawable;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        int n = typedArray.getResourceId(1, 0);
        if (n == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = xmlPullParser.getPositionDescription();
            String string3 = stringBuilder.append(string2).append(": <bitmap> requires a valid src attribute").toString();
            throw new XmlPullParserException(string3);
        }
        Bitmap bitmap = BitmapFactory.decodeResource(resources, n);
        if (bitmap == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = xmlPullParser.getPositionDescription();
            String string5 = stringBuilder.append(string4).append(": <bitmap> requires a valid src attribute").toString();
            throw new XmlPullParserException(string5);
        }
        this.mBitmapState.mBitmap = bitmap;
        this.setBitmap(bitmap);
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        this.setTargetDensity(displayMetrics);
        Paint paint = this.mBitmapState.mPaint;
        boolean bl = paint.isAntiAlias();
        boolean bl2 = typedArray.getBoolean(2, bl);
        paint.setAntiAlias(bl2);
        boolean bl3 = paint.isFilterBitmap();
        boolean bl4 = typedArray.getBoolean(3, bl3);
        paint.setFilterBitmap(bl4);
        boolean bl5 = paint.isDither();
        boolean bl6 = typedArray.getBoolean(4, bl5);
        paint.setDither(bl6);
        int n2 = typedArray.getInt(0, 119);
        this.setGravity(n2);
        int n3 = typedArray.getInt(5, -1);
        if (n3 != -1) {
            switch (n3) {
                case 0: {
                    Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                    Shader.TileMode tileMode2 = Shader.TileMode.CLAMP;
                    this.setTileModeXY(tileMode, tileMode2);
                    break;
                }
                case 1: {
                    Shader.TileMode tileMode = Shader.TileMode.REPEAT;
                    Shader.TileMode tileMode3 = Shader.TileMode.REPEAT;
                    this.setTileModeXY(tileMode, tileMode3);
                    break;
                }
                case 2: {
                    Shader.TileMode tileMode = Shader.TileMode.MIRROR;
                    Shader.TileMode tileMode4 = Shader.TileMode.MIRROR;
                    this.setTileModeXY(tileMode, tileMode4);
                    break;
                }
            }
        }
        typedArray.recycle();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            BitmapState bitmapState;
            BitmapState bitmapState2 = this.mBitmapState;
            this.mBitmapState = bitmapState = new BitmapState(bitmapState2);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.mApplyGravity = true;
    }

    @Override
    public void setAlpha(int n) {
        this.mBitmapState.mPaint.setAlpha(n);
    }

    public void setAntiAlias(boolean bl) {
        this.mBitmapState.mPaint.setAntiAlias(bl);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        ColorFilter colorFilter2 = this.mBitmapState.mPaint.setColorFilter(colorFilter);
    }

    @Override
    public void setDither(boolean bl) {
        this.mBitmapState.mPaint.setDither(bl);
    }

    @Override
    public void setFilterBitmap(boolean bl) {
        this.mBitmapState.mPaint.setFilterBitmap(bl);
    }

    public void setGravity(int n) {
        this.mBitmapState.mGravity = n;
        this.mApplyGravity = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTargetDensity(int n) {
        int n2 = n == 0 ? 160 : n;
        this.mTargetDensity = n2;
        if (this.mBitmap == null) {
            return;
        }
        this.computeBitmapSize();
    }

    public void setTargetDensity(Canvas canvas) {
        int n = canvas.getDensity();
        this.setTargetDensity(n);
    }

    public void setTargetDensity(DisplayMetrics displayMetrics) {
        int n;
        this.mTargetDensity = n = displayMetrics.densityDpi;
        if (this.mBitmap == null) {
            return;
        }
        this.computeBitmapSize();
    }

    public void setTileModeX(Shader.TileMode tileMode) {
        Shader.TileMode tileMode2 = this.mBitmapState.mTileModeY;
        this.setTileModeXY(tileMode, tileMode2);
    }

    public void setTileModeXY(Shader.TileMode tileMode, Shader.TileMode tileMode2) {
        BitmapState bitmapState = this.mBitmapState;
        if (bitmapState.mPaint.getShader() != null && bitmapState.mTileModeX == tileMode && bitmapState.mTileModeY == tileMode2) {
            return;
        }
        bitmapState.mTileModeX = tileMode;
        bitmapState.mTileModeY = tileMode2;
        this.mRebuildShader = true;
    }

    public final void setTileModeY(Shader.TileMode tileMode) {
        Shader.TileMode tileMode2 = this.mBitmapState.mTileModeX;
        this.setTileModeXY(tileMode2, tileMode);
    }

    static final class BitmapState
    extends Drawable.ConstantState {
        Bitmap mBitmap;
        int mChangingConfigurations;
        int mGravity;
        Paint mPaint;
        int mTargetDensity;
        Shader.TileMode mTileModeX;
        Shader.TileMode mTileModeY;

        BitmapState(Bitmap bitmap) {
            Paint paint;
            this.mGravity = 119;
            this.mPaint = paint = new Paint(6);
            this.mTargetDensity = 160;
            this.mBitmap = bitmap;
        }

        BitmapState(BitmapState bitmapState) {
            Paint paint;
            int n;
            Shader.TileMode tileMode;
            Shader.TileMode tileMode2;
            int n2;
            int n3;
            Bitmap bitmap = bitmapState.mBitmap;
            this(bitmap);
            this.mChangingConfigurations = n3 = bitmapState.mChangingConfigurations;
            this.mGravity = n2 = bitmapState.mGravity;
            this.mTileModeX = tileMode2 = bitmapState.mTileModeX;
            this.mTileModeY = tileMode = bitmapState.mTileModeY;
            this.mTargetDensity = n = bitmapState.mTargetDensity;
            Paint paint2 = bitmapState.mPaint;
            this.mPaint = paint = new Paint(paint2);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new BitmapDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new BitmapDrawable(this, resources);
        }
    }
}

