/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ClipDrawable
extends Drawable
implements Drawable.Callback {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private ClipState mClipState;
    private final Rect mTmpRect;

    ClipDrawable() {
        this(null, null);
    }

    private ClipDrawable(ClipState clipState, Resources resources) {
        ClipState clipState2;
        Rect rect;
        this.mTmpRect = rect = new Rect();
        this.mClipState = clipState2 = new ClipState(clipState, this, resources);
    }

    public ClipDrawable(Drawable drawable2, int n, int n2) {
        this(null, null);
        this.mClipState.mDrawable = drawable2;
        this.mClipState.mGravity = n;
        this.mClipState.mOrientation = n2;
        if (drawable2 == null) {
            return;
        }
        drawable2.setCallback(this);
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mClipState.mDrawable.getLevel() == 0) {
            return;
        }
        Rect rect = this.mTmpRect;
        Rect rect2 = this.getBounds();
        int n = this.getLevel();
        int n2 = rect2.width();
        if ((this.mClipState.mOrientation & 1) != 0) {
            int n3 = n2 - 0;
            int n4 = 10000 - n;
            int n5 = n3 * n4 / 10000;
            n2 -= n5;
        }
        int n6 = rect2.height();
        if ((this.mClipState.mOrientation & 2) != 0) {
            int n7 = n6 - 0;
            int n8 = 10000 - n;
            int n9 = n7 * n8 / 10000;
            n6 -= n9;
        }
        Gravity.apply(this.mClipState.mGravity, n2, n6, rect2, rect);
        if (n2 <= 0) {
            return;
        }
        if (n6 <= 0) {
            return;
        }
        int n10 = canvas.save();
        boolean bl = canvas.clipRect(rect);
        this.mClipState.mDrawable.draw(canvas);
        canvas.restore();
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mClipState.mChangingConfigurations;
        int n3 = n | n2;
        int n4 = this.mClipState.mDrawable.getChangingConfigurations();
        return n3 | n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        if (!this.mClipState.canConstantState()) return null;
        ClipState clipState = this.mClipState;
        clipState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mClipState;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mClipState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mClipState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mClipState.mDrawable.getOpacity();
    }

    @Override
    public boolean getPadding(Rect rect) {
        return this.mClipState.mDrawable.getPadding(rect);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        super.inflate(resources, xmlPullParser, attributeSet);
        int[] nArray = R.styleable.ClipDrawable;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        int n2 = typedArray.getInt(2, 1);
        int n3 = typedArray.getInt(0, 3);
        Drawable drawable2 = typedArray.getDrawable(1);
        typedArray.recycle();
        int n4 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n4)) {
            if (n != 2) continue;
            drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet);
        }
        if (drawable2 == null) {
            throw new IllegalArgumentException("No drawable specified for <clip>");
        }
        this.mClipState.mDrawable = drawable2;
        this.mClipState.mOrientation = n2;
        this.mClipState.mGravity = n3;
        drawable2.setCallback(this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.invalidateDrawable(this);
    }

    @Override
    public boolean isStateful() {
        return this.mClipState.mDrawable.isStateful();
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        this.mClipState.mDrawable.setBounds(rect);
    }

    @Override
    protected boolean onLevelChange(int n) {
        boolean bl = this.mClipState.mDrawable.setLevel(n);
        this.invalidateSelf();
        return true;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return this.mClipState.mDrawable.setState(nArray);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.scheduleDrawable(this, runnable, l);
    }

    @Override
    public void setAlpha(int n) {
        this.mClipState.mDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mClipState.mDrawable.setColorFilter(colorFilter);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = this.mClipState.mDrawable.setVisible(bl, bl2);
        return super.setVisible(bl, bl2);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.unscheduleDrawable(this, runnable);
    }

    static final class ClipState
    extends Drawable.ConstantState {
        private boolean mCanConstantState;
        int mChangingConfigurations;
        private boolean mCheckedConstantState;
        Drawable mDrawable;
        int mGravity;
        int mOrientation;

        /*
         * Enabled aggressive block sorting
         */
        ClipState(ClipState clipState, ClipDrawable clipDrawable, Resources resources) {
            int n;
            int n2;
            Drawable drawable2;
            Drawable drawable3;
            if (clipState == null) {
                return;
            }
            this.mDrawable = resources != null ? (drawable3 = clipState.mDrawable.getConstantState().newDrawable(resources)) : (drawable2 = clipState.mDrawable.getConstantState().newDrawable());
            this.mDrawable.setCallback(clipDrawable);
            this.mOrientation = n2 = clipState.mOrientation;
            this.mGravity = n = clipState.mGravity;
            this.mCanConstantState = true;
            this.mCheckedConstantState = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                boolean bl = this.mDrawable.getConstantState() != null;
                this.mCanConstantState = bl;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new ClipDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new ClipDrawable(this, resources);
        }
    }
}

