/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorDrawable
extends Drawable {
    private ColorState mState;

    public ColorDrawable() {
        this(null);
    }

    public ColorDrawable(int n) {
        this(null);
        ColorState colorState = this.mState;
        this.mState.mUseColor = n;
        colorState.mBaseColor = n;
    }

    private ColorDrawable(ColorState colorState) {
        ColorState colorState2;
        this.mState = colorState2 = new ColorState(colorState);
    }

    @Override
    public void draw(Canvas canvas) {
        int n = this.mState.mUseColor;
        canvas.drawColor(n);
    }

    public int getAlpha() {
        return this.mState.mUseColor >>> 24;
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mState.mChangingConfigurations;
        return n | n2;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        ColorState colorState = this.mState;
        colorState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getOpacity() {
        switch (this.mState.mUseColor >>> 24) {
            default: {
                return -1;
            }
            case 255: {
                return -1;
            }
            case 0: 
        }
        return -1;
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        super.inflate(resources, xmlPullParser, attributeSet);
        int[] nArray = R.styleable.ColorDrawable;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        int n = this.mState.mBaseColor;
        int n2 = typedArray.getColor(0, n);
        ColorState colorState = this.mState;
        this.mState.mUseColor = n2;
        colorState.mBaseColor = n2;
        typedArray.recycle();
    }

    @Override
    public void setAlpha(int n) {
        int n2;
        int n3 = n >> 7;
        int n4 = n + n3;
        int n5 = (this.mState.mBaseColor >>> 24) * n4 >> 8;
        ColorState colorState = this.mState;
        int n6 = this.mState.mBaseColor << 8 >>> 8;
        int n7 = n5 << 24;
        colorState.mUseColor = n2 = n6 | n7;
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
    }

    static final class ColorState
    extends Drawable.ConstantState {
        int mBaseColor;
        int mChangingConfigurations;
        int mUseColor;

        ColorState(ColorState colorState) {
            int n;
            int n2;
            if (colorState == null) {
                return;
            }
            this.mBaseColor = n2 = colorState.mBaseColor;
            this.mUseColor = n = colorState.mUseColor;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new ColorDrawable(this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new ColorDrawable(this);
        }
    }
}

