/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.NinePatch;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.AnimatedRotateDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.LevelListDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.RotateDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.TransitionDrawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class Drawable {
    private static final Rect ZERO_BOUNDS_RECT = new Rect();
    private Rect mBounds;
    Callback mCallback;
    private int mChangingConfigurations;
    private int mLevel;
    private int[] mStateSet;
    private boolean mVisible;

    public Drawable() {
        Rect rect;
        int[] nArray = StateSet.WILD_CARD;
        this.mStateSet = nArray;
        this.mLevel = 0;
        this.mChangingConfigurations = 0;
        this.mBounds = rect = ZERO_BOUNDS_RECT;
        this.mCallback = null;
        this.mVisible = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Drawable createFromPath(String string2) {
        Drawable drawable2 = null;
        if (string2 == null) {
            return drawable2;
        }
        Bitmap bitmap = BitmapFactory.decodeFile(string2);
        if (bitmap == null) return drawable2;
        return Drawable.drawableFromBitmap(null, bitmap, null, null, string2);
    }

    public static Drawable createFromResourceStream(Resources resources, TypedValue typedValue, InputStream inputStream, String string2) {
        return Drawable.createFromResourceStream(resources, typedValue, inputStream, string2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Drawable createFromResourceStream(Resources resources, TypedValue typedValue, InputStream inputStream, String string2, BitmapFactory.Options options) {
        int n;
        if (inputStream == null) {
            return null;
        }
        Rect rect = new Rect();
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        options.inScreenDensity = n = DisplayMetrics.DENSITY_DEVICE;
        Bitmap bitmap = BitmapFactory.decodeResourceStream(resources, typedValue, inputStream, rect, options);
        if (bitmap == null) return null;
        byte[] byArray = bitmap.getNinePatchChunk();
        if (byArray != null) {
            if (NinePatch.isNinePatchChunk(byArray)) return Drawable.drawableFromBitmap(resources, bitmap, byArray, rect, string2);
        }
        byArray = null;
        rect = null;
        return Drawable.drawableFromBitmap(resources, bitmap, byArray, rect, string2);
    }

    public static Drawable createFromStream(InputStream inputStream, String string2) {
        return Drawable.createFromResourceStream(null, null, inputStream, string2, null);
    }

    public static Drawable createFromXml(Resources resources, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n;
        AttributeSet attributeSet = Xml.asAttributeSet(xmlPullParser);
        while ((n = xmlPullParser.next()) != 2 && n != 1) {
        }
        if (n != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        Drawable drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet);
        if (drawable2 == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Unknown initial tag: ");
            String string2 = xmlPullParser.getName();
            String string3 = stringBuilder.append(string2).toString();
            throw new RuntimeException(string3);
        }
        return drawable2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Drawable createFromXmlInner(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        void var4_5;
        String string2 = xmlPullParser.getName();
        if (string2.equals("selector")) {
            StateListDrawable stateListDrawable = new StateListDrawable();
        } else if (string2.equals("level-list")) {
            LevelListDrawable levelListDrawable = new LevelListDrawable();
        } else if (string2.equals("layer-list")) {
            LayerDrawable layerDrawable = new LayerDrawable();
        } else if (string2.equals("transition")) {
            TransitionDrawable transitionDrawable = new TransitionDrawable();
        } else if (string2.equals("color")) {
            ColorDrawable colorDrawable = new ColorDrawable();
        } else if (string2.equals("shape")) {
            GradientDrawable gradientDrawable = new GradientDrawable();
        } else if (string2.equals("scale")) {
            ScaleDrawable scaleDrawable = new ScaleDrawable();
        } else if (string2.equals("clip")) {
            ClipDrawable clipDrawable = new ClipDrawable();
        } else if (string2.equals("rotate")) {
            RotateDrawable rotateDrawable = new RotateDrawable();
        } else if (string2.equals("animated-rotate")) {
            AnimatedRotateDrawable animatedRotateDrawable = new AnimatedRotateDrawable();
        } else if (string2.equals("animation-list")) {
            AnimationDrawable animationDrawable = new AnimationDrawable();
        } else if (string2.equals("inset")) {
            InsetDrawable insetDrawable = new InsetDrawable();
        } else if (string2.equals("bitmap")) {
            BitmapDrawable bitmapDrawable = new BitmapDrawable();
            if (resources != null) {
                BitmapDrawable bitmapDrawable2 = bitmapDrawable;
                DisplayMetrics displayMetrics = resources.getDisplayMetrics();
                bitmapDrawable2.setTargetDensity(displayMetrics);
            }
        } else {
            if (!string2.equals("nine-patch")) {
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = xmlPullParser.getPositionDescription();
                String string4 = stringBuilder.append(string3).append(": invalid drawable tag ").append(string2).toString();
                throw new XmlPullParserException(string4);
            }
            NinePatchDrawable ninePatchDrawable = new NinePatchDrawable();
            if (resources != null) {
                NinePatchDrawable ninePatchDrawable2 = ninePatchDrawable;
                DisplayMetrics displayMetrics = resources.getDisplayMetrics();
                ninePatchDrawable2.setTargetDensity(displayMetrics);
            }
        }
        var4_5.inflate(resources, xmlPullParser, attributeSet);
        return var4_5;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Drawable drawableFromBitmap(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        void var10_11;
        if (byArray != null) {
            Resources resources2 = resources;
            Bitmap bitmap2 = bitmap;
            byte[] byArray2 = byArray;
            Rect rect2 = rect;
            String string3 = string2;
            NinePatchDrawable ninePatchDrawable = new NinePatchDrawable(resources2, bitmap2, byArray2, rect2, string3);
            return var10_11;
        }
        BitmapDrawable bitmapDrawable = new BitmapDrawable(resources, bitmap);
        return var10_11;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int resolveOpacity(int n, int n2) {
        int n3 = -1;
        if (n != n2) {
            return n;
        }
        if (n == 0) return 0;
        if (n2 == 0) {
            return 0;
        }
        if (n == -1) return n3;
        if (n2 == -1) return n3;
        if (n == -1) return -1;
        if (n2 != -1) return -1;
        return -1;
    }

    public void clearColorFilter() {
        this.setColorFilter(null);
    }

    public final Rect copyBounds() {
        Rect rect = this.mBounds;
        return new Rect(rect);
    }

    public final void copyBounds(Rect rect) {
        Rect rect2 = this.mBounds;
        rect.set(rect2);
    }

    public abstract void draw(Canvas var1);

    public final Rect getBounds() {
        Rect rect = this.mBounds;
        Rect rect2 = ZERO_BOUNDS_RECT;
        if (rect == rect2) {
            Rect rect3;
            this.mBounds = rect3 = new Rect();
        }
        return this.mBounds;
    }

    public int getChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    public ConstantState getConstantState() {
        return null;
    }

    public Drawable getCurrent() {
        return this;
    }

    public int getIntrinsicHeight() {
        return -1;
    }

    public int getIntrinsicWidth() {
        return -1;
    }

    public final int getLevel() {
        return this.mLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMinimumHeight() {
        int n = this.getIntrinsicHeight();
        if (n <= 0) return 0;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMinimumWidth() {
        int n = this.getIntrinsicWidth();
        if (n <= 0) return 0;
        return n;
    }

    public abstract int getOpacity();

    public boolean getPadding(Rect rect) {
        rect.set(0, 0, 0, 0);
        return false;
    }

    public int[] getState() {
        return this.mStateSet;
    }

    public Region getTransparentRegion() {
        return null;
    }

    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int[] nArray = R.styleable.Drawable;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        this.inflateWithAttributes(resources, xmlPullParser, typedArray, 0);
        typedArray.recycle();
    }

    void inflateWithAttributes(Resources resources, XmlPullParser xmlPullParser, TypedArray typedArray, int n) throws XmlPullParserException, IOException {
        boolean bl;
        boolean bl2 = this.mVisible;
        this.mVisible = bl = typedArray.getBoolean(n, bl2);
    }

    public void invalidateSelf() {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.invalidateDrawable(this);
    }

    public boolean isStateful() {
        return false;
    }

    public final boolean isVisible() {
        return this.mVisible;
    }

    public Drawable mutate() {
        return this;
    }

    protected void onBoundsChange(Rect rect) {
    }

    protected boolean onLevelChange(int n) {
        return false;
    }

    protected boolean onStateChange(int[] nArray) {
        return false;
    }

    public void scheduleSelf(Runnable runnable, long l) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.scheduleDrawable(this, runnable, l);
    }

    public abstract void setAlpha(int var1);

    public void setBounds(int n, int n2, int n3, int n4) {
        Rect rect = this.mBounds;
        Rect rect2 = ZERO_BOUNDS_RECT;
        if (rect == rect2) {
            this.mBounds = rect = new Rect();
        }
        if (rect.left != n && rect.top != n2 && rect.right != n3 && rect.bottom != n4) {
            return;
        }
        this.mBounds.set(n, n2, n3, n4);
        Rect rect3 = this.mBounds;
        this.onBoundsChange(rect3);
    }

    public void setBounds(Rect rect) {
        int n = rect.left;
        int n2 = rect.top;
        int n3 = rect.right;
        int n4 = rect.bottom;
        this.setBounds(n, n2, n3, n4);
    }

    public final void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setChangingConfigurations(int n) {
        this.mChangingConfigurations = n;
    }

    public void setColorFilter(int n, PorterDuff.Mode mode) {
        PorterDuffColorFilter porterDuffColorFilter = new PorterDuffColorFilter(n, mode);
        this.setColorFilter(porterDuffColorFilter);
    }

    public abstract void setColorFilter(ColorFilter var1);

    public void setDither(boolean bl) {
    }

    public void setFilterBitmap(boolean bl) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean setLevel(int n) {
        if (this.mLevel == n) return false;
        this.mLevel = n;
        return this.onLevelChange(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setState(int[] nArray) {
        if (Arrays.equals(this.mStateSet, nArray)) return false;
        this.mStateSet = nArray;
        return this.onStateChange(nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = this.mVisible != bl;
        this.mVisible = bl;
        return bl3;
    }

    public void unscheduleSelf(Runnable runnable) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.unscheduleDrawable(this, runnable);
    }

    public static abstract class ConstantState {
        public abstract int getChangingConfigurations();

        public abstract Drawable newDrawable();

        public Drawable newDrawable(Resources resources) {
            return this.newDrawable();
        }
    }

    public static interface Callback {
        public void invalidateDrawable(Drawable var1);

        public void scheduleDrawable(Drawable var1, Runnable var2, long var3);

        public void unscheduleDrawable(Drawable var1, Runnable var2);
    }
}

