/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class DrawableContainer
extends Drawable
implements Drawable.Callback {
    private static final boolean DEFAULT_DITHER = true;
    private int mAlpha = 255;
    private ColorFilter mColorFilter;
    private int mCurIndex = -1;
    private Drawable mCurrDrawable;
    private DrawableContainerState mDrawableContainerState;
    private boolean mMutated;

    @Override
    public void draw(Canvas canvas) {
        if (this.mCurrDrawable == null) {
            return;
        }
        this.mCurrDrawable.draw(canvas);
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mDrawableContainerState.mChangingConfigurations;
        int n3 = n | n2;
        int n4 = this.mDrawableContainerState.mChildrenChangingConfigurations;
        return n3 | n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        if (!this.mDrawableContainerState.canConstantState()) return null;
        DrawableContainerState drawableContainerState = this.mDrawableContainerState;
        drawableContainerState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mDrawableContainerState;
    }

    @Override
    public Drawable getCurrent() {
        return this.mCurrDrawable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getIntrinsicHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantHeight();
        }
        if (this.mCurrDrawable == null) return -1;
        return this.mCurrDrawable.getIntrinsicHeight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getIntrinsicWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantWidth();
        }
        if (this.mCurrDrawable == null) return -1;
        return this.mCurrDrawable.getIntrinsicWidth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getMinimumHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumHeight();
        }
        if (this.mCurrDrawable == null) return 0;
        return this.mCurrDrawable.getMinimumHeight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getMinimumWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumWidth();
        }
        if (this.mCurrDrawable == null) return 0;
        return this.mCurrDrawable.getMinimumWidth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getOpacity() {
        if (this.mCurrDrawable == null) return -1;
        if (this.mCurrDrawable.isVisible()) return this.mDrawableContainerState.getOpacity();
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getPadding(Rect rect) {
        Rect rect2 = this.mDrawableContainerState.getConstantPadding();
        if (rect2 != null) {
            rect.set(rect2);
            return true;
        }
        if (this.mCurrDrawable == null) return super.getPadding(rect);
        return this.mCurrDrawable.getPadding(rect);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        Drawable drawable3 = this.mCurrDrawable;
        if (drawable2 != drawable3) {
            return;
        }
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.invalidateDrawable(this);
    }

    @Override
    public boolean isStateful() {
        return this.mDrawableContainerState.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            int n = this.mDrawableContainerState.getChildCount();
            Drawable[] drawableArray = this.mDrawableContainerState.getChildren();
            for (int i = 0; i < n; ++i) {
                if (drawableArray[i] == null) continue;
                Drawable drawable2 = drawableArray[i].mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        if (this.mCurrDrawable == null) {
            return;
        }
        this.mCurrDrawable.setBounds(rect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onLevelChange(int n) {
        if (this.mCurrDrawable == null) return false;
        return this.mCurrDrawable.setLevel(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onStateChange(int[] nArray) {
        if (this.mCurrDrawable == null) return false;
        return this.mCurrDrawable.setState(nArray);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable drawable3 = this.mCurrDrawable;
        if (drawable2 != drawable3) {
            return;
        }
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.scheduleDrawable(this, runnable, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean selectDrawable(int n) {
        int n2;
        int n3 = this.mCurIndex;
        if (n != n3) {
            return false;
        }
        if (n >= 0 && n < (n2 = this.mDrawableContainerState.mNumChildren)) {
            Drawable drawable2 = this.mDrawableContainerState.mDrawables[n];
            if (this.mCurrDrawable != null) {
                boolean bl = this.mCurrDrawable.setVisible(false, false);
            }
            this.mCurrDrawable = drawable2;
            this.mCurIndex = n;
            if (drawable2 != null) {
                boolean bl = this.isVisible();
                boolean bl2 = drawable2.setVisible(bl, true);
                int n4 = this.mAlpha;
                drawable2.setAlpha(n4);
                boolean bl3 = this.mDrawableContainerState.mDither;
                drawable2.setDither(bl3);
                ColorFilter colorFilter = this.mColorFilter;
                drawable2.setColorFilter(colorFilter);
                int[] nArray = this.getState();
                boolean bl4 = drawable2.setState(nArray);
                int n5 = this.getLevel();
                boolean bl5 = drawable2.setLevel(n5);
                Rect rect = this.getBounds();
                drawable2.setBounds(rect);
            }
        } else {
            if (this.mCurrDrawable != null) {
                boolean bl = this.mCurrDrawable.setVisible(false, false);
            }
            this.mCurrDrawable = null;
            this.mCurIndex = -1;
        }
        this.invalidateSelf();
        return true;
    }

    @Override
    public void setAlpha(int n) {
        if (this.mAlpha != n) {
            return;
        }
        this.mAlpha = n;
        if (this.mCurrDrawable == null) {
            return;
        }
        this.mCurrDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mColorFilter == colorFilter) {
            return;
        }
        this.mColorFilter = colorFilter;
        if (this.mCurrDrawable == null) {
            return;
        }
        this.mCurrDrawable.setColorFilter(colorFilter);
    }

    protected void setConstantState(DrawableContainerState drawableContainerState) {
        this.mDrawableContainerState = drawableContainerState;
    }

    @Override
    public void setDither(boolean bl) {
        if (this.mDrawableContainerState.mDither != bl) {
            return;
        }
        this.mDrawableContainerState.mDither = bl;
        if (this.mCurrDrawable == null) {
            return;
        }
        Drawable drawable2 = this.mCurrDrawable;
        boolean bl2 = this.mDrawableContainerState.mDither;
        drawable2.setDither(bl2);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = super.setVisible(bl, bl2);
        if (this.mCurrDrawable != null) {
            boolean bl4 = this.mCurrDrawable.setVisible(bl, bl2);
        }
        return bl3;
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable drawable3 = this.mCurrDrawable;
        if (drawable2 != drawable3) {
            return;
        }
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.unscheduleDrawable(this, runnable);
    }

    public static abstract class DrawableContainerState
    extends Drawable.ConstantState {
        boolean mCanConstantState;
        int mChangingConfigurations;
        boolean mCheckedConstantState;
        int mChildrenChangingConfigurations;
        boolean mComputedConstantSize = false;
        int mConstantHeight;
        int mConstantMinimumHeight;
        int mConstantMinimumWidth;
        Rect mConstantPadding = null;
        boolean mConstantSize = false;
        int mConstantWidth;
        boolean mDither = true;
        Drawable[] mDrawables;
        boolean mHaveOpacity = false;
        boolean mHaveStateful = false;
        int mNumChildren;
        int mOpacity;
        final DrawableContainer mOwner;
        boolean mPaddingChecked = false;
        boolean mStateful;
        boolean mVariablePadding = false;

        /*
         * Enabled aggressive block sorting
         */
        DrawableContainerState(DrawableContainerState drawableContainerState, DrawableContainer drawableContainer, Resources resources) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            int n;
            boolean bl4;
            int n2;
            int n3;
            boolean bl5;
            boolean bl6;
            boolean bl7;
            int n4;
            int n5;
            int n6;
            this.mOwner = drawableContainer;
            if (drawableContainerState == null) {
                Drawable[] drawableArray = new Drawable[10];
                this.mDrawables = drawableArray;
                this.mNumChildren = 0;
                this.mCanConstantState = false;
                this.mCheckedConstantState = false;
                return;
            }
            this.mChangingConfigurations = n6 = drawableContainerState.mChangingConfigurations;
            this.mChildrenChangingConfigurations = n5 = drawableContainerState.mChildrenChangingConfigurations;
            Drawable[] drawableArray = drawableContainerState.mDrawables;
            Drawable[] drawableArray2 = new Drawable[drawableArray.length];
            this.mDrawables = drawableArray2;
            int n7 = this.mNumChildren = (n4 = drawableContainerState.mNumChildren);
            for (int i = 0; i < n7; ++i) {
                if (resources != null) {
                    Drawable drawable2;
                    Drawable[] drawableArray3 = this.mDrawables;
                    drawableArray3[i] = drawable2 = drawableArray[i].getConstantState().newDrawable(resources);
                } else {
                    Drawable drawable3;
                    Drawable[] drawableArray4 = this.mDrawables;
                    drawableArray4[i] = drawable3 = drawableArray[i].getConstantState().newDrawable();
                }
                this.mDrawables[i].setCallback(drawableContainer);
            }
            this.mCanConstantState = true;
            this.mCheckedConstantState = true;
            this.mVariablePadding = bl7 = drawableContainerState.mVariablePadding;
            if (drawableContainerState.mConstantPadding != null) {
                Rect rect;
                Rect rect2 = drawableContainerState.mConstantPadding;
                this.mConstantPadding = rect = new Rect(rect2);
            }
            this.mConstantSize = bl6 = drawableContainerState.mConstantSize;
            this.mComputedConstantSize = bl5 = drawableContainerState.mComputedConstantSize;
            this.mConstantWidth = n3 = drawableContainerState.mConstantWidth;
            this.mConstantHeight = n2 = drawableContainerState.mConstantHeight;
            this.mHaveOpacity = bl4 = drawableContainerState.mHaveOpacity;
            this.mOpacity = n = drawableContainerState.mOpacity;
            this.mHaveStateful = bl3 = drawableContainerState.mHaveStateful;
            this.mStateful = bl2 = drawableContainerState.mStateful;
            this.mDither = bl = drawableContainerState.mDither;
        }

        private void computeConstantSize() {
            this.mComputedConstantSize = true;
            int n = this.getChildCount();
            Drawable[] drawableArray = this.mDrawables;
            this.mConstantHeight = 0;
            this.mConstantWidth = 0;
            this.mConstantMinimumHeight = 0;
            this.mConstantMinimumWidth = 0;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                Drawable drawable2 = drawableArray[n2];
                int n10 = drawable2.getIntrinsicWidth();
                if (n10 > (n9 = this.mConstantWidth)) {
                    this.mConstantWidth = n10;
                }
                if ((n8 = drawable2.getIntrinsicHeight()) > (n7 = this.mConstantHeight)) {
                    this.mConstantHeight = n8;
                }
                if ((n6 = drawable2.getMinimumWidth()) > (n5 = this.mConstantMinimumWidth)) {
                    this.mConstantMinimumWidth = n6;
                }
                if ((n4 = drawable2.getMinimumHeight()) > (n3 = this.mConstantMinimumHeight)) {
                    this.mConstantMinimumHeight = n4;
                }
                ++n2;
            }
            return;
        }

        public final int addChild(Drawable drawable2) {
            int n;
            int n2;
            int n3 = this.mNumChildren;
            int n4 = this.mDrawables.length;
            if (n3 >= n4) {
                int n5 = n3 + 10;
                this.growArray(n3, n5);
            }
            boolean bl = drawable2.setVisible(false, true);
            DrawableContainer drawableContainer = this.mOwner;
            drawable2.setCallback(drawableContainer);
            this.mDrawables[n3] = drawable2;
            this.mNumChildren = n2 = this.mNumChildren + 1;
            int n6 = this.mChildrenChangingConfigurations;
            int n7 = drawable2.getChangingConfigurations();
            this.mChildrenChangingConfigurations = n = n6 | n7;
            this.mHaveOpacity = false;
            this.mHaveStateful = false;
            this.mConstantPadding = null;
            this.mPaddingChecked = false;
            this.mComputedConstantSize = false;
            return n3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canConstantState() {
            synchronized (this) {
                if (this.mCheckedConstantState) return this.mCanConstantState;
                this.mCanConstantState = true;
                int n = this.mNumChildren;
                int n2 = 0;
                while (true) {
                    block7: {
                        block6: {
                            if (n2 >= n) break block6;
                            if (this.mDrawables[n2].getConstantState() != null) break block7;
                            this.mCanConstantState = false;
                        }
                        this.mCheckedConstantState = true;
                        return this.mCanConstantState;
                    }
                    ++n2;
                }
            }
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public final int getChildCount() {
            return this.mNumChildren;
        }

        public final Drawable[] getChildren() {
            return this.mDrawables;
        }

        public final int getConstantHeight() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantHeight;
        }

        public final int getConstantMinimumHeight() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumHeight;
        }

        public final int getConstantMinimumWidth() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumWidth;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final Rect getConstantPadding() {
            if (this.mVariablePadding) {
                return null;
            }
            if (this.mConstantPadding != null) return this.mConstantPadding;
            if (this.mPaddingChecked) {
                return this.mConstantPadding;
            }
            Rect rect = null;
            Rect rect2 = new Rect();
            int n = this.getChildCount();
            Drawable[] drawableArray = this.mDrawables;
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                if (!drawableArray[i].getPadding(rect2)) continue;
                if (rect == null) {
                    rect = new Rect(0, 0, 0, 0);
                }
                if ((n10 = rect2.left) > (n9 = rect.left)) {
                    int n11;
                    rect.left = n11 = rect2.left;
                }
                if ((n8 = rect2.top) > (n7 = rect.top)) {
                    int n12;
                    rect.top = n12 = rect2.top;
                }
                if ((n6 = rect2.right) > (n5 = rect.right)) {
                    int n13;
                    rect.right = n13 = rect2.right;
                }
                if ((n4 = rect2.bottom) <= (n3 = rect.bottom)) continue;
                rect.bottom = n2 = rect2.bottom;
            }
            this.mPaddingChecked = true;
            this.mConstantPadding = rect;
            return rect;
        }

        public final int getConstantWidth() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantWidth;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final int getOpacity() {
            if (this.mHaveOpacity) {
                return this.mOpacity;
            }
            int n = this.getChildCount();
            Drawable[] drawableArray = this.mDrawables;
            int n2 = n > 0 ? drawableArray[0].getOpacity() : -1;
            int n3 = 1;
            while (true) {
                if (n3 >= n) {
                    this.mOpacity = n2;
                    this.mHaveOpacity = true;
                    return n2;
                }
                int n4 = drawableArray[n3].getOpacity();
                n2 = Drawable.resolveOpacity(n2, n4);
                ++n3;
            }
        }

        public void growArray(int n, int n2) {
            Drawable[] drawableArray = new Drawable[n2];
            System.arraycopy(this.mDrawables, 0, drawableArray, 0, n);
            this.mDrawables = drawableArray;
        }

        public final boolean isConstantSize() {
            return this.mConstantSize;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isStateful() {
            if (this.mHaveStateful) {
                return this.mStateful;
            }
            boolean bl = false;
            int n = this.getChildCount();
            int n2 = 0;
            while (true) {
                block6: {
                    block5: {
                        if (n2 >= n) break block5;
                        if (!this.mDrawables[n2].isStateful()) break block6;
                        bl = true;
                    }
                    this.mStateful = bl;
                    this.mHaveStateful = true;
                    return bl;
                }
                ++n2;
            }
        }

        public final void setConstantSize(boolean bl) {
            this.mConstantSize = bl;
        }

        public final void setVariablePadding(boolean bl) {
            this.mVariablePadding = bl;
        }
    }
}

