/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GradientDrawable
extends Drawable {
    public static final int LINE = 2;
    public static final int LINEAR_GRADIENT = 0;
    public static final int OVAL = 1;
    public static final int RADIAL_GRADIENT = 1;
    public static final int RECTANGLE = 0;
    public static final int RING = 3;
    public static final int SWEEP_GRADIENT = 2;
    private int mAlpha;
    private ColorFilter mColorFilter;
    private boolean mDither;
    private final Paint mFillPaint;
    private GradientState mGradientState;
    private Paint mLayerPaint;
    private boolean mMutated;
    private Rect mPadding;
    private final Path mPath;
    private boolean mPathIsDirty;
    private final RectF mRect;
    private boolean mRectIsDirty;
    private Path mRingPath;
    private Paint mStrokePaint;

    public GradientDrawable() {
        Orientation orientation = Orientation.TOP_BOTTOM;
        GradientState gradientState = new GradientState(orientation, null);
        this(gradientState);
    }

    private GradientDrawable(GradientState gradientState) {
        RectF rectF;
        Path path;
        Paint paint;
        this.mFillPaint = paint = new Paint(1);
        this.mAlpha = 255;
        this.mPath = path = new Path();
        this.mRect = rectF = new RectF();
        this.mGradientState = gradientState;
        this.initializeWithState(gradientState);
        this.mRectIsDirty = true;
    }

    public GradientDrawable(Orientation orientation, int[] nArray) {
        GradientState gradientState = new GradientState(orientation, nArray);
        this(gradientState);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Path buildRing(GradientState gradientState) {
        float f;
        float f2;
        if (this.mRingPath != null) {
            if (!gradientState.mUseLevelForShape) return this.mRingPath;
            if (!this.mPathIsDirty) {
                return this.mRingPath;
            }
        }
        this.mPathIsDirty = false;
        float f3 = gradientState.mUseLevelForShape ? (float)this.getLevel() * 360.0f / 10000.0f : 360.0f;
        RectF rectF = this.mRect;
        RectF rectF2 = new RectF(rectF);
        float f4 = rectF2.width() / 2.0f;
        float f5 = rectF2.height() / 2.0f;
        if (gradientState.mThickness != -1) {
            f2 = gradientState.mThickness;
        } else {
            float f6 = rectF2.width();
            float f7 = gradientState.mThicknessRatio;
            f2 = f6 / f7;
        }
        if (gradientState.mInnerRadius != -1) {
            f = gradientState.mInnerRadius;
        } else {
            float f8 = rectF2.width();
            float f9 = gradientState.mInnerRadiusRatio;
            f = f8 / f9;
        }
        RectF rectF3 = new RectF(rectF2);
        float f10 = f4 - f;
        float f11 = f5 - f;
        rectF3.inset(f10, f11);
        RectF rectF4 = new RectF(rectF3);
        float f12 = -f2;
        float f13 = -f2;
        rectF4.inset(f12, f13);
        if (this.mRingPath == null) {
            Path path;
            this.mRingPath = path = new Path();
        } else {
            this.mRingPath.reset();
        }
        Path path = this.mRingPath;
        if (f3 < 360.0f && f3 > -360.0f) {
            Path.FillType fillType = Path.FillType.EVEN_ODD;
            path.setFillType(fillType);
            float f14 = f4 + f;
            path.moveTo(f14, f5);
            float f15 = f4 + f + f2;
            path.lineTo(f15, f5);
            path.arcTo(rectF4, 0.0f, f3, false);
            float f16 = -f3;
            path.arcTo(rectF3, f3, f16, false);
            path.close();
            return path;
        } else {
            Path.Direction direction = Path.Direction.CW;
            path.addOval(rectF4, direction);
            Path.Direction direction2 = Path.Direction.CCW;
            path.addOval(rectF3, direction2);
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean ensureValidRect() {
        if (this.mRectIsDirty) {
            boolean bl;
            this.mRectIsDirty = bl = false;
            Rect rect = this.getBounds();
            float f = 0.0f;
            if (this.mStrokePaint != null) {
                f = this.mStrokePaint.getStrokeWidth() * 0.5f;
            }
            GradientState gradientState = this.mGradientState;
            RectF rectF = this.mRect;
            float f2 = (float)rect.left + f;
            float f3 = (float)rect.top + f;
            float f4 = (float)rect.right - f;
            float f5 = (float)rect.bottom - f;
            rectF.set(f2, f3, f4, f5);
            int[] nArray = gradientState.mColors;
            if (nArray != null) {
                RectF rectF2 = this.mRect;
                if (gradientState.mGradient == 0) {
                    float f6;
                    float f7;
                    float f8;
                    float f9;
                    float f10 = gradientState.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    int[] nArray2 = 1.$SwitchMap$android$graphics$drawable$GradientDrawable$Orientation;
                    int n = gradientState.mOrientation.ordinal();
                    switch (nArray2[n]) {
                        default: {
                            f9 = rectF2.left;
                            f8 = rectF2.top;
                            float f11 = rectF2.right;
                            f7 = f10 * f11;
                            float f12 = rectF2.bottom;
                            f6 = f10 * f12;
                            break;
                        }
                        case 1: {
                            f9 = rectF2.left;
                            f8 = rectF2.top;
                            f7 = f9;
                            float f13 = rectF2.bottom;
                            f6 = f10 * f13;
                            break;
                        }
                        case 2: {
                            f9 = rectF2.right;
                            f8 = rectF2.top;
                            float f14 = rectF2.left;
                            f7 = f10 * f14;
                            float f15 = rectF2.bottom;
                            f6 = f10 * f15;
                            break;
                        }
                        case 3: {
                            f9 = rectF2.right;
                            f8 = rectF2.top;
                            float f16 = rectF2.left;
                            f7 = f10 * f16;
                            f6 = f8;
                            break;
                        }
                        case 4: {
                            f9 = rectF2.right;
                            f8 = rectF2.bottom;
                            float f17 = rectF2.left;
                            f7 = f10 * f17;
                            float f18 = rectF2.top;
                            f6 = f10 * f18;
                            break;
                        }
                        case 5: {
                            f9 = rectF2.left;
                            f8 = rectF2.bottom;
                            f7 = f9;
                            float f19 = rectF2.top;
                            f6 = f10 * f19;
                            break;
                        }
                        case 6: {
                            f9 = rectF2.left;
                            f8 = rectF2.bottom;
                            float f20 = rectF2.right;
                            f7 = f10 * f20;
                            float f21 = rectF2.top;
                            f6 = f10 * f21;
                            break;
                        }
                        case 7: {
                            f9 = rectF2.left;
                            f8 = rectF2.top;
                            float f22 = rectF2.right;
                            f7 = f10 * f22;
                            f6 = f8;
                            break;
                        }
                    }
                    Paint paint = this.mFillPaint;
                    float[] fArray = gradientState.mPositions;
                    Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                    LinearGradient linearGradient = new LinearGradient(f9, f8, f7, f6, nArray, fArray, tileMode);
                    Shader shader = paint.setShader(linearGradient);
                } else if (gradientState.mGradient == 1) {
                    float f23 = rectF2.left;
                    float f24 = rectF2.right;
                    float f25 = rectF2.left;
                    float f26 = f24 - f25;
                    float f27 = gradientState.mCenterX;
                    float f28 = f26 * f27 + f23;
                    float f29 = rectF2.top;
                    float f30 = rectF2.bottom;
                    float f31 = rectF2.top;
                    float f32 = f30 - f31;
                    float f33 = gradientState.mCenterY;
                    float f34 = f32 * f33 + f29;
                    float f35 = gradientState.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    Paint paint = this.mFillPaint;
                    float f36 = gradientState.mGradientRadius;
                    float f37 = f35 * f36;
                    Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                    float f38 = f28;
                    float f39 = f34;
                    int[] nArray3 = nArray;
                    RadialGradient radialGradient = new RadialGradient(f38, f39, f37, nArray3, null, tileMode);
                    Shader shader = paint.setShader(radialGradient);
                } else if (gradientState.mGradient == 2) {
                    SweepGradient sweepGradient;
                    float f40 = rectF2.left;
                    float f41 = rectF2.right;
                    float f42 = rectF2.left;
                    float f43 = f41 - f42;
                    float f44 = gradientState.mCenterX;
                    float f45 = f43 * f44 + f40;
                    float f46 = rectF2.top;
                    float f47 = rectF2.bottom;
                    float f48 = rectF2.top;
                    float f49 = f47 - f48;
                    float f50 = gradientState.mCenterY;
                    float f51 = f49 * f50 + f46;
                    int[] nArray4 = nArray;
                    float[] fArray = null;
                    if (gradientState.mUseLevel) {
                        int n;
                        int n2;
                        int n3;
                        int n4;
                        int n5;
                        int n6;
                        int n7;
                        nArray4 = gradientState.mTempColors;
                        int n8 = nArray.length;
                        if (nArray4 == null || (n7 = nArray4.length) != (n6 = n8 + 1)) {
                            int[] nArray5 = new int[n8 + 1];
                            gradientState.mTempColors = nArray5;
                        }
                        int[] nArray6 = nArray;
                        int n9 = 0;
                        int[] nArray7 = nArray4;
                        int n10 = 0;
                        int n11 = n8;
                        System.arraycopy(nArray6, n9, nArray7, n10, n11);
                        int n12 = n8 - 1;
                        nArray4[n8] = n5 = nArray[n12];
                        fArray = gradientState.mTempPositions;
                        float f52 = n8 - 1;
                        float f53 = 1.0f / f52;
                        if (fArray == null || (n4 = fArray.length) != (n3 = n8 + 1)) {
                            float[] fArray2 = new float[n8 + 1];
                            gradientState.mTempPositions = fArray2;
                        }
                        float f54 = (float)this.getLevel() / 10000.0f;
                        int n13 = 0;
                        while ((n2 = ++n13) < (n = n8)) {
                            float f55;
                            fArray[n13] = f55 = (float)n13 * f53 * f54;
                        }
                        fArray[n8] = 1065353216;
                    }
                    Paint paint = this.mFillPaint;
                    SweepGradient sweepGradient2 = sweepGradient;
                    float f56 = f45;
                    float f57 = f51;
                    int[] nArray8 = nArray4;
                    float[] fArray3 = fArray;
                    sweepGradient2(f56, f57, nArray8, fArray3);
                    Shader shader = paint.setShader(sweepGradient);
                }
            }
        }
        if (this.mRect.isEmpty()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static float getFloatOrFraction(TypedArray typedArray, int n, float f) {
        TypedValue typedValue = typedArray.peekValue(n);
        float f2 = f;
        if (typedValue == null) return f2;
        boolean bl = typedValue.type == 6;
        if (!bl) return typedValue.getFloat();
        return typedValue.getFraction(1.0f, 1.0f);
    }

    private void initializeWithState(GradientState gradientState) {
        Paint paint;
        Rect rect;
        if (gradientState.mHasSolidColor) {
            Paint paint2 = this.mFillPaint;
            int n = gradientState.mSolidColor;
            paint2.setColor(n);
        }
        this.mPadding = rect = gradientState.mPadding;
        if (gradientState.mStrokeWidth < 0) {
            return;
        }
        Paint paint3 = this.mStrokePaint = (paint = new Paint(1));
        Paint.Style style2 = Paint.Style.STROKE;
        paint3.setStyle(style2);
        Paint paint4 = this.mStrokePaint;
        float f = gradientState.mStrokeWidth;
        paint4.setStrokeWidth(f);
        Paint paint5 = this.mStrokePaint;
        int n = gradientState.mStrokeColor;
        paint5.setColor(n);
        if (gradientState.mStrokeDashWidth == 0.0f) {
            return;
        }
        float f2 = gradientState.mStrokeDashWidth;
        float f3 = gradientState.mStrokeDashGap;
        float[] fArray = new float[]{f2, f3};
        DashPathEffect dashPathEffect = new DashPathEffect(fArray, 0.0f);
        PathEffect pathEffect = this.mStrokePaint.setPathEffect(dashPathEffect);
    }

    private int modulateAlpha(int n) {
        int n2 = this.mAlpha;
        int n3 = this.mAlpha >> 7;
        int n4 = n2 + n3;
        return n * n4 >> 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        if (!this.ensureValidRect()) {
            return;
        }
        int n = this.mFillPaint.getAlpha();
        int n2 = this.mStrokePaint != null ? this.mStrokePaint.getAlpha() : 0;
        GradientDrawable gradientDrawable = this;
        int n3 = n;
        int n4 = gradientDrawable.modulateAlpha(n3);
        GradientDrawable gradientDrawable2 = this;
        int n5 = n2;
        int n6 = gradientDrawable2.modulateAlpha(n5);
        boolean bl = n6 > 0 && this.mStrokePaint.getStrokeWidth() > 0.0f;
        boolean bl2 = n4 > 0;
        GradientState gradientState = this.mGradientState;
        boolean bl3 = bl && bl2 && gradientState.mShape != 2 && n6 < 255;
        if (bl3) {
            if (this.mLayerPaint == null) {
                Paint paint;
                this.mLayerPaint = paint = new Paint();
            }
            Paint paint = this.mLayerPaint;
            boolean bl4 = this.mDither;
            paint.setDither(bl4);
            Paint paint2 = this.mLayerPaint;
            int n7 = this.mAlpha;
            paint2.setAlpha(n7);
            Paint paint3 = this.mLayerPaint;
            ColorFilter colorFilter = this.mColorFilter;
            ColorFilter colorFilter2 = paint3.setColorFilter(colorFilter);
            float f = this.mStrokePaint.getStrokeWidth();
            float f2 = this.mRect.left - f;
            float f3 = this.mRect.top - f;
            float f4 = this.mRect.right + f;
            float f5 = this.mRect.bottom + f;
            Paint paint4 = this.mLayerPaint;
            int n8 = canvas.saveLayer(f2, f3, f4, f5, paint4, 4);
            ColorFilter colorFilter3 = this.mFillPaint.setColorFilter(null);
            ColorFilter colorFilter4 = this.mStrokePaint.setColorFilter(null);
        } else {
            this.mFillPaint.setAlpha(n4);
            Paint paint = this.mFillPaint;
            boolean bl5 = this.mDither;
            paint.setDither(bl5);
            Paint paint5 = this.mFillPaint;
            ColorFilter colorFilter = this.mColorFilter;
            ColorFilter colorFilter5 = paint5.setColorFilter(colorFilter);
            if (bl) {
                this.mStrokePaint.setAlpha(n6);
                Paint paint6 = this.mStrokePaint;
                boolean bl6 = this.mDither;
                paint6.setDither(bl6);
                Paint paint7 = this.mStrokePaint;
                ColorFilter colorFilter6 = this.mColorFilter;
                ColorFilter colorFilter7 = paint7.setColorFilter(colorFilter6);
            }
        }
        switch (gradientState.mShape) {
            case 0: {
                float f;
                if (gradientState.mRadiusArray != null) {
                    this.mPath.reset();
                    Path path = this.mPath;
                    RectF rectF = this.mRect;
                    float[] fArray = gradientState.mRadiusArray;
                    Path.Direction direction = Path.Direction.CW;
                    path.addRoundRect(rectF, fArray, direction);
                    Path path2 = this.mPath;
                    Paint paint = this.mFillPaint;
                    Canvas canvas2 = canvas;
                    Path path3 = path2;
                    Paint paint8 = paint;
                    canvas2.drawPath(path3, paint8);
                    if (!bl) break;
                    Path path4 = this.mPath;
                    Paint paint9 = this.mStrokePaint;
                    Canvas canvas3 = canvas;
                    Path path5 = path4;
                    Paint paint10 = paint9;
                    canvas3.drawPath(path5, paint10);
                    break;
                }
                float f6 = gradientState.mRadius;
                float f7 = this.mRect.width();
                float f8 = Math.min(f7, f = this.mRect.height()) * 0.5f;
                if (f6 > f8) {
                    float f9 = f8;
                }
                RectF rectF = this.mRect;
                Paint paint = this.mFillPaint;
                Canvas canvas4 = canvas;
                RectF rectF2 = rectF;
                float f10 = f6;
                float f11 = f6;
                Paint paint11 = paint;
                canvas4.drawRoundRect(rectF2, f10, f11, paint11);
                if (!bl) break;
                RectF rectF3 = this.mRect;
                Paint paint12 = this.mStrokePaint;
                Canvas canvas5 = canvas;
                RectF rectF4 = rectF3;
                float f12 = f6;
                float f13 = f6;
                Paint paint13 = paint12;
                canvas5.drawRoundRect(rectF4, f12, f13, paint13);
                break;
            }
            case 1: {
                RectF rectF = this.mRect;
                Paint paint = this.mFillPaint;
                Canvas canvas6 = canvas;
                RectF rectF5 = rectF;
                Paint paint14 = paint;
                canvas6.drawOval(rectF5, paint14);
                if (!bl) break;
                RectF rectF6 = this.mRect;
                Paint paint15 = this.mStrokePaint;
                Canvas canvas7 = canvas;
                RectF rectF7 = rectF6;
                Paint paint16 = paint15;
                canvas7.drawOval(rectF7, paint16);
                break;
            }
            case 2: {
                RectF rectF = this.mRect;
                float f = rectF.centerY();
                float f14 = rectF.left;
                float f15 = rectF.right;
                Paint paint = this.mStrokePaint;
                Canvas canvas8 = canvas;
                float f16 = f;
                canvas8.drawLine(f14, f, f15, f16, paint);
                break;
            }
            case 3: {
                GradientDrawable gradientDrawable3 = this;
                GradientState gradientState2 = gradientState;
                Path path = gradientDrawable3.buildRing(gradientState2);
                Paint paint = this.mFillPaint;
                Canvas canvas9 = canvas;
                Path path6 = path;
                Paint paint17 = paint;
                canvas9.drawPath(path6, paint17);
                if (!bl) break;
                Paint paint18 = this.mStrokePaint;
                Canvas canvas10 = canvas;
                Path path7 = path;
                Paint paint19 = paint18;
                canvas10.drawPath(path7, paint19);
            }
        }
        if (bl3) {
            canvas.restore();
            return;
        }
        Paint paint = this.mFillPaint;
        int n9 = n;
        paint.setAlpha(n9);
        if (!bl) {
            return;
        }
        Paint paint20 = this.mStrokePaint;
        int n10 = n2;
        paint20.setAlpha(n10);
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mGradientState.mChangingConfigurations;
        return n | n2;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        GradientState gradientState = this.mGradientState;
        gradientState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mGradientState;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mGradientState.mHeight;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mGradientState.mWidth;
    }

    @Override
    public int getOpacity() {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getPadding(Rect rect) {
        if (this.mPadding == null) return super.getPadding(rect);
        Rect rect2 = this.mPadding;
        rect.set(rect2);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        GradientState gradientState = this.mGradientState;
        int[] nArray = R.styleable.GradientDrawable;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray = resources2.obtainAttributes(attributeSet2, nArray2);
        GradientDrawable gradientDrawable = this;
        Resources resources3 = resources;
        XmlPullParser xmlPullParser2 = xmlPullParser;
        TypedArray typedArray2 = typedArray;
        int n2 = 0;
        super.inflateWithAttributes(resources3, xmlPullParser2, typedArray2, n2);
        TypedArray typedArray3 = typedArray;
        int n3 = 1;
        int n4 = 0;
        int n5 = n = typedArray3.getInt(n3, n4);
        int n6 = 3;
        if (n5 == n6) {
            int n7;
            int n8;
            int n9;
            TypedArray typedArray4;
            int n10;
            int n11;
            int n12;
            TypedArray typedArray5 = typedArray;
            int n13 = 5;
            int n14 = 65535;
            int n15 = typedArray5.getDimensionPixelSize(n13, n14);
            gradientState.mInnerRadius = n15;
            int n16 = gradientState.mInnerRadius;
            if (n16 == (n12 = 65535)) {
                float f;
                TypedArray typedArray6 = typedArray;
                int n17 = 2;
                float f2 = 3.0f;
                gradientState.mInnerRadiusRatio = f = typedArray6.getFloat(n17, f2);
            }
            if ((n11 = (gradientState.mThickness = (n10 = (typedArray4 = typedArray).getDimensionPixelSize(n9 = 6, n8 = 65535)))) == (n7 = 65535)) {
                float f;
                TypedArray typedArray7 = typedArray;
                int n18 = 3;
                float f3 = 9.0f;
                gradientState.mThicknessRatio = f = typedArray7.getFloat(n18, f3);
            }
            TypedArray typedArray8 = typedArray;
            int n19 = 4;
            boolean bl = true;
            boolean bl2 = typedArray8.getBoolean(n19, bl);
            GradientState gradientState2 = gradientState;
            boolean bl3 = bl2;
            boolean bl4 = GradientState.access$102(gradientState2, bl3);
        }
        typedArray.recycle();
        GradientDrawable gradientDrawable2 = this;
        int n20 = n;
        gradientDrawable2.setShape(n20);
        int n21 = xmlPullParser.getDepth() + 1;
        int n22;
        int n23;
        int n24;
        while ((n24 = (n23 = xmlPullParser.next())) != (n22 = 1)) {
            String string2;
            int n25;
            int n26;
            int n27;
            int n28;
            int n29;
            int n30 = xmlPullParser.getDepth();
            int n31 = n30;
            if (n31 < (n29 = n21) && (n28 = n23) == (n27 = 3)) {
                return;
            }
            int n32 = n23;
            int n33 = 2;
            if (n32 != n33 || (n26 = n30) > (n25 = n21)) continue;
            String string3 = xmlPullParser.getName();
            String string4 = string3;
            if (string4.equals(string2 = "size")) {
                TypedArray typedArray9;
                int[] nArray3 = R.styleable.GradientDrawableSize;
                Resources resources4 = resources;
                AttributeSet attributeSet3 = attributeSet;
                int[] nArray4 = nArray3;
                TypedArray typedArray10 = typedArray9 = resources4.obtainAttributes(attributeSet3, nArray4);
                int n34 = 1;
                int n35 = 65535;
                int n36 = typedArray10.getDimensionPixelSize(n34, n35);
                TypedArray typedArray11 = typedArray9;
                int n37 = 0;
                int n38 = 65535;
                int n39 = typedArray11.getDimensionPixelSize(n37, n38);
                typedArray9.recycle();
                GradientDrawable gradientDrawable3 = this;
                int n40 = n36;
                int n41 = n39;
                gradientDrawable3.setSize(n40, n41);
                continue;
            }
            String string5 = string3;
            String string6 = "gradient";
            if (string5.equals(string6)) {
                int n42;
                int[] nArray5 = R.styleable.GradientDrawableGradient;
                Resources resources5 = resources;
                AttributeSet attributeSet4 = attributeSet;
                int[] nArray6 = nArray5;
                TypedArray typedArray12 = typedArray = resources5.obtainAttributes(attributeSet4, nArray6);
                int n43 = 0;
                int n44 = 0;
                int n45 = typedArray12.getColor(n43, n44);
                TypedArray typedArray13 = typedArray;
                int n46 = 8;
                boolean bl = typedArray13.hasValue(n46);
                TypedArray typedArray14 = typedArray;
                int n47 = 8;
                int n48 = 0;
                int n49 = typedArray14.getColor(n47, n48);
                TypedArray typedArray15 = typedArray;
                int n50 = 1;
                int n51 = 0;
                int n52 = typedArray15.getColor(n50, n51);
                TypedArray typedArray16 = typedArray;
                int n53 = 4;
                int n54 = 0;
                int n55 = typedArray16.getInt(n53, n54);
                TypedArray typedArray17 = typedArray;
                int n56 = 5;
                float f = 0.5f;
                float f4 = GradientDrawable.getFloatOrFraction(typedArray17, n56, f);
                GradientState gradientState3 = gradientState;
                float f5 = f4;
                float f6 = GradientState.access$202(gradientState3, f5);
                TypedArray typedArray18 = typedArray;
                int n57 = 6;
                float f7 = 0.5f;
                float f8 = GradientDrawable.getFloatOrFraction(typedArray18, n57, f7);
                GradientState gradientState4 = gradientState;
                float f9 = f8;
                float f10 = GradientState.access$302(gradientState4, f9);
                TypedArray typedArray19 = typedArray;
                int n58 = 2;
                boolean bl5 = false;
                boolean bl6 = typedArray19.getBoolean(n58, bl5);
                GradientState gradientState5 = gradientState;
                boolean bl7 = bl6;
                boolean bl8 = GradientState.access$002(gradientState5, bl7);
                gradientState.mGradient = n42 = n55;
                if (n55 == 0) {
                    TypedArray typedArray20 = typedArray;
                    int n59 = 3;
                    float f11 = 0.0f;
                    int n60 = (int)typedArray20.getFloat(n59, f11) % 360;
                    if (n60 % 45 != 0) {
                        StringBuilder stringBuilder = new StringBuilder();
                        String string7 = typedArray.getPositionDescription();
                        String string8 = stringBuilder.append(string7).append("<gradient> tag requires 'angle' attribute to ").append("be a multiple of 45").toString();
                        throw new XmlPullParserException(string8);
                    }
                    switch (n60) {
                        case 0: {
                            Orientation orientation;
                            gradientState.mOrientation = orientation = Orientation.LEFT_RIGHT;
                            break;
                        }
                        case 45: {
                            Orientation orientation;
                            gradientState.mOrientation = orientation = Orientation.BL_TR;
                            break;
                        }
                        case 90: {
                            Orientation orientation;
                            gradientState.mOrientation = orientation = Orientation.BOTTOM_TOP;
                            break;
                        }
                        case 135: {
                            Orientation orientation;
                            gradientState.mOrientation = orientation = Orientation.BR_TL;
                            break;
                        }
                        case 180: {
                            Orientation orientation;
                            gradientState.mOrientation = orientation = Orientation.RIGHT_LEFT;
                            break;
                        }
                        case 225: {
                            Orientation orientation;
                            gradientState.mOrientation = orientation = Orientation.TR_BL;
                            break;
                        }
                        case 270: {
                            Orientation orientation;
                            gradientState.mOrientation = orientation = Orientation.TOP_BOTTOM;
                            break;
                        }
                        case 315: {
                            Orientation orientation;
                            gradientState.mOrientation = orientation = Orientation.TL_BR;
                            break;
                        }
                    }
                } else {
                    TypedArray typedArray21 = typedArray;
                    int n61 = 7;
                    TypedValue typedValue = typedArray21.peekValue(n61);
                    if (typedValue != null) {
                        float f12;
                        int n62 = typedValue.type;
                        int n63 = 6;
                        boolean bl9 = n62 == n63;
                        if (bl9) {
                            TypedValue typedValue2 = typedValue;
                            float f13 = 1.0f;
                            float f14 = 1.0f;
                            f12 = typedValue2.getFraction(f13, f14);
                        } else {
                            f12 = typedValue.getFloat();
                        }
                        GradientState gradientState6 = gradientState;
                        float f15 = f12;
                        float f16 = GradientState.access$402(gradientState6, f15);
                    } else {
                        int n64 = n55;
                        int n65 = 1;
                        if (n64 == n65) {
                            StringBuilder stringBuilder = new StringBuilder();
                            String string9 = typedArray.getPositionDescription();
                            String string10 = stringBuilder.append(string9).append("<gradient> tag requires 'gradientRadius' ").append("attribute with radial type").toString();
                            throw new XmlPullParserException(string10);
                        }
                    }
                }
                typedArray.recycle();
                if (bl) {
                    int[] nArray7 = new int[3];
                    gradientState.mColors = nArray7;
                    gradientState.mColors[0] = n45;
                    gradientState.mColors[1] = n49;
                    gradientState.mColors[2] = n52;
                    float[] fArray = new float[3];
                    gradientState.mPositions = fArray;
                    gradientState.mPositions[0] = 0.0f;
                    float[] fArray2 = gradientState.mPositions;
                    int n66 = 1;
                    float f17 = gradientState.mCenterX != 0.5f ? gradientState.mCenterX : gradientState.mCenterY;
                    fArray2[n66] = f17;
                    gradientState.mPositions[2] = 1065353216;
                    continue;
                }
                int[] nArray8 = new int[2];
                gradientState.mColors = nArray8;
                gradientState.mColors[0] = n45;
                gradientState.mColors[1] = n52;
                continue;
            }
            String string11 = string3;
            String string12 = "solid";
            if (string11.equals(string12)) {
                TypedArray typedArray22;
                int[] nArray9 = R.styleable.GradientDrawableSolid;
                Resources resources6 = resources;
                AttributeSet attributeSet5 = attributeSet;
                int[] nArray10 = nArray9;
                TypedArray typedArray23 = typedArray22 = resources6.obtainAttributes(attributeSet5, nArray10);
                int n67 = 0;
                int n68 = 0;
                int n69 = typedArray23.getColor(n67, n68);
                typedArray22.recycle();
                GradientDrawable gradientDrawable4 = this;
                int n70 = n69;
                gradientDrawable4.setColor(n70);
                continue;
            }
            String string13 = string3;
            String string14 = "stroke";
            if (string13.equals(string14)) {
                int[] nArray11 = R.styleable.GradientDrawableStroke;
                Resources resources7 = resources;
                AttributeSet attributeSet6 = attributeSet;
                int[] nArray12 = nArray11;
                TypedArray typedArray24 = typedArray = resources7.obtainAttributes(attributeSet6, nArray12);
                int n71 = 0;
                int n72 = 0;
                int n73 = typedArray24.getDimensionPixelSize(n71, n72);
                TypedArray typedArray25 = typedArray;
                int n74 = 1;
                int n75 = 0;
                int n76 = typedArray25.getColor(n74, n75);
                TypedArray typedArray26 = typedArray;
                int n77 = 2;
                float f = 0.0f;
                float f18 = typedArray26.getDimension(n77, f);
                if (f18 != 0.0f) {
                    TypedArray typedArray27 = typedArray;
                    int n78 = 3;
                    float f19 = 0.0f;
                    float f20 = typedArray27.getDimension(n78, f19);
                    GradientDrawable gradientDrawable5 = this;
                    int n79 = n73;
                    int n80 = n76;
                    float f21 = f18;
                    float f22 = f20;
                    gradientDrawable5.setStroke(n79, n80, f21, f22);
                } else {
                    GradientDrawable gradientDrawable6 = this;
                    int n81 = n73;
                    int n82 = n76;
                    gradientDrawable6.setStroke(n81, n82);
                }
                typedArray.recycle();
                continue;
            }
            String string15 = string3;
            String string16 = "corners";
            if (string15.equals(string16)) {
                int n83;
                int n84;
                int n85;
                int n86;
                int n87;
                int n88;
                int[] nArray13 = R.styleable.DrawableCorners;
                Resources resources8 = resources;
                AttributeSet attributeSet7 = attributeSet;
                int[] nArray14 = nArray13;
                TypedArray typedArray28 = typedArray = resources8.obtainAttributes(attributeSet7, nArray14);
                int n89 = 0;
                int n90 = 0;
                int n91 = typedArray28.getDimensionPixelSize(n89, n90);
                float f = n91;
                GradientDrawable gradientDrawable7 = this;
                float f23 = f;
                gradientDrawable7.setCornerRadius(f23);
                TypedArray typedArray29 = typedArray;
                int n92 = 1;
                int n93 = n91;
                int n94 = typedArray29.getDimensionPixelSize(n92, n93);
                TypedArray typedArray30 = typedArray;
                int n95 = 2;
                int n96 = n91;
                int n97 = typedArray30.getDimensionPixelSize(n95, n96);
                TypedArray typedArray31 = typedArray;
                int n98 = 3;
                int n99 = n91;
                int n100 = typedArray31.getDimensionPixelSize(n98, n99);
                TypedArray typedArray32 = typedArray;
                int n101 = 4;
                int n102 = n91;
                int n103 = typedArray32.getDimensionPixelSize(n101, n102);
                int n104 = n94;
                int n105 = n91;
                if (n104 == n105 || (n88 = n97) == (n87 = n91) || (n86 = n100) == (n85 = n91) || (n84 = n103) != (n83 = n91)) {
                    float f24 = n94;
                    float f25 = n94;
                    float f26 = n97;
                    float f27 = n97;
                    float f28 = n100;
                    float f29 = n100;
                    float f30 = n103;
                    float f31 = n103;
                    float[] fArray = new float[]{f24, f25, f26, f27, f28, f29, f30, f31};
                    GradientDrawable gradientDrawable8 = this;
                    float[] fArray3 = fArray;
                    gradientDrawable8.setCornerRadii(fArray3);
                }
                typedArray.recycle();
                continue;
            }
            String string17 = string3;
            String string18 = "padding";
            if (string17.equals(string18)) {
                Rect rect;
                Rect rect2;
                TypedArray typedArray33;
                int[] nArray15 = R.styleable.GradientDrawablePadding;
                Resources resources9 = resources;
                AttributeSet attributeSet8 = attributeSet;
                int[] nArray16 = nArray15;
                TypedArray typedArray34 = typedArray33 = resources9.obtainAttributes(attributeSet8, nArray16);
                int n106 = 0;
                int n107 = 0;
                int n108 = typedArray34.getDimensionPixelOffset(n106, n107);
                TypedArray typedArray35 = typedArray33;
                int n109 = 1;
                int n110 = 0;
                int n111 = typedArray35.getDimensionPixelOffset(n109, n110);
                TypedArray typedArray36 = typedArray33;
                int n112 = 2;
                int n113 = 0;
                int n114 = typedArray36.getDimensionPixelOffset(n112, n113);
                TypedArray typedArray37 = typedArray33;
                int n115 = 3;
                int n116 = 0;
                int n117 = typedArray37.getDimensionPixelOffset(n115, n116);
                this.mPadding = rect2 = new Rect(n108, n111, n114, n117);
                typedArray33.recycle();
                GradientState gradientState7 = this.mGradientState;
                gradientState7.mPadding = rect = this.mPadding;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Bad element under <shape>: ");
            String string19 = string3;
            String string20 = stringBuilder.append(string19).toString();
            int n118 = Log.w("drawable", string20);
        }
        return;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            GradientState gradientState;
            GradientState gradientState2 = this.mGradientState;
            GradientState gradientState3 = this.mGradientState = (gradientState = new GradientState(gradientState2));
            this.initializeWithState(gradientState3);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mRectIsDirty = true;
    }

    @Override
    protected boolean onLevelChange(int n) {
        boolean bl = super.onLevelChange(n);
        this.mRectIsDirty = true;
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return true;
    }

    @Override
    public void setAlpha(int n) {
        this.mAlpha = n;
    }

    public void setColor(int n) {
        this.mGradientState.setSolidColor(n);
        this.mFillPaint.setColor(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
    }

    public void setCornerRadii(float[] fArray) {
        this.mGradientState.setCornerRadii(fArray);
    }

    public void setCornerRadius(float f) {
        this.mGradientState.setCornerRadius(f);
    }

    @Override
    public void setDither(boolean bl) {
        this.mDither = bl;
    }

    public void setGradientCenter(float f, float f2) {
        this.mGradientState.setGradientCenter(f, f2);
    }

    public void setGradientRadius(float f) {
        this.mGradientState.setGradientRadius(f);
    }

    public void setGradientType(int n) {
        this.mGradientState.setGradientType(n);
        this.mRectIsDirty = true;
    }

    public void setShape(int n) {
        this.mRingPath = null;
        this.mGradientState.setShape(n);
    }

    public void setSize(int n, int n2) {
        this.mGradientState.setSize(n, n2);
    }

    public void setStroke(int n, int n2) {
        this.setStroke(n, n2, 0.0f, 0.0f);
    }

    public void setStroke(int n, int n2, float f, float f2) {
        this.mGradientState.setStroke(n, n2, f, f2);
        if (this.mStrokePaint == null) {
            Paint paint;
            Paint paint2 = this.mStrokePaint = (paint = new Paint(1));
            Paint.Style style2 = Paint.Style.STROKE;
            paint2.setStyle(style2);
        }
        Paint paint = this.mStrokePaint;
        float f3 = n;
        paint.setStrokeWidth(f3);
        this.mStrokePaint.setColor(n2);
        DashPathEffect dashPathEffect = null;
        if (f > 0.0f) {
            float[] fArray = new float[]{f, f2};
            dashPathEffect = new DashPathEffect(fArray, 0.0f);
        }
        PathEffect pathEffect = this.mStrokePaint.setPathEffect(dashPathEffect);
    }

    public void setUseLevel(boolean bl) {
        boolean bl2 = GradientState.access$002(this.mGradientState, bl);
    }

    static final class GradientState
    extends Drawable.ConstantState {
        private float mCenterX = 0.5f;
        private float mCenterY = 0.5f;
        public int mChangingConfigurations;
        public int[] mColors;
        public int mGradient = 0;
        private float mGradientRadius = 0.5f;
        public boolean mHasSolidColor;
        public int mHeight = -1;
        public int mInnerRadius;
        public float mInnerRadiusRatio;
        public Orientation mOrientation;
        public Rect mPadding;
        public float[] mPositions;
        public float mRadius;
        public float[] mRadiusArray;
        public int mShape = 0;
        public int mSolidColor;
        public int mStrokeColor;
        public float mStrokeDashGap;
        public float mStrokeDashWidth;
        public int mStrokeWidth = -1;
        public int[] mTempColors;
        public float[] mTempPositions;
        public int mThickness;
        public float mThicknessRatio;
        private boolean mUseLevel;
        private boolean mUseLevelForShape;
        public int mWidth = -1;

        GradientState() {
            Orientation orientation;
            this.mOrientation = orientation = Orientation.TOP_BOTTOM;
        }

        public GradientState(GradientState gradientState) {
            boolean bl;
            boolean bl2;
            float f;
            float f2;
            float f3;
            int n;
            int n2;
            float f4;
            float f5;
            int n3;
            int n4;
            float f6;
            float f7;
            float f8;
            int n5;
            int n6;
            boolean bl3;
            Orientation orientation;
            int n7;
            int n8;
            int n9;
            this.mChangingConfigurations = n9 = gradientState.mChangingConfigurations;
            this.mShape = n8 = gradientState.mShape;
            this.mGradient = n7 = gradientState.mGradient;
            this.mOrientation = orientation = gradientState.mOrientation;
            if (gradientState.mColors != null) {
                int[] nArray = (int[])gradientState.mColors.clone();
                this.mColors = nArray;
            }
            if (gradientState.mPositions != null) {
                float[] fArray = (float[])gradientState.mPositions.clone();
                this.mPositions = fArray;
            }
            this.mHasSolidColor = bl3 = gradientState.mHasSolidColor;
            this.mStrokeWidth = n6 = gradientState.mStrokeWidth;
            this.mStrokeColor = n5 = gradientState.mStrokeColor;
            this.mStrokeDashWidth = f8 = gradientState.mStrokeDashWidth;
            this.mStrokeDashGap = f7 = gradientState.mStrokeDashGap;
            this.mRadius = f6 = gradientState.mRadius;
            if (gradientState.mRadiusArray != null) {
                float[] fArray = (float[])gradientState.mRadiusArray.clone();
                this.mRadiusArray = fArray;
            }
            if (gradientState.mPadding != null) {
                Rect rect;
                Rect rect2 = gradientState.mPadding;
                this.mPadding = rect = new Rect(rect2);
            }
            this.mWidth = n4 = gradientState.mWidth;
            this.mHeight = n3 = gradientState.mHeight;
            this.mInnerRadiusRatio = f5 = gradientState.mInnerRadiusRatio;
            this.mThicknessRatio = f4 = gradientState.mThicknessRatio;
            this.mInnerRadius = n2 = gradientState.mInnerRadius;
            this.mThickness = n = gradientState.mThickness;
            this.mCenterX = f3 = gradientState.mCenterX;
            this.mCenterY = f2 = gradientState.mCenterY;
            this.mGradientRadius = f = gradientState.mGradientRadius;
            this.mUseLevel = bl2 = gradientState.mUseLevel;
            this.mUseLevelForShape = bl = gradientState.mUseLevelForShape;
        }

        GradientState(Orientation orientation, int[] nArray) {
            this.mOrientation = orientation;
            this.mColors = nArray;
        }

        static /* synthetic */ boolean access$002(GradientState gradientState, boolean bl) {
            gradientState.mUseLevel = bl;
            return bl;
        }

        static /* synthetic */ boolean access$102(GradientState gradientState, boolean bl) {
            gradientState.mUseLevelForShape = bl;
            return bl;
        }

        static /* synthetic */ float access$202(GradientState gradientState, float f) {
            gradientState.mCenterX = f;
            return f;
        }

        static /* synthetic */ float access$302(GradientState gradientState, float f) {
            gradientState.mCenterY = f;
            return f;
        }

        static /* synthetic */ float access$402(GradientState gradientState, float f) {
            gradientState.mGradientRadius = f;
            return f;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new GradientDrawable(this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new GradientDrawable(this);
        }

        public void setCornerRadii(float[] fArray) {
            this.mRadiusArray = fArray;
            if (fArray != null) {
                return;
            }
            this.mRadius = 0.0f;
        }

        public void setCornerRadius(float f) {
            if (f < 0.0f) {
                f = 0.0f;
            }
            this.mRadius = f;
            this.mRadiusArray = null;
        }

        public void setGradientCenter(float f, float f2) {
            this.mCenterX = f;
            this.mCenterY = f2;
        }

        public void setGradientRadius(float f) {
            this.mGradientRadius = f;
        }

        public void setGradientType(int n) {
            this.mGradient = n;
        }

        public void setShape(int n) {
            this.mShape = n;
        }

        public void setSize(int n, int n2) {
            this.mWidth = n;
            this.mHeight = n2;
        }

        public void setSolidColor(int n) {
            this.mHasSolidColor = true;
            this.mSolidColor = n;
            this.mColors = null;
        }

        public void setStroke(int n, int n2) {
            this.mStrokeWidth = n;
            this.mStrokeColor = n2;
        }

        public void setStroke(int n, int n2, float f, float f2) {
            this.mStrokeWidth = n;
            this.mStrokeColor = n2;
            this.mStrokeDashWidth = f;
            this.mStrokeDashGap = f2;
        }
    }

    public static final class Orientation
    extends Enum<Orientation> {
        private static final /* synthetic */ Orientation[] $VALUES;
        public static final /* enum */ Orientation BL_TR;
        public static final /* enum */ Orientation BOTTOM_TOP;
        public static final /* enum */ Orientation BR_TL;
        public static final /* enum */ Orientation LEFT_RIGHT;
        public static final /* enum */ Orientation RIGHT_LEFT;
        public static final /* enum */ Orientation TL_BR;
        public static final /* enum */ Orientation TOP_BOTTOM;
        public static final /* enum */ Orientation TR_BL;

        static {
            TOP_BOTTOM = new Orientation();
            TR_BL = new Orientation();
            RIGHT_LEFT = new Orientation();
            BR_TL = new Orientation();
            BOTTOM_TOP = new Orientation();
            BL_TR = new Orientation();
            LEFT_RIGHT = new Orientation();
            TL_BR = new Orientation();
            Orientation orientation = TOP_BOTTOM;
            Orientation orientation2 = TR_BL;
            Orientation orientation3 = RIGHT_LEFT;
            Orientation orientation4 = BR_TL;
            Orientation orientation5 = BOTTOM_TOP;
            Orientation orientation6 = BL_TR;
            Orientation orientation7 = LEFT_RIGHT;
            Orientation orientation8 = TL_BR;
            Orientation[] orientationArray = new Orientation[]{orientation, orientation2, orientation3, orientation4, orientation5, orientation6, orientation7, orientation8};
            $VALUES = orientationArray;
        }

        public static Orientation valueOf(String string2) {
            return Enum.valueOf(Orientation.class, string2);
        }

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }
    }
}

