/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InsetDrawable
extends Drawable
implements Drawable.Callback {
    private InsetState mInsetState;
    private boolean mMutated;
    private final Rect mTmpRect;

    InsetDrawable() {
        this(null, null);
    }

    public InsetDrawable(Drawable drawable2, int n) {
        InsetDrawable insetDrawable = this;
        Drawable drawable3 = drawable2;
        int n2 = n;
        int n3 = n;
        int n4 = n;
        int n5 = n;
        insetDrawable(drawable3, n2, n3, n4, n5);
    }

    public InsetDrawable(Drawable drawable2, int n, int n2, int n3, int n4) {
        this(null, null);
        this.mInsetState.mDrawable = drawable2;
        this.mInsetState.mInsetLeft = n;
        this.mInsetState.mInsetTop = n2;
        this.mInsetState.mInsetRight = n3;
        this.mInsetState.mInsetBottom = n4;
        if (drawable2 == null) {
            return;
        }
        drawable2.setCallback(this);
    }

    private InsetDrawable(InsetState insetState, Resources resources) {
        InsetState insetState2;
        Rect rect;
        this.mTmpRect = rect = new Rect();
        this.mInsetState = insetState2 = new InsetState(insetState, this, resources);
    }

    @Override
    public void draw(Canvas canvas) {
        this.mInsetState.mDrawable.draw(canvas);
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mInsetState.mChangingConfigurations;
        int n3 = n | n2;
        int n4 = this.mInsetState.mDrawable.getChangingConfigurations();
        return n3 | n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        if (!this.mInsetState.canConstantState()) return null;
        InsetState insetState = this.mInsetState;
        insetState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mInsetState;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mInsetState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mInsetState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mInsetState.mDrawable.getOpacity();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getPadding(Rect rect) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = this.mInsetState.mDrawable.getPadding(rect);
        int n5 = rect.left;
        int n6 = this.mInsetState.mInsetLeft;
        rect.left = n4 = n5 + n6;
        int n7 = rect.right;
        int n8 = this.mInsetState.mInsetRight;
        rect.right = n3 = n7 + n8;
        int n9 = rect.top;
        int n10 = this.mInsetState.mInsetTop;
        rect.top = n2 = n9 + n10;
        int n11 = rect.bottom;
        int n12 = this.mInsetState.mInsetBottom;
        rect.bottom = n = n11 + n12;
        if (bl) return true;
        int n13 = this.mInsetState.mInsetLeft;
        int n14 = this.mInsetState.mInsetRight;
        int n15 = n13 | n14;
        int n16 = this.mInsetState.mInsetTop;
        int n17 = n15 | n16;
        int n18 = this.mInsetState.mInsetBottom;
        if ((n17 | n18) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        Drawable drawable2;
        int[] nArray = R.styleable.InsetDrawable;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        super.inflateWithAttributes(resources, xmlPullParser, typedArray, 0);
        int n = typedArray.getResourceId(1, 0);
        int n2 = typedArray.getDimensionPixelOffset(2, 0);
        int n3 = typedArray.getDimensionPixelOffset(4, 0);
        int n4 = typedArray.getDimensionPixelOffset(3, 0);
        int n5 = typedArray.getDimensionPixelOffset(5, 0);
        typedArray.recycle();
        if (n != 0) {
            drawable2 = resources.getDrawable(n);
        } else {
            int n6;
            while ((n6 = xmlPullParser.next()) == 4) {
            }
            if (n6 != 2) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = xmlPullParser.getPositionDescription();
                String string3 = stringBuilder.append(string2).append(": <inset> tag requires a 'drawable' attribute or ").append("child tag defining a drawable").toString();
                throw new XmlPullParserException(string3);
            }
            drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet);
        }
        if (drawable2 == null) {
            int n7 = Log.w("drawable", "No drawable specified for <inset>");
        }
        this.mInsetState.mDrawable = drawable2;
        this.mInsetState.mInsetLeft = n2;
        this.mInsetState.mInsetRight = n4;
        this.mInsetState.mInsetTop = n3;
        this.mInsetState.mInsetBottom = n5;
        if (drawable2 == null) {
            return;
        }
        drawable2.setCallback(this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.invalidateDrawable(this);
    }

    @Override
    public boolean isStateful() {
        return this.mInsetState.mDrawable.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            Drawable drawable2 = this.mInsetState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        int n;
        int n2;
        int n3;
        int n4;
        Rect rect2 = this.mTmpRect;
        rect2.set(rect);
        int n5 = rect2.left;
        int n6 = this.mInsetState.mInsetLeft;
        rect2.left = n4 = n5 + n6;
        int n7 = rect2.top;
        int n8 = this.mInsetState.mInsetTop;
        rect2.top = n3 = n7 + n8;
        int n9 = rect2.right;
        int n10 = this.mInsetState.mInsetRight;
        rect2.right = n2 = n9 - n10;
        int n11 = rect2.bottom;
        int n12 = this.mInsetState.mInsetBottom;
        rect2.bottom = n = n11 - n12;
        Drawable drawable2 = this.mInsetState.mDrawable;
        int n13 = rect2.left;
        int n14 = rect2.top;
        int n15 = rect2.right;
        int n16 = rect2.bottom;
        drawable2.setBounds(n13, n14, n15, n16);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        boolean bl = this.mInsetState.mDrawable.setState(nArray);
        Rect rect = this.getBounds();
        this.onBoundsChange(rect);
        return bl;
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.scheduleDrawable(this, runnable, l);
    }

    @Override
    public void setAlpha(int n) {
        this.mInsetState.mDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mInsetState.mDrawable.setColorFilter(colorFilter);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = this.mInsetState.mDrawable.setVisible(bl, bl2);
        return super.setVisible(bl, bl2);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.unscheduleDrawable(this, runnable);
    }

    static final class InsetState
    extends Drawable.ConstantState {
        boolean mCanConstantState;
        int mChangingConfigurations;
        boolean mCheckedConstantState;
        Drawable mDrawable;
        int mInsetBottom;
        int mInsetLeft;
        int mInsetRight;
        int mInsetTop;

        /*
         * Enabled aggressive block sorting
         */
        InsetState(InsetState insetState, InsetDrawable insetDrawable, Resources resources) {
            int n;
            int n2;
            int n3;
            int n4;
            Drawable drawable2;
            Drawable drawable3;
            if (insetState == null) {
                return;
            }
            this.mDrawable = resources != null ? (drawable3 = insetState.mDrawable.getConstantState().newDrawable(resources)) : (drawable2 = insetState.mDrawable.getConstantState().newDrawable());
            this.mDrawable.setCallback(insetDrawable);
            this.mInsetLeft = n4 = insetState.mInsetLeft;
            this.mInsetTop = n3 = insetState.mInsetTop;
            this.mInsetRight = n2 = insetState.mInsetRight;
            this.mInsetBottom = n = insetState.mInsetBottom;
            this.mCanConstantState = true;
            this.mCheckedConstantState = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                boolean bl = this.mDrawable.getConstantState() != null;
                this.mCanConstantState = bl;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new InsetDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new InsetDrawable(this, resources);
        }
    }
}

