/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayerDrawable
extends Drawable
implements Drawable.Callback {
    LayerState mLayerState;
    private boolean mMutated;
    private int[] mPaddingB;
    private int[] mPaddingL;
    private int[] mPaddingR;
    private int[] mPaddingT;
    private final Rect mTmpRect;

    LayerDrawable() {
        LayerState layerState = null;
        this(layerState, null);
    }

    LayerDrawable(LayerState layerState, Resources resources) {
        LayerState layerState2;
        Rect rect;
        this.mTmpRect = rect = new Rect();
        this.mLayerState = layerState2 = this.createConstantState(layerState, resources);
        if (layerState2.mNum <= 0) {
            return;
        }
        this.ensurePadding();
    }

    public LayerDrawable(Drawable[] drawableArray) {
        this(drawableArray, null);
    }

    LayerDrawable(Drawable[] drawableArray, LayerState layerState) {
        this(layerState, null);
        int n = drawableArray.length;
        ChildDrawable[] childDrawableArray = new ChildDrawable[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            Drawable drawable2;
            ChildDrawable childDrawable;
            childDrawableArray[i] = childDrawable = new ChildDrawable();
            ChildDrawable childDrawable2 = childDrawableArray[i];
            childDrawable2.mDrawable = drawable2 = drawableArray[i];
            drawableArray[i].setCallback(this);
            LayerState layerState2 = this.mLayerState;
            int n3 = layerState2.mChildrenChangingConfigurations;
            int n4 = drawableArray[i].getChangingConfigurations();
            layerState2.mChildrenChangingConfigurations = n2 = n3 | n4;
        }
        this.mLayerState.mNum = n;
        this.mLayerState.mChildren = childDrawableArray;
        this.ensurePadding();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addLayer(Drawable drawable2, int n, int n2, int n3, int n4, int n5) {
        int n6;
        ChildDrawable childDrawable;
        int n7;
        LayerState layerState = this.mLayerState;
        int n8 = layerState.mNum;
        int n9 = layerState.mChildren != null ? layerState.mChildren.length : 0;
        if (n8 >= n9) {
            ChildDrawable[] childDrawableArray = new ChildDrawable[n9 + 10];
            if (n8 > 0) {
                System.arraycopy(layerState.mChildren, 0, childDrawableArray, 0, n8);
            }
            layerState.mChildren = childDrawableArray;
        }
        LayerState layerState2 = this.mLayerState;
        int n10 = layerState2.mChildrenChangingConfigurations;
        int n11 = drawable2.getChangingConfigurations();
        layerState2.mChildrenChangingConfigurations = n7 = n10 | n11;
        layerState.mChildren[n8] = childDrawable = new ChildDrawable();
        childDrawable.mId = n;
        childDrawable.mDrawable = drawable2;
        childDrawable.mInsetL = n2;
        childDrawable.mInsetT = n3;
        childDrawable.mInsetR = n4;
        childDrawable.mInsetB = n5;
        layerState.mNum = n6 = layerState.mNum + 1;
        drawable2.setCallback(this);
    }

    private void ensurePadding() {
        int n = this.mLayerState.mNum;
        if (this.mPaddingL != null && this.mPaddingL.length >= n) {
            return;
        }
        int[] nArray = new int[n];
        this.mPaddingL = nArray;
        int[] nArray2 = new int[n];
        this.mPaddingT = nArray2;
        int[] nArray3 = new int[n];
        this.mPaddingR = nArray3;
        int[] nArray4 = new int[n];
        this.mPaddingB = nArray4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean reapplyPadding(int n, ChildDrawable childDrawable) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Rect rect = this.mTmpRect;
        boolean bl = childDrawable.mDrawable.getPadding(rect);
        int n10 = rect.left;
        int n11 = this.mPaddingL[n];
        if (n10 != n11 && (n9 = rect.top) != (n8 = this.mPaddingT[n]) && (n7 = rect.right) != (n6 = this.mPaddingR[n])) {
            int n12 = rect.bottom;
            int n13 = this.mPaddingB[n];
            if (n12 == n13) return false;
        }
        int[] nArray = this.mPaddingL;
        nArray[n] = n5 = rect.left;
        int[] nArray2 = this.mPaddingT;
        nArray2[n] = n4 = rect.top;
        int[] nArray3 = this.mPaddingR;
        nArray3[n] = n3 = rect.right;
        int[] nArray4 = this.mPaddingB;
        nArray4[n] = n2 = rect.bottom;
        return true;
    }

    LayerState createConstantState(LayerState layerState, Resources resources) {
        return new LayerState(layerState, this, resources);
    }

    @Override
    public void draw(Canvas canvas) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        int n2 = 0;
        while (n2 < n) {
            childDrawableArray[n2].mDrawable.draw(canvas);
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable findDrawableByLayerId(int n) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n2 = this.mLayerState.mNum - 1;
        while (n2 >= 0) {
            if (childDrawableArray[n2].mId != n) {
                return childDrawableArray[n2].mDrawable;
            }
            n2 += -1;
        }
        return null;
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mLayerState.mChangingConfigurations;
        int n3 = n | n2;
        int n4 = this.mLayerState.mChildrenChangingConfigurations;
        return n3 | n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        if (!this.mLayerState.canConstantState()) return null;
        LayerState layerState = this.mLayerState;
        layerState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mLayerState;
    }

    public Drawable getDrawable(int n) {
        return this.mLayerState.mChildren[n].mDrawable;
    }

    public int getId(int n) {
        return this.mLayerState.mChildren[n].mId;
    }

    @Override
    public int getIntrinsicHeight() {
        int n = -1;
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n2 = this.mLayerState.mNum;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6;
            ChildDrawable childDrawable = childDrawableArray[i];
            int n7 = childDrawable.mDrawable.getIntrinsicHeight();
            int n8 = n7 + (n6 = childDrawable.mInsetT);
            int n9 = n8 + (n5 = childDrawable.mInsetB) + n3 + n4;
            if (n9 > n) {
                n = n9;
            }
            int n10 = this.mPaddingT[i];
            n3 += n10;
            int n11 = this.mPaddingB[i];
            n4 += n11;
        }
        return n;
    }

    @Override
    public int getIntrinsicWidth() {
        int n = -1;
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n2 = this.mLayerState.mNum;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6;
            ChildDrawable childDrawable = childDrawableArray[i];
            int n7 = childDrawable.mDrawable.getIntrinsicWidth();
            int n8 = n7 + (n6 = childDrawable.mInsetL);
            int n9 = n8 + (n5 = childDrawable.mInsetR) + n3 + n4;
            if (n9 > n) {
                n = n9;
            }
            int n10 = this.mPaddingL[i];
            n3 += n10;
            int n11 = this.mPaddingR[i];
            n4 += n11;
        }
        return n;
    }

    public int getNumberOfLayers() {
        return this.mLayerState.mNum;
    }

    @Override
    public int getOpacity() {
        return this.mLayerState.getOpacity();
    }

    @Override
    public boolean getPadding(Rect rect) {
        rect.left = 0;
        rect.top = 0;
        rect.right = 0;
        rect.bottom = 0;
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            int n5;
            ChildDrawable childDrawable = childDrawableArray[i];
            boolean bl = this.reapplyPadding(i, childDrawable);
            int n6 = rect.left;
            int n7 = this.mPaddingL[i];
            rect.left = n5 = n6 + n7;
            int n8 = rect.top;
            int n9 = this.mPaddingT[i];
            rect.top = n4 = n8 + n9;
            int n10 = rect.right;
            int n11 = this.mPaddingR[i];
            rect.right = n3 = n10 + n11;
            int n12 = rect.bottom;
            int n13 = this.mPaddingB[i];
            rect.bottom = n2 = n12 + n13;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        int n2;
        super.inflate(resources, xmlPullParser, attributeSet);
        int n3 = xmlPullParser.getDepth() + 1;
        while ((n2 = xmlPullParser.next()) != 1 && ((n = xmlPullParser.getDepth()) >= n3 || n2 != 3)) {
            Drawable drawable2;
            if (n2 != 2 || n > n3 || !xmlPullParser.getName().equals("item")) continue;
            int[] nArray = R.styleable.LayerDrawableItem;
            TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
            int n4 = typedArray.getDimensionPixelOffset(2, 0);
            int n5 = typedArray.getDimensionPixelOffset(3, 0);
            int n6 = typedArray.getDimensionPixelOffset(4, 0);
            int n7 = typedArray.getDimensionPixelOffset(5, 0);
            int n8 = typedArray.getResourceId(1, 0);
            int n9 = typedArray.getResourceId(0, -1);
            typedArray.recycle();
            if (n8 != 0) {
                drawable2 = resources.getDrawable(n8);
            } else {
                while ((n2 = xmlPullParser.next()) == 4) {
                }
                if (n2 != 2) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = xmlPullParser.getPositionDescription();
                    String string3 = stringBuilder.append(string2).append(": <item> tag requires a 'drawable' attribute or ").append("child tag defining a drawable").toString();
                    throw new XmlPullParserException(string3);
                }
                drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet);
            }
            this.addLayer(drawable2, n9, n4, n5, n6, n7);
        }
        this.ensurePadding();
        int[] nArray = this.getState();
        boolean bl = this.onStateChange(nArray);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.invalidateDrawable(this);
    }

    @Override
    public boolean isStateful() {
        return this.mLayerState.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
            int n = this.mLayerState.mNum;
            for (int i = 0; i < n; ++i) {
                Drawable drawable2 = childDrawableArray[i].mDrawable.mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            ChildDrawable childDrawable = childDrawableArray[n6];
            Drawable drawable2 = childDrawable.mDrawable;
            int n7 = rect.left;
            int n8 = childDrawable.mInsetL;
            int n9 = n7 + n8 + n2;
            int n10 = rect.top;
            int n11 = childDrawable.mInsetT;
            int n12 = n10 + n11 + n3;
            int n13 = rect.right;
            int n14 = childDrawable.mInsetR;
            int n15 = n13 - n14 - n4;
            int n16 = rect.bottom;
            int n17 = childDrawable.mInsetB;
            int n18 = n16 - n17 - n5;
            drawable2.setBounds(n9, n12, n15, n18);
            int n19 = this.mPaddingL[n6];
            n2 += n19;
            int n20 = this.mPaddingR[n6];
            n4 += n20;
            int n21 = this.mPaddingT[n6];
            n3 += n21;
            int n22 = this.mPaddingB[n6];
            n5 += n22;
            ++n6;
        }
        return;
    }

    @Override
    protected boolean onLevelChange(int n) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n2 = this.mLayerState.mNum;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            ChildDrawable childDrawable = childDrawableArray[i];
            if (childDrawable.mDrawable.setLevel(n)) {
                bl2 = true;
            }
            if (!this.reapplyPadding(i, childDrawable)) continue;
            bl = true;
        }
        if (bl) {
            Rect rect = this.getBounds();
            this.onBoundsChange(rect);
        }
        return bl2;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            ChildDrawable childDrawable = childDrawableArray[i];
            if (childDrawable.mDrawable.setState(nArray)) {
                bl2 = true;
            }
            if (!this.reapplyPadding(i, childDrawable)) continue;
            bl = true;
        }
        if (bl) {
            Rect rect = this.getBounds();
            this.onBoundsChange(rect);
        }
        return bl2;
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.scheduleDrawable(this, runnable, l);
    }

    @Override
    public void setAlpha(int n) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n2 = this.mLayerState.mNum;
        int n3 = 0;
        while (n3 < n2) {
            childDrawableArray[n3].mDrawable.setAlpha(n);
            ++n3;
        }
        return;
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        int n2 = 0;
        while (n2 < n) {
            childDrawableArray[n2].mDrawable.setColorFilter(colorFilter);
            ++n2;
        }
        return;
    }

    @Override
    public void setDither(boolean bl) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        int n2 = 0;
        while (n2 < n) {
            childDrawableArray[n2].mDrawable.setDither(bl);
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setDrawableByLayerId(int n, Drawable drawable2) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n2 = this.mLayerState.mNum - 1;
        while (n2 >= 0) {
            if (childDrawableArray[n2].mId != n) {
                childDrawableArray[n2].mDrawable = drawable2;
                return true;
            }
            n2 += -1;
        }
        return false;
    }

    public void setId(int n, int n2) {
        this.mLayerState.mChildren[n].mId = n2;
    }

    public void setLayerInset(int n, int n2, int n3, int n4, int n5) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[n];
        childDrawable.mInsetL = n2;
        childDrawable.mInsetT = n3;
        childDrawable.mInsetR = n4;
        childDrawable.mInsetB = n5;
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = super.setVisible(bl, bl2);
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            boolean bl4 = childDrawableArray[i].mDrawable.setVisible(bl, bl2);
        }
        return bl3;
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.unscheduleDrawable(this, runnable);
    }

    static class LayerState
    extends Drawable.ConstantState {
        private boolean mCanConstantState;
        int mChangingConfigurations;
        private boolean mCheckedConstantState;
        ChildDrawable[] mChildren;
        int mChildrenChangingConfigurations;
        private boolean mHaveOpacity = false;
        private boolean mHaveStateful = false;
        int mNum;
        private int mOpacity;
        private boolean mStateful;

        /*
         * Enabled aggressive block sorting
         */
        LayerState(LayerState layerState, LayerDrawable layerDrawable, Resources resources) {
            int n;
            int n2;
            int n3;
            if (layerState == null) {
                this.mNum = 0;
                this.mChildren = null;
                return;
            }
            ChildDrawable[] childDrawableArray = layerState.mChildren;
            this.mNum = n3 = layerState.mNum;
            ChildDrawable[] childDrawableArray2 = new ChildDrawable[n3];
            this.mChildren = childDrawableArray2;
            this.mChangingConfigurations = n2 = layerState.mChangingConfigurations;
            this.mChildrenChangingConfigurations = n = layerState.mChildrenChangingConfigurations;
            int n4 = 0;
            while (true) {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                Drawable drawable2;
                Drawable drawable3;
                ChildDrawable childDrawable;
                if (n4 >= n3) {
                    boolean bl;
                    boolean bl2;
                    int n10;
                    boolean bl3;
                    this.mHaveOpacity = bl3 = layerState.mHaveOpacity;
                    this.mOpacity = n10 = layerState.mOpacity;
                    this.mHaveStateful = bl2 = layerState.mHaveStateful;
                    this.mStateful = bl = layerState.mStateful;
                    this.mCanConstantState = true;
                    this.mCheckedConstantState = true;
                    return;
                }
                ChildDrawable[] childDrawableArray3 = this.mChildren;
                childDrawableArray3[n4] = childDrawable = new ChildDrawable();
                ChildDrawable childDrawable2 = childDrawableArray[n4];
                childDrawable.mDrawable = resources != null ? (drawable3 = childDrawable2.mDrawable.getConstantState().newDrawable(resources)) : (drawable2 = childDrawable2.mDrawable.getConstantState().newDrawable());
                childDrawable.mDrawable.setCallback(layerDrawable);
                childDrawable.mInsetL = n9 = childDrawable2.mInsetL;
                childDrawable.mInsetT = n8 = childDrawable2.mInsetT;
                childDrawable.mInsetR = n7 = childDrawable2.mInsetR;
                childDrawable.mInsetB = n6 = childDrawable2.mInsetB;
                childDrawable.mId = n5 = childDrawable2.mId;
                ++n4;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canConstantState() {
            synchronized (this) {
                if (this.mCheckedConstantState) return this.mCanConstantState;
                if (this.mChildren == null) return this.mCanConstantState;
                this.mCanConstantState = true;
                int n = this.mNum;
                int n2 = 0;
                while (true) {
                    block7: {
                        block6: {
                            if (n2 >= n) break block6;
                            if (this.mChildren[n2].mDrawable.getConstantState() != null) break block7;
                            this.mCanConstantState = false;
                        }
                        this.mCheckedConstantState = true;
                        return this.mCanConstantState;
                    }
                    ++n2;
                }
            }
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final int getOpacity() {
            if (this.mHaveOpacity) {
                return this.mOpacity;
            }
            int n = this.mNum;
            int n2 = n > 0 ? this.mChildren[0].mDrawable.getOpacity() : -1;
            int n3 = 1;
            while (true) {
                if (n3 >= n) {
                    this.mOpacity = n2;
                    this.mHaveOpacity = true;
                    return n2;
                }
                int n4 = this.mChildren[n3].mDrawable.getOpacity();
                n2 = Drawable.resolveOpacity(n2, n4);
                ++n3;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isStateful() {
            if (this.mHaveStateful) {
                return this.mStateful;
            }
            boolean bl = false;
            int n = this.mNum;
            int n2 = 0;
            while (true) {
                block6: {
                    block5: {
                        if (n2 >= n) break block5;
                        if (!this.mChildren[n2].mDrawable.isStateful()) break block6;
                        bl = true;
                    }
                    this.mStateful = bl;
                    this.mHaveStateful = true;
                    return bl;
                }
                ++n2;
            }
        }

        @Override
        public Drawable newDrawable() {
            return new LayerDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new LayerDrawable(this, resources);
        }
    }

    static class ChildDrawable {
        public Drawable mDrawable;
        public int mId;
        public int mInsetB;
        public int mInsetL;
        public int mInsetR;
        public int mInsetT;

        ChildDrawable() {
        }
    }
}

