/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LevelListDrawable
extends DrawableContainer {
    private final LevelListState mLevelListState;
    private boolean mMutated;

    public LevelListDrawable() {
        this(null, null);
    }

    private LevelListDrawable(LevelListState levelListState, Resources resources) {
        LevelListState levelListState2;
        this.mLevelListState = levelListState2 = new LevelListState(levelListState, this, resources);
        this.setConstantState(levelListState2);
        int n = this.getLevel();
        boolean bl = this.onLevelChange(n);
    }

    public void addLevel(int n, int n2, Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        this.mLevelListState.addLevel(n, n2, drawable2);
        int n3 = this.getLevel();
        boolean bl = this.onLevelChange(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        int n2;
        super.inflate(resources, xmlPullParser, attributeSet);
        int n3 = xmlPullParser.getDepth() + 1;
        while ((n2 = xmlPullParser.next()) != 1 && ((n = xmlPullParser.getDepth()) >= n3 || n2 != 3)) {
            Drawable drawable2;
            if (n2 != 2 || n > n3 || !xmlPullParser.getName().equals("item")) continue;
            int[] nArray = R.styleable.LevelListDrawableItem;
            TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
            int n4 = typedArray.getInt(1, 0);
            int n5 = typedArray.getInt(2, 0);
            int n6 = typedArray.getResourceId(0, 0);
            typedArray.recycle();
            if (n5 < 0) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = xmlPullParser.getPositionDescription();
                String string3 = stringBuilder.append(string2).append(": <item> tag requires a 'maxLevel' attribute").toString();
                throw new XmlPullParserException(string3);
            }
            if (n6 != 0) {
                drawable2 = resources.getDrawable(n6);
            } else {
                while ((n2 = xmlPullParser.next()) == 4) {
                }
                if (n2 != 2) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string4 = xmlPullParser.getPositionDescription();
                    String string5 = stringBuilder.append(string4).append(": <item> tag requires a 'drawable' attribute or ").append("child tag defining a drawable").toString();
                    throw new XmlPullParserException(string5);
                }
                drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet);
            }
            this.mLevelListState.addLevel(n4, n5, drawable2);
        }
        int n7 = this.getLevel();
        boolean bl = this.onLevelChange(n7);
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            LevelListState levelListState = this.mLevelListState;
            int[] nArray = (int[])this.mLevelListState.mLows.clone();
            int[] nArray2 = LevelListState.access$002(levelListState, nArray);
            LevelListState levelListState2 = this.mLevelListState;
            int[] nArray3 = (int[])this.mLevelListState.mHighs.clone();
            int[] nArray4 = LevelListState.access$102(levelListState2, nArray3);
            this.mMutated = true;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onLevelChange(int n) {
        int n2 = this.mLevelListState.indexOfLevel(n);
        if (!this.selectDrawable(n2)) return super.onLevelChange(n);
        return true;
    }

    private static final class LevelListState
    extends DrawableContainer.DrawableContainerState {
        private int[] mHighs;
        private int[] mLows;

        LevelListState(LevelListState levelListState, LevelListDrawable levelListDrawable, Resources resources) {
            super(levelListState, levelListDrawable, resources);
            if (levelListState != null) {
                int[] nArray;
                int[] nArray2;
                this.mLows = nArray2 = levelListState.mLows;
                this.mHighs = nArray = levelListState.mHighs;
                return;
            }
            int[] nArray = new int[this.getChildren().length];
            this.mLows = nArray;
            int[] nArray3 = new int[this.getChildren().length];
            this.mHighs = nArray3;
        }

        static /* synthetic */ int[] access$002(LevelListState levelListState, int[] nArray) {
            levelListState.mLows = nArray;
            return nArray;
        }

        static /* synthetic */ int[] access$102(LevelListState levelListState, int[] nArray) {
            levelListState.mHighs = nArray;
            return nArray;
        }

        public void addLevel(int n, int n2, Drawable drawable2) {
            int n3 = this.addChild(drawable2);
            this.mLows[n3] = n;
            this.mHighs[n3] = n2;
        }

        @Override
        public void growArray(int n, int n2) {
            super.growArray(n, n2);
            int[] nArray = new int[n2];
            System.arraycopy(this.mLows, 0, nArray, 0, n);
            this.mLows = nArray;
            int[] nArray2 = new int[n2];
            System.arraycopy(this.mHighs, 0, nArray2, 0, n);
            this.mHighs = nArray2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int indexOfLevel(int n) {
            int[] nArray = this.mLows;
            int[] nArray2 = this.mHighs;
            int n2 = this.getChildCount();
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5 = nArray[n3];
                if (n >= n5 && n <= (n4 = nArray2[n3])) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }

        @Override
        public Drawable newDrawable() {
            return new LevelListDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new LevelListDrawable(this, resources);
        }
    }
}

