/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NinePatchDrawable
extends Drawable {
    private static final boolean DEFAULT_DITHER = true;
    private int mBitmapHeight;
    private int mBitmapWidth;
    private boolean mMutated;
    private NinePatch mNinePatch;
    private NinePatchState mNinePatchState;
    private Rect mPadding;
    private Paint mPaint;
    private int mTargetDensity;

    NinePatchDrawable() {
        this.mTargetDensity = 160;
    }

    public NinePatchDrawable(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        int n;
        NinePatch ninePatch = new NinePatch(bitmap, byArray, string2);
        NinePatchState ninePatchState = new NinePatchState(ninePatch, rect);
        this(ninePatchState, resources);
        NinePatchState ninePatchState2 = this.mNinePatchState;
        ninePatchState2.mTargetDensity = n = this.mTargetDensity;
    }

    public NinePatchDrawable(Resources resources, NinePatch ninePatch) {
        int n;
        Rect rect = new Rect();
        NinePatchState ninePatchState = new NinePatchState(ninePatch, rect);
        this(ninePatchState, resources);
        NinePatchState ninePatchState2 = this.mNinePatchState;
        ninePatchState2.mTargetDensity = n = this.mTargetDensity;
    }

    @Deprecated
    public NinePatchDrawable(Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        NinePatch ninePatch = new NinePatch(bitmap, byArray, string2);
        NinePatchState ninePatchState = new NinePatchState(ninePatch, rect);
        this(ninePatchState, null);
    }

    @Deprecated
    public NinePatchDrawable(NinePatch ninePatch) {
        Rect rect = new Rect();
        NinePatchState ninePatchState = new NinePatchState(ninePatch, rect);
        this(ninePatchState, null);
    }

    private NinePatchDrawable(NinePatchState ninePatchState, Resources resources) {
        this.mTargetDensity = 160;
        this.setNinePatchState(ninePatchState, resources);
    }

    private void computeBitmapSize() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.mNinePatch.getDensity();
        if (n8 != (n7 = this.mTargetDensity)) {
            int n9;
            int n10;
            this.mBitmapWidth = n10 = this.mNinePatch.getWidth();
            this.mBitmapHeight = n9 = this.mNinePatch.getHeight();
            return;
        }
        this.mBitmapWidth = n6 = Bitmap.scaleFromDensity(this.mNinePatch.getWidth(), n8, n7);
        this.mBitmapHeight = n5 = Bitmap.scaleFromDensity(this.mNinePatch.getHeight(), n8, n7);
        if (this.mNinePatchState.mPadding == null) {
            return;
        }
        if (this.mPadding == null) {
            return;
        }
        Rect rect = this.mPadding;
        Rect rect2 = this.mNinePatchState.mPadding;
        if (rect == rect2) {
            this.mPadding = rect = new Rect(rect2);
        }
        rect.left = n4 = Bitmap.scaleFromDensity(rect2.left, n8, n7);
        rect.top = n3 = Bitmap.scaleFromDensity(rect2.top, n8, n7);
        rect.right = n2 = Bitmap.scaleFromDensity(rect2.right, n8, n7);
        rect.bottom = n = Bitmap.scaleFromDensity(rect2.bottom, n8, n7);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setNinePatchState(NinePatchState ninePatchState, Resources resources) {
        Rect rect;
        NinePatch ninePatch;
        this.mNinePatchState = ninePatchState;
        this.mNinePatch = ninePatch = ninePatchState.mNinePatch;
        this.mPadding = rect = ninePatchState.mPadding;
        int n = resources != null ? resources.getDisplayMetrics().densityDpi : ninePatchState.mTargetDensity;
        this.mTargetDensity = n;
        boolean bl = ninePatchState.mDither;
        if (!bl) {
            boolean bl2 = ninePatchState.mDither;
            this.setDither(bl2);
        }
        if (this.mNinePatch == null) {
            return;
        }
        this.computeBitmapSize();
    }

    @Override
    public void draw(Canvas canvas) {
        NinePatch ninePatch = this.mNinePatch;
        Rect rect = this.getBounds();
        Paint paint = this.mPaint;
        ninePatch.draw(canvas, rect, paint);
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mNinePatchState.mChangingConfigurations;
        return n | n2;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        NinePatchState ninePatchState = this.mNinePatchState;
        ninePatchState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mNinePatchState;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    @Override
    public int getMinimumHeight() {
        return this.mBitmapHeight;
    }

    @Override
    public int getMinimumWidth() {
        return this.mBitmapWidth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getOpacity() {
        if (this.mNinePatch.hasAlpha()) return -1;
        if (this.mPaint == null) return -1;
        if (this.mPaint.getAlpha() >= 255) return -1;
        return -1;
    }

    @Override
    public boolean getPadding(Rect rect) {
        Rect rect2 = this.mPadding;
        rect.set(rect2);
        return true;
    }

    public Paint getPaint() {
        if (this.mPaint == null) {
            Paint paint;
            this.mPaint = paint = new Paint();
            this.mPaint.setDither(true);
        }
        return this.mPaint;
    }

    @Override
    public Region getTransparentRegion() {
        NinePatch ninePatch = this.mNinePatch;
        Rect rect = this.getBounds();
        return ninePatch.getTransparentRegion(rect);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        Bitmap bitmap;
        int n2;
        super.inflate(resources, xmlPullParser, attributeSet);
        int[] nArray = R.styleable.NinePatchDrawable;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        int n3 = typedArray.getResourceId(0, 0);
        if (n3 == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = xmlPullParser.getPositionDescription();
            String string3 = stringBuilder.append(string2).append(": <nine-patch> requires a valid src attribute").toString();
            throw new XmlPullParserException(string3);
        }
        boolean bl = typedArray.getBoolean(1, true);
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (bl) {
            options.inDither = false;
        }
        options.inScreenDensity = n2 = DisplayMetrics.DENSITY_DEVICE;
        Rect rect = new Rect();
        try {
            TypedValue typedValue = new TypedValue();
            InputStream inputStream = resources.openRawResource(n3, typedValue);
            bitmap = BitmapFactory.decodeResourceStream(resources, typedValue, inputStream, rect, options);
            inputStream.close();
        }
        catch (IOException iOException) {}
        if (bitmap == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = xmlPullParser.getPositionDescription();
            String string5 = stringBuilder.append(string4).append(": <nine-patch> requires a valid src attribute").toString();
            throw new XmlPullParserException(string5);
        }
        if (bitmap.getNinePatchChunk() == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string6 = xmlPullParser.getPositionDescription();
            String string7 = stringBuilder.append(string6).append(": <nine-patch> requires a valid 9-patch source image").toString();
            throw new XmlPullParserException(string7);
        }
        byte[] byArray = bitmap.getNinePatchChunk();
        NinePatch ninePatch = new NinePatch(bitmap, byArray, "XML 9-patch");
        NinePatchState ninePatchState = new NinePatchState(ninePatch, rect, bl);
        this.setNinePatchState(ninePatchState, resources);
        NinePatchState ninePatchState2 = this.mNinePatchState;
        ninePatchState2.mTargetDensity = n = this.mTargetDensity;
        typedArray.recycle();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            NinePatch ninePatch;
            NinePatchState ninePatchState;
            NinePatchState ninePatchState2 = this.mNinePatchState;
            this.mNinePatchState = ninePatchState = new NinePatchState(ninePatchState2);
            this.mNinePatch = ninePatch = this.mNinePatchState.mNinePatch;
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void setAlpha(int n) {
        this.getPaint().setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        ColorFilter colorFilter2 = this.getPaint().setColorFilter(colorFilter);
    }

    @Override
    public void setDither(boolean bl) {
        this.getPaint().setDither(bl);
    }

    @Override
    public void setFilterBitmap(boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTargetDensity(int n) {
        int n2 = n == 0 ? 160 : n;
        this.mTargetDensity = n2;
        if (this.mNinePatch == null) {
            return;
        }
        this.computeBitmapSize();
    }

    public void setTargetDensity(Canvas canvas) {
        int n = canvas.getDensity();
        this.setTargetDensity(n);
    }

    public void setTargetDensity(DisplayMetrics displayMetrics) {
        int n;
        this.mTargetDensity = n = displayMetrics.densityDpi;
        if (this.mNinePatch == null) {
            return;
        }
        this.computeBitmapSize();
    }

    static final class NinePatchState
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        final boolean mDither;
        final NinePatch mNinePatch;
        final Rect mPadding;
        int mTargetDensity = 160;

        NinePatchState(NinePatch ninePatch, Rect rect) {
            this(ninePatch, rect, true);
        }

        NinePatchState(NinePatch ninePatch, Rect rect, boolean bl) {
            this.mNinePatch = ninePatch;
            this.mPadding = rect;
            this.mDither = bl;
        }

        NinePatchState(NinePatchState ninePatchState) {
            int n;
            int n2;
            boolean bl;
            Rect rect;
            NinePatch ninePatch;
            NinePatch ninePatch2 = ninePatchState.mNinePatch;
            this.mNinePatch = ninePatch = new NinePatch(ninePatch2);
            this.mPadding = rect = ninePatchState.mPadding;
            this.mDither = bl = ninePatchState.mDither;
            this.mChangingConfigurations = n2 = ninePatchState.mChangingConfigurations;
            this.mTargetDensity = n = ninePatchState.mTargetDensity;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new NinePatchDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new NinePatchDrawable(this, resources);
        }
    }
}

