/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.util.AttributeSet;
import com.android.internal.R;
import org.xmlpull.v1.XmlPullParser;

public class PaintDrawable
extends ShapeDrawable {
    public PaintDrawable() {
    }

    public PaintDrawable(int n) {
        this.getPaint().setColor(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean inflateTag(String string2, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) {
        if (!string2.equals("corners")) return super.inflateTag(string2, resources, xmlPullParser, attributeSet);
        int[] nArray = R.styleable.DrawableCorners;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        int n = typedArray.getDimensionPixelSize(0, 0);
        float f = n;
        this.setCornerRadius(f);
        int n2 = typedArray.getDimensionPixelSize(1, n);
        int n3 = typedArray.getDimensionPixelSize(2, n);
        int n4 = typedArray.getDimensionPixelSize(3, n);
        int n5 = typedArray.getDimensionPixelSize(4, n);
        if (n2 == n || n3 == n || n4 == n || n5 != n) {
            float f2 = n2;
            float f3 = n2;
            float f4 = n3;
            float f5 = n3;
            float f6 = n4;
            float f7 = n4;
            float f8 = n5;
            float f9 = n5;
            float[] fArray = new float[]{f2, f3, f4, f5, f6, f7, f8, f9};
            this.setCornerRadii(fArray);
        }
        typedArray.recycle();
        return true;
    }

    public void setCornerRadii(float[] fArray) {
        if (fArray == null) {
            if (this.getShape() == null) {
                return;
            }
            this.setShape(null);
            return;
        }
        RoundRectShape roundRectShape = new RoundRectShape(fArray, null, null);
        this.setShape(roundRectShape);
    }

    public void setCornerRadius(float f) {
        float[] fArray = null;
        if (f > 0.0f) {
            fArray = new float[8];
            for (int i = 0; i < 8; ++i) {
                fArray[i] = f;
            }
        }
        this.setCornerRadii(fArray);
    }
}

