/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Picture;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class PictureDrawable
extends Drawable {
    private Picture mPicture;

    public PictureDrawable(Picture picture) {
        this.mPicture = picture;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mPicture == null) {
            return;
        }
        Rect rect = this.getBounds();
        int n = canvas.save();
        boolean bl = canvas.clipRect(rect);
        float f = rect.left;
        float f2 = rect.top;
        canvas.translate(f, f2);
        Picture picture = this.mPicture;
        canvas.drawPicture(picture);
        canvas.restore();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getIntrinsicHeight() {
        if (this.mPicture == null) return -1;
        return this.mPicture.getHeight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getIntrinsicWidth() {
        if (this.mPicture == null) return -1;
        return this.mPicture.getWidth();
    }

    @Override
    public int getOpacity() {
        return -1;
    }

    public Picture getPicture() {
        return this.mPicture;
    }

    @Override
    public void setAlpha(int n) {
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
    }

    @Override
    public void setDither(boolean bl) {
    }

    @Override
    public void setFilterBitmap(boolean bl) {
    }

    public void setPicture(Picture picture) {
        this.mPicture = picture;
    }
}

