/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RotateDrawable
extends Drawable
implements Drawable.Callback {
    private static final float MAX_LEVEL = 10000.0f;
    private boolean mMutated;
    private RotateState mState;

    public RotateDrawable() {
        this(null, null);
    }

    private RotateDrawable(RotateState rotateState, Resources resources) {
        RotateState rotateState2;
        this.mState = rotateState2 = new RotateState(rotateState, this, resources);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        float f;
        float f2;
        int n = canvas.save();
        Rect rect = this.mState.mDrawable.getBounds();
        int n2 = rect.right;
        int n3 = rect.left;
        int n4 = n2 - n3;
        int n5 = rect.bottom;
        int n6 = rect.top;
        int n7 = n5 - n6;
        RotateState rotateState = this.mState;
        if (rotateState.mPivotXRel) {
            float f3 = n4;
            float f4 = rotateState.mPivotX;
            f2 = f3 * f4;
        } else {
            f2 = rotateState.mPivotX;
        }
        if (rotateState.mPivotYRel) {
            float f5 = n7;
            float f6 = rotateState.mPivotY;
            f = f5 * f6;
        } else {
            f = rotateState.mPivotY;
        }
        float f7 = rotateState.mCurrentDegrees;
        canvas.rotate(f7, f2, f);
        rotateState.mDrawable.draw(canvas);
        canvas.restoreToCount(n);
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mState.mChangingConfigurations;
        int n3 = n | n2;
        int n4 = this.mState.mDrawable.getChangingConfigurations();
        return n3 | n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        if (!this.mState.canConstantState()) return null;
        RotateState rotateState = this.mState;
        rotateState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mState;
    }

    public Drawable getDrawable() {
        return this.mState.mDrawable;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mState.mDrawable.getOpacity();
    }

    @Override
    public boolean getPadding(Rect rect) {
        return this.mState.mDrawable.getPadding(rect);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        float f;
        float f2;
        float f3;
        float f4;
        boolean bl;
        float f5;
        boolean bl2;
        Drawable drawable2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        float f6;
        boolean bl3;
        int n8;
        TypedArray typedArray;
        TypedValue typedValue;
        float f7;
        boolean bl4;
        int[] nArray = R.styleable.RotateDrawable;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray2 = resources2.obtainAttributes(attributeSet2, nArray2);
        RotateDrawable rotateDrawable = this;
        Resources resources3 = resources;
        XmlPullParser xmlPullParser2 = xmlPullParser;
        TypedArray typedArray3 = typedArray2;
        int n9 = 0;
        super.inflateWithAttributes(resources3, xmlPullParser2, typedArray3, n9);
        TypedArray typedArray4 = typedArray2;
        int n10 = 4;
        TypedValue typedValue2 = typedArray4.peekValue(n10);
        if (typedValue2 == null) {
            bl4 = true;
            f7 = 0.5f;
        } else {
            int n11 = typedValue2.type;
            int n12 = 6;
            bl4 = n11 == n12;
            if (bl4) {
                TypedValue typedValue3 = typedValue2;
                float f8 = 1.0f;
                float f9 = 1.0f;
                f7 = typedValue3.getFraction(f8, f9);
            } else {
                f7 = typedValue2.getFloat();
            }
        }
        if ((typedValue = (typedArray = typedArray2).peekValue(n8 = 5)) == null) {
            bl3 = true;
            f6 = 0.5f;
        } else {
            int n13 = typedValue.type;
            int n14 = 6;
            bl3 = n13 == n14;
            if (bl3) {
                TypedValue typedValue4 = typedValue;
                float f10 = 1.0f;
                float f11 = 1.0f;
                f6 = typedValue4.getFraction(f10, f11);
            } else {
                f6 = typedValue.getFloat();
            }
        }
        TypedArray typedArray5 = typedArray2;
        int n15 = 2;
        float f12 = 0.0f;
        float f13 = typedArray5.getFloat(n15, f12);
        TypedArray typedArray6 = typedArray2;
        int n16 = 3;
        float f14 = 360.0f;
        float f15 = typedArray6.getFloat(n16, f14);
        float f16 = Math.max(f13, f15);
        TypedArray typedArray7 = typedArray2;
        int n17 = 1;
        int n18 = 0;
        int n19 = typedArray7.getResourceId(n17, n18);
        Drawable drawable3 = null;
        if (n19 > 0) {
            Resources resources4 = resources;
            int n20 = n19;
            drawable3 = resources4.getDrawable(n20);
        }
        typedArray2.recycle();
        int n21 = xmlPullParser.getDepth();
        while ((n7 = (n6 = xmlPullParser.next())) != (n5 = 1) && ((n4 = n6) != (n3 = 3) || (n2 = xmlPullParser.getDepth()) > (n = n21))) {
            int n22 = n6;
            int n23 = 2;
            if (n22 != n23 || (drawable3 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet)) != null) continue;
            StringBuilder stringBuilder = new StringBuilder().append("Bad element under <rotate>: ");
            String string2 = xmlPullParser.getName();
            String string3 = stringBuilder.append(string2).toString();
            int n24 = Log.w("drawable", string3);
        }
        if (drawable3 == null) {
            int n25 = Log.w("drawable", "No drawable specified for <rotate>");
        }
        RotateState rotateState = this.mState;
        rotateState.mDrawable = drawable2 = drawable3;
        RotateState rotateState2 = this.mState;
        rotateState2.mPivotXRel = bl2 = bl4;
        RotateState rotateState3 = this.mState;
        rotateState3.mPivotX = f5 = f7;
        RotateState rotateState4 = this.mState;
        rotateState4.mPivotYRel = bl = bl3;
        RotateState rotateState5 = this.mState;
        rotateState5.mPivotY = f4 = f6;
        RotateState rotateState6 = this.mState;
        RotateState rotateState7 = this.mState;
        rotateState7.mCurrentDegrees = f3 = f13;
        rotateState6.mFromDegrees = f2 = f13;
        RotateState rotateState8 = this.mState;
        rotateState8.mToDegrees = f = f16;
        if (drawable3 == null) {
            return;
        }
        Drawable drawable4 = drawable3;
        RotateDrawable rotateDrawable2 = this;
        drawable4.setCallback(rotateDrawable2);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.invalidateDrawable(this);
    }

    @Override
    public boolean isStateful() {
        return this.mState.mDrawable.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            Drawable drawable2 = this.mState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        Drawable drawable2 = this.mState.mDrawable;
        int n = rect.left;
        int n2 = rect.top;
        int n3 = rect.right;
        int n4 = rect.bottom;
        drawable2.setBounds(n, n2, n3, n4);
    }

    @Override
    protected boolean onLevelChange(int n) {
        float f;
        boolean bl = this.mState.mDrawable.setLevel(n);
        Rect rect = this.getBounds();
        this.onBoundsChange(rect);
        RotateState rotateState = this.mState;
        float f2 = this.mState.mFromDegrees;
        float f3 = this.mState.mToDegrees;
        float f4 = this.mState.mFromDegrees;
        float f5 = f3 - f4;
        float f6 = (float)n / 10000.0f;
        float f7 = f5 * f6;
        rotateState.mCurrentDegrees = f = f2 + f7;
        this.invalidateSelf();
        return true;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        boolean bl = this.mState.mDrawable.setState(nArray);
        Rect rect = this.getBounds();
        this.onBoundsChange(rect);
        return bl;
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.scheduleDrawable(this, runnable, l);
    }

    @Override
    public void setAlpha(int n) {
        this.mState.mDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mState.mDrawable.setColorFilter(colorFilter);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = this.mState.mDrawable.setVisible(bl, bl2);
        return super.setVisible(bl, bl2);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.unscheduleDrawable(this, runnable);
    }

    static final class RotateState
    extends Drawable.ConstantState {
        private boolean mCanConstantState;
        int mChangingConfigurations;
        private boolean mCheckedConstantState;
        float mCurrentDegrees;
        Drawable mDrawable;
        float mFromDegrees;
        float mPivotX;
        boolean mPivotXRel;
        float mPivotY;
        boolean mPivotYRel;
        float mToDegrees;

        /*
         * Enabled aggressive block sorting
         */
        public RotateState(RotateState rotateState, RotateDrawable rotateDrawable, Resources resources) {
            float f;
            float f2;
            float f3;
            boolean bl;
            float f4;
            boolean bl2;
            Drawable drawable2;
            Drawable drawable3;
            if (rotateState == null) {
                return;
            }
            this.mDrawable = resources != null ? (drawable3 = rotateState.mDrawable.getConstantState().newDrawable(resources)) : (drawable2 = rotateState.mDrawable.getConstantState().newDrawable());
            this.mDrawable.setCallback(rotateDrawable);
            this.mPivotXRel = bl2 = rotateState.mPivotXRel;
            this.mPivotX = f4 = rotateState.mPivotX;
            this.mPivotYRel = bl = rotateState.mPivotYRel;
            this.mPivotY = f3 = rotateState.mPivotY;
            this.mCurrentDegrees = f2 = rotateState.mFromDegrees;
            this.mFromDegrees = f2;
            this.mToDegrees = f = rotateState.mToDegrees;
            this.mCheckedConstantState = true;
            this.mCanConstantState = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                boolean bl = this.mDrawable.getConstantState() != null;
                this.mCanConstantState = bl;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new RotateDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new RotateDrawable(this, resources);
        }
    }
}

