/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ScaleDrawable
extends Drawable
implements Drawable.Callback {
    private boolean mMutated;
    private ScaleState mScaleState;
    private final Rect mTmpRect;

    ScaleDrawable() {
        this(null, null);
    }

    public ScaleDrawable(Drawable drawable2, int n, float f, float f2) {
        this(null, null);
        this.mScaleState.mDrawable = drawable2;
        this.mScaleState.mGravity = n;
        this.mScaleState.mScaleWidth = f;
        this.mScaleState.mScaleHeight = f2;
        if (drawable2 == null) {
            return;
        }
        drawable2.setCallback(this);
    }

    private ScaleDrawable(ScaleState scaleState, Resources resources) {
        ScaleState scaleState2;
        Rect rect;
        this.mTmpRect = rect = new Rect();
        this.mScaleState = scaleState2 = new ScaleState(scaleState, this, resources);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float getPercent(TypedArray typedArray, int n) {
        String string2 = typedArray.getString(n);
        if (string2 == null) return -1.0f;
        if (!string2.endsWith("%")) return -1.0f;
        int n2 = string2.length() - 1;
        return Float.parseFloat(string2.substring(0, n2)) / 100.0f;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mScaleState.mDrawable.getLevel() == 0) {
            return;
        }
        this.mScaleState.mDrawable.draw(canvas);
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mScaleState.mChangingConfigurations;
        int n3 = n | n2;
        int n4 = this.mScaleState.mDrawable.getChangingConfigurations();
        return n3 | n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        if (!this.mScaleState.canConstantState()) return null;
        ScaleState scaleState = this.mScaleState;
        scaleState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mScaleState;
    }

    public Drawable getDrawable() {
        return this.mScaleState.mDrawable;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mScaleState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mScaleState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mScaleState.mDrawable.getOpacity();
    }

    @Override
    public boolean getPadding(Rect rect) {
        return this.mScaleState.mDrawable.getPadding(rect);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        super.inflate(resources, xmlPullParser, attributeSet);
        int[] nArray = R.styleable.ScaleDrawable;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        float f = ScaleDrawable.getPercent(typedArray, 1);
        float f2 = ScaleDrawable.getPercent(typedArray, 2);
        int n2 = typedArray.getInt(3, 3);
        Drawable drawable2 = typedArray.getDrawable(0);
        typedArray.recycle();
        int n3 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n3)) {
            if (n != 2) continue;
            drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet);
        }
        if (drawable2 == null) {
            throw new IllegalArgumentException("No drawable specified for <scale>");
        }
        this.mScaleState.mDrawable = drawable2;
        this.mScaleState.mScaleWidth = f;
        this.mScaleState.mScaleHeight = f2;
        this.mScaleState.mGravity = n2;
        if (drawable2 == null) {
            return;
        }
        drawable2.setCallback(this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.invalidateDrawable(this);
    }

    @Override
    public boolean isStateful() {
        return this.mScaleState.mDrawable.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            Drawable drawable2 = this.mScaleState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        Rect rect2 = this.mTmpRect;
        int n = this.getLevel();
        int n2 = rect.width();
        if (this.mScaleState.mScaleWidth > 0.0f) {
            int n3 = n2 - 0;
            int n4 = 10000 - n;
            float f = n3 * n4;
            float f2 = this.mScaleState.mScaleWidth;
            int n5 = (int)(f * f2 / 10000.0f);
            n2 -= n5;
        }
        int n6 = rect.height();
        if (this.mScaleState.mScaleHeight > 0.0f) {
            int n7 = n6 - 0;
            int n8 = 10000 - n;
            float f = n7 * n8;
            float f3 = this.mScaleState.mScaleHeight;
            int n9 = (int)(f * f3 / 10000.0f);
            n6 -= n9;
        }
        Gravity.apply(this.mScaleState.mGravity, n2, n6, rect, rect2);
        if (n2 <= 0) {
            return;
        }
        if (n6 <= 0) {
            return;
        }
        Drawable drawable2 = this.mScaleState.mDrawable;
        int n10 = rect2.left;
        int n11 = rect2.top;
        int n12 = rect2.right;
        int n13 = rect2.bottom;
        drawable2.setBounds(n10, n11, n12, n13);
    }

    @Override
    protected boolean onLevelChange(int n) {
        boolean bl = this.mScaleState.mDrawable.setLevel(n);
        Rect rect = this.getBounds();
        this.onBoundsChange(rect);
        this.invalidateSelf();
        return true;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        boolean bl = this.mScaleState.mDrawable.setState(nArray);
        Rect rect = this.getBounds();
        this.onBoundsChange(rect);
        return bl;
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.scheduleDrawable(this, runnable, l);
    }

    @Override
    public void setAlpha(int n) {
        this.mScaleState.mDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mScaleState.mDrawable.setColorFilter(colorFilter);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = this.mScaleState.mDrawable.setVisible(bl, bl2);
        return super.setVisible(bl, bl2);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.unscheduleDrawable(this, runnable);
    }

    static final class ScaleState
    extends Drawable.ConstantState {
        private boolean mCanConstantState;
        int mChangingConfigurations;
        private boolean mCheckedConstantState;
        Drawable mDrawable;
        int mGravity;
        float mScaleHeight;
        float mScaleWidth;

        /*
         * Enabled aggressive block sorting
         */
        ScaleState(ScaleState scaleState, ScaleDrawable scaleDrawable, Resources resources) {
            int n;
            float f;
            float f2;
            Drawable drawable2;
            Drawable drawable3;
            if (scaleState == null) {
                return;
            }
            this.mDrawable = resources != null ? (drawable3 = scaleState.mDrawable.getConstantState().newDrawable(resources)) : (drawable2 = scaleState.mDrawable.getConstantState().newDrawable());
            this.mDrawable.setCallback(scaleDrawable);
            this.mScaleWidth = f2 = scaleState.mScaleWidth;
            this.mScaleHeight = f = scaleState.mScaleHeight;
            this.mGravity = n = scaleState.mGravity;
            this.mCanConstantState = true;
            this.mCheckedConstantState = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                boolean bl = this.mDrawable.getConstantState() != null;
                this.mCanConstantState = bl;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new ScaleDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new ScaleDrawable(this, resources);
        }
    }
}

