/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ShapeDrawable
extends Drawable {
    private boolean mMutated;
    private ShapeState mShapeState;

    public ShapeDrawable() {
        ShapeState shapeState = null;
        this(shapeState);
    }

    private ShapeDrawable(ShapeState shapeState) {
        ShapeState shapeState2;
        this.mShapeState = shapeState2 = new ShapeState(shapeState);
    }

    public ShapeDrawable(Shape shape) {
        ShapeState shapeState = null;
        this(shapeState);
        this.mShapeState.mShape = shape;
    }

    private static int modulateAlpha(int n, int n2) {
        int n3 = n2 >>> 7;
        int n4 = n2 + n3;
        return n * n4 >>> 8;
    }

    private void updateShape() {
        if (this.mShapeState.mShape == null) {
            return;
        }
        Rect rect = this.getBounds();
        int n = rect.width();
        int n2 = rect.height();
        Shape shape = this.mShapeState.mShape;
        float f = n;
        float f2 = n2;
        shape.resize(f, f2);
        if (this.mShapeState.mShaderFactory == null) {
            return;
        }
        Paint paint = this.mShapeState.mPaint;
        Shader shader = this.mShapeState.mShaderFactory.resize(n, n2);
        Shader shader2 = paint.setShader(shader);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        Rect rect = this.getBounds();
        Paint paint = this.mShapeState.mPaint;
        int n = paint.getAlpha();
        int n2 = this.mShapeState.mAlpha;
        int n3 = ShapeDrawable.modulateAlpha(n, n2);
        paint.setAlpha(n3);
        if (this.mShapeState.mShape != null) {
            int n4 = canvas.save();
            float f = rect.left;
            float f2 = rect.top;
            canvas.translate(f, f2);
            Shape shape = this.mShapeState.mShape;
            this.onDraw(shape, canvas, paint);
            canvas.restoreToCount(n4);
        } else {
            canvas.drawRect(rect, paint);
        }
        paint.setAlpha(n);
    }

    @Override
    public int getChangingConfigurations() {
        int n = super.getChangingConfigurations();
        int n2 = this.mShapeState.mChangingConfigurations;
        return n | n2;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        int n;
        ShapeState shapeState = this.mShapeState;
        shapeState.mChangingConfigurations = n = super.getChangingConfigurations();
        return this.mShapeState;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mShapeState.mIntrinsicHeight;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mShapeState.mIntrinsicWidth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getOpacity() {
        if (this.mShapeState.mShape != null) return -1;
        Paint paint = this.mShapeState.mPaint;
        if (paint.getXfermode() != null) return -1;
        int n = paint.getAlpha();
        if (n == 0) {
            return -1;
        }
        if (n != 255) return -1;
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getPadding(Rect rect) {
        if (this.mShapeState.mPadding == null) return super.getPadding(rect);
        Rect rect2 = this.mShapeState.mPadding;
        rect.set(rect2);
        return true;
    }

    public Paint getPaint() {
        return this.mShapeState.mPaint;
    }

    public ShaderFactory getShaderFactory() {
        return this.mShapeState.mShaderFactory;
    }

    public Shape getShape() {
        return this.mShapeState.mShape;
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        super.inflate(resources, xmlPullParser, attributeSet);
        int[] nArray = R.styleable.ShapeDrawable;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        int n = this.mShapeState.mPaint.getColor();
        int n2 = typedArray.getColor(2, n);
        this.mShapeState.mPaint.setColor(n2);
        int n3 = (int)typedArray.getDimension(1, 0.0f);
        this.setIntrinsicWidth(n3);
        int n4 = (int)typedArray.getDimension(0, 0.0f);
        this.setIntrinsicHeight(n4);
        typedArray.recycle();
        int n5 = xmlPullParser.getDepth();
        int n6;
        while ((n6 = xmlPullParser.next()) != 1) {
            String string2;
            if (n6 == 3 && xmlPullParser.getDepth() <= n5) {
                return;
            }
            if (n6 != 2 || this.inflateTag(string2 = xmlPullParser.getName(), resources, xmlPullParser, attributeSet)) continue;
            String string3 = "Unknown element: " + string2 + " for ShapeDrawable " + this;
            int n7 = Log.w("drawable", string3);
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean inflateTag(String string2, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) {
        if (!string2.equals("padding")) return false;
        int[] nArray = R.styleable.ShapeDrawablePadding;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        int n = typedArray.getDimensionPixelOffset(0, 0);
        int n2 = typedArray.getDimensionPixelOffset(1, 0);
        int n3 = typedArray.getDimensionPixelOffset(2, 0);
        int n4 = typedArray.getDimensionPixelOffset(3, 0);
        this.setPadding(n, n2, n3, n4);
        typedArray.recycle();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Drawable mutate() {
        Rect rect;
        Paint paint;
        if (this.mMutated) return this;
        if (super.mutate() != this) return this;
        ShapeState shapeState = this.mShapeState;
        Paint paint2 = this.mShapeState.mPaint;
        shapeState.mPaint = paint = new Paint(paint2);
        ShapeState shapeState2 = this.mShapeState;
        Rect rect2 = this.mShapeState.mPadding;
        shapeState2.mPadding = rect = new Rect(rect2);
        try {
            Shape shape;
            ShapeState shapeState3 = this.mShapeState;
            shapeState3.mShape = shape = this.mShapeState.mShape.clone();
            this.mMutated = true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.updateShape();
    }

    protected void onDraw(Shape shape, Canvas canvas, Paint paint) {
        shape.draw(canvas, paint);
    }

    @Override
    public void setAlpha(int n) {
        this.mShapeState.mAlpha = n;
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        ColorFilter colorFilter2 = this.mShapeState.mPaint.setColorFilter(colorFilter);
    }

    @Override
    public void setDither(boolean bl) {
        this.mShapeState.mPaint.setDither(bl);
    }

    public void setIntrinsicHeight(int n) {
        this.mShapeState.mIntrinsicHeight = n;
    }

    public void setIntrinsicWidth(int n) {
        this.mShapeState.mIntrinsicWidth = n;
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        if ((n | n2 | n3 | n4) == 0) {
            this.mShapeState.mPadding = null;
            return;
        }
        if (this.mShapeState.mPadding == null) {
            Rect rect;
            ShapeState shapeState = this.mShapeState;
            shapeState.mPadding = rect = new Rect();
        }
        this.mShapeState.mPadding.set(n, n2, n3, n4);
    }

    public void setPadding(Rect rect) {
        if (rect == null) {
            this.mShapeState.mPadding = null;
            return;
        }
        if (this.mShapeState.mPadding == null) {
            Rect rect2;
            ShapeState shapeState = this.mShapeState;
            shapeState.mPadding = rect2 = new Rect();
        }
        this.mShapeState.mPadding.set(rect);
    }

    public void setShaderFactory(ShaderFactory shaderFactory) {
        this.mShapeState.mShaderFactory = shaderFactory;
    }

    public void setShape(Shape shape) {
        this.mShapeState.mShape = shape;
        this.updateShape();
    }

    public static abstract class ShaderFactory {
        public abstract Shader resize(int var1, int var2);
    }

    static final class ShapeState
    extends Drawable.ConstantState {
        int mAlpha = 255;
        int mChangingConfigurations;
        int mIntrinsicHeight;
        int mIntrinsicWidth;
        Rect mPadding;
        Paint mPaint;
        ShaderFactory mShaderFactory;
        Shape mShape;

        ShapeState(ShapeState shapeState) {
            Paint paint;
            if (shapeState != null) {
                ShaderFactory shaderFactory;
                int n;
                int n2;
                int n3;
                Rect rect;
                Shape shape;
                Paint paint2;
                this.mPaint = paint2 = shapeState.mPaint;
                this.mShape = shape = shapeState.mShape;
                this.mPadding = rect = shapeState.mPadding;
                this.mIntrinsicWidth = n3 = shapeState.mIntrinsicWidth;
                this.mIntrinsicHeight = n2 = shapeState.mIntrinsicHeight;
                this.mAlpha = n = shapeState.mAlpha;
                this.mShaderFactory = shaderFactory = shapeState.mShaderFactory;
                return;
            }
            this.mPaint = paint = new Paint(1);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new ShapeDrawable(this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new ShapeDrawable(this);
        }
    }
}

