/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StateListDrawable
extends DrawableContainer {
    private static final boolean DEFAULT_DITHER = true;
    private boolean mMutated;
    private final StateListState mStateListState;

    public StateListDrawable() {
        this(null, null);
    }

    private StateListDrawable(StateListState stateListState, Resources resources) {
        StateListState stateListState2;
        this.mStateListState = stateListState2 = new StateListState(stateListState, this, resources);
        this.setConstantState(stateListState2);
        int[] nArray = this.getState();
        boolean bl = this.onStateChange(nArray);
    }

    public void addState(int[] nArray, Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        int n = this.mStateListState.addStateSet(nArray, drawable2);
        int[] nArray2 = this.getState();
        boolean bl = this.onStateChange(nArray2);
    }

    public int getStateCount() {
        return this.mStateListState.getChildCount();
    }

    public Drawable getStateDrawable(int n) {
        return this.mStateListState.getChildren()[n];
    }

    public int getStateDrawableIndex(int[] nArray) {
        return this.mStateListState.indexOfStateSet(nArray);
    }

    StateListState getStateListState() {
        return this.mStateListState;
    }

    public int[] getStateSet(int n) {
        return this.mStateListState.mStateSets[n];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int[] nArray = R.styleable.StateListDrawable;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray = resources2.obtainAttributes(attributeSet2, nArray2);
        StateListDrawable stateListDrawable = this;
        Resources resources3 = resources;
        XmlPullParser xmlPullParser2 = xmlPullParser;
        TypedArray typedArray2 = typedArray;
        int n = 1;
        super.inflateWithAttributes(resources3, xmlPullParser2, typedArray2, n);
        StateListState stateListState = this.mStateListState;
        TypedArray typedArray3 = typedArray;
        int n2 = 2;
        boolean bl = false;
        boolean bl2 = typedArray3.getBoolean(n2, bl);
        stateListState.setVariablePadding(bl2);
        StateListState stateListState2 = this.mStateListState;
        TypedArray typedArray4 = typedArray;
        int n3 = 3;
        boolean bl3 = false;
        boolean bl4 = typedArray4.getBoolean(n3, bl3);
        stateListState2.setConstantSize(bl4);
        TypedArray typedArray5 = typedArray;
        int n4 = 0;
        boolean bl5 = true;
        boolean bl6 = typedArray5.getBoolean(n4, bl5);
        StateListDrawable stateListDrawable2 = this;
        boolean bl7 = bl6;
        stateListDrawable2.setDither(bl7);
        typedArray.recycle();
        int n5 = xmlPullParser.getDepth() + 1;
        while (true) {
            Drawable drawable2;
            int[] nArray3;
            block9: {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                if ((n13 = (n12 = xmlPullParser.next())) != (n11 = 1) && ((n10 = xmlPullParser.getDepth()) >= n5 || (n9 = n12) != (n8 = 3))) {
                    int n14 = n12;
                    int n15 = 2;
                    if (n14 != n15 || n10 > n5 || !xmlPullParser.getName().equals("item")) continue;
                } else {
                    int[] nArray4 = this.getState();
                    StateListDrawable stateListDrawable3 = this;
                    int[] nArray5 = nArray4;
                    boolean bl8 = stateListDrawable3.onStateChange(nArray5);
                    return;
                }
                int n16 = 0;
                int n17 = attributeSet.getAttributeCount();
                int[] nArray6 = new int[n17];
                int n18 = 0;
                int n19 = 0;
                while (true) {
                    int n20;
                    int n21;
                    AttributeSet attributeSet3;
                    int n22;
                    if (n18 >= n17 || (n22 = (attributeSet3 = attributeSet).getAttributeNameResource(n21 = n18)) == 0) {
                        nArray3 = StateSet.trimStateSet(nArray6, n19);
                        if (n16 == 0) break;
                        Resources resources4 = resources;
                        int n23 = n16;
                        drawable2 = resources4.getDrawable(n23);
                        break block9;
                    }
                    int n24 = n22;
                    int n25 = 0x1010199;
                    if (n24 == n25) {
                        AttributeSet attributeSet4 = attributeSet;
                        int n26 = n18;
                        int n27 = 0;
                        n16 = attributeSet4.getAttributeResourceValue(n26, n27);
                        n20 = n19;
                    } else {
                        n20 = n19 + 1;
                        AttributeSet attributeSet5 = attributeSet;
                        int n28 = n18;
                        boolean bl9 = false;
                        int n29 = attributeSet5.getAttributeBooleanValue(n28, bl9) ? n22 : -n22;
                        nArray6[n19] = n29;
                    }
                    ++n18;
                    n19 = n20;
                }
                while ((n7 = (n12 = xmlPullParser.next())) == (n6 = 4)) {
                }
                int n30 = n12;
                int n31 = 2;
                if (n30 != n31) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = xmlPullParser.getPositionDescription();
                    String string3 = stringBuilder.append(string2).append(": <item> tag requires a 'drawable' attribute or ").append("child tag defining a drawable").toString();
                    throw new XmlPullParserException(string3);
                }
                drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet);
            }
            StateListState stateListState3 = this.mStateListState;
            int[] nArray7 = nArray3;
            Drawable drawable3 = drawable2;
            int n32 = stateListState3.addStateSet(nArray7, drawable3);
        }
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            int[][] nArray = this.mStateListState.mStateSets;
            int n = nArray.length;
            StateListState stateListState = this.mStateListState;
            int[] nArray2 = new int[n];
            int[][] nArray3 = StateListState.access$102(stateListState, (int[][])nArray2);
            for (int i = 0; i < n; ++i) {
                int[] nArray4 = nArray[i];
                if (nArray4 == null) continue;
                int[][] nArray5 = this.mStateListState.mStateSets;
                int[] nArray6 = (int[])nArray4.clone();
                nArray5[i] = nArray6;
            }
            this.mMutated = true;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onStateChange(int[] nArray) {
        int n = this.mStateListState.indexOfStateSet(nArray);
        if (n < 0) {
            StateListState stateListState = this.mStateListState;
            int[] nArray2 = StateSet.WILD_CARD;
            n = stateListState.indexOfStateSet(nArray2);
        }
        if (!this.selectDrawable(n)) return super.onStateChange(nArray);
        return true;
    }

    static final class StateListState
    extends DrawableContainer.DrawableContainerState {
        private int[][] mStateSets;

        StateListState(StateListState stateListState, StateListDrawable stateListDrawable, Resources resources) {
            super(stateListState, stateListDrawable, resources);
            if (stateListState != null) {
                int[][] nArray;
                this.mStateSets = nArray = stateListState.mStateSets;
                return;
            }
            int[] nArray = new int[this.getChildren().length];
            this.mStateSets = (int[][])nArray;
        }

        static /* synthetic */ int[][] access$102(StateListState stateListState, int[][] nArray) {
            stateListState.mStateSets = nArray;
            return nArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int indexOfStateSet(int[] nArray) {
            int[][] nArray2 = this.mStateSets;
            int n = this.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                if (StateSet.stateSetMatches(nArray2[n2], nArray)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        int addStateSet(int[] nArray, Drawable drawable2) {
            int n = this.addChild(drawable2);
            this.mStateSets[n] = nArray;
            return n;
        }

        @Override
        public void growArray(int n, int n2) {
            super.growArray(n, n2);
            int[] nArray = new int[n2];
            System.arraycopy(this.mStateSets, 0, nArray, 0, n);
            this.mStateSets = (int[][])nArray;
        }

        @Override
        public Drawable newDrawable() {
            return new StateListDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new StateListDrawable(this, resources);
        }
    }
}

