/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.SystemClock;

public class TransitionDrawable
extends LayerDrawable
implements Drawable.Callback {
    private static final int TRANSITION_NONE = 2;
    private static final int TRANSITION_RUNNING = 1;
    private static final int TRANSITION_STARTING;
    private int mAlpha;
    private boolean mCrossFade;
    private int mDuration;
    private int mFrom;
    private int mOriginalDuration;
    private boolean mReverse;
    private long mStartTimeMillis;
    private int mTo;
    private int mTransitionState;

    TransitionDrawable() {
        TransitionState transitionState = new TransitionState(null, null, null);
        Resources resources = null;
        this(transitionState, resources);
    }

    private TransitionDrawable(TransitionState transitionState, Resources resources) {
        super(transitionState, resources);
        this.mTransitionState = 2;
        this.mAlpha = 0;
    }

    private TransitionDrawable(TransitionState transitionState, Drawable[] drawableArray) {
        super(drawableArray, transitionState);
        this.mTransitionState = 2;
        this.mAlpha = 0;
    }

    public TransitionDrawable(Drawable[] drawableArray) {
        TransitionState transitionState = new TransitionState(null, null, null);
        this(transitionState, drawableArray);
    }

    @Override
    LayerDrawable.LayerState createConstantState(LayerDrawable.LayerState layerState, Resources resources) {
        TransitionState transitionState = (TransitionState)layerState;
        return new TransitionState(transitionState, this, resources);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.mTransitionState) {
            case 0: {
                long l;
                this.mStartTimeMillis = l = SystemClock.uptimeMillis();
                bl = false;
                this.mTransitionState = 1;
            }
            default: {
                break;
            }
            case 1: {
                int n;
                float f;
                long l;
                if (this.mStartTimeMillis < 0L) break;
                long l2 = SystemClock.uptimeMillis();
                float f2 = l2 - (l = this.mStartTimeMillis);
                float f3 = f2 / (f = (float)this.mDuration);
                bl = f3 >= 1.0f;
                float f4 = Math.min(f3, 1.0f);
                float f5 = this.mFrom;
                int n2 = this.mTo;
                int n3 = this.mFrom;
                float f6 = (float)(n2 - n3) * f4;
                this.mAlpha = n = (int)(f5 + f6);
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.mCrossFade;
        LayerDrawable.ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        Drawable drawable2 = childDrawableArray[0].mDrawable;
        if (bl2) {
            int n4 = 255 - n;
            drawable2.setAlpha(n4);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(255);
        }
        if (n > 0) {
            Drawable drawable3 = childDrawableArray[1].mDrawable;
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(255);
        }
        if (bl) {
            return;
        }
        this.invalidateSelf();
    }

    public boolean isCrossFadeEnabled() {
        return this.mCrossFade;
    }

    public void resetTransition() {
        this.mAlpha = 0;
        this.mTransitionState = 2;
        this.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void reverseTransition(int n) {
        int n2;
        long l;
        int n3;
        long l2;
        long l3;
        long l4 = SystemClock.uptimeMillis();
        long l5 = l4 - (l3 = this.mStartTimeMillis);
        if (l5 > (l2 = (long)this.mDuration)) {
            if (this.mAlpha == 0) {
                this.mFrom = 0;
                this.mTo = 255;
                this.mAlpha = 0;
                this.mReverse = false;
            } else {
                this.mFrom = 255;
                this.mTo = 0;
                this.mAlpha = 255;
                this.mReverse = true;
            }
            this.mOriginalDuration = n;
            this.mDuration = n;
            this.mTransitionState = 0;
            this.invalidateSelf();
            return;
        }
        boolean bl = !this.mReverse;
        this.mReverse = bl;
        this.mFrom = n3 = this.mAlpha;
        int n4 = this.mReverse ? 0 : 255;
        this.mTo = n4;
        if (this.mReverse) {
            long l6 = this.mStartTimeMillis;
            l = l4 - l6;
        } else {
            long l7 = this.mOriginalDuration;
            long l8 = this.mStartTimeMillis;
            long l9 = l4 - l8;
            l = l7 - l9;
        }
        this.mDuration = n2 = (int)l;
        this.mTransitionState = 0;
    }

    public void setCrossFadeEnabled(boolean bl) {
        this.mCrossFade = bl;
    }

    public void startTransition(int n) {
        this.mFrom = 0;
        this.mTo = 255;
        this.mAlpha = 0;
        this.mOriginalDuration = n;
        this.mDuration = n;
        this.mReverse = false;
        this.mTransitionState = 0;
        this.invalidateSelf();
    }

    static class TransitionState
    extends LayerDrawable.LayerState {
        TransitionState(TransitionState transitionState, TransitionDrawable transitionDrawable, Resources resources) {
            super(transitionState, transitionDrawable, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            Resources resources = null;
            return new TransitionDrawable(this, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new TransitionDrawable(this, resources);
        }
    }
}

