/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable.shapes;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.shapes.RectShape;

public class RoundRectShape
extends RectShape {
    private float[] mInnerRadii;
    private RectF mInnerRect;
    private RectF mInset;
    private float[] mOuterRadii;
    private Path mPath;

    public RoundRectShape(float[] fArray, RectF rectF, float[] fArray2) {
        Path path;
        if (fArray.length < 8) {
            throw new ArrayIndexOutOfBoundsException("outer radii must have >= 8 values");
        }
        if (fArray2 != null && fArray2.length < 8) {
            throw new ArrayIndexOutOfBoundsException("inner radii must have >= 8 values");
        }
        this.mOuterRadii = fArray;
        this.mInset = rectF;
        this.mInnerRadii = fArray2;
        if (rectF != null) {
            RectF rectF2;
            this.mInnerRect = rectF2 = new RectF();
        }
        this.mPath = path = new Path();
    }

    @Override
    public RoundRectShape clone() throws CloneNotSupportedException {
        Path path;
        RectF rectF;
        RectF rectF2;
        RoundRectShape roundRectShape = (RoundRectShape)super.clone();
        float[] fArray = (float[])this.mOuterRadii.clone();
        roundRectShape.mOuterRadii = fArray;
        float[] fArray2 = (float[])this.mInnerRadii.clone();
        roundRectShape.mInnerRadii = fArray2;
        RectF rectF3 = this.mInset;
        roundRectShape.mInset = rectF2 = new RectF(rectF3);
        RectF rectF4 = this.mInnerRect;
        roundRectShape.mInnerRect = rectF = new RectF(rectF4);
        Path path2 = this.mPath;
        roundRectShape.mPath = path = new Path(path2);
        return roundRectShape;
    }

    @Override
    public void draw(Canvas canvas, Paint paint) {
        Path path = this.mPath;
        canvas.drawPath(path, paint);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onResize(float f, float f2) {
        super.onResize(f, f2);
        RectF rectF = this.rect();
        this.mPath.reset();
        if (this.mOuterRadii != null) {
            Path path = this.mPath;
            float[] fArray = this.mOuterRadii;
            Path.Direction direction = Path.Direction.CW;
            path.addRoundRect(rectF, fArray, direction);
        } else {
            Path path = this.mPath;
            Path.Direction direction = Path.Direction.CW;
            path.addRect(rectF, direction);
        }
        if (this.mInnerRect == null) {
            return;
        }
        RectF rectF2 = this.mInnerRect;
        float f3 = rectF.left;
        float f4 = this.mInset.left;
        float f5 = f3 + f4;
        float f6 = rectF.top;
        float f7 = this.mInset.top;
        float f8 = f6 + f7;
        float f9 = rectF.right;
        float f10 = this.mInset.right;
        float f11 = f9 - f10;
        float f12 = rectF.bottom;
        float f13 = this.mInset.bottom;
        float f14 = f12 - f13;
        rectF2.set(f5, f8, f11, f14);
        if (!(this.mInnerRect.width() < f)) {
            return;
        }
        if (!(this.mInnerRect.height() < f2)) {
            return;
        }
        if (this.mInnerRadii != null) {
            Path path = this.mPath;
            RectF rectF3 = this.mInnerRect;
            float[] fArray = this.mInnerRadii;
            Path.Direction direction = Path.Direction.CCW;
            path.addRoundRect(rectF3, fArray, direction);
            return;
        }
        Path path = this.mPath;
        RectF rectF4 = this.mInnerRect;
        Path.Direction direction = Path.Direction.CCW;
        path.addRect(rectF4, direction);
    }
}

