/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.Xfermode;

public class BoundaryPatch {
    private int mCols = 2;
    private float[] mCubicPoints;
    private boolean mDirty;
    private short[] mIndices;
    private Paint mPaint;
    private int mRows = 2;
    private Bitmap mTexture;
    private float[] mVerts;

    public BoundaryPatch() {
        Paint paint;
        float[] fArray = new float[24];
        this.mCubicPoints = fArray;
        this.mPaint = paint = new Paint();
        this.mPaint.setDither(true);
        this.mPaint.setFilterBitmap(true);
        this.mDirty = true;
    }

    private void buildCache() {
        int n = this.mRows;
        int n2 = this.mCols;
        int n3 = n * n2 * 4;
        if (this.mVerts == null || this.mVerts.length != n3) {
            float[] fArray = new float[n3];
            this.mVerts = fArray;
        }
        int n4 = this.mRows - 1;
        int n5 = this.mCols - 1;
        int n6 = n4 * n5 * 6;
        if (this.mIndices == null || this.mIndices.length != n6) {
            int n7 = n6;
            this.mIndices = (short[])n7;
        }
        float[] fArray = this.mCubicPoints;
        int n8 = this.mTexture.getWidth();
        int n9 = this.mTexture.getHeight();
        int n10 = this.mRows;
        int n11 = this.mCols;
        float[] fArray2 = this.mVerts;
        short[] sArray = this.mIndices;
        BoundaryPatch.nativeComputeCubicPatch(fArray, n8, n9, n10, n11, fArray2, sArray);
    }

    private static native void nativeComputeCubicPatch(float[] var0, int var1, int var2, int var3, int var4, float[] var5, short[] var6);

    public void draw(Canvas canvas) {
        if (this.mDirty) {
            this.buildCache();
            this.mDirty = false;
        }
        int n = this.mVerts.length >> 1;
        Canvas.VertexMode vertexMode = Canvas.VertexMode.TRIANGLES;
        float[] fArray = this.mVerts;
        float[] fArray2 = this.mVerts;
        short[] sArray = this.mIndices;
        int n2 = this.mIndices.length;
        Paint paint = this.mPaint;
        Canvas canvas2 = canvas;
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        canvas2.drawVertices(vertexMode, n, fArray, 0, fArray2, n3, null, n4, sArray, n5, n2, paint);
    }

    public int getPaintFlags() {
        return this.mPaint.getFlags();
    }

    public void setAlpha(int n) {
        this.mPaint.setAlpha(n);
    }

    public void setCubicBoundary(float[] fArray, int n, int n2, int n3) {
        if (n2 < 2 || n3 < 2) {
            throw new RuntimeException("rows and cols must be >= 2");
        }
        float[] fArray2 = this.mCubicPoints;
        System.arraycopy(fArray, n, fArray2, 0, 24);
        if (this.mRows == n2 || this.mCols != n3) {
            this.mRows = n2;
            this.mCols = n3;
        }
        this.mDirty = true;
    }

    public void setPaintFlags(int n) {
        this.mPaint.setFlags(n);
    }

    public void setTexture(Bitmap bitmap) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.mTexture == bitmap) {
            return;
        }
        if (this.mTexture == null || (n4 = this.mTexture.getWidth()) == (n3 = bitmap.getWidth()) || (n2 = this.mTexture.getHeight()) != (n = bitmap.getHeight())) {
            this.mDirty = true;
        }
        this.mTexture = bitmap;
        Paint paint = this.mPaint;
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        Shader.TileMode tileMode2 = Shader.TileMode.CLAMP;
        BitmapShader bitmapShader = new BitmapShader(bitmap, tileMode, tileMode2);
        Shader shader = paint.setShader(bitmapShader);
    }

    public void setXfermode(Xfermode xfermode) {
        Xfermode xfermode2 = this.mPaint.setXfermode(xfermode);
    }
}

