/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class Camera {
    public static final int CAMERA_ERROR_SERVER_DIED = 100;
    public static final int CAMERA_ERROR_UNKNOWN = 1;
    private static final int CAMERA_MSG_ALL_MSGS = 511;
    private static final int CAMERA_MSG_COMPRESSED_IMAGE = 256;
    private static final int CAMERA_MSG_ERROR = 1;
    private static final int CAMERA_MSG_FOCUS = 4;
    private static final int CAMERA_MSG_POSTVIEW_FRAME = 64;
    private static final int CAMERA_MSG_PREVIEW_FRAME = 16;
    private static final int CAMERA_MSG_RAW_IMAGE = 128;
    private static final int CAMERA_MSG_SHUTTER = 2;
    private static final int CAMERA_MSG_VIDEO_FRAME = 32;
    private static final int CAMERA_MSG_ZOOM = 8;
    private static final String TAG = "Camera";
    private AutoFocusCallback mAutoFocusCallback;
    private ErrorCallback mErrorCallback;
    private EventHandler mEventHandler;
    private PictureCallback mJpegCallback = null;
    private int mNativeContext;
    private boolean mOneShot;
    private PictureCallback mPostviewCallback = null;
    private PreviewCallback mPreviewCallback = null;
    private PictureCallback mRawImageCallback = null;
    private ShutterCallback mShutterCallback = null;
    private boolean mWithBuffer;
    private OnZoomChangeListener mZoomListener = null;

    /*
     * Enabled aggressive block sorting
     */
    Camera(int n) {
        EventHandler eventHandler;
        EventHandler eventHandler2;
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? (eventHandler2 = new EventHandler(this, looper)) : ((looper = Looper.getMainLooper()) != null ? (eventHandler = new EventHandler(this, looper)) : null);
        WeakReference<Camera> weakReference = new WeakReference<Camera>(this);
        this.native_setup(weakReference, n);
    }

    static /* synthetic */ PreviewCallback access$302(Camera camera, PreviewCallback previewCallback) {
        camera.mPreviewCallback = previewCallback;
        return previewCallback;
    }

    public static native void getCameraInfo(int var0, CameraInfo var1);

    public static native int getNumberOfCameras();

    private final native void native_autoFocus();

    private final native void native_cancelAutoFocus();

    private final native String native_getParameters();

    private final native void native_release();

    private final native void native_setParameters(String var1);

    private final native void native_setup(Object var1, int var2);

    private final native void native_takePicture();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Camera open() {
        int n = Camera.getNumberOfCameras();
        CameraInfo cameraInfo = new CameraInfo();
        int n2 = 0;
        while (n2 < n) {
            Camera.getCameraInfo(n2, cameraInfo);
            if (cameraInfo.facing == 0) {
                return new Camera(n2);
            }
            ++n2;
        }
        return null;
    }

    public static Camera open(int n) {
        return new Camera(n);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        Camera camera = (Camera)((WeakReference)object).get();
        if (camera == null) {
            return;
        }
        if (camera.mEventHandler == null) {
            return;
        }
        Message message = camera.mEventHandler.obtainMessage(n, n2, n3, object2);
        boolean bl = camera.mEventHandler.sendMessage(message);
    }

    private final native void setHasPreviewCallback(boolean var1, boolean var2);

    private final native void setPreviewDisplay(Surface var1);

    public final native void addCallbackBuffer(byte[] var1);

    public final void autoFocus(AutoFocusCallback autoFocusCallback) {
        this.mAutoFocusCallback = autoFocusCallback;
        this.native_autoFocus();
    }

    public final void cancelAutoFocus() {
        this.mAutoFocusCallback = null;
        this.native_cancelAutoFocus();
    }

    protected void finalize() {
        this.native_release();
    }

    public Parameters getParameters() {
        Parameters parameters = new Parameters();
        String string2 = this.native_getParameters();
        parameters.unflatten(string2);
        return parameters;
    }

    public final native void lock();

    public final native boolean previewEnabled();

    public final native void reconnect() throws IOException;

    public final void release() {
        this.native_release();
    }

    public final native void setDisplayOrientation(int var1);

    public final void setErrorCallback(ErrorCallback errorCallback) {
        this.mErrorCallback = errorCallback;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setOneShotPreviewCallback(PreviewCallback previewCallback) {
        boolean bl = true;
        this.mPreviewCallback = previewCallback;
        this.mOneShot = bl;
        this.mWithBuffer = false;
        if (previewCallback == null) {
            bl = false;
        }
        this.setHasPreviewCallback(bl, false);
    }

    public void setParameters(Parameters parameters) {
        String string2 = parameters.flatten();
        this.native_setParameters(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setPreviewCallback(PreviewCallback previewCallback) {
        this.mPreviewCallback = previewCallback;
        this.mOneShot = false;
        this.mWithBuffer = false;
        boolean bl = previewCallback != null;
        this.setHasPreviewCallback(bl, false);
    }

    public final void setPreviewCallbackWithBuffer(PreviewCallback previewCallback) {
        boolean bl = false;
        this.mPreviewCallback = previewCallback;
        this.mOneShot = bl;
        this.mWithBuffer = true;
        if (previewCallback != null) {
            bl = true;
        }
        this.setHasPreviewCallback(bl, true);
    }

    public final void setPreviewDisplay(SurfaceHolder surfaceHolder) throws IOException {
        if (surfaceHolder != null) {
            Surface surface = surfaceHolder.getSurface();
            this.setPreviewDisplay(surface);
            return;
        }
        Surface surface = null;
        this.setPreviewDisplay(surface);
    }

    public final void setZoomChangeListener(OnZoomChangeListener onZoomChangeListener) {
        this.mZoomListener = onZoomChangeListener;
    }

    public final native void startPreview();

    public final native void startSmoothZoom(int var1);

    public final native void stopPreview();

    public final native void stopSmoothZoom();

    public final void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback, PictureCallback pictureCallback2) {
        this.takePicture(shutterCallback, pictureCallback, null, pictureCallback2);
    }

    public final void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback, PictureCallback pictureCallback2, PictureCallback pictureCallback3) {
        this.mShutterCallback = shutterCallback;
        this.mRawImageCallback = pictureCallback;
        this.mPostviewCallback = pictureCallback2;
        this.mJpegCallback = pictureCallback3;
        this.native_takePicture();
    }

    public final native void unlock();

    public class Parameters {
        public static final String ANTIBANDING_50HZ = "50hz";
        public static final String ANTIBANDING_60HZ = "60hz";
        public static final String ANTIBANDING_AUTO = "auto";
        public static final String ANTIBANDING_OFF = "off";
        public static final String EFFECT_AQUA = "aqua";
        public static final String EFFECT_BLACKBOARD = "blackboard";
        public static final String EFFECT_MONO = "mono";
        public static final String EFFECT_NEGATIVE = "negative";
        public static final String EFFECT_NONE = "none";
        public static final String EFFECT_POSTERIZE = "posterize";
        public static final String EFFECT_SEPIA = "sepia";
        public static final String EFFECT_SOLARIZE = "solarize";
        public static final String EFFECT_WHITEBOARD = "whiteboard";
        public static final String FLASH_MODE_AUTO = "auto";
        public static final String FLASH_MODE_OFF = "off";
        public static final String FLASH_MODE_ON = "on";
        public static final String FLASH_MODE_RED_EYE = "red-eye";
        public static final String FLASH_MODE_TORCH = "torch";
        public static final int FOCUS_DISTANCE_FAR_INDEX = 2;
        public static final int FOCUS_DISTANCE_NEAR_INDEX = 0;
        public static final int FOCUS_DISTANCE_OPTIMAL_INDEX = 1;
        public static final String FOCUS_MODE_AUTO = "auto";
        public static final String FOCUS_MODE_CONTINUOUS_VIDEO = "continuous-video";
        public static final String FOCUS_MODE_EDOF = "edof";
        public static final String FOCUS_MODE_FIXED = "fixed";
        public static final String FOCUS_MODE_INFINITY = "infinity";
        public static final String FOCUS_MODE_MACRO = "macro";
        private static final String KEY_ANTIBANDING = "antibanding";
        private static final String KEY_EFFECT = "effect";
        private static final String KEY_EXPOSURE_COMPENSATION = "exposure-compensation";
        private static final String KEY_EXPOSURE_COMPENSATION_STEP = "exposure-compensation-step";
        private static final String KEY_FLASH_MODE = "flash-mode";
        private static final String KEY_FOCAL_LENGTH = "focal-length";
        private static final String KEY_FOCUS_DISTANCES = "focus-distances";
        private static final String KEY_FOCUS_MODE = "focus-mode";
        private static final String KEY_GPS_ALTITUDE = "gps-altitude";
        private static final String KEY_GPS_LATITUDE = "gps-latitude";
        private static final String KEY_GPS_LONGITUDE = "gps-longitude";
        private static final String KEY_GPS_PROCESSING_METHOD = "gps-processing-method";
        private static final String KEY_GPS_TIMESTAMP = "gps-timestamp";
        private static final String KEY_HORIZONTAL_VIEW_ANGLE = "horizontal-view-angle";
        private static final String KEY_JPEG_QUALITY = "jpeg-quality";
        private static final String KEY_JPEG_THUMBNAIL_HEIGHT = "jpeg-thumbnail-height";
        private static final String KEY_JPEG_THUMBNAIL_QUALITY = "jpeg-thumbnail-quality";
        private static final String KEY_JPEG_THUMBNAIL_SIZE = "jpeg-thumbnail-size";
        private static final String KEY_JPEG_THUMBNAIL_WIDTH = "jpeg-thumbnail-width";
        private static final String KEY_MAX_EXPOSURE_COMPENSATION = "max-exposure-compensation";
        private static final String KEY_MAX_ZOOM = "max-zoom";
        private static final String KEY_MIN_EXPOSURE_COMPENSATION = "min-exposure-compensation";
        private static final String KEY_PICTURE_FORMAT = "picture-format";
        private static final String KEY_PICTURE_SIZE = "picture-size";
        private static final String KEY_PREVIEW_FORMAT = "preview-format";
        private static final String KEY_PREVIEW_FPS_RANGE = "preview-fps-range";
        private static final String KEY_PREVIEW_FRAME_RATE = "preview-frame-rate";
        private static final String KEY_PREVIEW_SIZE = "preview-size";
        private static final String KEY_ROTATION = "rotation";
        private static final String KEY_SCENE_MODE = "scene-mode";
        private static final String KEY_SMOOTH_ZOOM_SUPPORTED = "smooth-zoom-supported";
        private static final String KEY_VERTICAL_VIEW_ANGLE = "vertical-view-angle";
        private static final String KEY_WHITE_BALANCE = "whitebalance";
        private static final String KEY_ZOOM = "zoom";
        private static final String KEY_ZOOM_RATIOS = "zoom-ratios";
        private static final String KEY_ZOOM_SUPPORTED = "zoom-supported";
        private static final String PIXEL_FORMAT_JPEG = "jpeg";
        private static final String PIXEL_FORMAT_RGB565 = "rgb565";
        private static final String PIXEL_FORMAT_YUV420SP = "yuv420sp";
        private static final String PIXEL_FORMAT_YUV422I = "yuv422i-yuyv";
        private static final String PIXEL_FORMAT_YUV422SP = "yuv422sp";
        public static final int PREVIEW_FPS_MAX_INDEX = 1;
        public static final int PREVIEW_FPS_MIN_INDEX = 0;
        public static final String SCENE_MODE_ACTION = "action";
        public static final String SCENE_MODE_AUTO = "auto";
        public static final String SCENE_MODE_BARCODE = "barcode";
        public static final String SCENE_MODE_BEACH = "beach";
        public static final String SCENE_MODE_CANDLELIGHT = "candlelight";
        public static final String SCENE_MODE_FIREWORKS = "fireworks";
        public static final String SCENE_MODE_LANDSCAPE = "landscape";
        public static final String SCENE_MODE_NIGHT = "night";
        public static final String SCENE_MODE_NIGHT_PORTRAIT = "night-portrait";
        public static final String SCENE_MODE_PARTY = "party";
        public static final String SCENE_MODE_PORTRAIT = "portrait";
        public static final String SCENE_MODE_SNOW = "snow";
        public static final String SCENE_MODE_SPORTS = "sports";
        public static final String SCENE_MODE_STEADYPHOTO = "steadyphoto";
        public static final String SCENE_MODE_SUNSET = "sunset";
        public static final String SCENE_MODE_THEATRE = "theatre";
        private static final String SUPPORTED_VALUES_SUFFIX = "-values";
        private static final String TRUE = "true";
        public static final String WHITE_BALANCE_AUTO = "auto";
        public static final String WHITE_BALANCE_CLOUDY_DAYLIGHT = "cloudy-daylight";
        public static final String WHITE_BALANCE_DAYLIGHT = "daylight";
        public static final String WHITE_BALANCE_FLUORESCENT = "fluorescent";
        public static final String WHITE_BALANCE_INCANDESCENT = "incandescent";
        public static final String WHITE_BALANCE_SHADE = "shade";
        public static final String WHITE_BALANCE_TWILIGHT = "twilight";
        public static final String WHITE_BALANCE_WARM_FLUORESCENT = "warm-fluorescent";
        private HashMap<String, String> mMap;

        private Parameters() {
            HashMap hashMap = new HashMap();
            this.mMap = hashMap;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String cameraFormatForPixelFormat(int n) {
            switch (n) {
                default: {
                    return null;
                }
                case 16: {
                    return PIXEL_FORMAT_YUV422SP;
                }
                case 17: {
                    return PIXEL_FORMAT_YUV420SP;
                }
                case 20: {
                    return PIXEL_FORMAT_YUV422I;
                }
                case 4: {
                    return PIXEL_FORMAT_RGB565;
                }
                case 256: 
            }
            return PIXEL_FORMAT_JPEG;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private float getFloat(String string2, float f) {
            try {
                float f2 = Float.parseFloat(this.mMap.get(string2));
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int getInt(String string2, int n) {
            try {
                int n2 = Integer.parseInt(this.mMap.get(string2));
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int pixelFormatForCameraFormat(String string2) {
            if (string2 == null) {
                return 0;
            }
            if (string2.equals(PIXEL_FORMAT_YUV422SP)) {
                return 16;
            }
            if (string2.equals(PIXEL_FORMAT_YUV420SP)) {
                return 17;
            }
            if (string2.equals(PIXEL_FORMAT_YUV422I)) {
                return 20;
            }
            if (string2.equals(PIXEL_FORMAT_RGB565)) {
                return 4;
            }
            if (!string2.equals(PIXEL_FORMAT_JPEG)) return 0;
            return 256;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ArrayList<String> split(String string2) {
            if (string2 == null) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                boolean bl = arrayList.add(string3);
            }
            return arrayList;
        }

        private void splitFloat(String string2, float[] fArray) {
            if (string2 == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                float f;
                String string3 = stringTokenizer.nextToken();
                int n2 = n + 1;
                fArray[n] = f = Float.parseFloat(string3);
                n = n2;
            }
            return;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ArrayList<Integer> splitInt(String string2) {
            if (string2 == null) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (stringTokenizer.hasMoreElements()) {
                Integer n = Integer.parseInt(stringTokenizer.nextToken());
                boolean bl = arrayList.add(n);
            }
            if (arrayList.size() != 0) return arrayList;
            return null;
        }

        private void splitInt(String string2, int[] nArray) {
            if (string2 == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                int n2;
                String string3 = stringTokenizer.nextToken();
                int n3 = n + 1;
                nArray[n] = n2 = Integer.parseInt(string3);
                n = n3;
            }
            return;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ArrayList<int[]> splitRange(String string2) {
            int n;
            int n2;
            int n3;
            if (string2 == null || string2.charAt(0) != '(' || string2.charAt(n3 = string2.length() - 1) != ')') {
                String string3 = "Invalid range list string=" + string2;
                int n4 = Log.e(Camera.TAG, string3);
                return null;
            }
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            int n5 = 1;
            do {
                int[] nArray = new int[2];
                n2 = string2.indexOf("),(", n5);
                if (n2 == -1) {
                    n2 = string2.length() - 1;
                }
                String string4 = string2.substring(n5, n2);
                this.splitInt(string4, nArray);
                boolean bl = arrayList.add(nArray);
                n5 = n2 + 3;
            } while (n2 == (n = string2.length() - 1));
            if (arrayList.size() != 0) return arrayList;
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ArrayList<Size> splitSize(String string2) {
            if (string2 == null) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            ArrayList<Size> arrayList = new ArrayList<Size>();
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                Size size = this.strToSize(string3);
                if (size == null) continue;
                boolean bl = arrayList.add(size);
            }
            if (arrayList.size() != 0) return arrayList;
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Size strToSize(String string2) {
            if (string2 == null) {
                return null;
            }
            int n = string2.indexOf(120);
            if (n != -1) {
                String string3 = string2.substring(0, n);
                int n2 = n + 1;
                String string4 = string2.substring(n2);
                Camera camera = Camera.this;
                int n3 = Integer.parseInt(string3);
                int n4 = Integer.parseInt(string4);
                return camera.new Size(n3, n4);
            }
            String string5 = "Invalid size parameter string=" + string2;
            int n5 = Log.e(Camera.TAG, string5);
            return null;
        }

        public void dump() {
            StringBuilder stringBuilder = new StringBuilder().append("dump: size=");
            int n = this.mMap.size();
            String string2 = stringBuilder.append(n).toString();
            int n2 = Log.e(Camera.TAG, string2);
            Iterator<String> iterator = this.mMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                StringBuilder stringBuilder2 = new StringBuilder().append("dump: ").append(string3).append("=");
                String string4 = this.mMap.get(string3);
                String string5 = stringBuilder2.append(string4).toString();
                int n3 = Log.e(Camera.TAG, string5);
            }
            return;
        }

        public String flatten() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : this.mMap.keySet()) {
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
                StringBuilder stringBuilder3 = stringBuilder.append("=");
                String string3 = this.mMap.get(string2);
                StringBuilder stringBuilder4 = stringBuilder.append(string3);
                StringBuilder stringBuilder5 = stringBuilder.append(";");
            }
            int n = stringBuilder.length() - 1;
            StringBuilder stringBuilder6 = stringBuilder.deleteCharAt(n);
            return stringBuilder.toString();
        }

        public String get(String string2) {
            return this.mMap.get(string2);
        }

        public String getAntibanding() {
            return this.get(KEY_ANTIBANDING);
        }

        public String getColorEffect() {
            return this.get(KEY_EFFECT);
        }

        public int getExposureCompensation() {
            return this.getInt(KEY_EXPOSURE_COMPENSATION, 0);
        }

        public float getExposureCompensationStep() {
            return this.getFloat(KEY_EXPOSURE_COMPENSATION_STEP, 0.0f);
        }

        public String getFlashMode() {
            return this.get(KEY_FLASH_MODE);
        }

        public float getFocalLength() {
            return Float.parseFloat(this.get(KEY_FOCAL_LENGTH));
        }

        public void getFocusDistances(float[] fArray) {
            if (fArray == null || fArray.length != 3) {
                throw new IllegalArgumentException("output must be an float array with three elements.");
            }
            String string2 = this.get(KEY_FOCUS_DISTANCES);
            this.splitFloat(string2, fArray);
        }

        public String getFocusMode() {
            return this.get(KEY_FOCUS_MODE);
        }

        public float getHorizontalViewAngle() {
            return Float.parseFloat(this.get(KEY_HORIZONTAL_VIEW_ANGLE));
        }

        public int getInt(String string2) {
            return Integer.parseInt(this.mMap.get(string2));
        }

        public int getJpegQuality() {
            return this.getInt(KEY_JPEG_QUALITY);
        }

        public int getJpegThumbnailQuality() {
            return this.getInt(KEY_JPEG_THUMBNAIL_QUALITY);
        }

        public Size getJpegThumbnailSize() {
            Camera camera = Camera.this;
            int n = this.getInt(KEY_JPEG_THUMBNAIL_WIDTH);
            int n2 = this.getInt(KEY_JPEG_THUMBNAIL_HEIGHT);
            return camera.new Size(n, n2);
        }

        public int getMaxExposureCompensation() {
            return this.getInt(KEY_MAX_EXPOSURE_COMPENSATION, 0);
        }

        public int getMaxZoom() {
            return this.getInt(KEY_MAX_ZOOM, 0);
        }

        public int getMinExposureCompensation() {
            return this.getInt(KEY_MIN_EXPOSURE_COMPENSATION, 0);
        }

        public int getPictureFormat() {
            String string2 = this.get(KEY_PICTURE_FORMAT);
            return this.pixelFormatForCameraFormat(string2);
        }

        public Size getPictureSize() {
            String string2 = this.get(KEY_PICTURE_SIZE);
            return this.strToSize(string2);
        }

        public int getPreviewFormat() {
            String string2 = this.get(KEY_PREVIEW_FORMAT);
            return this.pixelFormatForCameraFormat(string2);
        }

        public void getPreviewFpsRange(int[] nArray) {
            if (nArray == null || nArray.length != 2) {
                throw new IllegalArgumentException("range must be an array with two elements.");
            }
            String string2 = this.get(KEY_PREVIEW_FPS_RANGE);
            this.splitInt(string2, nArray);
        }

        @Deprecated
        public int getPreviewFrameRate() {
            return this.getInt(KEY_PREVIEW_FRAME_RATE);
        }

        public Size getPreviewSize() {
            String string2 = this.get(KEY_PREVIEW_SIZE);
            return this.strToSize(string2);
        }

        public String getSceneMode() {
            return this.get(KEY_SCENE_MODE);
        }

        public List<String> getSupportedAntibanding() {
            String string2 = this.get("antibanding-values");
            return this.split(string2);
        }

        public List<String> getSupportedColorEffects() {
            String string2 = this.get("effect-values");
            return this.split(string2);
        }

        public List<String> getSupportedFlashModes() {
            String string2 = this.get("flash-mode-values");
            return this.split(string2);
        }

        public List<String> getSupportedFocusModes() {
            String string2 = this.get("focus-mode-values");
            return this.split(string2);
        }

        public List<Size> getSupportedJpegThumbnailSizes() {
            String string2 = this.get("jpeg-thumbnail-size-values");
            return this.splitSize(string2);
        }

        public List<Integer> getSupportedPictureFormats() {
            String string2 = this.get("picture-format-values");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (String string3 : this.split(string2)) {
                int n = this.pixelFormatForCameraFormat(string3);
                if (n == 0) continue;
                Integer n2 = n;
                boolean bl = arrayList.add(n2);
            }
            return arrayList;
        }

        public List<Size> getSupportedPictureSizes() {
            String string2 = this.get("picture-size-values");
            return this.splitSize(string2);
        }

        public List<Integer> getSupportedPreviewFormats() {
            String string2 = this.get("preview-format-values");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (String string3 : this.split(string2)) {
                int n = this.pixelFormatForCameraFormat(string3);
                if (n == 0) continue;
                Integer n2 = n;
                boolean bl = arrayList.add(n2);
            }
            return arrayList;
        }

        public List<int[]> getSupportedPreviewFpsRange() {
            String string2 = this.get("preview-fps-range-values");
            return this.splitRange(string2);
        }

        @Deprecated
        public List<Integer> getSupportedPreviewFrameRates() {
            String string2 = this.get("preview-frame-rate-values");
            return this.splitInt(string2);
        }

        public List<Size> getSupportedPreviewSizes() {
            String string2 = this.get("preview-size-values");
            return this.splitSize(string2);
        }

        public List<String> getSupportedSceneModes() {
            String string2 = this.get("scene-mode-values");
            return this.split(string2);
        }

        public List<String> getSupportedWhiteBalance() {
            String string2 = this.get("whitebalance-values");
            return this.split(string2);
        }

        public float getVerticalViewAngle() {
            return Float.parseFloat(this.get(KEY_VERTICAL_VIEW_ANGLE));
        }

        public String getWhiteBalance() {
            return this.get(KEY_WHITE_BALANCE);
        }

        public int getZoom() {
            return this.getInt(KEY_ZOOM, 0);
        }

        public List<Integer> getZoomRatios() {
            String string2 = this.get(KEY_ZOOM_RATIOS);
            return this.splitInt(string2);
        }

        public boolean isSmoothZoomSupported() {
            String string2 = this.get(KEY_SMOOTH_ZOOM_SUPPORTED);
            return TRUE.equals(string2);
        }

        public boolean isZoomSupported() {
            String string2 = this.get(KEY_ZOOM_SUPPORTED);
            return TRUE.equals(string2);
        }

        public void remove(String string2) {
            String string3 = this.mMap.remove(string2);
        }

        public void removeGpsData() {
            this.remove(KEY_GPS_LATITUDE);
            this.remove(KEY_GPS_LONGITUDE);
            this.remove(KEY_GPS_ALTITUDE);
            this.remove(KEY_GPS_TIMESTAMP);
            this.remove(KEY_GPS_PROCESSING_METHOD);
        }

        public void set(String string2, int n) {
            HashMap<String, String> hashMap = this.mMap;
            String string3 = Integer.toString(n);
            String string4 = hashMap.put(string2, string3);
        }

        public void set(String string2, String string3) {
            if (string2.indexOf(61) != -1 || string2.indexOf(59) != -1) {
                String string4 = "Key \"" + string2 + "\" contains invalid character (= or ;)";
                int n = Log.e(Camera.TAG, string4);
                return;
            }
            if (string3.indexOf(61) != -1 || string3.indexOf(59) != -1) {
                String string5 = "Value \"" + string3 + "\" contains invalid character (= or ;)";
                int n = Log.e(Camera.TAG, string5);
                return;
            }
            String string6 = this.mMap.put(string2, string3);
        }

        public void setAntibanding(String string2) {
            this.set(KEY_ANTIBANDING, string2);
        }

        public void setColorEffect(String string2) {
            this.set(KEY_EFFECT, string2);
        }

        public void setExposureCompensation(int n) {
            this.set(KEY_EXPOSURE_COMPENSATION, n);
        }

        public void setFlashMode(String string2) {
            this.set(KEY_FLASH_MODE, string2);
        }

        public void setFocusMode(String string2) {
            this.set(KEY_FOCUS_MODE, string2);
        }

        public void setGpsAltitude(double d) {
            String string2 = Double.toString(d);
            this.set(KEY_GPS_ALTITUDE, string2);
        }

        public void setGpsLatitude(double d) {
            String string2 = Double.toString(d);
            this.set(KEY_GPS_LATITUDE, string2);
        }

        public void setGpsLongitude(double d) {
            String string2 = Double.toString(d);
            this.set(KEY_GPS_LONGITUDE, string2);
        }

        public void setGpsProcessingMethod(String string2) {
            this.set(KEY_GPS_PROCESSING_METHOD, string2);
        }

        public void setGpsTimestamp(long l) {
            String string2 = Long.toString(l);
            this.set(KEY_GPS_TIMESTAMP, string2);
        }

        public void setJpegQuality(int n) {
            this.set(KEY_JPEG_QUALITY, n);
        }

        public void setJpegThumbnailQuality(int n) {
            this.set(KEY_JPEG_THUMBNAIL_QUALITY, n);
        }

        public void setJpegThumbnailSize(int n, int n2) {
            this.set(KEY_JPEG_THUMBNAIL_WIDTH, n);
            this.set(KEY_JPEG_THUMBNAIL_HEIGHT, n2);
        }

        public void setPictureFormat(int n) {
            String string2 = this.cameraFormatForPixelFormat(n);
            if (string2 == null) {
                String string3 = "Invalid pixel_format=" + n;
                throw new IllegalArgumentException(string3);
            }
            this.set(KEY_PICTURE_FORMAT, string2);
        }

        public void setPictureSize(int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = Integer.toString(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append("x");
            String string3 = Integer.toString(n2);
            String string4 = stringBuilder2.append(string3).toString();
            this.set(KEY_PICTURE_SIZE, string4);
        }

        public void setPreviewFormat(int n) {
            String string2 = this.cameraFormatForPixelFormat(n);
            if (string2 == null) {
                String string3 = "Invalid pixel_format=" + n;
                throw new IllegalArgumentException(string3);
            }
            this.set(KEY_PREVIEW_FORMAT, string2);
        }

        public void setPreviewFpsRange(int n, int n2) {
            String string2 = "" + n + "," + n2;
            this.set(KEY_PREVIEW_FPS_RANGE, string2);
        }

        @Deprecated
        public void setPreviewFrameRate(int n) {
            this.set(KEY_PREVIEW_FRAME_RATE, n);
        }

        public void setPreviewSize(int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = Integer.toString(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append("x");
            String string3 = Integer.toString(n2);
            String string4 = stringBuilder2.append(string3).toString();
            this.set(KEY_PREVIEW_SIZE, string4);
        }

        public void setRotation(int n) {
            if (n == 0 || n == 90 || n == 180 || n == 270) {
                String string2 = Integer.toString(n);
                this.set(KEY_ROTATION, string2);
                return;
            }
            String string3 = "Invalid rotation=" + n;
            throw new IllegalArgumentException(string3);
        }

        public void setSceneMode(String string2) {
            this.set(KEY_SCENE_MODE, string2);
        }

        public void setWhiteBalance(String string2) {
            this.set(KEY_WHITE_BALANCE, string2);
        }

        public void setZoom(int n) {
            this.set(KEY_ZOOM, n);
        }

        public void unflatten(String string2) {
            this.mMap.clear();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                int n = string3.indexOf(61);
                if (n == -1) continue;
                String string4 = string3.substring(0, n);
                int n2 = n + 1;
                String string5 = string3.substring(n2);
                String string6 = this.mMap.put(string4, string5);
            }
            return;
        }
    }

    public class Size {
        public int height;
        public int width;

        public Size(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof Size)) {
                return false;
            }
            Size size = (Size)object;
            int n = this.width;
            int n2 = size.width;
            if (n == n2) return false;
            int n3 = this.height;
            int n4 = size.height;
            if (n3 == n4) return false;
            return true;
        }

        public int hashCode() {
            int n = this.width * 32713;
            int n2 = this.height;
            return n + n2;
        }
    }

    public static interface ErrorCallback {
        public void onError(int var1, Camera var2);
    }

    public static interface OnZoomChangeListener {
        public void onZoomChange(int var1, boolean var2, Camera var3);
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1, Camera var2);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static interface AutoFocusCallback {
        public void onAutoFocus(boolean var1, Camera var2);
    }

    private class EventHandler
    extends Handler {
        private Camera mCamera;

        public EventHandler(Camera camera2, Looper looper) {
            super(looper);
            this.mCamera = camera2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown message type ");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.e(Camera.TAG, string2);
                    return;
                }
                case 2: {
                    if (Camera.this.mShutterCallback == null) {
                        return;
                    }
                    Camera.this.mShutterCallback.onShutter();
                    return;
                }
                case 128: {
                    if (Camera.this.mRawImageCallback == null) {
                        return;
                    }
                    PictureCallback pictureCallback = Camera.this.mRawImageCallback;
                    byte[] byArray = (byte[])message.obj;
                    Camera camera = this.mCamera;
                    pictureCallback.onPictureTaken(byArray, camera);
                    return;
                }
                case 256: {
                    if (Camera.this.mJpegCallback == null) {
                        return;
                    }
                    PictureCallback pictureCallback = Camera.this.mJpegCallback;
                    byte[] byArray = (byte[])message.obj;
                    Camera camera = this.mCamera;
                    pictureCallback.onPictureTaken(byArray, camera);
                    return;
                }
                case 16: {
                    if (Camera.this.mPreviewCallback == null) {
                        return;
                    }
                    PreviewCallback previewCallback = Camera.this.mPreviewCallback;
                    if (Camera.this.mOneShot) {
                        PreviewCallback previewCallback2 = Camera.access$302(Camera.this, null);
                    } else if (!Camera.this.mWithBuffer) {
                        Camera.this.setHasPreviewCallback(true, false);
                    }
                    byte[] byArray = (byte[])message.obj;
                    Camera camera = this.mCamera;
                    previewCallback.onPreviewFrame(byArray, camera);
                    return;
                }
                case 64: {
                    if (Camera.this.mPostviewCallback == null) {
                        return;
                    }
                    PictureCallback pictureCallback = Camera.this.mPostviewCallback;
                    byte[] byArray = (byte[])message.obj;
                    Camera camera = this.mCamera;
                    pictureCallback.onPictureTaken(byArray, camera);
                    return;
                }
                case 4: {
                    if (Camera.this.mAutoFocusCallback == null) {
                        return;
                    }
                    AutoFocusCallback autoFocusCallback = Camera.this.mAutoFocusCallback;
                    boolean bl = message.arg1 != 0;
                    Camera camera = this.mCamera;
                    autoFocusCallback.onAutoFocus(bl, camera);
                    return;
                }
                case 8: {
                    if (Camera.this.mZoomListener == null) {
                        return;
                    }
                    OnZoomChangeListener onZoomChangeListener = Camera.this.mZoomListener;
                    int n = message.arg1;
                    boolean bl = message.arg2 != 0;
                    Camera camera = this.mCamera;
                    onZoomChangeListener.onZoomChange(n, bl, camera);
                    return;
                }
                case 1: 
            }
            StringBuilder stringBuilder = new StringBuilder().append("Error ");
            int n = message.arg1;
            String string3 = stringBuilder.append(n).toString();
            int n3 = Log.e(Camera.TAG, string3);
            if (Camera.this.mErrorCallback == null) {
                return;
            }
            ErrorCallback errorCallback = Camera.this.mErrorCallback;
            int n4 = message.arg1;
            Camera camera = this.mCamera;
            errorCallback.onError(n4, camera);
        }
    }

    public static interface PreviewCallback {
        public void onPreviewFrame(byte[] var1, Camera var2);
    }

    public static class CameraInfo {
        public static final int CAMERA_FACING_BACK = 0;
        public static final int CAMERA_FACING_FRONT = 1;
        public int facing;
        public int orientation;
    }
}

