/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import java.util.GregorianCalendar;

public class GeomagneticField {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final long BASE_TIME = 0L;
    private static final float[][] DELTA_G;
    private static final float[][] DELTA_H;
    private static final float EARTH_REFERENCE_RADIUS_KM = 6371.2f;
    private static final float EARTH_SEMI_MAJOR_AXIS_KM = 6378.137f;
    private static final float EARTH_SEMI_MINOR_AXIS_KM = 6356.7524f;
    private static final float[][] G_COEFF;
    private static final float[][] H_COEFF;
    private static final float[][] SCHMIDT_QUASI_NORM_FACTORS;
    private float mGcLatitudeRad;
    private float mGcLongitudeRad;
    private float mGcRadiusKm;
    private float mX;
    private float mY;
    private float mZ;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !GeomagneticField.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        float[] fArray = new float[13];
        float[] fArray2 = new float[]{0.0f};
        fArray[0] = (float)fArray2;
        float[] fArray3 = new float[]{-957976269, -993637990};
        fArray[1] = (float)fArray3;
        float[] fArray4 = new float[]{-988427878, 1161634202, 1154519859};
        fArray[2] = (float)fArray4;
        float[] fArray5 = new float[]{1151828787, -988716237, 1150942413, 1142849536};
        fArray[3] = (float)fArray5;
        float[] fArray6 = new float[]{0x44642666, 1145715098, 1126609715, -1011708723, 1119014093};
        fArray[4] = (float)fArray6;
        float[] fArray7 = new float[]{-1016666522, 1135778202, 1128811725, -1022551654, -1021116416, -1057384038};
        fArray[5] = (float)fArray7;
        float[] fArray8 = new float[]{1116838298, 1116287795, 1117257728, -1022531994, -1045010842, 1095971635, -1029976883};
        fArray[6] = (float)fArray8;
        float[] fArray9 = new float[]{1117847552, -1030343885, -1063885210, 1110782771, 1096705638, 1093035622, 1071225242, 1084017869};
        fArray[7] = (float)fArray9;
        float[] fArray10 = new float[]{1103311667, 1090623898, -1050148864, -1061997773, -1046845850, 1094189056, 1093559910, -1050568294, -1066611507};
        fArray[8] = (float)fArray10;
        float[] fArray11 = new float[]{1085066445, 0x41166666, 1079613850, -1062836634, 0x40466666, -1052350874, -1087163597, 1090938470, -1056440320, -1054762598};
        fArray[9] = (float)fArray11;
        float[] fArray12 = new float[]{-1073741824, -1060529766, 0x3F666666, -1081291571, -1102263091, 0x40200000, -1097229926, 1074580685, 0x40466666, -1082130432, -1070386381};
        fArray[10] = (float)fArray12;
        float[] fArray13 = new float[]{0x40400000, -1077936128, -1073322394, 1071225242, -1090519040, 0x3F000000, -1085485875, 1053609165, 1072064102, 0x3DCCCCCD, 0x3F333333, 1081291571};
        fArray[11] = (float)fArray13;
        float[] fArray14 = new float[]{-1072902963, -1102263091, 1050253722, 1065353216, -1088841318, 0x3F666666, -1110651699, 0x3F000000, -1093874483, -1093874483, 1045220557, -1085485875, 0.0f};
        fArray[12] = (float)fArray14;
        G_COEFF = (float[][])fArray;
        float[] fArray15 = new float[13];
        float[] fArray16 = new float[]{0.0f};
        fArray15[0] = (float)fArray16;
        float[] fArray17 = new float[]{0.0f, 1167754035};
        fArray15[1] = (float)fArray17;
        float[] fArray18 = new float[]{0.0f, -987153613, -1005582746};
        fArray15[2] = (float)fArray18;
        float[] fArray19 = new float[]{0.0f, -1021299917, 1132193382, -1006229914};
        fArray15[3] = (float)fArray19;
        float[] fArray20 = new float[]{0.0f, 1133458227, -1017957581, 1126452429, -1013281587};
        fArray15[4] = (float)fArray20;
        float[] fArray21 = new float[]{0.0f, 1110599270, 1128064614, -1024694682, 0.0f, 1120521421};
        fArray15[5] = (float)fArray21;
        float[] fArray22 = new float[]{0.0f, -1046059418, 1110468198, 1115029504, -1031497318, 0x40466666, 1113325568};
        fArray15[6] = (float)fArray22;
        float[] fArray23 = new float[]{0.0f, -1033397862, -1045902131, 0x40D00000, 1103573811, 0x40E00000, -1042441830, -1068289229};
        fArray15[7] = (float)fArray23;
        float[] fArray24 = new float[]{0.0f, 1093664768, -1046478848, 1094608486, -1047841997, 1099274650, 0x40E00000, -1054028595, 1071225242};
        fArray15[8] = (float)fArray24;
        float[] fArray25 = new float[]{0.0f, -1046216704, 1094189056, 1095552205, -1058642330, -1058222899, 0x41000000, 0x40066666, -1060949197, 0x40E00000};
        fArray15[9] = (float)fArray25;
        float[] fArray26 = new float[]{0.0f, 0x40333333, -1110651699, 1083598438, 1082969293, -1058642330, -1082130432, -1065772646, -1073741824, -1073741824, -1056650035};
        fArray15[10] = (float)fArray26;
        float[] fArray27 = new float[]{0.0f, 1045220557, 1071225242, -1088841318, -1075419546, 0x3F666666, -1093874483, -1071644672, -1079613850, -1073322394, -1074580685, -1075419546};
        fArray15[11] = (float)fArray27;
        float[] fArray28 = new float[]{0.0f, -1083808154, 1050253722, 0x40066666, -1071644672, 0x3F000000, 1058642330, 0.0f, 0x3DCCCCCD, 1050253722, -1083808154, -1102263091, 0x3F666666};
        fArray15[12] = (float)fArray28;
        H_COEFF = (float[][])fArray15;
        float[] fArray29 = new float[13];
        float[] fArray30 = new float[]{0.0f};
        fArray29[0] = (float)fArray30;
        float[] fArray31 = new float[]{1094293914, 1099169792};
        fArray29[1] = (float)fArray31;
        float[] fArray32 = new float[]{-1052665446, -1064514355, 0x3FF33333};
        fArray29[2] = (float)fArray32;
        float[] fArray33 = new float[]{1053609165, -1065143501, -1069966950, -1057593754};
        fArray29[3] = (float)fArray33;
        float[] fArray34 = new float[]{-1075419546, 1075000115, -1056230605, 1083388723, -1073322394};
        fArray29[4] = (float)fArray34;
        float[] fArray35 = new float[]{-1082130432, 1058642330, -1075419546, -1082130432, 0x3F666666, 1065353216};
        fArray29[5] = (float)fArray35;
        float[] fArray36 = new float[]{-1102263091, -1102263091, -1110651699, 0x40000000, -1076258406, -1097229926, 1071225242};
        fArray29[6] = (float)fArray36;
        float[] fArray37 = new float[]{0x3DCCCCCD, -1110651699, -1088841318, 1067869798, 1053609165, 1050253722, -1087163597, 1058642330};
        fArray29[7] = (float)fArray37;
        float[] fArray38 = new float[]{-1110651699, 0x3DCCCCCD, -1088841318, 1045220557, -1102263091, 1050253722, 1050253722, -1088841318, 1045220557};
        fArray29[8] = (float)fArray38;
        float[] fArray39 = new float[]{0.0f, -1110651699, 0.0f, 1050253722, -1093874483, -1097229926, 0x3DCCCCCD, -1110651699, -1093874483, -1102263091};
        fArray29[9] = (float)fArray39;
        float[] fArray40 = new float[]{0.0f, 0.0f, -1110651699, 1045220557, 0.0f, -1110651699, -1102263091, 0.0f, -1110651699, -1102263091, -1102263091};
        fArray29[10] = (float)fArray40;
        float[] fArray41 = new float[]{0.0f, 0.0f, 0.0f, 0x3DCCCCCD, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1110651699, 0.0f};
        fArray29[11] = (float)fArray41;
        float[] fArray42 = new float[]{0.0f, 0.0f, 0x3DCCCCCD, 0x3DCCCCCD, -1110651699, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1110651699, 0x3DCCCCCD};
        fArray29[12] = (float)fArray42;
        DELTA_G = (float[][])fArray29;
        float[] fArray43 = new float[13];
        float[] fArray44 = new float[]{0.0f};
        fArray43[0] = (float)fArray44;
        float[] fArray45 = new float[]{0.0f, -1043385549};
        fArray43[1] = (float)fArray45;
        float[] fArray46 = new float[]{0.0f, -1045168128, -1052980019};
        fArray43[2] = (float)fArray46;
        float[] fArray47 = new float[]{0.0f, 1089051034, -1065772646, -1071225242};
        fArray43[3] = (float)fArray47;
        float[] fArray48 = new float[]{0.0f, 1066192077, 1076677837, 1081711002, -1085485875};
        fArray43[4] = (float)fArray48;
        float[] fArray49 = new float[]{0.0f, 1053609165, 1072064102, 1067030938, 0x40800000, -1088841318};
        fArray43[5] = (float)fArray49;
        float[] fArray50 = new float[]{0.0f, -1102263091, -1073322394, -1093874483, -1088841318, 0x3F000000, 0x3F666666};
        fArray43[6] = (float)fArray50;
        float[] fArray51 = new float[]{0.0f, 0x3F333333, 1050253722, -1110651699, -1110651699, -1085485875, -1097229926, 1050253722};
        fArray43[7] = (float)fArray51;
        float[] fArray52 = new float[]{0.0f, -1110651699, 1045220557, 1053609165, 1053609165, 0x3DCCCCCD, -1110651699, 1053609165, 1050253722};
        fArray43[8] = (float)fArray52;
        float[] fArray53 = new float[]{0.0f, 0.0f, -1102263091, 0.0f, -1110651699, 0x3DCCCCCD, 0.0f, -1102263091, 1050253722, 1045220557};
        fArray43[9] = (float)fArray53;
        float[] fArray54 = new float[]{0.0f, 0x3DCCCCCD, -1110651699, 0.0f, -1110651699, -1110651699, 0.0f, -1110651699, -1102263091, 0.0f, -1110651699};
        fArray43[10] = (float)fArray54;
        float[] fArray55 = new float[]{0.0f, 0.0f, 0x3DCCCCCD, 0.0f, 0x3DCCCCCD, 0.0f, 0x3DCCCCCD, 0.0f, -1110651699, -1110651699, 0.0f, -1110651699};
        fArray43[11] = (float)fArray55;
        float[] fArray56 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0x3DCCCCCD, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        fArray43[12] = (float)fArray56;
        DELTA_H = (float[][])fArray43;
        BASE_TIME = new GregorianCalendar(2010, 1, 1).getTimeInMillis();
        SCHMIDT_QUASI_NORM_FACTORS = GeomagneticField.computeSchmidtQuasiNormFactors(G_COEFF.length);
    }

    public GeomagneticField(float f, float f2, float f3, long l) {
        float f4;
        float f5;
        float f6;
        int n;
        int n2;
        int n3;
        float f7;
        float f8;
        int n4;
        int n5;
        int n6;
        float f9;
        LegendreTable legendreTable;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = G_COEFF.length;
        float f10 = -89.99999f;
        float f11 = f;
        float f12 = Math.max(f10, f11);
        float f13 = Math.min(89.99999f, f12);
        this.computeGeocentricCoordinates(f13, f2, f3);
        if (!$assertionsDisabled && (n10 = (n9 = G_COEFF.length)) != (n8 = (n7 = H_COEFF.length))) {
            throw new AssertionError();
        }
        int n12 = n11 - 1;
        double d = this.mGcLatitudeRad;
        float f14 = (float)(1.5707963267948966 - d);
        LegendreTable legendreTable2 = legendreTable;
        int n13 = n12;
        float f15 = f14;
        legendreTable2(n13, f15);
        float[] fArray = new float[n11 + 2];
        fArray[0] = 1065353216;
        float f16 = this.mGcRadiusKm;
        fArray[1] = f9 = 6371.2f / f16;
        int n14 = 2;
        while ((n6 = ++n14) < (n5 = (n4 = fArray.length))) {
            float f17;
            int n15 = n14 - 1;
            float f18 = fArray[n15];
            float f19 = fArray[1];
            fArray[n14] = f17 = f18 * f19;
        }
        float[] fArray2 = new float[n11];
        float[] fArray3 = new float[n11];
        fArray2[0] = 0.0f;
        fArray3[0] = 1065353216;
        fArray2[1] = f8 = (float)Math.sin(this.mGcLongitudeRad);
        fArray3[1] = f7 = (float)Math.cos(this.mGcLongitudeRad);
        for (n3 = 2; n3 < n11; ++n3) {
            float f20;
            float f21;
            int n16 = n3 >> 1;
            int n17 = n3 - n16;
            float f22 = fArray2[n17];
            float f23 = fArray3[n16];
            float f24 = f22 * f23;
            int n18 = n3 - n16;
            float f25 = fArray3[n18];
            float f26 = fArray2[n16];
            float f27 = f25 * f26;
            fArray2[n3] = f21 = f24 + f27;
            int n19 = n3 - n16;
            float f28 = fArray3[n19];
            float f29 = fArray3[n16];
            float f30 = f28 * f29;
            int n20 = n3 - n16;
            float f31 = fArray2[n20];
            float f32 = fArray2[n16];
            float f33 = f31 * f32;
            fArray3[n3] = f20 = f30 - f33;
        }
        float f34 = (float)Math.cos(this.mGcLatitudeRad);
        float f35 = 1.0f / f34;
        long l2 = BASE_TIME;
        float f36 = (float)(l - l2) / 3.1536E10f;
        float f37 = 0.0f;
        float f38 = 0.0f;
        float f39 = 0.0f;
        int n21 = 1;
        while ((n2 = n21) < (n = n11)) {
            int n22;
            int n23;
            n3 = 0;
            while ((n23 = n3) <= (n22 = n21++)) {
                float f40 = G_COEFF[n21][n3];
                float f41 = DELTA_G[n21][n3] * f36;
                float f42 = f40 + f41;
                float f43 = H_COEFF[n21][n3];
                float f44 = DELTA_H[n21][n3] * f36;
                float f45 = f43 + f44;
                int n24 = n21 + 2;
                float f46 = fArray[n24];
                float f47 = fArray3[n3] * f42;
                float f48 = fArray2[n3] * f45;
                float f49 = f47 + f48;
                float f50 = f46 * f49;
                float f51 = legendreTable.mPDeriv[n21][n3];
                float f52 = f50 * f51;
                float f53 = SCHMIDT_QUASI_NORM_FACTORS[n21][n3];
                float f54 = f52 * f53;
                f37 += f54;
                int n25 = n21 + 2;
                float f55 = fArray[n25];
                float f56 = n3;
                float f57 = f55 * f56;
                float f58 = fArray2[n3] * f42;
                float f59 = fArray3[n3] * f45;
                float f60 = f58 - f59;
                float f61 = f57 * f60;
                float f62 = legendreTable.mP[n21][n3];
                float f63 = f61 * f62;
                float f64 = SCHMIDT_QUASI_NORM_FACTORS[n21][n3];
                float f65 = f63 * f64 * f35;
                f38 += f65;
                float f66 = n21 + 1;
                int n26 = n21 + 2;
                float f67 = fArray[n26];
                float f68 = f66 * f67;
                float f69 = fArray3[n3] * f42;
                float f70 = fArray2[n3] * f45;
                float f71 = f69 + f70;
                float f72 = f68 * f71;
                float f73 = legendreTable.mP[n21][n3];
                float f74 = f72 * f73;
                float f75 = SCHMIDT_QUASI_NORM_FACTORS[n21][n3];
                float f76 = f74 * f75;
                f39 -= f76;
                int n27 = n3 + 1;
            }
        }
        double d2 = Math.toRadians(f13);
        double d3 = this.mGcLatitudeRad;
        double d4 = d2 - d3;
        double d5 = f37;
        double d6 = Math.cos(d4);
        double d7 = d5 * d6;
        double d8 = f39;
        double d9 = Math.sin(d4);
        double d10 = d8 * d9;
        this.mX = f6 = (float)(d7 + d10);
        this.mY = f5 = f38;
        double d11 = -f37;
        double d12 = Math.sin(d4);
        double d13 = d11 * d12;
        double d14 = f39;
        double d15 = Math.cos(d4);
        double d16 = d14 * d15;
        this.mZ = f4 = (float)(d13 + d16);
    }

    private void computeGeocentricCoordinates(float f, float f2, float f3) {
        float f4;
        float f5;
        float f6;
        float f7 = f3 / 1000.0f;
        double d = Math.toRadians(f);
        float f8 = (float)Math.cos(d);
        float f9 = (float)Math.sin(d);
        float f10 = f9 / f8;
        float f11 = 4.0680636E7f * f8 * f8;
        float f12 = 4.04083E7f * f9 * f9;
        float f13 = (float)Math.sqrt(f11 + f12);
        float f14 = (f13 * f7 + 4.04083E7f) * f10;
        float f15 = f13 * f7 + 4.0680636E7f;
        this.mGcLatitudeRad = f6 = (float)Math.atan(f14 / f15);
        this.mGcLongitudeRad = f5 = (float)Math.toRadians(f2);
        float f16 = f7 * f7;
        float f17 = 2.0f * f7;
        float f18 = 4.0680636E7f * f8 * f8;
        float f19 = 4.04083E7f * f9 * f9;
        float f20 = (float)Math.sqrt(f18 + f19);
        float f21 = f17 * f20;
        float f22 = f16 + f21;
        float f23 = 4.0680636E7f * 4.0680636E7f * f8 * f8;
        float f24 = 4.04083E7f * 4.04083E7f * f9 * f9;
        float f25 = f23 + f24;
        float f26 = 4.0680636E7f * f8 * f8;
        float f27 = 4.04083E7f * f9 * f9;
        float f28 = f26 + f27;
        float f29 = f25 / f28;
        this.mGcRadiusKm = f4 = (float)Math.sqrt(f22 + f29);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static float[][] computeSchmidtQuasiNormFactors(int n) {
        float[] fArray = new float[n + 1];
        float[] fArray2 = new float[]{1065353216};
        fArray[0] = (float)fArray2;
        int n2 = 1;
        while (n2 <= n) {
            void var11_11;
            float[] fArray3 = new float[n2 + 1];
            fArray[n2] = (float)fArray3;
            float f = fArray[n2];
            int n3 = n2 - 1;
            void var7_7 = fArray[n3][0];
            float f2 = n2 * 2 - 1;
            void var9_9 = var7_7 * f2;
            float f3 = n2;
            f[0] = var11_11 = var9_9 / f3;
            for (int i = 1; i <= n2; ++i) {
                void var22_22;
                float f4 = fArray[n2];
                float f5 = fArray[n2];
                int n4 = i - 1;
                void var16_16 = f5[n4];
                int n5 = n2 - i + 1;
                int n6 = i == 1 ? 2 : 1;
                float f6 = n5 * n6;
                float f7 = n2 + i;
                float f8 = (float)Math.sqrt(f6 / f7);
                f4[i] = var22_22 = var16_16 * f8;
            }
            ++n2;
        }
        return fArray;
    }

    public float getDeclination() {
        double d = this.mY;
        double d2 = this.mX;
        return (float)Math.toDegrees(Math.atan2(d, d2));
    }

    public float getFieldStrength() {
        float f = this.mX;
        float f2 = this.mX;
        float f3 = f * f2;
        float f4 = this.mY;
        float f5 = this.mY;
        float f6 = f4 * f5;
        float f7 = f3 + f6;
        float f8 = this.mZ;
        float f9 = this.mZ;
        float f10 = f8 * f9;
        return (float)Math.sqrt(f7 + f10);
    }

    public float getHorizontalStrength() {
        float f = this.mX;
        float f2 = this.mX;
        float f3 = f * f2;
        float f4 = this.mY;
        float f5 = this.mY;
        float f6 = f4 * f5;
        return (float)Math.sqrt(f3 + f6);
    }

    public float getInclination() {
        double d = this.mZ;
        double d2 = this.getHorizontalStrength();
        return (float)Math.toDegrees(Math.atan2(d, d2));
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getZ() {
        return this.mZ;
    }

    private static class LegendreTable {
        static final /* synthetic */ boolean $assertionsDisabled;
        public final float[][] mP;
        public final float[][] mPDeriv;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !GeomagneticField.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public LegendreTable(int n, float f) {
            float f2 = (float)Math.cos(f);
            float f3 = (float)Math.sin(f);
            float[] fArray = new float[n + 1];
            this.mP = (float[][])fArray;
            float[] fArray2 = new float[n + 1];
            this.mPDeriv = (float[][])fArray2;
            float[][] fArray3 = this.mP;
            float[] fArray4 = new float[]{1065353216};
            fArray3[0] = fArray4;
            float[][] fArray5 = this.mPDeriv;
            float[] fArray6 = new float[]{0.0f};
            fArray5[0] = fArray6;
            int n2 = 1;
            while (n2 <= n) {
                float[][] fArray7 = this.mP;
                float[] fArray8 = new float[n2 + 1];
                fArray7[n2] = fArray8;
                float[][] fArray9 = this.mPDeriv;
                float[] fArray10 = new float[n2 + 1];
                fArray9[n2] = fArray10;
                for (int i = 0; i <= n2; ++i) {
                    float f4;
                    float f5;
                    int n3;
                    int n4;
                    if (n2 != i) {
                        float f6;
                        float f7;
                        float[] fArray11 = this.mP[n2];
                        float[][] fArray12 = this.mP;
                        int n5 = n2 - 1;
                        float[] fArray13 = fArray12[n5];
                        int n6 = i - 1;
                        fArray11[i] = f7 = fArray13[n6] * f3;
                        float[] fArray14 = this.mPDeriv[n2];
                        float[][] fArray15 = this.mP;
                        int n7 = n2 - 1;
                        float[] fArray16 = fArray15[n7];
                        int n8 = i - 1;
                        float f8 = fArray16[n8] * f2;
                        float[][] fArray17 = this.mPDeriv;
                        int n9 = n2 - 1;
                        float[] fArray18 = fArray17[n9];
                        int n10 = i - 1;
                        float f9 = fArray18[n10] * f3;
                        fArray14[i] = f6 = f8 + f9;
                        continue;
                    }
                    if (n2 == 1 || i != (n4 = n2 - 1)) {
                        float f10;
                        float f11;
                        float[] fArray19 = this.mP[n2];
                        float[][] fArray20 = this.mP;
                        int n11 = n2 - 1;
                        fArray19[i] = f11 = fArray20[n11][i] * f2;
                        float[] fArray21 = this.mPDeriv[n2];
                        float f12 = -f3;
                        float[][] fArray22 = this.mP;
                        int n12 = n2 - 1;
                        float f13 = fArray22[n12][i];
                        float f14 = f12 * f13;
                        float[][] fArray23 = this.mPDeriv;
                        int n13 = n2 - 1;
                        float f15 = fArray23[n13][i] * f2;
                        fArray21[i] = f10 = f14 + f15;
                        continue;
                    }
                    if (!($assertionsDisabled || n2 > 1 && i < (n3 = n2 - 1))) {
                        throw new AssertionError();
                    }
                    int n14 = n2 - 1;
                    int n15 = n2 - 1;
                    int n16 = n14 * n15;
                    int n17 = i * i;
                    float f16 = n16 - n17;
                    int n18 = n2 * 2 - 1;
                    int n19 = n2 * 2 - 3;
                    float f17 = n18 * n19;
                    float f18 = f16 / f17;
                    float[] fArray24 = this.mP[n2];
                    float[][] fArray25 = this.mP;
                    int n20 = n2 - 1;
                    float f19 = fArray25[n20][i] * f2;
                    float[][] fArray26 = this.mP;
                    int n21 = n2 - 2;
                    float f20 = fArray26[n21][i] * f18;
                    fArray24[i] = f5 = f19 - f20;
                    float[] fArray27 = this.mPDeriv[n2];
                    float f21 = -f3;
                    float[][] fArray28 = this.mP;
                    int n22 = n2 - 1;
                    float f22 = fArray28[n22][i];
                    float f23 = f21 * f22;
                    float[][] fArray29 = this.mPDeriv;
                    int n23 = n2 - 1;
                    float f24 = fArray29[n23][i] * f2;
                    float f25 = f23 + f24;
                    float[][] fArray30 = this.mPDeriv;
                    int n24 = n2 - 2;
                    float f26 = fArray30[n24][i] * f18;
                    fArray27[i] = f4 = f25 - f26;
                }
                ++n2;
            }
            return;
        }
    }
}

