/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.IRotationWatcher;
import android.view.IWindowManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SensorManager {
    public static final int AXIS_MINUS_X = 129;
    public static final int AXIS_MINUS_Y = 130;
    public static final int AXIS_MINUS_Z = 131;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    public static final int AXIS_Z = 3;
    @Deprecated
    public static final int DATA_X = 0;
    @Deprecated
    public static final int DATA_Y = 1;
    @Deprecated
    public static final int DATA_Z = 2;
    public static final float GRAVITY_DEATH_STAR_I = 3.5303614E-7f;
    public static final float GRAVITY_EARTH = 9.80665f;
    public static final float GRAVITY_JUPITER = 23.12f;
    public static final float GRAVITY_MARS = 3.71f;
    public static final float GRAVITY_MERCURY = 3.7f;
    public static final float GRAVITY_MOON = 1.6f;
    public static final float GRAVITY_NEPTUNE = 11.0f;
    public static final float GRAVITY_PLUTO = 0.6f;
    public static final float GRAVITY_SATURN = 8.96f;
    public static final float GRAVITY_SUN = 275.0f;
    public static final float GRAVITY_THE_ISLAND = 4.815162f;
    public static final float GRAVITY_URANUS = 8.69f;
    public static final float GRAVITY_VENUS = 8.87f;
    public static final float LIGHT_CLOUDY = 100.0f;
    public static final float LIGHT_FULLMOON = 0.25f;
    public static final float LIGHT_NO_MOON = 0.001f;
    public static final float LIGHT_OVERCAST = 10000.0f;
    public static final float LIGHT_SHADE = 20000.0f;
    public static final float LIGHT_SUNLIGHT = 110000.0f;
    public static final float LIGHT_SUNLIGHT_MAX = 120000.0f;
    public static final float LIGHT_SUNRISE = 400.0f;
    public static final float MAGNETIC_FIELD_EARTH_MAX = 60.0f;
    public static final float MAGNETIC_FIELD_EARTH_MIN = 30.0f;
    public static final float PRESSURE_STANDARD_ATMOSPHERE = 1013.25f;
    @Deprecated
    public static final int RAW_DATA_INDEX = 3;
    @Deprecated
    public static final int RAW_DATA_X = 3;
    @Deprecated
    public static final int RAW_DATA_Y = 4;
    @Deprecated
    public static final int RAW_DATA_Z = 5;
    @Deprecated
    public static final int SENSOR_ACCELEROMETER = 2;
    @Deprecated
    public static final int SENSOR_ALL = 127;
    public static final int SENSOR_DELAY_FASTEST = 0;
    public static final int SENSOR_DELAY_GAME = 1;
    public static final int SENSOR_DELAY_NORMAL = 3;
    public static final int SENSOR_DELAY_UI = 2;
    private static final int SENSOR_DISABLE = 255;
    @Deprecated
    public static final int SENSOR_LIGHT = 16;
    @Deprecated
    public static final int SENSOR_MAGNETIC_FIELD = 8;
    @Deprecated
    public static final int SENSOR_MAX = 64;
    @Deprecated
    public static final int SENSOR_MIN = 1;
    @Deprecated
    public static final int SENSOR_ORIENTATION = 1;
    @Deprecated
    public static final int SENSOR_ORIENTATION_RAW = 128;
    @Deprecated
    public static final int SENSOR_PROXIMITY = 32;
    public static final int SENSOR_STATUS_ACCURACY_HIGH = 3;
    public static final int SENSOR_STATUS_ACCURACY_LOW = 1;
    public static final int SENSOR_STATUS_ACCURACY_MEDIUM = 2;
    public static final int SENSOR_STATUS_UNRELIABLE = 0;
    @Deprecated
    public static final int SENSOR_TEMPERATURE = 4;
    @Deprecated
    public static final int SENSOR_TRICORDER = 64;
    public static final float STANDARD_GRAVITY = 9.80665f;
    private static final String TAG = "SensorManager";
    private static final float[] mTempMatrix = new float[16];
    private static ArrayList<Sensor> sFullSensorsList;
    static SparseArray<Sensor> sHandleToSensor;
    static final ArrayList<ListenerDelegate> sListeners;
    private static int sQueue;
    private static int sRotation;
    private static SparseArray<List<Sensor>> sSensorListByType;
    private static boolean sSensorModuleInitialized;
    private static SensorThread sSensorThread;
    private static IWindowManager sWindowManager;
    private HashMap<SensorListener, LegacyListener> mLegacyListenersMap;
    Looper mMainLooper;

    static {
        sSensorModuleInitialized = false;
        sFullSensorsList = new ArrayList();
        sSensorListByType = new SparseArray();
        sRotation = 0;
        sHandleToSensor = new SparseArray();
        sListeners = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SensorManager(Looper looper) {
        HashMap hashMap = new HashMap();
        this.mLegacyListenersMap = hashMap;
        this.mMainLooper = looper;
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            if (!sSensorModuleInitialized) {
                sSensorModuleInitialized = true;
                SensorManager.nativeClassInit();
                IWindowManager iWindowManager = sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
                if (iWindowManager != null) {
                    try {
                        IWindowManager iWindowManager2 = sWindowManager;
                        IRotationWatcher.Stub stub = new IRotationWatcher.Stub(){

                            @Override
                            public void onRotationChanged(int n) {
                                SensorManager.this.onRotationChanged(n);
                            }
                        };
                        sRotation = iWindowManager2.watchRotation(stub);
                    }
                    catch (RemoteException remoteException) {}
                }
                int n = SensorManager.sensors_module_init();
                ArrayList<Sensor> arrayList2 = sFullSensorsList;
                int n2 = 0;
                do {
                    Sensor sensor;
                    if ((n2 = SensorManager.sensors_module_get_next_sensor(sensor = new Sensor(), n2)) < 0) continue;
                    int n3 = sensor.getType();
                    int n4 = this.getLegacySensorType(n3);
                    sensor.setLegacyType(n4);
                    boolean bl = arrayList2.add(sensor);
                    SparseArray<Sensor> sparseArray = sHandleToSensor;
                    int n5 = sensor.getHandle();
                    sparseArray.append(n5, sensor);
                } while (n2 > 0);
                sSensorThread = new SensorThread();
            }
            return;
        }
    }

    static /* synthetic */ int access$002(int n) {
        sQueue = n;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean disableSensorLocked(Sensor sensor) {
        Iterator<ListenerDelegate> iterator = sListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().hasSensor(sensor)) continue;
            return true;
        }
        String string2 = sensor.getName();
        int n = sensor.getHandle();
        return SensorManager.sensors_enable_sensor(sQueue, string2, n, -1);
    }

    private boolean enableSensorLocked(Sensor sensor, int n) {
        boolean bl = false;
        Iterator<ListenerDelegate> iterator = sListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().hasSensor(sensor)) continue;
            String string2 = sensor.getName();
            int n2 = sensor.getHandle();
            bl = SensorManager.sensors_enable_sensor(sQueue, string2, n2, n);
            break;
        }
        return bl;
    }

    public static float getAltitude(float f, float f2) {
        float f3 = (float)Math.pow(f2 / f, 0.19029495120048523);
        float f4 = 1.0f - f3;
        return 44330.0f * f4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void getAngleChange(float[] fArray, float[] fArray2, float[] fArray3) {
        float f;
        float f2;
        float f3;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        float f4;
        int n9;
        int n10;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = fArray2.length;
        int n21 = 9;
        if (n20 == n21) {
            n11 = fArray2[0];
            n12 = fArray2[1];
            n13 = fArray2[2];
            n14 = fArray2[3];
            n15 = fArray2[4];
            n16 = fArray2[5];
            n17 = fArray2[6];
            n18 = fArray2[7];
            n19 = fArray2[8];
        } else {
            int n22 = fArray2.length;
            int n23 = 16;
            if (n22 == n23) {
                n11 = fArray2[0];
                n12 = fArray2[1];
                n13 = fArray2[2];
                n14 = fArray2[4];
                n15 = fArray2[5];
                n16 = fArray2[6];
                n17 = fArray2[8];
                n18 = fArray2[9];
                n19 = fArray2[10];
            }
        }
        if ((n10 = fArray3.length) == (n9 = 9)) {
            f4 = fArray3[0];
            float f5 = fArray3[1];
            float f6 = fArray3[2];
            float f7 = fArray3[3];
            float f8 = fArray3[4];
            float f9 = fArray3[5];
            float f10 = fArray3[6];
            float f11 = fArray3[7];
            float f12 = fArray3[8];
            n8 = f5;
            n7 = f6;
            n6 = (int)f7;
            n5 = f8;
            n4 = f9;
            n3 = (int)f10;
            n2 = f11;
            n = f12;
        } else {
            int n24 = fArray3.length;
            int n25 = 16;
            if (n24 == n25) {
                f4 = fArray3[0];
                float f13 = fArray3[1];
                float f14 = fArray3[2];
                float f15 = fArray3[4];
                float f16 = fArray3[5];
                float f17 = fArray3[6];
                float f18 = fArray3[8];
                float f19 = fArray3[9];
                float f20 = fArray3[10];
                n8 = f13;
                n7 = f14;
                n6 = (int)f15;
                n5 = f16;
                n4 = f17;
                n3 = (int)f18;
                n2 = f19;
                n = f20;
            } else {
                n8 = 0;
                f4 = 0.0f;
                n6 = 0;
                n7 = 0;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
            }
        }
        float f21 = f4 * n12;
        int n26 = n6 * n15;
        float f22 = f21 + n26;
        int n27 = n3 * n18;
        float f23 = f22 + n27;
        int n28 = n8 * n12;
        int n29 = n5 * n15;
        int n30 = n28 + n29;
        int n31 = n2 * n18;
        int n32 = n30 + n31;
        int n33 = n7 * n11;
        int n34 = n4 * n14;
        int n35 = n33 + n34;
        int n36 = n * n17;
        int n37 = n35 + n36;
        int n38 = n7 * n12;
        int n39 = n4 * n15;
        int n40 = n38 + n39;
        int n41 = n * n18;
        int n42 = n40 + n41;
        int n43 = n7 * n13;
        int n44 = n4 * n16;
        int n45 = n43 + n44;
        int n46 = n * n19;
        int n47 = n45 + n46;
        double d = f23;
        double d2 = n32;
        double d3 = d;
        double d4 = d2;
        fArray[0] = f3 = (float)Math.atan2(d3, d4);
        fArray[1] = f2 = (float)Math.asin(-n42);
        double d5 = -n37;
        double d6 = n47;
        fArray[2] = f = (float)Math.atan2(d5, d6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float getInclination(float[] fArray) {
        if (fArray.length == 9) {
            double d = fArray[5];
            double d2 = fArray[4];
            return (float)Math.atan2(d, d2);
        }
        double d = fArray[6];
        double d3 = fArray[5];
        return (float)Math.atan2(d, d3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getLegacySensorType(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 128;
            }
            case 7: 
        }
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float[] getOrientation(float[] fArray, float[] fArray2) {
        float f;
        float f2;
        float f3;
        if (fArray.length == 9) {
            float f4;
            float f5;
            float f6;
            double d = fArray[1];
            double d2 = fArray[4];
            fArray2[0] = f6 = (float)Math.atan2(d, d2);
            fArray2[1] = f5 = (float)Math.asin(-fArray[7]);
            double d3 = -fArray[6];
            double d4 = fArray[8];
            fArray2[2] = f4 = (float)Math.atan2(d3, d4);
            return fArray2;
        }
        double d = fArray[1];
        double d5 = fArray[5];
        fArray2[0] = f3 = (float)Math.atan2(d, d5);
        fArray2[1] = f2 = (float)Math.asin(-fArray[9]);
        double d6 = -fArray[8];
        double d7 = fArray[10];
        fArray2[2] = f = (float)Math.atan2(d6, d7);
        return fArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void getQuaternionFromVector(float[] fArray, float[] fArray2) {
        float f;
        float f2;
        float f3;
        if (fArray2.length == 4) {
            float f4;
            fArray[0] = f4 = fArray2[3];
        } else {
            float f5;
            float f6 = fArray2[0];
            float f7 = fArray2[0];
            float f8 = f6 * f7;
            float f9 = 1.0f - f8;
            float f10 = fArray2[1];
            float f11 = fArray2[1];
            float f12 = f10 * f11;
            float f13 = f9 - f12;
            float f14 = fArray2[2];
            float f15 = fArray2[2];
            float f16 = f14 * f15;
            fArray[0] = f5 = (float)Math.sqrt(f13 - f16);
        }
        fArray[1] = f3 = fArray2[0];
        fArray[2] = f2 = fArray2[1];
        fArray[3] = f = fArray2[2];
    }

    static int getRotation() {
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            int n = sRotation;
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean getRotationMatrix(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        boolean bl;
        float f = fArray4[1];
        float f2 = fArray3[2];
        float f3 = f * f2;
        float f4 = fArray4[2];
        float f5 = fArray3[1];
        float f6 = f4 * f5;
        float f7 = f3 - f6;
        float f8 = f7 * f7;
        float f9 = fArray3[0];
        float f10 = f4 * f9;
        float f11 = fArray4[0];
        float f12 = f11 * f2;
        float f13 = f10 - f12;
        float f14 = f13 * f13;
        float f15 = f8 + f14;
        float f16 = f11 * f5;
        float f17 = f * f9;
        float f18 = f16 - f17;
        float f19 = f18 * f18;
        float f20 = (float)Math.sqrt(f15 + f19);
        if (f20 < 0.1f) {
            float f21 = f5;
            float f22 = f18;
            float f23 = f7;
            float f24 = f2;
            bl = false;
            float f25 = f9;
            float f26 = f13;
            float f27 = f23;
            return bl;
        }
        float f28 = 1.0f / f20;
        f20 = f7 * f28;
        float f29 = f13 * f28;
        f18 *= f28;
        float f30 = f9 * f9;
        float f31 = f5 * f5;
        float f32 = f30 + f31;
        float f33 = f2 * f2;
        float f34 = (float)Math.sqrt(f32 + f33);
        float f35 = 1.0f / f34;
        float f36 = f9 * f35;
        float f37 = f5 * f35;
        float f38 = f2 * f35;
        float f39 = f37 * f18;
        float f40 = f38 * f29;
        float f41 = f39 - f40;
        float f42 = f38 * f20;
        float f43 = f36 * f18;
        float f44 = f42 - f43;
        float f45 = f36 * f29;
        float f46 = f37 * f20;
        float f47 = f45 - f46;
        if (fArray != null) {
            if (fArray.length == 9) {
                fArray[0] = f20;
                fArray[1] = f29;
                fArray[2] = f18;
                fArray[3] = f41;
                fArray[4] = f44;
                fArray[5] = f47;
                fArray[6] = f36;
                fArray[7] = f37;
                fArray[8] = f38;
            } else if (fArray.length == 16) {
                fArray[0] = f20;
                fArray[1] = f29;
                fArray[2] = f18;
                fArray[3] = 0.0f;
                fArray[4] = f41;
                fArray[5] = f44;
                fArray[6] = f47;
                fArray[7] = 0.0f;
                fArray[8] = f36;
                fArray[9] = f37;
                fArray[10] = f38;
                fArray[11] = 0.0f;
                fArray[12] = 0.0f;
                fArray[13] = 0.0f;
                fArray[14] = 0.0f;
                fArray[15] = 1065353216;
            }
        }
        if (fArray2 != null) {
            float f48 = f11 * f11;
            float f49 = f * f;
            float f50 = f48 + f49;
            float f51 = f4 * f4;
            float f52 = (float)Math.sqrt(f50 + f51);
            float f53 = 1.0f / f52;
            float f54 = f11 * f41;
            float f55 = f * f44;
            float f56 = f54 + f55;
            float f57 = f4 * f47;
            float f58 = (f56 + f57) * f53;
            float f59 = f11 * f36;
            float f60 = f * f37;
            float f61 = f59 + f60;
            float f62 = f4 * f38;
            f41 = (f61 + f62) * f53;
            if (fArray2.length == 9) {
                float f63;
                fArray2[0] = 1065353216;
                fArray2[1] = 0.0f;
                fArray2[2] = 0.0f;
                fArray2[3] = 0.0f;
                fArray2[4] = f58;
                fArray2[5] = f41;
                fArray2[6] = 0.0f;
                fArray2[7] = f63 = -f41;
                fArray2[8] = f58;
            } else if (fArray2.length == 16) {
                float f64;
                fArray2[0] = 1065353216;
                fArray2[1] = 0.0f;
                fArray2[2] = 0.0f;
                fArray2[4] = 0.0f;
                fArray2[5] = f58;
                fArray2[6] = f41;
                fArray2[8] = 0.0f;
                fArray2[9] = f64 = -f41;
                fArray2[10] = f58;
                fArray2[14] = 0.0f;
                fArray2[13] = 0.0f;
                fArray2[12] = 0.0f;
                fArray2[11] = 0.0f;
                fArray2[7] = 0.0f;
                fArray2[3] = 0.0f;
                fArray2[15] = 1065353216;
            }
        }
        float f65 = f18;
        float f66 = f37;
        bl = true;
        float f67 = f36;
        float f68 = f20;
        float f69 = f38;
        float f70 = f29;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void getRotationMatrixFromVector(float[] fArray, float[] fArray2) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11 = fArray2[0];
        float f12 = fArray2[1];
        float f13 = fArray2[2];
        if (fArray2.length == 4) {
            f10 = fArray2[3];
        } else {
            float f14 = f11 * f11;
            float f15 = 1.0f - f14;
            float f16 = f12 * f12;
            float f17 = f15 - f16;
            float f18 = f13 * f13;
            f10 = (float)Math.sqrt(f17 - f18);
        }
        float f19 = 2.0f * f11 * f11;
        float f20 = 2.0f * f12 * f12;
        float f21 = 2.0f * f13 * f13;
        float f22 = 2.0f * f11 * f12;
        float f23 = 2.0f * f13 * f10;
        float f24 = 2.0f * f11 * f13;
        float f25 = 2.0f * f12 * f10;
        float f26 = f12 * 2.0f * f13;
        float f27 = f11 * 2.0f;
        float f28 = f10 * f27;
        if (fArray.length == 9) {
            float f29;
            float f30;
            float f31;
            float f32;
            float f33;
            float f34;
            float f35;
            float f36;
            float f37;
            fArray[0] = f37 = 1.0f - f20 - f21;
            fArray[1] = f36 = f22 - f23;
            fArray[2] = f35 = f24 + f25;
            fArray[3] = f34 = f22 + f23;
            fArray[4] = f33 = 1.0f - f19 - f21;
            fArray[5] = f32 = f26 - f28;
            fArray[6] = f31 = f24 - f25;
            fArray[7] = f30 = f28 + f26;
            fArray[8] = f29 = 1.0f - f19 - f20;
            return;
        }
        if (fArray.length != 16) {
            return;
        }
        fArray[0] = f9 = 1.0f - f20 - f21;
        fArray[1] = f8 = f22 - f23;
        fArray[2] = f7 = f24 + f25;
        fArray[3] = 0.0f;
        fArray[4] = f6 = f22 + f23;
        fArray[5] = f5 = 1.0f - f19 - f21;
        fArray[6] = f4 = f26 - f28;
        fArray[7] = 0.0f;
        fArray[8] = f3 = f24 - f25;
        fArray[9] = f2 = f28 + f26;
        fArray[10] = f = 1.0f - f19 - f20;
        fArray[11] = 0.0f;
        fArray[14] = 0.0f;
        fArray[13] = 0.0f;
        fArray[12] = 0.0f;
        fArray[15] = 1065353216;
    }

    private static native void nativeClassInit();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean registerLegacyListener(int n, int n2, SensorListener sensorListener, int n3, int n4) {
        LegacyListener legacyListener;
        LegacyListener legacyListener2;
        if (sensorListener == null) {
            return false;
        }
        boolean bl = false;
        if ((n3 & n) == 0) return bl;
        Sensor sensor = this.getDefaultSensor(n2);
        if (sensor == null) return bl;
        HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
        synchronized (hashMap) {
            legacyListener2 = this.mLegacyListenersMap.get(sensorListener);
            if (legacyListener2 == null) {
                legacyListener = new LegacyListener(sensorListener);
                LegacyListener legacyListener3 = this.mLegacyListenersMap.put(sensorListener, legacyListener);
                legacyListener2 = legacyListener;
            }
        }
        legacyListener2.registerSensor(n);
        bl = this.registerListener(legacyListener2, sensor, n4);
        return bl;
        {
            catch (Throwable throwable) {
                LegacyListener legacyListener4 = legacyListener;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean remapCoordinateSystem(float[] fArray, int n, int n2, float[] fArray2) {
        if (fArray != fArray2) return SensorManager.remapCoordinateSystemImpl(fArray, n, n2, fArray2);
        float[] fArray3 = mTempMatrix;
        synchronized (fArray3) {
            if (!SensorManager.remapCoordinateSystemImpl(fArray, n, n2, fArray3)) return SensorManager.remapCoordinateSystemImpl(fArray, n, n2, fArray2);
            int n3 = fArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                float f;
                fArray2[n4] = f = fArray3[n4];
                ++n4;
            }
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean remapCoordinateSystemImpl(float[] fArray, int n, int n2, float[] fArray2) {
        int n3 = fArray2.length;
        if (fArray.length != n3) {
            return false;
        }
        if ((n & 0x7C) != 0) return false;
        if ((n2 & 0x7C) != 0) {
            return false;
        }
        if ((n & 3) == 0) return false;
        if ((n2 & 3) == 0) {
            return false;
        }
        int n4 = n & 3;
        int n5 = n2 & 3;
        if (n4 != n5) {
            return false;
        }
        int n6 = n ^ n2;
        int n7 = (n6 & 3) - 1;
        int n8 = (n7 + 1) % 3;
        int n9 = (n & 3) - 1;
        int n10 = n8 ^ n9;
        int n11 = (n7 + 2) % 3;
        int n12 = (n2 & 3) - 1;
        int n13 = n11 ^ n12;
        if ((n10 | n13) != 0) {
            int n14 = n6 ^ 0x80;
        }
        boolean bl = n >= 128;
        boolean bl2 = n2 >= 128;
        boolean bl3 = n6 >= 128;
        int n15 = n3 == 16 ? 4 : 3;
        n2 = 0;
        while (true) {
            int n16;
            if (n2 < 3) {
                n16 = n2 * n15;
            } else {
                if (n3 != 16) return true;
                fArray2[14] = 0.0f;
                fArray2[13] = 0.0f;
                fArray2[12] = 0.0f;
                fArray2[11] = 0.0f;
                fArray2[7] = 0.0f;
                fArray2[3] = 0.0f;
                fArray2[15] = 1065353216;
                return true;
            }
            for (int i = 0; i < 3; ++i) {
                float f;
                int n17;
                if (n9 != i) {
                    n17 = n16 + i;
                    if (bl) {
                        int n18 = n16 + 0;
                        f = -fArray[n18];
                    } else {
                        int n19 = n16 + 0;
                        f = fArray[n19];
                    }
                    fArray2[n17] = f;
                }
                if (n12 != i) {
                    n17 = n16 + i;
                    if (bl2) {
                        int n20 = n16 + 1;
                        f = -fArray[n20];
                    } else {
                        int n21 = n16 + 1;
                        f = fArray[n21];
                    }
                    fArray2[n17] = f;
                }
                if (n7 == i) continue;
                n17 = n16 + i;
                if (bl3) {
                    int n22 = n16 + 2;
                    f = -fArray[n22];
                } else {
                    int n23 = n16 + 2;
                    f = fArray[n23];
                }
                fArray2[n17] = f;
            }
            int n24 = n2 + 1;
        }
    }

    static native int sensors_create_queue();

    static native int sensors_data_poll(int var0, float[] var1, int[] var2, long[] var3);

    static native void sensors_destroy_queue(int var0);

    static native boolean sensors_enable_sensor(int var0, String var1, int var2, int var3);

    private static native int sensors_module_get_next_sensor(Sensor var0, int var1);

    private static native int sensors_module_init();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void unregisterLegacyListener(int n, int n2, SensorListener sensorListener, int n3) {
        if (sensorListener == null) {
            return;
        }
        HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
        // MONITORENTER : hashMap
        LegacyListener legacyListener = this.mLegacyListenersMap.get(sensorListener);
        // MONITOREXIT : hashMap
        if (legacyListener == null) {
            return;
        }
        if ((n3 & n) == 0) {
            return;
        }
        Sensor sensor = this.getDefaultSensor(n2);
        if (sensor == null) {
            return;
        }
        if (!legacyListener.unregisterSensor(n)) {
            return;
        }
        this.unregisterListener(legacyListener, sensor);
        ArrayList<ListenerDelegate> arrayList = sListeners;
        // MONITORENTER : arrayList
        boolean bl = false;
        Iterator<ListenerDelegate> iterator = sListeners.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getListener() != legacyListener) continue;
            bl = true;
            break;
        }
        if (!bl) {
            hashMap = this.mLegacyListenersMap;
            // MONITORENTER : hashMap
            LegacyListener legacyListener2 = this.mLegacyListenersMap.remove(sensorListener);
            // MONITOREXIT : hashMap
        }
        // MONITOREXIT : arrayList
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unregisterListener(Object object) {
        if (object == null) {
            return;
        }
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            int n = sListeners.size();
            for (int i = 0; i < n; ++i) {
                ListenerDelegate listenerDelegate = sListeners.get(i);
                if (listenerDelegate.getListener() != object) continue;
                ListenerDelegate listenerDelegate2 = sListeners.remove(i);
                for (Sensor sensor : listenerDelegate.getSensors()) {
                    boolean bl = this.disableSensorLocked(sensor);
                }
                break;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unregisterListener(Object object, Sensor sensor) {
        if (object == null) {
            return;
        }
        if (sensor == null) {
            return;
        }
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            int n = sListeners.size();
            int n2 = 0;
            while (true) {
                block10: {
                    block9: {
                        if (n2 >= n) break block9;
                        ListenerDelegate listenerDelegate = sListeners.get(n2);
                        if (listenerDelegate.getListener() != object) break block10;
                        if (listenerDelegate.removeSensor(sensor) == 0) {
                            ListenerDelegate listenerDelegate2 = sListeners.remove(n2);
                        }
                    }
                    boolean bl = this.disableSensorLocked(sensor);
                    return;
                }
                ++n2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Sensor getDefaultSensor(int n) {
        List<Sensor> list = this.getSensorList(n);
        if (!list.isEmpty()) return list.get(0);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Sensor> getSensorList(int n) {
        ArrayList<Sensor> arrayList = sFullSensorsList;
        synchronized (arrayList) {
            List<Sensor> list = sSensorListByType.get(n);
            if (list == null) {
                if (n == -1) {
                    list = arrayList;
                } else {
                    list = new ArrayList<Sensor>();
                    for (Sensor sensor : arrayList) {
                        if (sensor.getType() == n) continue;
                        boolean bl = list.add(sensor);
                    }
                }
                list = Collections.unmodifiableList(list);
                sSensorListByType.append(n, list);
            }
            return list;
        }
    }

    @Deprecated
    public int getSensors() {
        int n = 0;
        Iterator<Sensor> iterator = sFullSensorsList.iterator();
        block5: while (iterator.hasNext()) {
            switch (iterator.next().getType()) {
                default: {
                    continue block5;
                }
                case 1: {
                    n |= 2;
                    continue block5;
                }
                case 2: {
                    n |= 8;
                    continue block5;
                }
                case 3: 
            }
            n |= 0x81;
        }
        return n;
    }

    public void onRotationChanged(int n) {
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            sRotation = n;
            return;
        }
    }

    public boolean registerListener(SensorEventListener sensorEventListener, Sensor sensor, int n) {
        return this.registerListener(sensorEventListener, sensor, n, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerListener(SensorEventListener var1_1, Sensor var2_2, int var3_3, Handler var4_4) {
        if (var1_1 == null) return false;
        if (var2_2 == null) {
            return false;
        }
        var6_6 = true;
        switch (var3_3) {
            default: {
                var7_7 = var3_3;
                break;
            }
            case 0: {
                var7_7 = 0;
                break;
            }
            case 1: {
                var7_7 = 20000;
                break;
            }
            case 2: {
                var7_7 = 60000;
                break;
            }
            case 3: {
                var7_7 = 200000;
            }
        }
        var8_8 = SensorManager.sListeners;
        synchronized (var8_8) {
            block18: {
                block17: {
                    block16: {
                        var9_9 = null;
                        for (ListenerDelegate var11_11 : SensorManager.sListeners) {
                            var12_12 = var11_11.getListener();
                            if (var12_12 != var1_1) continue;
                            var13_13 = var11_11;
                            break block16;
                        }
                        var13_13 = var9_9;
                    }
                    if (var13_13 != null) ** GOTO lbl41
                    try {
                        var14_14 = new ListenerDelegate(var1_1, var2_2, var4_4);
                        var15_15 = SensorManager.sListeners.add(var14_14);
                        if (SensorManager.sListeners.isEmpty() != false) return false;
                        if (SensorManager.sSensorThread.startLocked()) {
                            if (this.enableSensorLocked(var2_2, var7_7) != false) return var6_6;
                            var16_16 = SensorManager.sListeners.remove(var14_14);
                            return false;
                        }
                        var17_17 = SensorManager.sListeners.remove(var14_14);
                        return false;
lbl41:
                        // 1 sources

                        var13_13.addSensor(var2_2);
                        if (this.enableSensorLocked(var2_2, var7_7)) break block17;
                        var18_18 = var13_13.removeSensor(var2_2);
                        var6_6 = false;
                        var19_19 = var13_13;
                        break block18;
                    }
                    catch (Throwable var20_20) {
                        var21_21 = var13_13;
                    }
                    throw var20_20;
                }
                var22_22 = var13_13;
            }
            return var6_6;
        }
    }

    @Deprecated
    public boolean registerListener(SensorListener sensorListener, int n) {
        return this.registerListener(sensorListener, n, 3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public boolean registerListener(SensorListener sensorListener, int n, int n2) {
        if (sensorListener == null) {
            return false;
        }
        boolean bl = false;
        SensorManager sensorManager = this;
        SensorListener sensorListener2 = sensorListener;
        int n3 = n;
        int n4 = n2;
        boolean bl2 = sensorManager.registerLegacyListener(2, 1, sensorListener2, n3, n4) || bl;
        SensorManager sensorManager2 = this;
        int n5 = 2;
        SensorListener sensorListener3 = sensorListener;
        int n6 = n;
        int n7 = n2;
        boolean bl3 = sensorManager2.registerLegacyListener(8, n5, sensorListener3, n6, n7) || bl2;
        SensorManager sensorManager3 = this;
        int n8 = 3;
        SensorListener sensorListener4 = sensorListener;
        int n9 = n;
        int n10 = n2;
        boolean bl4 = sensorManager3.registerLegacyListener(128, n8, sensorListener4, n9, n10) || bl3;
        SensorManager sensorManager4 = this;
        int n11 = 3;
        SensorListener sensorListener5 = sensorListener;
        int n12 = n;
        int n13 = n2;
        boolean bl5 = sensorManager4.registerLegacyListener(1, n11, sensorListener5, n12, n13) || bl4;
        SensorManager sensorManager5 = this;
        SensorListener sensorListener6 = sensorListener;
        int n14 = n;
        int n15 = n2;
        if (sensorManager5.registerLegacyListener(4, 7, sensorListener6, n14, n15)) return true;
        if (!bl5) return false;
        return true;
    }

    public void unregisterListener(SensorEventListener sensorEventListener) {
        this.unregisterListener((Object)sensorEventListener);
    }

    public void unregisterListener(SensorEventListener sensorEventListener, Sensor sensor) {
        this.unregisterListener((Object)sensorEventListener, sensor);
    }

    @Deprecated
    public void unregisterListener(SensorListener sensorListener) {
        this.unregisterListener(sensorListener, 255);
    }

    @Deprecated
    public void unregisterListener(SensorListener sensorListener, int n) {
        this.unregisterLegacyListener(2, 1, sensorListener, n);
        this.unregisterLegacyListener(8, 2, sensorListener, n);
        this.unregisterLegacyListener(128, 3, sensorListener, n);
        this.unregisterLegacyListener(1, 3, sensorListener, n);
        this.unregisterLegacyListener(4, 7, sensorListener, n);
    }

    class LmsFilter {
        private static final int COUNT = 12;
        private static final float PREDICTION_RATIO = 0.33333334f;
        private static final float PREDICTION_TIME = 0.08f;
        private static final int SENSORS_RATE_MS = 20;
        private int mIndex;
        private float[] mT;
        private float[] mV;

        public LmsFilter() {
            float[] fArray = new float[24];
            this.mV = fArray;
            float[] fArray2 = new float[24];
            this.mT = fArray2;
            this.mIndex = 12;
        }

        /*
         * Enabled aggressive block sorting
         */
        public float filter(long l, float f) {
            int n;
            int n2;
            float f2;
            int n3;
            int n4;
            int n5;
            float f3 = f;
            float f4 = (float)l * 1.0E-9f;
            float[] fArray = this.mV;
            int n6 = this.mIndex;
            float f5 = fArray[n6];
            if (f3 - f5 > 180.0f) {
                f3 -= 360.0f;
            } else if (f5 - f3 > 180.0f) {
                f3 += 360.0f;
            }
            if ((n5 = (this.mIndex = (n4 = this.mIndex + 1))) >= (n3 = 24)) {
                int n7;
                this.mIndex = n7 = 12;
            }
            float[] fArray2 = this.mV;
            int n8 = this.mIndex;
            fArray2[n8] = f3;
            float[] fArray3 = this.mT;
            int n9 = this.mIndex;
            fArray3[n9] = f4;
            float[] fArray4 = this.mV;
            int n10 = this.mIndex - 12;
            fArray4[n10] = f3;
            float[] fArray5 = this.mT;
            int n11 = this.mIndex - 12;
            fArray5[n11] = f4;
            float f6 = f2 = 0.0f;
            float f7 = f2;
            float f8 = f2;
            float f9 = f2;
            int n12 = 0;
            while ((n2 = ++n12) < (n = 11)) {
                int n13 = this.mIndex - 1 - n12;
                float f10 = this.mV[n13];
                float f11 = this.mT[n13];
                float[] fArray6 = this.mT;
                int n14 = n13 + 1;
                float f12 = fArray6[n14];
                float f13 = f11 + f12;
                float f14 = 0.5f * f13 - f4;
                float f15 = this.mT[n13];
                float[] fArray7 = this.mT;
                int n15 = n13 + 1;
                float f16 = fArray7[n15];
                float f17 = f15 - f16;
                float f18 = f17 * f17;
                float f19 = f10 * f18;
                f9 += f19;
                float f20 = f14 * f18 * f14;
                f8 += f20;
                float f21 = f14 * f18;
                f7 += f21;
                float f22 = f14 * f18 * f10;
                f6 += f22;
                f2 += f18;
            }
            float f23 = f9 * f8;
            float f24 = f7 * f6;
            float f25 = f23 + f24;
            float f26 = f2 * f8;
            float f27 = f7 * f7;
            float f28 = f26 + f27;
            float f29 = f25 / f28;
            float f30 = (f2 * f29 - f9) / f7;
            float f31 = 0.08f * f30;
            float f32 = (f29 + f31) * 0.0027777778f;
            float f33 = f32 >= 0.0f ? f32 : -f32;
            if (f33 >= 0.5f) {
                float f34 = (float)Math.ceil(0.5f + f32);
                f32 = f32 - f34 + 1.0f;
            }
            if (f32 < 0.0f) {
                f32 += 1.0f;
            }
            return f32 * 360.0f;
        }
    }

    private class LegacyListener
    implements SensorEventListener {
        private int mSensors;
        private SensorListener mTarget;
        private float[] mValues;
        private final LmsFilter mYawfilter;

        LegacyListener(SensorListener sensorListener) {
            LmsFilter lmsFilter;
            float[] fArray = new float[6];
            this.mValues = fArray;
            SensorManager sensorManager2 = SensorManager.this;
            this.mYawfilter = lmsFilter = sensorManager2.new LmsFilter();
            this.mTarget = sensorListener;
            this.mSensors = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void mapSensorDataToWindow(int n, float[] fArray, int n2) {
            float f;
            float f2;
            float f3 = fArray[0];
            float f4 = fArray[1];
            float f5 = fArray[2];
            switch (n) {
                case 1: 
                case 128: {
                    f5 = -f5;
                    break;
                }
                case 2: {
                    f3 = -f3;
                    f4 = -f4;
                    f5 = -f5;
                    break;
                }
                case 8: {
                    f3 = -f3;
                    f4 = -f4;
                    break;
                }
            }
            fArray[0] = f3;
            fArray[1] = f4;
            fArray[2] = f5;
            fArray[3] = f3;
            fArray[4] = f4;
            fArray[5] = f5;
            if ((n2 & 1) != 0) {
                switch (n) {
                    case 2: 
                    case 8: {
                        float f6;
                        fArray[0] = f6 = -f4;
                        fArray[1] = f3;
                        fArray[2] = f5;
                        break;
                    }
                    case 1: 
                    case 128: {
                        float f7;
                        int n3 = f3 < 270.0f ? 90 : 65266;
                        fArray[0] = f7 = (float)n3 + f3;
                        fArray[1] = f5;
                        fArray[2] = f4;
                        break;
                    }
                }
            }
            if ((n2 & 2) == 0) {
                return;
            }
            f3 = fArray[0];
            f4 = fArray[1];
            f5 = fArray[2];
            switch (n) {
                default: {
                    return;
                }
                case 2: 
                case 8: {
                    float f8;
                    float f9;
                    fArray[0] = f9 = -f3;
                    fArray[1] = f8 = -f4;
                    fArray[2] = f5;
                    return;
                }
                case 1: 
                case 128: 
            }
            float f10 = f3 >= 180.0f ? f3 - 180.0f : f3 + 180.0f;
            fArray[0] = f10;
            fArray[1] = f2 = -f4;
            fArray[2] = f = -f5;
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int n) {
            try {
                SensorListener sensorListener = this.mTarget;
                int n2 = sensor.getLegacyType();
                sensorListener.onAccuracyChanged(n2, n);
                return;
            }
            catch (AbstractMethodError abstractMethodError) {
                return;
            }
        }

        @Override
        public void onSensorChanged(SensorEvent sensorEvent) {
            float f;
            float f2;
            float f3;
            float[] fArray = this.mValues;
            fArray[0] = f3 = sensorEvent.values[0];
            fArray[1] = f2 = sensorEvent.values[1];
            fArray[2] = f = sensorEvent.values[2];
            int n = sensorEvent.sensor.getLegacyType();
            int n2 = SensorManager.getRotation();
            this.mapSensorDataToWindow(n, fArray, n2);
            if (sensorEvent.sensor.getType() == 3) {
                float f4;
                if ((this.mSensors & 0x80) != 0) {
                    this.mTarget.onSensorChanged(128, fArray);
                }
                if ((this.mSensors & 1) == 0) {
                    return;
                }
                LmsFilter lmsFilter = this.mYawfilter;
                long l = sensorEvent.timestamp;
                float f5 = fArray[0];
                fArray[0] = f4 = lmsFilter.filter(l, f5);
                this.mTarget.onSensorChanged(1, fArray);
                return;
            }
            this.mTarget.onSensorChanged(n, fArray);
        }

        void registerSensor(int n) {
            int n2;
            this.mSensors = n2 = this.mSensors | n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean unregisterSensor(int n) {
            int n2;
            int n3 = this.mSensors;
            int n4 = ~n;
            this.mSensors = n2 = n3 & n4;
            if ((n & 0x81) == 0) return true;
            if ((this.mSensors & 0x81) == 0) return true;
            return false;
        }
    }

    private class ListenerDelegate {
        public SparseBooleanArray mFirstEvent;
        private final Handler mHandler;
        public SparseIntArray mSensorAccuracies;
        final SensorEventListener mSensorEventListener;
        private final ArrayList<Sensor> mSensorList;
        public SparseBooleanArray mSensors;
        private SensorEvent mValuesPool;

        /*
         * Enabled aggressive block sorting
         */
        ListenerDelegate(SensorEventListener sensorEventListener, Sensor sensor, Handler handler) {
            Handler handler2;
            SparseIntArray sparseIntArray;
            SparseBooleanArray sparseBooleanArray;
            SparseBooleanArray sparseBooleanArray2;
            ArrayList arrayList = new ArrayList();
            this.mSensorList = arrayList;
            this.mSensors = sparseBooleanArray2 = new SparseBooleanArray();
            this.mFirstEvent = sparseBooleanArray = new SparseBooleanArray();
            this.mSensorAccuracies = sparseIntArray = new SparseIntArray();
            this.mSensorEventListener = sensorEventListener;
            Looper looper = handler != null ? handler.getLooper() : SensorManager.this.mMainLooper;
            this.mHandler = handler2 = new Handler(looper){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void handleMessage(Message message) {
                    SensorEvent sensorEvent = (SensorEvent)message.obj;
                    int n = sensorEvent.sensor.getHandle();
                    switch (sensorEvent.sensor.getType()) {
                        default: {
                            if (ListenerDelegate.this.mFirstEvent.get(n)) break;
                            ListenerDelegate.this.mFirstEvent.put(n, true);
                            SensorEventListener sensorEventListener = ListenerDelegate.this.mSensorEventListener;
                            Sensor sensor = sensorEvent.sensor;
                            sensorEventListener.onAccuracyChanged(sensor, 3);
                            break;
                        }
                        case 2: 
                        case 3: {
                            int n2;
                            int n3 = ListenerDelegate.this.mSensorAccuracies.get(n);
                            if (sensorEvent.accuracy < 0 || n3 == (n2 = sensorEvent.accuracy)) break;
                            SparseIntArray sparseIntArray = ListenerDelegate.this.mSensorAccuracies;
                            int n4 = sensorEvent.accuracy;
                            sparseIntArray.put(n, n4);
                            SensorEventListener sensorEventListener = ListenerDelegate.this.mSensorEventListener;
                            Sensor sensor = sensorEvent.sensor;
                            int n5 = sensorEvent.accuracy;
                            sensorEventListener.onAccuracyChanged(sensor, n5);
                        }
                    }
                    ListenerDelegate.this.mSensorEventListener.onSensorChanged(sensorEvent);
                    ListenerDelegate.this.returnToPool(sensorEvent);
                }
            };
            this.addSensor(sensor);
        }

        void addSensor(Sensor sensor) {
            SparseBooleanArray sparseBooleanArray = this.mSensors;
            int n = sensor.getHandle();
            sparseBooleanArray.put(n, true);
            boolean bl = this.mSensorList.add(sensor);
        }

        protected SensorEvent createSensorEvent() {
            return new SensorEvent(3);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected SensorEvent getFromPool() {
            SensorEvent sensorEvent;
            synchronized (this) {
                sensorEvent = this.mValuesPool;
                this.mValuesPool = null;
            }
            if (sensorEvent != null) return sensorEvent;
            return this.createSensorEvent();
        }

        Object getListener() {
            return this.mSensorEventListener;
        }

        List<Sensor> getSensors() {
            return this.mSensorList;
        }

        boolean hasSensor(Sensor sensor) {
            SparseBooleanArray sparseBooleanArray = this.mSensors;
            int n = sensor.getHandle();
            return sparseBooleanArray.get(n);
        }

        void onSensorChangedLocked(Sensor sensor, float[] fArray, long[] lArray, int n) {
            long l;
            float f;
            float f2;
            float f3;
            SensorEvent sensorEvent = this.getFromPool();
            float[] fArray2 = sensorEvent.values;
            fArray2[0] = f3 = fArray[0];
            fArray2[1] = f2 = fArray[1];
            fArray2[2] = f = fArray[2];
            sensorEvent.timestamp = l = lArray[0];
            sensorEvent.accuracy = n;
            sensorEvent.sensor = sensor;
            Message message = Message.obtain();
            message.what = 0;
            message.obj = sensorEvent;
            boolean bl = this.mHandler.sendMessage(message);
        }

        int removeSensor(Sensor sensor) {
            SparseBooleanArray sparseBooleanArray = this.mSensors;
            int n = sensor.getHandle();
            sparseBooleanArray.delete(n);
            boolean bl = this.mSensorList.remove(sensor);
            return this.mSensors.size();
        }

        protected void returnToPool(SensorEvent sensorEvent) {
            synchronized (this) {
                if (this.mValuesPool == null) {
                    this.mValuesPool = sensorEvent;
                }
                return;
            }
        }
    }

    private static class SensorThread {
        boolean mSensorsReady;
        Thread mThread;

        SensorThread() {
        }

        protected void finalize() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        boolean startLocked() {
            block8: {
                if (this.mThread != null) break block8;
                this.mSensorsReady = false;
                SensorThreadRunnable sensorThreadRunnable = new SensorThreadRunnable();
                String string2 = SensorThread.class.getName();
                Thread thread = new Thread(sensorThreadRunnable, string2);
                thread.start();
                // MONITORENTER : sensorThreadRunnable
                while (!this.mSensorsReady) {
                    sensorThreadRunnable.wait();
                }
                // MONITOREXIT : sensorThreadRunnable
                try {
                    this.mThread = thread;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.mThread != null) return true;
            return false;
        }

        private class SensorThreadRunnable
        implements Runnable {
            SensorThreadRunnable() {
            }

            private boolean open() {
                int n = SensorManager.access$002(SensorManager.sensors_create_queue());
                return true;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                float[] fArray = new float[3];
                int[] nArray = new int[1];
                Process.setThreadPriority(-1);
                if (!this.open()) {
                    return;
                }
                synchronized (this) {
                    SensorThread.this.mSensorsReady = true;
                    this.notify();
                }
                while (true) {
                    int n = SensorManager.sensors_data_poll(sQueue, fArray, nArray, null);
                    int n2 = nArray[0];
                    ArrayList<ListenerDelegate> arrayList = sListeners;
                    synchronized (arrayList) {
                        if (n == -1 || sListeners.isEmpty()) {
                            if (n == -1 && !sListeners.isEmpty()) {
                                String string2 = "_sensors_data_poll() failed, we bail out: sensors=" + n;
                                int n3 = Log.e(SensorManager.TAG, string2);
                            }
                            SensorManager.sensors_destroy_queue(sQueue);
                            int n4 = SensorManager.access$002(0);
                            SensorThread.this.mThread = null;
                            return;
                        }
                        Sensor sensor = sHandleToSensor.get(n);
                        if (sensor != null) {
                            int n5 = sListeners.size();
                            for (int i = 0; i < n5; ++i) {
                                ListenerDelegate listenerDelegate = sListeners.get(i);
                                if (!listenerDelegate.hasSensor(sensor)) continue;
                                listenerDelegate.onSensorChangedLocked(sensor, fArray, null, n2);
                            }
                        }
                    }
                }
            }
        }
    }
}

