/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.app.Service;
import android.content.Intent;
import android.inputmethodservice.IInputMethodWrapper;
import android.os.IBinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.inputmethod.InputMethod;
import android.view.inputmethod.InputMethodSession;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class AbstractInputMethodService
extends Service
implements KeyEvent.Callback {
    final KeyEvent.DispatcherState mDispatcherState;
    private InputMethod mInputMethod;

    public AbstractInputMethodService() {
        KeyEvent.DispatcherState dispatcherState;
        this.mDispatcherState = dispatcherState = new KeyEvent.DispatcherState();
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    public KeyEvent.DispatcherState getKeyDispatcherState() {
        return this.mDispatcherState;
    }

    @Override
    public final IBinder onBind(Intent intent) {
        if (this.mInputMethod == null) {
            AbstractInputMethodImpl abstractInputMethodImpl = this.onCreateInputMethodInterface();
            this.mInputMethod = abstractInputMethodImpl;
        }
        InputMethod inputMethod = this.mInputMethod;
        return new IInputMethodWrapper(this, inputMethod);
    }

    public abstract AbstractInputMethodImpl onCreateInputMethodInterface();

    public abstract AbstractInputMethodSessionImpl onCreateInputMethodSessionInterface();

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return false;
    }

    public abstract class AbstractInputMethodSessionImpl
    implements InputMethodSession {
        boolean mEnabled = true;
        boolean mRevoked;

        @Override
        public void dispatchKeyEvent(int n, KeyEvent keyEvent, InputMethodSession.EventCallback eventCallback) {
            AbstractInputMethodService abstractInputMethodService = AbstractInputMethodService.this;
            KeyEvent.DispatcherState dispatcherState = AbstractInputMethodService.this.mDispatcherState;
            boolean bl = keyEvent.dispatch(abstractInputMethodService, dispatcherState, this);
            if (eventCallback == null) {
                return;
            }
            eventCallback.finishedEvent(n, bl);
        }

        @Override
        public void dispatchTrackballEvent(int n, MotionEvent motionEvent, InputMethodSession.EventCallback eventCallback) {
            boolean bl = AbstractInputMethodService.this.onTrackballEvent(motionEvent);
            if (eventCallback == null) {
                return;
            }
            eventCallback.finishedEvent(n, bl);
        }

        public boolean isEnabled() {
            return this.mEnabled;
        }

        public boolean isRevoked() {
            return this.mRevoked;
        }

        public void revokeSelf() {
            this.mRevoked = true;
            this.mEnabled = false;
        }

        public void setEnabled(boolean bl) {
            if (this.mRevoked) {
                return;
            }
            this.mEnabled = bl;
        }
    }

    public abstract class AbstractInputMethodImpl
    implements InputMethod {
        @Override
        public void createSession(InputMethod.SessionCallback sessionCallback) {
            AbstractInputMethodSessionImpl abstractInputMethodSessionImpl = AbstractInputMethodService.this.onCreateInputMethodSessionInterface();
            sessionCallback.sessionCreated(abstractInputMethodSessionImpl);
        }

        @Override
        public void revokeSession(InputMethodSession inputMethodSession) {
            ((AbstractInputMethodSessionImpl)inputMethodSession).revokeSelf();
        }

        @Override
        public void setSessionEnabled(InputMethodSession inputMethodSession, boolean bl) {
            ((AbstractInputMethodSessionImpl)inputMethodSession).setEnabled(bl);
        }
    }
}

