/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputMethodSession;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodSession;

class IInputMethodSessionWrapper
extends IInputMethodSession.Stub
implements HandlerCaller.Callback {
    private static final boolean DEBUG = false;
    private static final int DO_APP_PRIVATE_COMMAND = 100;
    private static final int DO_DISPATCH_KEY_EVENT = 70;
    private static final int DO_DISPATCH_TRACKBALL_EVENT = 80;
    private static final int DO_DISPLAY_COMPLETIONS = 65;
    private static final int DO_FINISH_INPUT = 60;
    private static final int DO_FINISH_SESSION = 110;
    private static final int DO_TOGGLE_SOFT_INPUT = 105;
    private static final int DO_UPDATE_CURSOR = 95;
    private static final int DO_UPDATE_EXTRACTED_TEXT = 67;
    private static final int DO_UPDATE_SELECTION = 90;
    private static final String TAG = "InputMethodWrapper";
    HandlerCaller mCaller;
    InputMethodSession mInputMethodSession;

    public IInputMethodSessionWrapper(Context context, InputMethodSession inputMethodSession) {
        HandlerCaller handlerCaller;
        this.mCaller = handlerCaller = new HandlerCaller(context, this);
        this.mInputMethodSession = inputMethodSession;
    }

    @Override
    public void appPrivateCommand(String string2, Bundle bundle) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageOO(100, string2, bundle);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void dispatchKeyEvent(int n, KeyEvent keyEvent, IInputMethodCallback iInputMethodCallback) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageIOO(70, n, keyEvent, iInputMethodCallback);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void dispatchTrackballEvent(int n, MotionEvent motionEvent, IInputMethodCallback iInputMethodCallback) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageIOO(80, n, motionEvent, iInputMethodCallback);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void displayCompletions(CompletionInfo[] completionInfoArray) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageO(65, completionInfoArray);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void executeMessage(Message message) {
        switch (message.what) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Unhandled message code: ");
                int n = message.what;
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.w(TAG, string2);
                return;
            }
            case 60: {
                this.mInputMethodSession.finishInput();
                return;
            }
            case 65: {
                InputMethodSession inputMethodSession = this.mInputMethodSession;
                CompletionInfo[] completionInfoArray = (CompletionInfo[])message.obj;
                inputMethodSession.displayCompletions(completionInfoArray);
                return;
            }
            case 67: {
                InputMethodSession inputMethodSession = this.mInputMethodSession;
                int n = message.arg1;
                ExtractedText extractedText = (ExtractedText)message.obj;
                inputMethodSession.updateExtractedText(n, extractedText);
                return;
            }
            case 70: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                InputMethodSession inputMethodSession = this.mInputMethodSession;
                int n = message.arg1;
                KeyEvent keyEvent = (KeyEvent)someArgs.arg1;
                IInputMethodCallback iInputMethodCallback = (IInputMethodCallback)someArgs.arg2;
                InputMethodEventCallbackWrapper inputMethodEventCallbackWrapper = new InputMethodEventCallbackWrapper(iInputMethodCallback);
                inputMethodSession.dispatchKeyEvent(n, keyEvent, inputMethodEventCallbackWrapper);
                this.mCaller.recycleArgs(someArgs);
                return;
            }
            case 80: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                InputMethodSession inputMethodSession = this.mInputMethodSession;
                int n = message.arg1;
                MotionEvent motionEvent = (MotionEvent)someArgs.arg1;
                IInputMethodCallback iInputMethodCallback = (IInputMethodCallback)someArgs.arg2;
                InputMethodEventCallbackWrapper inputMethodEventCallbackWrapper = new InputMethodEventCallbackWrapper(iInputMethodCallback);
                inputMethodSession.dispatchTrackballEvent(n, motionEvent, inputMethodEventCallbackWrapper);
                this.mCaller.recycleArgs(someArgs);
                return;
            }
            case 90: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                InputMethodSession inputMethodSession = this.mInputMethodSession;
                int n = someArgs.argi1;
                int n3 = someArgs.argi2;
                int n4 = someArgs.argi3;
                int n5 = someArgs.argi4;
                int n6 = someArgs.argi5;
                int n7 = someArgs.argi6;
                inputMethodSession.updateSelection(n, n3, n4, n5, n6, n7);
                this.mCaller.recycleArgs(someArgs);
                return;
            }
            case 95: {
                InputMethodSession inputMethodSession = this.mInputMethodSession;
                Rect rect = (Rect)message.obj;
                inputMethodSession.updateCursor(rect);
                return;
            }
            case 100: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                InputMethodSession inputMethodSession = this.mInputMethodSession;
                String string3 = (String)someArgs.arg1;
                Bundle bundle = (Bundle)someArgs.arg2;
                inputMethodSession.appPrivateCommand(string3, bundle);
                this.mCaller.recycleArgs(someArgs);
                return;
            }
            case 105: {
                InputMethodSession inputMethodSession = this.mInputMethodSession;
                int n = message.arg1;
                int n8 = message.arg2;
                inputMethodSession.toggleSoftInput(n, n8);
                return;
            }
            case 110: 
        }
        this.mInputMethodSession = null;
    }

    @Override
    public void finishInput() {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessage(60);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void finishSession() {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessage(110);
        handlerCaller.executeOrSendMessage(message);
    }

    public InputMethodSession getInternalInputMethodSession() {
        return this.mInputMethodSession;
    }

    @Override
    public void toggleSoftInput(int n, int n2) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageII(105, n, n2);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void updateCursor(Rect rect) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageO(95, rect);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void updateExtractedText(int n, ExtractedText extractedText) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageIO(67, n, extractedText);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void updateSelection(int n, int n2, int n3, int n4, int n5, int n6) {
        HandlerCaller handlerCaller = this.mCaller;
        HandlerCaller handlerCaller2 = this.mCaller;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        Message message = handlerCaller2.obtainMessageIIIIII(90, n7, n8, n9, n10, n11, n12);
        handlerCaller.executeOrSendMessage(message);
    }

    static class InputMethodEventCallbackWrapper
    implements InputMethodSession.EventCallback {
        final IInputMethodCallback mCb;

        InputMethodEventCallbackWrapper(IInputMethodCallback iInputMethodCallback) {
            this.mCb = iInputMethodCallback;
        }

        @Override
        public void finishedEvent(int n, boolean bl) {
            try {
                this.mCb.finishedEvent(n, bl);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }
}

