/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.inputmethodservice.AbstractInputMethodService;
import android.inputmethodservice.IInputMethodSessionWrapper;
import android.os.Binder;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethod;
import android.view.inputmethod.InputMethodSession;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethod;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.InputConnectionWrapper;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class IInputMethodWrapper
extends IInputMethod.Stub
implements HandlerCaller.Callback {
    private static final boolean DEBUG = false;
    private static final int DO_ATTACH_TOKEN = 10;
    private static final int DO_CREATE_SESSION = 40;
    private static final int DO_DUMP = 1;
    private static final int DO_HIDE_SOFT_INPUT = 70;
    private static final int DO_RESTART_INPUT = 34;
    private static final int DO_REVOKE_SESSION = 50;
    private static final int DO_SET_INPUT_CONTEXT = 20;
    private static final int DO_SET_SESSION_ENABLED = 45;
    private static final int DO_SHOW_SOFT_INPUT = 60;
    private static final int DO_START_INPUT = 32;
    private static final int DO_UNSET_INPUT_CONTEXT = 30;
    private static final String TAG = "InputMethodWrapper";
    final HandlerCaller mCaller;
    final WeakReference<InputMethod> mInputMethod;
    final WeakReference<AbstractInputMethodService> mTarget;

    public IInputMethodWrapper(AbstractInputMethodService abstractInputMethodService, InputMethod inputMethod) {
        HandlerCaller handlerCaller;
        WeakReference<AbstractInputMethodService> weakReference = new WeakReference<AbstractInputMethodService>(abstractInputMethodService);
        this.mTarget = weakReference;
        Context context = abstractInputMethodService.getApplicationContext();
        this.mCaller = handlerCaller = new HandlerCaller(context, this);
        WeakReference<InputMethod> weakReference2 = new WeakReference<InputMethod>(inputMethod);
        this.mInputMethod = weakReference2;
    }

    @Override
    public void attachToken(IBinder iBinder) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageO(10, iBinder);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void bindInput(InputBinding inputBinding) {
        IInputContext iInputContext = IInputContext.Stub.asInterface(inputBinding.getConnectionToken());
        InputConnectionWrapper inputConnectionWrapper = new InputConnectionWrapper(iInputContext);
        InputBinding inputBinding2 = new InputBinding(inputConnectionWrapper, inputBinding);
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageO(20, inputBinding2);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void createSession(IInputMethodCallback iInputMethodCallback) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageO(40, iInputMethodCallback);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        AbstractInputMethodService abstractInputMethodService = (AbstractInputMethodService)this.mTarget.get();
        if (abstractInputMethodService == null) {
            return;
        }
        if (abstractInputMethodService.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            StringBuilder stringBuilder = new StringBuilder().append("Permission Denial: can't dump InputMethodManager from from pid=");
            int n = Binder.getCallingPid();
            StringBuilder stringBuilder2 = stringBuilder.append(n).append(", uid=");
            int n2 = Binder.getCallingUid();
            String string2 = stringBuilder2.append(n2).toString();
            printWriter.println(string2);
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        HandlerCaller handlerCaller = this.mCaller;
        HandlerCaller handlerCaller2 = this.mCaller;
        FileDescriptor fileDescriptor2 = fileDescriptor;
        PrintWriter printWriter2 = printWriter;
        String[] stringArray2 = stringArray;
        Message message = handlerCaller2.obtainMessageOOOO(1, fileDescriptor2, printWriter2, stringArray2, countDownLatch);
        handlerCaller.executeOrSendMessage(message);
        long l = 5L;
        try {
            TimeUnit timeUnit = TimeUnit.SECONDS;
            if (countDownLatch.await(l, timeUnit)) {
                return;
            }
            printWriter.println("Timeout waiting for dump");
            return;
        }
        catch (InterruptedException interruptedException) {
            printWriter.println("Interrupted waiting for dump");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeMessage(Message message) {
        InputMethod inputMethod = (InputMethod)((IInputMethodWrapper)((Object)inputMethodSession)).mInputMethod.get();
        if (inputMethod == null && message.what != 1) {
            StringBuilder stringBuilder = new StringBuilder().append("Input method reference was null, ignoring message: ");
            int n = message.what;
            String string2 = stringBuilder.append(n).toString();
            int n2 = Log.w(TAG, string2);
            return;
        }
        switch (message.what) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Unhandled message code: ");
                int n = message.what;
                String string3 = stringBuilder.append(n).toString();
                int n3 = Log.w(TAG, string3);
                return;
            }
            case 1: {
                AbstractInputMethodService abstractInputMethodService = (AbstractInputMethodService)((IInputMethodWrapper)((Object)inputMethodSession)).mTarget.get();
                if (abstractInputMethodService == null) {
                    return;
                }
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                try {
                    FileDescriptor fileDescriptor = (FileDescriptor)someArgs.arg1;
                    PrintWriter printWriter = (PrintWriter)someArgs.arg2;
                    String[] stringArray = (String[])someArgs.arg3;
                    abstractInputMethodService.dump(fileDescriptor, printWriter, stringArray);
                }
                catch (RuntimeException runtimeException) {
                    PrintWriter printWriter = (PrintWriter)someArgs.arg2;
                    String string4 = "Exception: " + runtimeException;
                    printWriter.println(string4);
                }
                Object object = someArgs.arg4;
                synchronized (object) {
                    ((CountDownLatch)someArgs.arg4).countDown();
                    return;
                }
            }
            case 10: {
                IBinder iBinder = (IBinder)message.obj;
                inputMethod.attachToken(iBinder);
                return;
            }
            case 20: {
                InputBinding inputBinding = (InputBinding)message.obj;
                inputMethod.bindInput(inputBinding);
                return;
            }
            case 30: {
                inputMethod.unbindInput();
                return;
            }
            case 32: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                IInputContext iInputContext = (IInputContext)someArgs.arg1;
                InputConnectionWrapper inputConnectionWrapper = iInputContext != null ? new InputConnectionWrapper(iInputContext) : null;
                EditorInfo editorInfo = (EditorInfo)someArgs.arg2;
                inputMethod.startInput(inputConnectionWrapper, editorInfo);
                return;
            }
            case 34: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                IInputContext iInputContext = (IInputContext)someArgs.arg1;
                InputConnectionWrapper inputConnectionWrapper = iInputContext != null ? new InputConnectionWrapper(iInputContext) : null;
                EditorInfo editorInfo = (EditorInfo)someArgs.arg2;
                inputMethod.restartInput(inputConnectionWrapper, editorInfo);
                return;
            }
            case 40: {
                Context context = ((IInputMethodWrapper)((Object)inputMethodSession)).mCaller.mContext;
                IInputMethodCallback iInputMethodCallback = (IInputMethodCallback)message.obj;
                InputMethodSessionCallbackWrapper inputMethodSessionCallbackWrapper = new InputMethodSessionCallbackWrapper(context, iInputMethodCallback);
                inputMethod.createSession(inputMethodSessionCallbackWrapper);
                return;
            }
            case 45: {
                InputMethodSession inputMethodSession = (InputMethodSession)message.obj;
                boolean bl = message.arg1 != 0;
                inputMethod.setSessionEnabled(inputMethodSession, bl);
                return;
            }
            case 50: {
                InputMethodSession inputMethodSession = (InputMethodSession)message.obj;
                inputMethod.revokeSession(inputMethodSession);
                return;
            }
            case 60: {
                int n = message.arg1;
                ResultReceiver resultReceiver = (ResultReceiver)message.obj;
                inputMethod.showSoftInput(n, resultReceiver);
                return;
            }
            case 70: 
        }
        int n = message.arg1;
        ResultReceiver resultReceiver = (ResultReceiver)message.obj;
        inputMethod.hideSoftInput(n, resultReceiver);
    }

    public InputMethod getInternalInputMethod() {
        return (InputMethod)this.mInputMethod.get();
    }

    @Override
    public void hideSoftInput(int n, ResultReceiver resultReceiver) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageIO(70, n, resultReceiver);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void restartInput(IInputContext iInputContext, EditorInfo editorInfo) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageOO(34, iInputContext, editorInfo);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void revokeSession(IInputMethodSession iInputMethodSession) {
        try {
            InputMethodSession inputMethodSession = ((IInputMethodSessionWrapper)iInputMethodSession).getInternalInputMethodSession();
            HandlerCaller handlerCaller = this.mCaller;
            Message message = this.mCaller.obtainMessageO(50, inputMethodSession);
            handlerCaller.executeOrSendMessage(message);
            return;
        }
        catch (ClassCastException classCastException) {
            String string2 = "Incoming session not of correct type: " + iInputMethodSession;
            int n = Log.w(TAG, string2, classCastException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setSessionEnabled(IInputMethodSession iInputMethodSession, boolean bl) {
        try {
            InputMethodSession inputMethodSession = ((IInputMethodSessionWrapper)iInputMethodSession).getInternalInputMethodSession();
            HandlerCaller handlerCaller = this.mCaller;
            HandlerCaller handlerCaller2 = this.mCaller;
            int n = bl ? 1 : 0;
            Message message = handlerCaller2.obtainMessageIO(45, n, inputMethodSession);
            handlerCaller.executeOrSendMessage(message);
            return;
        }
        catch (ClassCastException classCastException) {
            String string2 = "Incoming session not of correct type: " + iInputMethodSession;
            int n = Log.w(TAG, string2, classCastException);
            return;
        }
    }

    @Override
    public void showSoftInput(int n, ResultReceiver resultReceiver) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageIO(60, n, resultReceiver);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void startInput(IInputContext iInputContext, EditorInfo editorInfo) {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessageOO(32, iInputContext, editorInfo);
        handlerCaller.executeOrSendMessage(message);
    }

    @Override
    public void unbindInput() {
        HandlerCaller handlerCaller = this.mCaller;
        Message message = this.mCaller.obtainMessage(30);
        handlerCaller.executeOrSendMessage(message);
    }

    static class InputMethodSessionCallbackWrapper
    implements InputMethod.SessionCallback {
        final IInputMethodCallback mCb;
        final Context mContext;

        InputMethodSessionCallbackWrapper(Context context, IInputMethodCallback iInputMethodCallback) {
            this.mContext = context;
            this.mCb = iInputMethodCallback;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void sessionCreated(InputMethodSession var1_1) {
            if (var1_1 == null) ** GOTO lbl7
            try {
                var2_2 = this.mContext;
                var3_3 = new IInputMethodSessionWrapper(var2_2, var1_1);
                this.mCb.sessionCreated(var3_3);
                return;
lbl7:
                // 1 sources

                this.mCb.sessionCreated(null);
                return;
            }
            catch (RemoteException var4_4) {
                return;
            }
        }
    }

    static class Notifier {
        boolean notified;

        Notifier() {
        }
    }
}

