/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.AbstractInputMethodService;
import android.inputmethodservice.ExtractEditText;
import android.inputmethodservice.SoftInputWindow;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.Editable;
import android.text.Layout;
import android.text.method.MovementMethod;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class InputMethodService
extends AbstractInputMethodService {
    static final boolean DEBUG = false;
    static final int MOVEMENT_DOWN = 255;
    static final int MOVEMENT_UP = 254;
    static final String TAG = "InputMethodService";
    final View.OnClickListener mActionClickListener;
    FrameLayout mCandidatesFrame;
    boolean mCandidatesViewStarted;
    int mCandidatesVisibility;
    CompletionInfo[] mCurCompletions;
    ViewGroup mExtractAccessories;
    Button mExtractAction;
    ExtractEditText mExtractEditText;
    FrameLayout mExtractFrame;
    View mExtractView;
    boolean mExtractViewHidden;
    ExtractedText mExtractedText;
    int mExtractedToken;
    boolean mFullscreenApplied;
    ViewGroup mFullscreenArea;
    InputMethodManager mImm;
    boolean mInShowWindow;
    LayoutInflater mInflater;
    boolean mInitialized;
    InputBinding mInputBinding;
    InputConnection mInputConnection;
    EditorInfo mInputEditorInfo;
    FrameLayout mInputFrame;
    boolean mInputStarted;
    View mInputView;
    boolean mInputViewStarted;
    final ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer;
    boolean mIsFullscreen;
    boolean mIsInputViewShown;
    boolean mLastShowInputRequested;
    View mRootView;
    int mShowInputFlags;
    boolean mShowInputForced;
    boolean mShowInputRequested;
    InputConnection mStartedInputConnection;
    int mStatusIcon;
    int mTheme = 16973908;
    TypedArray mThemeAttrs;
    final Insets mTmpInsets;
    final int[] mTmpLocation;
    IBinder mToken;
    SoftInputWindow mWindow;
    boolean mWindowAdded;
    boolean mWindowCreated;
    boolean mWindowVisible;
    boolean mWindowWasVisible;

    public InputMethodService() {
        View.OnClickListener onClickListener;
        ViewTreeObserver.OnComputeInternalInsetsListener onComputeInternalInsetsListener;
        Insets insets;
        this.mTmpInsets = insets = new Insets();
        int[] nArray = new int[2];
        this.mTmpLocation = nArray;
        this.mInsetsComputer = onComputeInternalInsetsListener = new ViewTreeObserver.OnComputeInternalInsetsListener(){

            @Override
            public void onComputeInternalInsets(ViewTreeObserver.InternalInsetsInfo internalInsetsInfo) {
                int n;
                int n2;
                if (InputMethodService.this.isExtractViewShown()) {
                    int n3;
                    View view = InputMethodService.this.getWindow().getWindow().getDecorView();
                    Rect rect = internalInsetsInfo.contentInsets;
                    Rect rect2 = internalInsetsInfo.visibleInsets;
                    rect2.top = n3 = view.getHeight();
                    rect.top = n3;
                    internalInsetsInfo.setTouchableInsets(0);
                    return;
                }
                InputMethodService inputMethodService = InputMethodService.this;
                Insets insets = InputMethodService.this.mTmpInsets;
                inputMethodService.onComputeInsets(insets);
                Rect rect = internalInsetsInfo.contentInsets;
                rect.top = n2 = InputMethodService.this.mTmpInsets.contentTopInsets;
                Rect rect3 = internalInsetsInfo.visibleInsets;
                rect3.top = n = InputMethodService.this.mTmpInsets.visibleTopInsets;
                int n4 = InputMethodService.this.mTmpInsets.touchableInsets;
                internalInsetsInfo.setTouchableInsets(n4);
            }
        };
        this.mActionClickListener = onClickListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                EditorInfo editorInfo = InputMethodService.this.getCurrentInputEditorInfo();
                InputConnection inputConnection = InputMethodService.this.getCurrentInputConnection();
                if (editorInfo == null) {
                    return;
                }
                if (inputConnection == null) {
                    return;
                }
                if (editorInfo.actionId != 0) {
                    int n = editorInfo.actionId;
                    boolean bl = inputConnection.performEditorAction(n);
                    return;
                }
                if ((editorInfo.imeOptions & 0xFF) == 1) {
                    return;
                }
                int n = editorInfo.imeOptions & 0xFF;
                boolean bl = inputConnection.performEditorAction(n);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleBack(boolean bl) {
        if (this.mShowInputRequested) {
            if (!bl) return true;
            this.requestHideSelf(0);
            return true;
        }
        if (!this.mWindowVisible) return false;
        if (this.mCandidatesVisibility == 0) {
            if (!bl) return true;
            this.setCandidatesViewShown(false);
            return true;
        }
        if (!bl) return true;
        this.hideWindow();
        return true;
    }

    private void onToggleSoftInput(int n, int n2) {
        if (this.isInputViewShown()) {
            this.requestHideSelf(n2);
            return;
        }
        this.requestShowSelf(n);
    }

    private void requestShowSelf(int n) {
        InputMethodManager inputMethodManager = this.mImm;
        IBinder iBinder = this.mToken;
        inputMethodManager.showSoftInputFromInputMethod(iBinder, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void doFinishInput() {
        if (this.mInputViewStarted) {
            this.onFinishInputView(true);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(true);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (this.mInputStarted) {
            this.onFinishInput();
        }
        this.mInputStarted = false;
        this.mStartedInputConnection = null;
        this.mCurCompletions = null;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    boolean doMovementKey(int n, KeyEvent keyEvent, int n2) {
        ExtractEditText extractEditText = this.mExtractEditText;
        if (!this.isExtractViewShown()) return false;
        if (!this.isInputViewShown()) return false;
        if (extractEditText == null) return false;
        MovementMethod movementMethod = extractEditText.getMovementMethod();
        Layout layout2 = extractEditText.getLayout();
        if (movementMethod != null && layout2 != null) {
            if (n2 == -1) {
                Editable editable = extractEditText.getText();
                if (movementMethod.onKeyDown(extractEditText, editable, n, keyEvent)) {
                    this.reportExtractedMovement(n, 1);
                    return true;
                }
            } else if (n2 == -1) {
                Editable editable = extractEditText.getText();
                if (movementMethod.onKeyUp(extractEditText, editable, n, keyEvent)) {
                    return true;
                }
            } else {
                Editable editable = extractEditText.getText();
                if (movementMethod.onKeyOther(extractEditText, editable, keyEvent)) {
                    this.reportExtractedMovement(n, n2);
                } else {
                    KeyEvent keyEvent2 = KeyEvent.changeAction(keyEvent, 0);
                    Editable editable2 = extractEditText.getText();
                    if (movementMethod.onKeyDown(extractEditText, editable2, n, keyEvent2)) {
                        KeyEvent keyEvent3 = KeyEvent.changeAction(keyEvent, 1);
                        Editable editable3 = extractEditText.getText();
                        boolean bl = movementMethod.onKeyUp(extractEditText, editable3, n, keyEvent3);
                        while ((n2 += -1) > 0) {
                            Editable editable4 = extractEditText.getText();
                            boolean bl2 = movementMethod.onKeyDown(extractEditText, editable4, n, keyEvent2);
                            Editable editable5 = extractEditText.getText();
                            boolean bl3 = movementMethod.onKeyUp(extractEditText, editable5, n, keyEvent3);
                        }
                        this.reportExtractedMovement(n, n2);
                    }
                }
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
        }
        return true;
    }

    void doStartInput(InputConnection inputConnection, EditorInfo editorInfo, boolean bl) {
        if (!bl) {
            this.doFinishInput();
        }
        this.mInputStarted = true;
        this.mStartedInputConnection = inputConnection;
        this.mInputEditorInfo = editorInfo;
        this.initialize();
        this.onStartInput(editorInfo, bl);
        if (!this.mWindowVisible) {
            return;
        }
        if (this.mShowInputRequested) {
            this.mInputViewStarted = true;
            EditorInfo editorInfo2 = this.mInputEditorInfo;
            this.onStartInputView(editorInfo2, bl);
            this.startExtractingText(true);
            return;
        }
        if (this.mCandidatesVisibility != 0) {
            return;
        }
        this.mCandidatesViewStarted = true;
        EditorInfo editorInfo3 = this.mInputEditorInfo;
        this.onStartCandidatesView(editorInfo3, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        PrintWriterPrinter printWriterPrinter = new PrintWriterPrinter(printWriter);
        String string2 = "Input method service state for " + this + ":";
        printWriterPrinter.println(string2);
        StringBuilder stringBuilder = new StringBuilder().append("  mWindowCreated=");
        boolean bl = this.mWindowCreated;
        StringBuilder stringBuilder2 = stringBuilder.append(bl).append(" mWindowAdded=");
        boolean bl2 = this.mWindowAdded;
        String string3 = stringBuilder2.append(bl2).toString();
        printWriterPrinter.println(string3);
        StringBuilder stringBuilder3 = new StringBuilder().append("  mWindowVisible=");
        boolean bl3 = this.mWindowVisible;
        StringBuilder stringBuilder4 = stringBuilder3.append(bl3).append(" mWindowWasVisible=");
        boolean bl4 = this.mWindowWasVisible;
        StringBuilder stringBuilder5 = stringBuilder4.append(bl4).append(" mInShowWindow=");
        boolean bl5 = this.mInShowWindow;
        String string4 = stringBuilder5.append(bl5).toString();
        printWriterPrinter.println(string4);
        StringBuilder stringBuilder6 = new StringBuilder().append("  Configuration=");
        Configuration configuration = this.getResources().getConfiguration();
        String string5 = stringBuilder6.append(configuration).toString();
        printWriterPrinter.println(string5);
        StringBuilder stringBuilder7 = new StringBuilder().append("  mToken=");
        IBinder iBinder = this.mToken;
        String string6 = stringBuilder7.append(iBinder).toString();
        printWriterPrinter.println(string6);
        StringBuilder stringBuilder8 = new StringBuilder().append("  mInputBinding=");
        InputBinding inputBinding = this.mInputBinding;
        String string7 = stringBuilder8.append(inputBinding).toString();
        printWriterPrinter.println(string7);
        StringBuilder stringBuilder9 = new StringBuilder().append("  mInputConnection=");
        InputConnection inputConnection = this.mInputConnection;
        String string8 = stringBuilder9.append(inputConnection).toString();
        printWriterPrinter.println(string8);
        StringBuilder stringBuilder10 = new StringBuilder().append("  mStartedInputConnection=");
        InputConnection inputConnection2 = this.mStartedInputConnection;
        String string9 = stringBuilder10.append(inputConnection2).toString();
        printWriterPrinter.println(string9);
        StringBuilder stringBuilder11 = new StringBuilder().append("  mInputStarted=");
        boolean bl6 = this.mInputStarted;
        StringBuilder stringBuilder12 = stringBuilder11.append(bl6).append(" mInputViewStarted=");
        boolean bl7 = this.mInputViewStarted;
        StringBuilder stringBuilder13 = stringBuilder12.append(bl7).append(" mCandidatesViewStarted=");
        boolean bl8 = this.mCandidatesViewStarted;
        String string10 = stringBuilder13.append(bl8).toString();
        printWriterPrinter.println(string10);
        if (this.mInputEditorInfo != null) {
            printWriterPrinter.println("  mInputEditorInfo:");
            this.mInputEditorInfo.dump(printWriterPrinter, "    ");
        } else {
            printWriterPrinter.println("  mInputEditorInfo: null");
        }
        StringBuilder stringBuilder14 = new StringBuilder().append("  mShowInputRequested=");
        boolean bl9 = this.mShowInputRequested;
        StringBuilder stringBuilder15 = stringBuilder14.append(bl9).append(" mLastShowInputRequested=");
        boolean bl10 = this.mLastShowInputRequested;
        StringBuilder stringBuilder16 = stringBuilder15.append(bl10).append(" mShowInputForced=");
        boolean bl11 = this.mShowInputForced;
        StringBuilder stringBuilder17 = stringBuilder16.append(bl11).append(" mShowInputFlags=0x");
        String string11 = Integer.toHexString(this.mShowInputFlags);
        String string12 = stringBuilder17.append(string11).toString();
        printWriterPrinter.println(string12);
        StringBuilder stringBuilder18 = new StringBuilder().append("  mCandidatesVisibility=");
        int n = this.mCandidatesVisibility;
        StringBuilder stringBuilder19 = stringBuilder18.append(n).append(" mFullscreenApplied=");
        boolean bl12 = this.mFullscreenApplied;
        StringBuilder stringBuilder20 = stringBuilder19.append(bl12).append(" mIsFullscreen=");
        boolean bl13 = this.mIsFullscreen;
        StringBuilder stringBuilder21 = stringBuilder20.append(bl13).append(" mExtractViewHidden=");
        boolean bl14 = this.mExtractViewHidden;
        String string13 = stringBuilder21.append(bl14).toString();
        printWriterPrinter.println(string13);
        if (this.mExtractedText != null) {
            printWriterPrinter.println("  mExtractedText:");
            StringBuilder stringBuilder22 = new StringBuilder().append("    text=");
            int n2 = this.mExtractedText.text.length();
            StringBuilder stringBuilder23 = stringBuilder22.append(n2).append(" chars").append(" startOffset=");
            int n3 = this.mExtractedText.startOffset;
            String string14 = stringBuilder23.append(n3).toString();
            printWriterPrinter.println(string14);
            StringBuilder stringBuilder24 = new StringBuilder().append("    selectionStart=");
            int n4 = this.mExtractedText.selectionStart;
            StringBuilder stringBuilder25 = stringBuilder24.append(n4).append(" selectionEnd=");
            int n5 = this.mExtractedText.selectionEnd;
            StringBuilder stringBuilder26 = stringBuilder25.append(n5).append(" flags=0x");
            String string15 = Integer.toHexString(this.mExtractedText.flags);
            String string16 = stringBuilder26.append(string15).toString();
            printWriterPrinter.println(string16);
        } else {
            printWriterPrinter.println("  mExtractedText: null");
        }
        StringBuilder stringBuilder27 = new StringBuilder().append("  mExtractedToken=");
        int n6 = this.mExtractedToken;
        String string17 = stringBuilder27.append(n6).toString();
        printWriterPrinter.println(string17);
        StringBuilder stringBuilder28 = new StringBuilder().append("  mIsInputViewShown=");
        boolean bl15 = this.mIsInputViewShown;
        StringBuilder stringBuilder29 = stringBuilder28.append(bl15).append(" mStatusIcon=");
        int n7 = this.mStatusIcon;
        String string18 = stringBuilder29.append(n7).toString();
        printWriterPrinter.println(string18);
        printWriterPrinter.println("Last computed insets:");
        StringBuilder stringBuilder30 = new StringBuilder().append("  contentTopInsets=");
        int n8 = this.mTmpInsets.contentTopInsets;
        StringBuilder stringBuilder31 = stringBuilder30.append(n8).append(" visibleTopInsets=");
        int n9 = this.mTmpInsets.visibleTopInsets;
        StringBuilder stringBuilder32 = stringBuilder31.append(n9).append(" touchableInsets=");
        int n10 = this.mTmpInsets.touchableInsets;
        String string19 = stringBuilder32.append(n10).toString();
        printWriterPrinter.println(string19);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCandidatesHiddenVisibility() {
        if (!this.isExtractViewShown()) return 4;
        return 8;
    }

    public InputBinding getCurrentInputBinding() {
        return this.mInputBinding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputConnection getCurrentInputConnection() {
        InputConnection inputConnection = this.mStartedInputConnection;
        if (inputConnection == null) return this.mInputConnection;
        return inputConnection;
    }

    public EditorInfo getCurrentInputEditorInfo() {
        return this.mInputEditorInfo;
    }

    public boolean getCurrentInputStarted() {
        return this.mInputStarted;
    }

    public LayoutInflater getLayoutInflater() {
        return this.mInflater;
    }

    public int getMaxWidth() {
        return ((WindowManager)this.getSystemService("window")).getDefaultDisplay().getWidth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getTextForImeAction(int n) {
        switch (n & 0xFF) {
            default: {
                return this.getText(17040213);
            }
            case 1: {
                return null;
            }
            case 2: {
                return this.getText(17040208);
            }
            case 3: {
                return this.getText(17040209);
            }
            case 4: {
                return this.getText(17040210);
            }
            case 5: {
                return this.getText(17040211);
            }
            case 6: 
        }
        return this.getText(17040212);
    }

    public Dialog getWindow() {
        return this.mWindow;
    }

    public void hideStatusIcon() {
        this.mStatusIcon = 0;
        InputMethodManager inputMethodManager = this.mImm;
        IBinder iBinder = this.mToken;
        inputMethodManager.hideStatusIcon(iBinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void hideWindow() {
        if (this.mInputViewStarted) {
            this.onFinishInputView(false);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(false);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (!this.mWindowVisible) {
            return;
        }
        this.mWindow.hide();
        this.mWindowVisible = false;
        this.onWindowHidden();
        this.mWindowWasVisible = false;
    }

    void initViews() {
        int n;
        FrameLayout frameLayout;
        FrameLayout frameLayout2;
        FrameLayout frameLayout3;
        ViewGroup viewGroup;
        View view;
        TypedArray typedArray;
        this.mInitialized = false;
        this.mWindowCreated = false;
        this.mShowInputRequested = false;
        this.mShowInputForced = false;
        int[] nArray = R.styleable.InputMethodService;
        this.mThemeAttrs = typedArray = this.obtainStyledAttributes(nArray);
        this.mRootView = view = this.mInflater.inflate(17367082, null);
        SoftInputWindow softInputWindow = this.mWindow;
        View view2 = this.mRootView;
        softInputWindow.setContentView(view2);
        ViewTreeObserver viewTreeObserver = this.mRootView.getViewTreeObserver();
        ViewTreeObserver.OnComputeInternalInsetsListener onComputeInternalInsetsListener = this.mInsetsComputer;
        viewTreeObserver.addOnComputeInternalInsetsListener(onComputeInternalInsetsListener);
        if (Settings.System.getInt(this.getContentResolver(), "fancy_ime_animations", 0) != 0) {
            this.mWindow.getWindow().setWindowAnimations(16973942);
        }
        this.mFullscreenArea = viewGroup = (ViewGroup)this.mRootView.findViewById(16908727);
        this.mExtractViewHidden = false;
        this.mExtractFrame = frameLayout3 = (FrameLayout)this.mRootView.findViewById(16908316);
        this.mExtractView = null;
        this.mExtractEditText = null;
        this.mExtractAccessories = null;
        this.mExtractAction = null;
        this.mFullscreenApplied = false;
        this.mCandidatesFrame = frameLayout2 = (FrameLayout)this.mRootView.findViewById(16908317);
        this.mInputFrame = frameLayout = (FrameLayout)this.mRootView.findViewById(16908318);
        this.mInputView = null;
        this.mIsInputViewShown = false;
        this.mExtractFrame.setVisibility(8);
        this.mCandidatesVisibility = n = this.getCandidatesHiddenVisibility();
        FrameLayout frameLayout4 = this.mCandidatesFrame;
        int n2 = this.mCandidatesVisibility;
        frameLayout4.setVisibility(n2);
        this.mInputFrame.setVisibility(8);
    }

    void initialize() {
        if (this.mInitialized) {
            return;
        }
        this.mInitialized = true;
        this.onInitializeInterface();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExtractViewShown() {
        if (!this.mIsFullscreen) return false;
        if (this.mExtractViewHidden) return false;
        return true;
    }

    public boolean isFullscreenMode() {
        return this.mIsFullscreen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInputViewShown() {
        if (!this.mIsInputViewShown) return false;
        if (!this.mWindowVisible) return false;
        return true;
    }

    public boolean isShowInputRequested() {
        return this.mShowInputRequested;
    }

    public void onAppPrivateCommand(String string2, Bundle bundle) {
    }

    public void onBindInput() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onComputeInsets(Insets insets) {
        int n;
        int n2;
        int n3;
        int[] nArray = this.mTmpLocation;
        if (this.mInputFrame.getVisibility() == 0) {
            this.mInputFrame.getLocationInWindow(nArray);
        } else {
            int n4;
            nArray[1] = n4 = this.getWindow().getWindow().getDecorView().getHeight();
        }
        insets.contentTopInsets = this.isFullscreenMode() ? (n3 = this.getWindow().getWindow().getDecorView().getHeight()) : (n2 = nArray[1]);
        if (this.mCandidatesFrame.getVisibility() == 0) {
            this.mCandidatesFrame.getLocationInWindow(nArray);
        }
        insets.visibleTopInsets = n = nArray[1];
        insets.touchableInsets = 2;
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        boolean bl = this.mWindowVisible;
        int n = this.mShowInputFlags;
        boolean bl2 = this.mShowInputRequested;
        CompletionInfo[] completionInfoArray = this.mCurCompletions;
        this.initViews();
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (this.mInputStarted) {
            InputConnection inputConnection = this.getCurrentInputConnection();
            EditorInfo editorInfo = this.getCurrentInputEditorInfo();
            this.doStartInput(inputConnection, editorInfo, true);
        }
        if (!bl) {
            return;
        }
        if (bl2) {
            if (this.onShowInputRequested(n, true)) {
                this.showWindow(true);
                if (completionInfoArray == null) {
                    return;
                }
                this.mCurCompletions = completionInfoArray;
                this.onDisplayCompletions(completionInfoArray);
                return;
            }
            this.hideWindow();
            return;
        }
        if (this.mCandidatesVisibility == 0) {
            this.showWindow(false);
            return;
        }
        this.hideWindow();
    }

    public void onConfigureWindow(Window window, boolean bl, boolean bl2) {
        if (bl) {
            this.mWindow.getWindow().setLayout(-1, -1);
            return;
        }
        this.mWindow.getWindow().setLayout(-1, -1);
    }

    @Override
    public void onCreate() {
        SoftInputWindow softInputWindow;
        LayoutInflater layoutInflater;
        InputMethodManager inputMethodManager;
        int n = this.mTheme;
        super.setTheme(n);
        super.onCreate();
        this.mImm = inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        this.mInflater = layoutInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        int n2 = this.mTheme;
        KeyEvent.DispatcherState dispatcherState = this.mDispatcherState;
        this.mWindow = softInputWindow = new SoftInputWindow((Context)this, n2, dispatcherState);
        this.initViews();
        this.mWindow.getWindow().setLayout(-1, -1);
    }

    public View onCreateCandidatesView() {
        return null;
    }

    public View onCreateExtractTextView() {
        return this.mInflater.inflate(17367083, null);
    }

    @Override
    public AbstractInputMethodService.AbstractInputMethodImpl onCreateInputMethodInterface() {
        return new InputMethodImpl();
    }

    @Override
    public AbstractInputMethodService.AbstractInputMethodSessionImpl onCreateInputMethodSessionInterface() {
        return new InputMethodSessionImpl();
    }

    public View onCreateInputView() {
        return null;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        ViewTreeObserver viewTreeObserver = this.mRootView.getViewTreeObserver();
        ViewTreeObserver.OnComputeInternalInsetsListener onComputeInternalInsetsListener = this.mInsetsComputer;
        viewTreeObserver.removeOnComputeInternalInsetsListener(onComputeInternalInsetsListener);
        if (!this.mWindowAdded) {
            return;
        }
        this.mWindow.dismiss();
    }

    public void onDisplayCompletions(CompletionInfo[] completionInfoArray) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onEvaluateFullscreenMode() {
        if (this.getResources().getConfiguration().orientation != 2) {
            return false;
        }
        if (this.mInputEditorInfo == null) return true;
        if ((this.mInputEditorInfo.imeOptions & Integer.MIN_VALUE) == 0) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onEvaluateInputViewShown() {
        Configuration configuration = this.getResources().getConfiguration();
        if (configuration.keyboard == 1) return true;
        if (configuration.hardKeyboardHidden != 2) return false;
        return true;
    }

    public boolean onExtractTextContextMenuItem(int n) {
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection != null) {
            boolean bl = inputConnection.performContextMenuAction(n);
        }
        return true;
    }

    public void onExtractedCursorMovement(int n, int n2) {
        if (this.mExtractEditText == null) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        if (!this.mExtractEditText.hasVerticalScrollBar()) {
            return;
        }
        this.setCandidatesViewShown(false);
    }

    public void onExtractedSelectionChanged(int n, int n2) {
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection == null) {
            return;
        }
        boolean bl = inputConnection.setSelection(n, n2);
    }

    public void onExtractedTextClicked() {
        if (this.mExtractEditText == null) {
            return;
        }
        if (!this.mExtractEditText.hasVerticalScrollBar()) {
            return;
        }
        this.setCandidatesViewShown(false);
    }

    public void onExtractingInputChanged(EditorInfo editorInfo) {
        if (editorInfo.inputType != 0) {
            return;
        }
        this.requestHideSelf(2);
    }

    public void onFinishCandidatesView(boolean bl) {
        if (bl) {
            return;
        }
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection == null) {
            return;
        }
        boolean bl2 = inputConnection.finishComposingText();
    }

    public void onFinishInput() {
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection == null) {
            return;
        }
        boolean bl = inputConnection.finishComposingText();
    }

    public void onFinishInputView(boolean bl) {
        if (bl) {
            return;
        }
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection == null) {
            return;
        }
        boolean bl2 = inputConnection.finishComposingText();
    }

    public void onInitializeInterface() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 4) return this.doMovementKey(n, keyEvent, -1);
        if (!this.handleBack(false)) return false;
        keyEvent.startTracking();
        return true;
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return this.doMovementKey(n, keyEvent, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 4) return this.doMovementKey(n, keyEvent, -1);
        if (!keyEvent.isTracking()) return this.doMovementKey(n, keyEvent, -1);
        if (keyEvent.isCanceled()) return this.doMovementKey(n, keyEvent, -1);
        return this.handleBack(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onShowInputRequested(int n, boolean bl) {
        if (!this.onEvaluateInputViewShown()) {
            return false;
        }
        if ((n & 1) == 0) {
            if (!bl && this.onEvaluateFullscreenMode()) {
                return false;
            }
            if (this.getResources().getConfiguration().keyboard != 1) {
                return false;
            }
        }
        if ((n & 2) == 0) return true;
        this.mShowInputForced = true;
        return true;
    }

    public void onStartCandidatesView(EditorInfo editorInfo, boolean bl) {
    }

    public void onStartInput(EditorInfo editorInfo, boolean bl) {
    }

    public void onStartInputView(EditorInfo editorInfo, boolean bl) {
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return false;
    }

    public void onUnbindInput() {
    }

    public void onUpdateCursor(Rect rect) {
    }

    public void onUpdateExtractedText(int n, ExtractedText extractedText) {
        if (this.mExtractedToken != n) {
            return;
        }
        if (extractedText == null) {
            return;
        }
        if (this.mExtractEditText == null) {
            return;
        }
        this.mExtractedText = extractedText;
        this.mExtractEditText.setExtractedText(extractedText);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onUpdateExtractingViews(EditorInfo editorInfo) {
        if (!this.isExtractViewShown()) {
            return;
        }
        if (this.mExtractAccessories == null) {
            return;
        }
        boolean bl = editorInfo.actionLabel != null || (editorInfo.imeOptions & 0xFF) != 1 && (editorInfo.imeOptions & 0x20000000) == 0 && editorInfo.inputType != 0;
        if (bl) {
            this.mExtractAccessories.setVisibility(0);
            if (this.mExtractAction == null) {
                return;
            }
            if (editorInfo.actionLabel != null) {
                Button button = this.mExtractAction;
                CharSequence charSequence = editorInfo.actionLabel;
                button.setText(charSequence);
            } else {
                Button button = this.mExtractAction;
                int n = editorInfo.imeOptions;
                CharSequence charSequence = this.getTextForImeAction(n);
                button.setText(charSequence);
            }
            Button button = this.mExtractAction;
            View.OnClickListener onClickListener = this.mActionClickListener;
            button.setOnClickListener(onClickListener);
            return;
        }
        this.mExtractAccessories.setVisibility(8);
        if (this.mExtractAction == null) {
            return;
        }
        this.mExtractAction.setOnClickListener(null);
    }

    public void onUpdateExtractingVisibility(EditorInfo editorInfo) {
        if (editorInfo.inputType == 0 || (editorInfo.imeOptions & 0x10000000) != 0) {
            this.setExtractViewShown(false);
            return;
        }
        this.setExtractViewShown(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onUpdateSelection(int n, int n2, int n3, int n4, int n5, int n6) {
        ExtractEditText extractEditText = this.mExtractEditText;
        if (extractEditText == null) {
            return;
        }
        if (!this.isFullscreenMode()) {
            return;
        }
        if (this.mExtractedText == null) {
            return;
        }
        int n7 = this.mExtractedText.startOffset;
        extractEditText.startInternalChanges();
        n4 -= n7;
        int n8 = extractEditText.getText().length();
        if ((n3 -= n7) < 0) {
            n3 = 0;
        } else if (n3 > n8) {
            n3 = n8;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > n8) {
            n4 = n8;
        }
        extractEditText.setSelection(n3, n4);
        extractEditText.finishInternalChanges();
    }

    public void onWindowHidden() {
    }

    public void onWindowShown() {
    }

    /*
     * Enabled aggressive block sorting
     */
    void reportExtractedMovement(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 21: {
                n3 = -n2;
                break;
            }
            case 22: {
                n3 = n2;
                break;
            }
            case 19: {
                n4 = -n2;
                break;
            }
            case 20: {
                n4 = n2;
                break;
            }
        }
        this.onExtractedCursorMovement(n3, n4);
    }

    public void requestHideSelf(int n) {
        InputMethodManager inputMethodManager = this.mImm;
        IBinder iBinder = this.mToken;
        inputMethodManager.hideSoftInputFromInputMethod(iBinder, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendDefaultEditorAction(boolean bl) {
        EditorInfo editorInfo = this.getCurrentInputEditorInfo();
        if (editorInfo == null) return false;
        if (bl) {
            if ((editorInfo.imeOptions & 0x40000000) != 0) return false;
        }
        if ((editorInfo.imeOptions & 0xFF) == 1) return false;
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection == null) return true;
        int n = editorInfo.imeOptions & 0xFF;
        boolean bl2 = inputConnection.performEditorAction(n);
        return true;
    }

    public void sendDownUpKeyEvents(int n) {
        long l;
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection == null) {
            return;
        }
        long l2 = l = SystemClock.uptimeMillis();
        int n2 = n;
        KeyEvent keyEvent = new KeyEvent(l, l2, 0, n2, 0, 0, 0, 0, 6);
        boolean bl = inputConnection.sendKeyEvent(keyEvent);
        long l3 = SystemClock.uptimeMillis();
        long l4 = l;
        int n3 = n;
        KeyEvent keyEvent2 = new KeyEvent(l3, l4, 1, n3, 0, 0, 0, 0, 6);
        boolean bl2 = inputConnection.sendKeyEvent(keyEvent2);
    }

    public void sendKeyChar(char c) {
        switch (c) {
            default: {
                if (c < '0' || c > '9') break;
                int n = c - 48 + 7;
                this.sendDownUpKeyEvents(n);
                return;
            }
            case '\n': {
                if (this.sendDefaultEditorAction(true)) {
                    return;
                }
                this.sendDownUpKeyEvents(66);
                return;
            }
        }
        InputConnection inputConnection = this.getCurrentInputConnection();
        if (inputConnection == null) {
            return;
        }
        String string2 = String.valueOf(c);
        boolean bl = inputConnection.commitText(string2, 1);
    }

    public void setCandidatesView(View view) {
        this.mCandidatesFrame.removeAllViews();
        FrameLayout frameLayout = this.mCandidatesFrame;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        frameLayout.addView(view, layoutParams);
    }

    public void setCandidatesViewShown(boolean bl) {
        this.updateCandidatesVisibility(bl);
        if (this.mShowInputRequested) {
            return;
        }
        if (this.mWindowVisible != bl) {
            return;
        }
        if (bl) {
            this.showWindow(false);
            return;
        }
        this.hideWindow();
    }

    public void setExtractView(View view) {
        this.mExtractFrame.removeAllViews();
        FrameLayout frameLayout = this.mExtractFrame;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        frameLayout.addView(view, layoutParams);
        this.mExtractView = view;
        if (view != null) {
            Button button;
            ExtractEditText extractEditText;
            this.mExtractEditText = extractEditText = (ExtractEditText)view.findViewById(16908325);
            this.mExtractEditText.setIME(this);
            this.mExtractAction = button = (Button)view.findViewById(16908729);
            if (this.mExtractAction != null) {
                ViewGroup viewGroup;
                this.mExtractAccessories = viewGroup = (ViewGroup)view.findViewById(16908728);
            }
            this.startExtractingText(false);
            return;
        }
        this.mExtractEditText = null;
        this.mExtractAccessories = null;
        this.mExtractAction = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExtractViewShown(boolean bl) {
        if (this.mExtractViewHidden != bl) {
            return;
        }
        boolean bl2 = !bl;
        this.mExtractViewHidden = bl2;
        this.updateExtractFrameVisibility();
    }

    public void setInputView(View view) {
        this.mInputFrame.removeAllViews();
        FrameLayout frameLayout = this.mInputFrame;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        frameLayout.addView(view, layoutParams);
        this.mInputView = view;
    }

    @Override
    public void setTheme(int n) {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        this.mTheme = n;
    }

    public void showStatusIcon(int n) {
        this.mStatusIcon = n;
        InputMethodManager inputMethodManager = this.mImm;
        IBinder iBinder = this.mToken;
        String string2 = this.getPackageName();
        inputMethodManager.showStatusIcon(iBinder, string2, n);
    }

    public void showWindow(boolean bl) {
        if (this.mInShowWindow) {
            int n = Log.w(TAG, "Re-entrance in to showWindow");
            return;
        }
        try {
            boolean bl2;
            this.mWindowWasVisible = bl2 = this.mWindowVisible;
            this.mInShowWindow = true;
            this.showWindowInner(bl);
            return;
        }
        finally {
            this.mWindowWasVisible = true;
            this.mInShowWindow = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void showWindowInner(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = this.mWindowVisible;
        this.mWindowVisible = true;
        if (!this.mShowInputRequested && this.mInputStarted && bl) {
            bl2 = true;
            this.mShowInputRequested = true;
        }
        this.initialize();
        this.updateFullscreenMode();
        this.updateInputViewShown();
        if (!this.mWindowAdded || !this.mWindowCreated) {
            this.mWindowAdded = true;
            this.mWindowCreated = true;
            this.initialize();
            View view = this.onCreateCandidatesView();
            if (view != null) {
                this.setCandidatesView(view);
            }
        }
        if (this.mShowInputRequested) {
            if (!this.mInputViewStarted) {
                this.mInputViewStarted = true;
                EditorInfo editorInfo = this.mInputEditorInfo;
                this.onStartInputView(editorInfo, false);
            }
        } else if (!this.mCandidatesViewStarted) {
            this.mCandidatesViewStarted = true;
            EditorInfo editorInfo = this.mInputEditorInfo;
            this.onStartCandidatesView(editorInfo, false);
        }
        if (bl2) {
            this.startExtractingText(false);
        }
        if (bl3) {
            return;
        }
        this.onWindowShown();
        this.mWindow.show();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startExtractingText(boolean bl) {
        int n;
        int n2;
        ExtractEditText extractEditText = this.mExtractEditText;
        if (extractEditText == null) {
            return;
        }
        if (!this.getCurrentInputStarted()) {
            return;
        }
        if (!this.isFullscreenMode()) {
            return;
        }
        this.mExtractedToken = n2 = this.mExtractedToken + 1;
        ExtractedTextRequest extractedTextRequest = new ExtractedTextRequest();
        extractedTextRequest.token = n = this.mExtractedToken;
        extractedTextRequest.flags = 1;
        extractedTextRequest.hintMaxLines = 10;
        extractedTextRequest.hintMaxChars = 10000;
        InputConnection inputConnection = this.getCurrentInputConnection();
        ExtractedText extractedText = inputConnection == null ? null : inputConnection.getExtractedText(extractedTextRequest, 1);
        this.mExtractedText = extractedText;
        if (this.mExtractedText == null || inputConnection == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected null in startExtractingText : mExtractedText = ");
            ExtractedText extractedText2 = this.mExtractedText;
            String string2 = stringBuilder.append(extractedText2).append(", input connection = ").append(inputConnection).toString();
            int n3 = Log.e(TAG, string2);
        }
        EditorInfo editorInfo = this.getCurrentInputEditorInfo();
        try {
            extractEditText.startInternalChanges();
            this.onUpdateExtractingVisibility(editorInfo);
            this.onUpdateExtractingViews(editorInfo);
            int n4 = editorInfo.inputType;
            if ((n4 & 0xF) == 1 && (0x40000 & n4) != 0) {
                n4 |= 0x20000;
            }
            extractEditText.setInputType(n4);
            CharSequence charSequence = editorInfo.hintText;
            extractEditText.setHint(charSequence);
            if (this.mExtractedText != null) {
                extractEditText.setEnabled(true);
                ExtractedText extractedText3 = this.mExtractedText;
                extractEditText.setExtractedText(extractedText3);
            } else {
                boolean bl2 = false;
                extractEditText.setEnabled(bl2);
                extractEditText.setText("");
            }
            if (!bl) {
                return;
            }
            this.onExtractingInputChanged(editorInfo);
            return;
        }
        finally {
            extractEditText.finishInternalChanges();
        }
    }

    public void switchInputMethod(String string2) {
        InputMethodManager inputMethodManager = this.mImm;
        IBinder iBinder = this.mToken;
        inputMethodManager.setInputMethod(iBinder, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateCandidatesVisibility(boolean bl) {
        int n = bl ? 0 : this.getCandidatesHiddenVisibility();
        if (this.mCandidatesVisibility != n) {
            return;
        }
        this.mCandidatesFrame.setVisibility(n);
        this.mCandidatesVisibility = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateExtractFrameVisibility() {
        int n;
        TypedArray typedArray;
        int n2;
        int n3;
        if (this.isFullscreenMode()) {
            n3 = this.mExtractViewHidden ? 4 : 0;
            this.mExtractFrame.setVisibility(0);
        } else {
            n3 = 0;
            this.mExtractFrame.setVisibility(8);
        }
        boolean bl = this.mCandidatesVisibility == 0;
        this.updateCandidatesVisibility(bl);
        if (this.mWindowWasVisible && this.mFullscreenArea.getVisibility() != n3 && (n2 = (typedArray = this.mThemeAttrs).getResourceId(n = n3 == 0 ? 1 : 2, 0)) != 0) {
            ViewGroup viewGroup = this.mFullscreenArea;
            Animation animation = AnimationUtils.loadAnimation(this, n2);
            viewGroup.startAnimation(animation);
        }
        this.mFullscreenArea.setVisibility(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateFullscreenMode() {
        boolean bl;
        boolean bl2 = this.mShowInputRequested && this.onEvaluateFullscreenMode();
        boolean bl3 = this.mLastShowInputRequested;
        boolean bl4 = this.mShowInputRequested;
        boolean bl5 = bl3 != bl4;
        if (this.mIsFullscreen == bl2 || !this.mFullscreenApplied) {
            bl5 = true;
            this.mIsFullscreen = bl2;
            InputConnection inputConnection = this.getCurrentInputConnection();
            if (inputConnection != null) {
                boolean bl6 = inputConnection.reportFullscreenMode(bl2);
            }
            this.mFullscreenApplied = true;
            this.initialize();
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mFullscreenArea.getLayoutParams();
            if (bl2) {
                ViewGroup viewGroup = this.mFullscreenArea;
                Drawable drawable2 = this.mThemeAttrs.getDrawable(0);
                viewGroup.setBackgroundDrawable(drawable2);
                layoutParams.height = 0;
                layoutParams.weight = 1.0f;
            } else {
                this.mFullscreenArea.setBackgroundDrawable(null);
                layoutParams.height = -1;
                layoutParams.weight = 0.0f;
            }
            ViewGroup viewGroup = (ViewGroup)this.mFullscreenArea.getParent();
            ViewGroup viewGroup2 = this.mFullscreenArea;
            viewGroup.updateViewLayout(viewGroup2, layoutParams);
            if (bl2) {
                View view;
                if (this.mExtractView == null && (view = this.onCreateExtractTextView()) != null) {
                    this.setExtractView(view);
                }
                this.startExtractingText(false);
            }
            this.updateExtractFrameVisibility();
        }
        if (!bl5) {
            return;
        }
        Window window = this.mWindow.getWindow();
        boolean bl7 = !this.mShowInputRequested;
        this.onConfigureWindow(window, bl2, bl7);
        this.mLastShowInputRequested = bl = this.mShowInputRequested;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateInputViewShown() {
        int n = 0;
        boolean bl = this.mShowInputRequested && this.onEvaluateInputViewShown();
        if (this.mIsInputViewShown != bl) {
            return;
        }
        if (!this.mWindowVisible) {
            return;
        }
        this.mIsInputViewShown = bl;
        FrameLayout frameLayout = this.mInputFrame;
        if (!bl) {
            n = 8;
        }
        frameLayout.setVisibility(n);
        if (this.mInputView != null) {
            return;
        }
        this.initialize();
        View view = this.onCreateInputView();
        if (view == null) {
            return;
        }
        this.setInputView(view);
    }

    public static final class Insets {
        public static final int TOUCHABLE_INSETS_CONTENT = 1;
        public static final int TOUCHABLE_INSETS_FRAME = 0;
        public static final int TOUCHABLE_INSETS_VISIBLE = 2;
        public int contentTopInsets;
        public int touchableInsets;
        public int visibleTopInsets;
    }

    public class InputMethodSessionImpl
    extends AbstractInputMethodService.AbstractInputMethodSessionImpl {
        @Override
        public void appPrivateCommand(String string2, Bundle bundle) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onAppPrivateCommand(string2, bundle);
        }

        @Override
        public void displayCompletions(CompletionInfo[] completionInfoArray) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.mCurCompletions = completionInfoArray;
            InputMethodService.this.onDisplayCompletions(completionInfoArray);
        }

        @Override
        public void finishInput() {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.doFinishInput();
        }

        @Override
        public void toggleSoftInput(int n, int n2) {
            InputMethodService.this.onToggleSoftInput(n, n2);
        }

        @Override
        public void updateCursor(Rect rect) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateCursor(rect);
        }

        @Override
        public void updateExtractedText(int n, ExtractedText extractedText) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateExtractedText(n, extractedText);
        }

        @Override
        public void updateSelection(int n, int n2, int n3, int n4, int n5, int n6) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService inputMethodService = InputMethodService.this;
            int n7 = n;
            int n8 = n2;
            int n9 = n3;
            int n10 = n4;
            int n11 = n5;
            int n12 = n6;
            inputMethodService.onUpdateSelection(n7, n8, n9, n10, n11, n12);
        }
    }

    public class InputMethodImpl
    extends AbstractInputMethodService.AbstractInputMethodImpl {
        @Override
        public void attachToken(IBinder iBinder) {
            if (InputMethodService.this.mToken != null) {
                return;
            }
            InputMethodService.this.mToken = iBinder;
            InputMethodService.this.mWindow.setToken(iBinder);
        }

        @Override
        public void bindInput(InputBinding inputBinding) {
            InputConnection inputConnection;
            InputMethodService.this.mInputBinding = inputBinding;
            InputMethodService inputMethodService = InputMethodService.this;
            inputMethodService.mInputConnection = inputConnection = inputBinding.getConnection();
            InputConnection inputConnection2 = InputMethodService.this.getCurrentInputConnection();
            if (inputConnection2 != null) {
                boolean bl = InputMethodService.this.mIsFullscreen;
                boolean bl2 = inputConnection2.reportFullscreenMode(bl);
            }
            InputMethodService.this.initialize();
            InputMethodService.this.onBindInput();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void hideSoftInput(int n, ResultReceiver resultReceiver) {
            boolean bl = InputMethodService.this.isInputViewShown();
            InputMethodService.this.mShowInputFlags = 0;
            InputMethodService.this.mShowInputRequested = false;
            InputMethodService.this.mShowInputForced = false;
            InputMethodService.this.hideWindow();
            if (resultReceiver == null) {
                return;
            }
            boolean bl2 = InputMethodService.this.isInputViewShown();
            int n2 = bl != bl2 ? 3 : (bl ? 0 : 1);
            resultReceiver.send(n2, null);
        }

        @Override
        public void restartInput(InputConnection inputConnection, EditorInfo editorInfo) {
            InputMethodService.this.doStartInput(inputConnection, editorInfo, true);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void showSoftInput(int n, ResultReceiver resultReceiver) {
            boolean bl = InputMethodService.this.isInputViewShown();
            InputMethodService.this.mShowInputFlags = 0;
            if (InputMethodService.this.onShowInputRequested(n, false)) {
                InputMethodService.this.showWindow(true);
            }
            if (resultReceiver == null) {
                return;
            }
            boolean bl2 = InputMethodService.this.isInputViewShown();
            int n2 = bl != bl2 ? 2 : (bl ? 0 : 1);
            resultReceiver.send(n2, null);
        }

        @Override
        public void startInput(InputConnection inputConnection, EditorInfo editorInfo) {
            InputMethodService.this.doStartInput(inputConnection, editorInfo, false);
        }

        @Override
        public void unbindInput() {
            InputMethodService.this.onUnbindInput();
            InputMethodService.this.mInputStarted = false;
            InputMethodService.this.mInputBinding = null;
            InputMethodService.this.mInputConnection = null;
        }
    }
}

